/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.token;

import com.netscape.certsrv.tps.token.TokenClient;
import com.netscape.certsrv.tps.token.TokenData;
import com.netscape.certsrv.tps.token.TokenStatus;
import com.netscape.cmstools.tps.TPSCLI;
import com.netscape.cmstools.tps.token.TokenAddCLI;
import com.netscape.cmstools.tps.token.TokenFindCLI;
import com.netscape.cmstools.tps.token.TokenModifyCLI;
import com.netscape.cmstools.tps.token.TokenRemoveCLI;
import com.netscape.cmstools.tps.token.TokenShowCLI;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(TokenCLI.class);
    public TPSCLI tpsCLI;
    public TokenClient tokenClient;

    public TokenCLI(TPSCLI tpsCLI) {
        super("token", "Token management commands", (CLI)tpsCLI);
        this.tpsCLI = tpsCLI;
        this.addModule((CLI)new TokenAddCLI(this));
        this.addModule((CLI)new TokenFindCLI(this));
        this.addModule((CLI)new TokenModifyCLI(this));
        this.addModule((CLI)new TokenRemoveCLI(this));
        this.addModule((CLI)new TokenShowCLI(this));
    }

    public TokenClient getTokenClient() throws Exception {
        if (this.tokenClient != null) {
            return this.tokenClient;
        }
        this.tokenClient = (TokenClient)this.parent.getClient("tokens");
        return this.tokenClient;
    }

    public static void printToken(TokenData token) {
        Collection nextStates;
        TokenData.TokenStatusData status;
        System.out.println("  Token ID: " + token.getID());
        if (token.getUserID() != null) {
            System.out.println("  User ID: " + token.getUserID());
        }
        if (token.getType() != null) {
            System.out.println("  Type: " + token.getType());
        }
        if ((status = token.getStatus()) != null) {
            System.out.println("  Status: " + status.name);
        }
        if ((nextStates = token.getNextStates()) != null) {
            ArrayList<TokenStatus> names = new ArrayList<TokenStatus>();
            for (TokenData.TokenStatusData nextState : nextStates) {
                names.add(nextState.name);
            }
            System.out.println("  Next States: " + StringUtils.join(names, (String)", "));
        }
        if (token.getAppletID() != null) {
            System.out.println("  Applet ID: " + token.getAppletID());
        }
        if (token.getKeyInfo() != null) {
            System.out.println("  Key Info: " + token.getKeyInfo());
        }
        if (token.getPolicy() != null) {
            System.out.println("  Policy: " + token.getPolicy());
        }
        if (token.getCreateTimestamp() != null) {
            System.out.println("  Date Created: " + token.getCreateTimestamp());
        }
        if (token.getModifyTimestamp() != null) {
            System.out.println("  Date Modified: " + token.getModifyTimestamp());
        }
    }
}

