/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.cert;

import com.netscape.certsrv.tps.cert.TPSCertClient;
import com.netscape.certsrv.tps.cert.TPSCertData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.cert.TPSCertCLI;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSCertShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TPSCertShowCLI.class);
    public TPSCertCLI certCLI;

    public TPSCertShowCLI(TPSCertCLI certCLI) {
        super("show", "Show certificate", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Certificate ID> [OPTIONS...]", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Certificate ID specified.");
        }
        String certID = cmdArgs[0];
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        TPSCertClient certClient = this.certCLI.getTPSCertClient();
        TPSCertData certData = certClient.getCert(certID);
        MainCLI.printMessage("Certificate \"" + certID + "\"");
        TPSCertCLI.printCert(certData);
    }
}

