/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class StatsEvent {
    private String mName = null;
    private long mMin = -1L;
    private long mMax = -1L;
    private long mTimeTaken = 0L;
    private long mTimeTakenSqSum = 0L;
    private long mNoOfOperations = 0L;
    private Map<String, StatsEvent> mSubEvents = new HashMap<String, StatsEvent>();
    private StatsEvent mParent = null;

    public StatsEvent(StatsEvent parent) {
        this.mParent = parent;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void addSubEvent(StatsEvent st) {
        this.mSubEvents.put(st.getName(), st);
    }

    public Enumeration<String> getSubEventNames() {
        Vector<String> names = new Vector<String>();
        names.addAll(this.mSubEvents.keySet());
        return names.elements();
    }

    public StatsEvent getSubEvent(String name) {
        return this.mSubEvents.get(name);
    }

    public void resetCounters() {
        this.mMin = -1L;
        this.mMax = -1L;
        this.mNoOfOperations = 0L;
        this.mTimeTaken = 0L;
        this.mTimeTakenSqSum = 0L;
        for (StatsEvent c : this.mSubEvents.values()) {
            c.resetCounters();
        }
    }

    public long getMax() {
        return this.mMax;
    }

    public long getMin() {
        return this.mMin;
    }

    public void incNoOfOperations(long c) {
        this.mNoOfOperations += c;
    }

    public long getTimeTakenSqSum() {
        return this.mTimeTakenSqSum;
    }

    public long getPercentage() {
        if (this.mParent == null || this.mParent.getTimeTaken() == 0L) {
            return 100L;
        }
        return this.mTimeTaken * 100L / this.mParent.getTimeTaken();
    }

    public long getStdDev() {
        if (this.getNoOfOperations() == 0L) {
            return 0L;
        }
        long a = this.getTimeTakenSqSum();
        long b = -2L * this.getAvg() * this.getTimeTaken();
        long c = this.getAvg() * this.getAvg() * this.getNoOfOperations();
        return (long)Math.sqrt((double)(a + b + c) / (double)this.getNoOfOperations());
    }

    public long getAvg() {
        return this.mNoOfOperations == 0L ? -1L : this.mTimeTaken / this.mNoOfOperations;
    }

    public long getNoOfOperations() {
        return this.mNoOfOperations;
    }

    public void incTimeTaken(long c) {
        if (this.mMin == -1L) {
            this.mMin = c;
        } else if (c < this.mMin) {
            this.mMin = c;
        }
        if (this.mMax == -1L) {
            this.mMax = c;
        } else if (c > this.mMax) {
            this.mMax = c;
        }
        this.mTimeTaken += c;
        this.mTimeTakenSqSum += c * c;
    }

    public long getTimeTaken() {
        return this.mTimeTaken;
    }
}

