/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.tps.token;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TokenStatus {
    static Map<String, TokenStatus> instancesByName = new HashMap<String, TokenStatus>();
    static Map<Integer, TokenStatus> instancesByValue = new HashMap<Integer, TokenStatus>();
    public static final int TOKEN_UNKNOWN = -1;
    public static final int TOKEN_FORMATTED = 0;
    public static final int TOKEN_DAMAGED = 1;
    public static final int TOKEN_PERM_LOST = 2;
    public static final int TOKEN_SUSPENDED = 3;
    public static final int TOKEN_ACTIVE = 4;
    public static final int TOKEN_TEMP_LOST_PERM_LOST = 5;
    public static final int TOKEN_TERMINATED = 6;
    public static final int TOKEN_UNFORMATTED = 7;
    public static final TokenStatus FORMATTED = new TokenStatus("FORMATTED", 0);
    public static final TokenStatus DAMAGED = new TokenStatus("DAMAGED", 1);
    public static final TokenStatus PERM_LOST = new TokenStatus("PERM_LOST", 2);
    public static final TokenStatus SUSPENDED = new TokenStatus("SUSPENDED", 3);
    public static final TokenStatus ACTIVE = new TokenStatus("ACTIVE", 4);
    public static final TokenStatus TEMP_LOST_PERM_LOST = new TokenStatus("TEMP_LOST_PERM_LOST", 5);
    public static final TokenStatus TERMINATED = new TokenStatus("TERMINATED", 6);
    public static final TokenStatus UNFORMATTED = new TokenStatus("UNFORMATTED", 7);
    String name;
    Integer value;

    public TokenStatus() {
    }

    TokenStatus(String name, Integer value) {
        this.name = name;
        this.value = value;
        if (value > -1) {
            instancesByName.put(name, this);
            instancesByValue.put(value, this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TokenStatus other = (TokenStatus)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static Collection<TokenStatus> values() {
        return instancesByName.values();
    }

    public static TokenStatus valueOf(String name) {
        if ("UNINITIALIZED".equals(name)) {
            System.err.println("WARNING: The token status " + name + " has been deprecated. Please use " + FORMATTED + " instead.");
            return FORMATTED;
        }
        if ("TEMP_LOST".equals(name)) {
            System.err.println("WARNING: The token status " + name + " has been deprecated. Please use " + SUSPENDED + " instead.");
            return SUSPENDED;
        }
        if (name == null) {
            return new TokenStatus("UNKNOWN", -1);
        }
        TokenStatus status = instancesByName.get(name);
        if (status == null) {
            status = new TokenStatus(name, -1);
        }
        return status;
    }

    public static TokenStatus fromInt(Integer value) {
        TokenStatus status = instancesByValue.get(value);
        if (status == null) {
            status = new TokenStatus("UNKNOWN", -1);
        }
        return status;
    }

    public boolean isValid() {
        return this.value >= 0;
    }
}

