/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.tps.connector;

import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.tps.connector.ConnectorCollection;
import com.netscape.certsrv.tps.connector.ConnectorData;
import java.util.HashMap;
import javax.ws.rs.client.Entity;

public class ConnectorClient
extends Client {
    public ConnectorClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "connectors");
    }

    public ConnectorCollection findConnectors(String filter, Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (filter != null) {
            params.put("filter", filter);
        }
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get(null, params, ConnectorCollection.class);
    }

    public ConnectorData getConnector(String connectorID) throws Exception {
        return this.get(connectorID, ConnectorData.class);
    }

    public ConnectorData addConnector(ConnectorData connectorData) throws Exception {
        Entity<ConnectorData> entity = this.client.entity(connectorData);
        return this.post(null, null, entity, ConnectorData.class);
    }

    public ConnectorData updateConnector(String connectorID, ConnectorData connectorData) throws Exception {
        Entity<ConnectorData> entity = this.client.entity(connectorData);
        return this.patch(connectorID, null, entity, ConnectorData.class);
    }

    public ConnectorData changeConnectorStatus(String connectorID, String action) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (action != null) {
            params.put("action", action);
        }
        return this.post(connectorID, params, null, ConnectorData.class);
    }

    public void removeConnector(String connectorID) throws Exception {
        this.delete(connectorID, Void.class);
    }
}

