/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.certsrv.util.JSONSerializer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CMSRequestInfo
implements JSONSerializer {
    protected RequestId requestID;
    protected String requestType;
    protected RequestStatus requestStatus;
    protected String requestURL;
    protected String realm;
    protected Date creationTime;
    protected Date modificationTime;

    public RequestId getRequestID() {
        return this.requestID;
    }

    public void setRequestID(RequestId requestID) {
        this.requestID = requestID;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public RequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(RequestStatus requestStatus) {
        this.requestStatus = requestStatus;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    @Deprecated(since="11.2.0", forRemoval=true)
    public RequestId getRequestId() {
        if (this.requestURL == null) {
            return null;
        }
        String id = this.requestURL.substring(this.requestURL.lastIndexOf("/") + 1);
        return new RequestId(id);
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(Date modificationTime) {
        this.modificationTime = modificationTime;
    }

    public int hashCode() {
        return Objects.hash(this.creationTime, this.modificationTime, this.realm, this.requestID, this.requestStatus, this.requestType, this.requestURL);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CMSRequestInfo other = (CMSRequestInfo)obj;
        return Objects.equals(this.creationTime, other.creationTime) && Objects.equals(this.modificationTime, other.modificationTime) && Objects.equals(this.realm, other.realm) && Objects.equals(this.requestID, other.requestID) && Objects.equals(this.requestStatus, other.requestStatus) && Objects.equals(this.requestType, other.requestType) && Objects.equals(this.requestURL, other.requestURL);
    }

    public void toDOM(Document document, Element infoElement) {
        Element requestTypeElement;
        if (this.requestID != null) {
            requestTypeElement = document.createElement("requestID");
            requestTypeElement.appendChild(document.createTextNode(this.requestID.toHexString()));
            infoElement.appendChild(requestTypeElement);
        }
        if (this.requestType != null) {
            requestTypeElement = document.createElement("requestType");
            requestTypeElement.appendChild(document.createTextNode(this.requestType));
            infoElement.appendChild(requestTypeElement);
        }
        if (this.requestStatus != null) {
            Element requestStatusElement = document.createElement("requestStatus");
            requestStatusElement.appendChild(document.createTextNode(this.requestStatus.toString()));
            infoElement.appendChild(requestStatusElement);
        }
        if (this.requestURL != null) {
            Element requestURLElement = document.createElement("requestURL");
            requestURLElement.appendChild(document.createTextNode(this.requestURL));
            infoElement.appendChild(requestURLElement);
        }
        if (this.realm != null) {
            Element realmElement = document.createElement("realm");
            realmElement.appendChild(document.createTextNode(this.realm));
            infoElement.appendChild(realmElement);
        }
    }

    public Element toDOM(Document document) {
        Element infoElement = document.createElement("CMSRequestInfo");
        this.toDOM(document, infoElement);
        return infoElement;
    }

    public static void fromDOM(Element infoElement, CMSRequestInfo info) {
        NodeList realmList;
        NodeList requestURLList;
        NodeList requestStatusList;
        NodeList requestTypeList;
        NodeList requestIDList = infoElement.getElementsByTagName("requestID");
        if (requestIDList.getLength() > 0) {
            String value = requestIDList.item(0).getTextContent();
            info.setRequestID(new RequestId(value));
        }
        if ((requestTypeList = infoElement.getElementsByTagName("requestType")).getLength() > 0) {
            String value = requestTypeList.item(0).getTextContent();
            info.setRequestType(value);
        }
        if ((requestStatusList = infoElement.getElementsByTagName("requestStatus")).getLength() > 0) {
            String value = requestStatusList.item(0).getTextContent();
            info.setRequestStatus(RequestStatus.valueOf(value));
        }
        if ((requestURLList = infoElement.getElementsByTagName("requestURL")).getLength() > 0) {
            String value = requestURLList.item(0).getTextContent();
            info.setRequestURL(value);
        }
        if ((realmList = infoElement.getElementsByTagName("realm")).getLength() > 0) {
            String value = realmList.item(0).getTextContent();
            info.setRealm(value);
        }
    }

    public static CMSRequestInfo fromDOM(Element infoElement) {
        CMSRequestInfo info = new CMSRequestInfo();
        CMSRequestInfo.fromDOM(infoElement, info);
        return info;
    }

    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element element = this.toDOM(document);
        document.appendChild(element);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static CMSRequestInfo fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element element = document.getDocumentElement();
        return CMSRequestInfo.fromDOM(element);
    }
}

