/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.cert;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.util.JSONSerializer;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CertData
implements JSONSerializer {
    protected CertId serialNumber;
    protected String issuerDN;
    protected String subjectDN;
    protected String prettyPrint;
    protected String encoded;
    protected String pkcs7CertChain;
    protected String notBefore;
    protected String notAfter;
    protected String status;
    protected Long nonce;
    protected Date revokedOn;
    protected String revokedBy;
    protected Integer revocationReason;

    @JsonProperty(value="id")
    public CertId getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(CertId serialNumber) {
        this.serialNumber = serialNumber;
    }

    @JsonProperty(value="IssuerDN")
    public String getIssuerDN() {
        return this.issuerDN;
    }

    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    @JsonProperty(value="SubjectDN")
    public String getSubjectDN() {
        return this.subjectDN;
    }

    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }

    @JsonProperty(value="PrettyPrint")
    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(String prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @JsonProperty(value="Encoded")
    public String getEncoded() {
        return this.encoded;
    }

    public void setEncoded(String encoded) {
        this.encoded = encoded;
    }

    @JsonProperty(value="PKCS7CertChain")
    public void setPkcs7CertChain(String chain) {
        this.pkcs7CertChain = chain;
    }

    public String getPkcs7CertChain() {
        return this.pkcs7CertChain;
    }

    @JsonProperty(value="NotBefore")
    public String getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(String notBefore) {
        this.notBefore = notBefore;
    }

    @JsonProperty(value="NotAfter")
    public String getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(String notAfter) {
        this.notAfter = notAfter;
    }

    @JsonProperty(value="Status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="Nonce")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    @JsonProperty(value="RevokedOn")
    public Date getRevokedOn() {
        return this.revokedOn;
    }

    public void setRevokedOn(Date revokedOn) {
        this.revokedOn = revokedOn;
    }

    @JsonProperty(value="RevokedBy")
    public String getRevokedBy() {
        return this.revokedBy;
    }

    public void setRevokedBy(String revokedBy) {
        this.revokedBy = revokedBy;
    }

    @JsonProperty(value="RevocationReason")
    public Integer getRevocationReason() {
        return this.revocationReason;
    }

    public void setRevocationReason(Integer revocationReason) {
        this.revocationReason = revocationReason;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.encoded == null ? 0 : this.encoded.hashCode());
        result = 31 * result + (this.issuerDN == null ? 0 : this.issuerDN.hashCode());
        result = 31 * result + (this.nonce == null ? 0 : this.nonce.hashCode());
        result = 31 * result + (this.notAfter == null ? 0 : this.notAfter.hashCode());
        result = 31 * result + (this.notBefore == null ? 0 : this.notBefore.hashCode());
        result = 31 * result + (this.pkcs7CertChain == null ? 0 : this.pkcs7CertChain.hashCode());
        result = 31 * result + (this.prettyPrint == null ? 0 : this.prettyPrint.hashCode());
        result = 31 * result + (this.serialNumber == null ? 0 : this.serialNumber.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.subjectDN == null ? 0 : this.subjectDN.hashCode());
        result = 31 * result + (this.revokedOn == null ? 0 : this.revokedOn.hashCode());
        result = 31 * result + (this.revokedBy == null ? 0 : this.revokedBy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertData other = (CertData)obj;
        if (this.encoded == null ? other.encoded != null : !this.encoded.equals(other.encoded)) {
            return false;
        }
        if (this.issuerDN == null ? other.issuerDN != null : !this.issuerDN.equals(other.issuerDN)) {
            return false;
        }
        if (this.nonce == null ? other.nonce != null : !this.nonce.equals(other.nonce)) {
            return false;
        }
        if (this.notAfter == null ? other.notAfter != null : !this.notAfter.equals(other.notAfter)) {
            return false;
        }
        if (this.notBefore == null ? other.notBefore != null : !this.notBefore.equals(other.notBefore)) {
            return false;
        }
        if (this.pkcs7CertChain == null ? other.pkcs7CertChain != null : !this.pkcs7CertChain.equals(other.pkcs7CertChain)) {
            return false;
        }
        if (this.prettyPrint == null ? other.prettyPrint != null : !this.prettyPrint.equals(other.prettyPrint)) {
            return false;
        }
        if (this.serialNumber == null ? other.serialNumber != null : !this.serialNumber.equals(other.serialNumber)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.subjectDN == null ? other.subjectDN != null : !this.subjectDN.equals(other.subjectDN)) {
            return false;
        }
        if (this.revokedOn == null ? other.revokedOn != null : !this.revokedOn.equals(other.revokedOn)) {
            return false;
        }
        return !(this.revokedBy == null ? other.revokedBy != null : !this.revokedBy.equals(other.revokedBy));
    }

    public Element toDOM(Document document) {
        Element dataElement = document.createElement("CertData");
        if (this.serialNumber != null) {
            dataElement.setAttribute("id", this.serialNumber.toHexString());
        }
        if (this.issuerDN != null) {
            Element issuerDNElement = document.createElement("IssuerDN");
            issuerDNElement.appendChild(document.createTextNode(this.issuerDN));
            dataElement.appendChild(issuerDNElement);
        }
        if (this.subjectDN != null) {
            Element subjectDNElement = document.createElement("SubjectDN");
            subjectDNElement.appendChild(document.createTextNode(this.subjectDN));
            dataElement.appendChild(subjectDNElement);
        }
        if (this.prettyPrint != null) {
            Element prettyPrintElement = document.createElement("PrettyPrint");
            prettyPrintElement.appendChild(document.createTextNode(this.prettyPrint));
            dataElement.appendChild(prettyPrintElement);
        }
        if (this.encoded != null) {
            Element encodedElement = document.createElement("Encoded");
            encodedElement.appendChild(document.createTextNode(this.encoded));
            dataElement.appendChild(encodedElement);
        }
        if (this.pkcs7CertChain != null) {
            Element pkcs7CertChainElement = document.createElement("PKCS7CertChain");
            pkcs7CertChainElement.appendChild(document.createTextNode(this.pkcs7CertChain));
            dataElement.appendChild(pkcs7CertChainElement);
        }
        if (this.notBefore != null) {
            Element notBeforeElement = document.createElement("NotBefore");
            notBeforeElement.appendChild(document.createTextNode(this.notBefore));
            dataElement.appendChild(notBeforeElement);
        }
        if (this.notAfter != null) {
            Element notAfterElement = document.createElement("NotAfter");
            notAfterElement.appendChild(document.createTextNode(this.notAfter));
            dataElement.appendChild(notAfterElement);
        }
        if (this.status != null) {
            Element statusElement = document.createElement("Status");
            statusElement.appendChild(document.createTextNode(this.status));
            dataElement.appendChild(statusElement);
        }
        if (this.nonce != null) {
            Element nonceElement = document.createElement("Nonce");
            nonceElement.appendChild(document.createTextNode(Long.toString(this.nonce)));
            dataElement.appendChild(nonceElement);
        }
        if (this.revokedOn != null) {
            Element revokedOnElement = document.createElement("RevokedOn");
            revokedOnElement.appendChild(document.createTextNode(Long.toString(this.revokedOn.getTime())));
            dataElement.appendChild(revokedOnElement);
        }
        if (this.revokedBy != null) {
            Element revokedByElement = document.createElement("RevokedBy");
            revokedByElement.appendChild(document.createTextNode(this.revokedBy));
            dataElement.appendChild(revokedByElement);
        }
        if (this.revocationReason != null) {
            Element revocationReasonElement = document.createElement("RevocationReason");
            revocationReasonElement.appendChild(document.createTextNode(Integer.toString(this.revocationReason)));
            dataElement.appendChild(revocationReasonElement);
        }
        return dataElement;
    }

    public static CertData fromDOM(Element dataElement) {
        NodeList revocationReasonList;
        NodeList revokedByList;
        NodeList revokedOnList;
        NodeList nonceList;
        NodeList statusList;
        NodeList notAfterList;
        NodeList notBeforeList;
        NodeList pkcs7CertChainList;
        NodeList encodedList;
        NodeList prettyPrintList;
        NodeList subjectDNList;
        CertData data = new CertData();
        String id = dataElement.getAttribute("id");
        data.setSerialNumber(StringUtils.isEmpty((CharSequence)id) ? null : new CertId(id));
        NodeList issuerDNList = dataElement.getElementsByTagName("IssuerDN");
        if (issuerDNList.getLength() > 0) {
            String value = issuerDNList.item(0).getTextContent();
            data.setIssuerDN(value);
        }
        if ((subjectDNList = dataElement.getElementsByTagName("SubjectDN")).getLength() > 0) {
            String value = subjectDNList.item(0).getTextContent();
            data.setSubjectDN(value);
        }
        if ((prettyPrintList = dataElement.getElementsByTagName("PrettyPrint")).getLength() > 0) {
            String value = prettyPrintList.item(0).getTextContent();
            data.setPrettyPrint(value);
        }
        if ((encodedList = dataElement.getElementsByTagName("Encoded")).getLength() > 0) {
            String value = encodedList.item(0).getTextContent();
            data.setEncoded(value);
        }
        if ((pkcs7CertChainList = dataElement.getElementsByTagName("PKCS7CertChain")).getLength() > 0) {
            String value = pkcs7CertChainList.item(0).getTextContent();
            data.setPkcs7CertChain(value);
        }
        if ((notBeforeList = dataElement.getElementsByTagName("NotBefore")).getLength() > 0) {
            String value = notBeforeList.item(0).getTextContent();
            data.setNotBefore(value);
        }
        if ((notAfterList = dataElement.getElementsByTagName("NotAfter")).getLength() > 0) {
            String value = notAfterList.item(0).getTextContent();
            data.setNotAfter(value);
        }
        if ((statusList = dataElement.getElementsByTagName("Status")).getLength() > 0) {
            String value = statusList.item(0).getTextContent();
            data.setStatus(value);
        }
        if ((nonceList = dataElement.getElementsByTagName("Nonce")).getLength() > 0) {
            String value = nonceList.item(0).getTextContent();
            data.setNonce(Long.parseLong(value));
        }
        if ((revokedOnList = dataElement.getElementsByTagName("RevokedOn")).getLength() > 0) {
            String value = revokedOnList.item(0).getTextContent();
            data.setRevokedOn(new Date(Long.parseLong(value)));
        }
        if ((revokedByList = dataElement.getElementsByTagName("RevokedBy")).getLength() > 0) {
            String value = revokedByList.item(0).getTextContent();
            data.setRevokedBy(value);
        }
        if ((revocationReasonList = dataElement.getElementsByTagName("RevocationReason")).getLength() > 0) {
            String value = revocationReasonList.item(0).getTextContent();
            data.setRevocationReason(Integer.parseInt(value));
        }
        return data;
    }

    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element infoElement = this.toDOM(document);
        document.appendChild(infoElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static CertData fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element infoElement = document.getDocumentElement();
        return CertData.fromDOM(infoElement);
    }

    public static CertData fromCertChain(PKCS7 pkcs7) throws Exception {
        Date notAfter;
        Date notBefore;
        Principal subjectDN;
        X509Certificate[] certs = pkcs7.getCertificates();
        certs = Cert.sortCertificateChain((X509Certificate[])certs);
        X509Certificate cert = certs[certs.length - 1];
        CertData data = new CertData();
        data.setSerialNumber(new CertId(cert.getSerialNumber()));
        Principal issuerDN = cert.getIssuerDN();
        if (issuerDN != null) {
            data.setIssuerDN(issuerDN.toString());
        }
        if ((subjectDN = cert.getSubjectDN()) != null) {
            data.setSubjectDN(subjectDN.toString());
        }
        if ((notBefore = cert.getNotBefore()) != null) {
            data.setNotBefore(notBefore.toString());
        }
        if ((notAfter = cert.getNotAfter()) != null) {
            data.setNotAfter(notAfter.toString());
        }
        String b64 = "-----BEGIN CERTIFICATE-----\n" + Utils.base64encodeMultiLine((byte[])cert.getEncoded()) + "-----END CERTIFICATE-----\n";
        data.setEncoded(b64);
        byte[] pkcs7bytes = pkcs7.getBytes();
        String pkcs7str = Utils.base64encodeSingleLine((byte[])pkcs7bytes);
        data.setPkcs7CertChain(pkcs7str);
        return data;
    }
}

