/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEHeader;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.ACMERevocation;
import org.dogtagpki.acme.JWK;
import org.dogtagpki.acme.JWS;
import org.dogtagpki.acme.issuer.ACMEIssuer;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="revoke-cert")
@ACMEManagedService
public class ACMERevokeCertificateService {
    public static Logger logger = LoggerFactory.getLogger(ACMERevokeCertificateService.class);
    @Context
    UriInfo uriInfo;

    @POST
    @Produces(value={"application/json"})
    public Response revokeCert(JWS jws) throws Exception {
        logger.info("Revoking certificate");
        String protectedHeader = new String(jws.getProtectedHeaderAsBytes(), "UTF-8");
        logger.info("Header: " + protectedHeader);
        ACMEHeader header = ACMEHeader.fromJSON((String)protectedHeader);
        ACMEEngine engine = ACMEEngine.getInstance();
        engine.validateNonce(header.getNonce());
        String payload = new String(jws.getPayloadAsBytes(), "UTF-8");
        logger.info("Payload: " + payload);
        ACMERevocation revocation = ACMERevocation.fromJSON((String)payload);
        URI kid = header.getKid();
        JWK jwk = header.getJwk();
        if (kid != null && jwk == null) {
            String kidPath = kid.getPath();
            String accountID = kidPath.substring(kidPath.lastIndexOf(47) + 1);
            logger.info("Account ID: " + accountID);
            ACMEAccount account = engine.getAccount(accountID);
            engine.validateJWS(jws, header.getAlg(), account.getJWK());
            engine.validateRevocation(account, revocation);
        } else if (kid == null && jwk != null) {
            engine.validateJWS(jws, header.getAlg(), jwk);
        } else {
            throw new Exception("Invalid revocation request");
        }
        ACMEIssuer issuer = engine.getIssuer();
        issuer.revokeCertificate(revocation);
        logger.info("Certificate revoked");
        Response.ResponseBuilder builder = Response.ok();
        ACMENonce nonce = engine.createNonce();
        builder.header("Replay-Nonce", (Object)nonce.getID());
        URI directoryURL = this.uriInfo.getBaseUriBuilder().path("directory").build(new Object[0]);
        builder.link(directoryURL, "index");
        return builder.build();
    }
}

