/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldapconn;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;

public class LdapConnInfo {
    public static final String PROP_HOST = "host";
    public static final String PROP_PORT = "port";
    public static final String PROP_SECURE = "secureConn";
    public static final String PROP_VERSION = "version";
    public static final String PROP_FOLLOW_REFERRALS = "followReferrals";
    public static final String PROP_HOST_DEFAULT = "localhost";
    public static final String PROP_PORT_DEFAULT = "389";
    public static final int LDAP_VERSION_2 = 2;
    public static final int LDAP_VERSION_3 = 3;
    private String mHost = null;
    private int mPort = -1;
    private boolean mSecure = false;
    private int mVersion = 17;
    private boolean mFollowReferrals = true;

    public LdapConnInfo(LDAPConnectionConfig config) throws EBaseException, ELdapException {
        this.init(config);
    }

    public void init(LDAPConnectionConfig config) throws EBaseException, ELdapException {
        this.mSecure = config.isSecure();
        this.mHost = config.getHostname();
        this.mPort = config.getPort();
        this.mVersion = config.getVersion();
        this.mFollowReferrals = config.getFollowReferrals();
        if (this.mVersion != 2 && this.mVersion != 3) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_PROPERTY", PROP_VERSION));
        }
        if (this.mHost == null || this.mHost.trim().isEmpty()) {
            throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", PROP_HOST));
        }
        if (this.mPort <= 0) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_PROPERTY", PROP_PORT));
        }
    }

    public LdapConnInfo(String host, int port, boolean secure) {
        this.mHost = host;
        this.mPort = port;
        this.mSecure = secure;
        if (this.mHost == null || this.mPort <= 0) {
            throw new IllegalArgumentException("LDAP host or port is null");
        }
    }

    public LdapConnInfo(String host, int port) {
        this.mHost = host;
        this.mPort = port;
        if (this.mHost == null || this.mPort <= 0) {
            throw new IllegalArgumentException("LDAP host or port is null");
        }
    }

    public String getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public boolean getSecure() {
        return this.mSecure;
    }

    public boolean getFollowReferrals() {
        return this.mFollowReferrals;
    }
}

