/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Database<E> {
    public static Logger logger = LoggerFactory.getLogger(Database.class);
    public static final int DEFAULT_SIZE = 20;
    public String name;
    public Map<String, E> records = new LinkedHashMap<String, E>();

    public Database(String name) {
        this.name = name;
        logger.debug("Initializing " + name + " database");
    }

    public Collection<E> findRecords(String filter) throws Exception {
        ArrayList<E> results = new ArrayList<E>();
        for (String id : this.records.keySet()) {
            if (filter != null && !id.contains(filter)) continue;
            results.add(this.records.get(id));
        }
        return results;
    }

    public E getRecord(String id) throws Exception {
        if (!this.records.containsKey(id)) {
            throw new Exception(this.name + " " + id + " does not exist.");
        }
        return this.records.get(id);
    }

    public void addRecord(String id, E record) throws Exception {
        if (this.records.containsKey(id)) {
            throw new Exception(this.name + " " + id + " already exists.");
        }
        this.records.put(id, record);
    }

    public void updateRecord(String id, E record) throws Exception {
        if (!this.records.containsKey(id)) {
            throw new Exception(this.name + " " + id + " does not exist.");
        }
        this.records.put(id, record);
    }

    public void removeRecord(String id) throws Exception {
        if (!this.records.containsKey(id)) {
            throw new Exception(this.name + " " + id + " does not exist.");
        }
        this.records.remove(id);
    }
}

