/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.connector;

import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestTransfer {
    public static Logger logger = LoggerFactory.getLogger(RequestTransfer.class);
    private static String[] transferAttributes = new String[]{"HTTP_PARAMS", "AGENT_PARAMS", "CERT_INFO", "issuedCerts", "OLD_CERTS", "OLD_SERIALS", "revokedCerts", "CACertChain", "CRL", "errors", "Result", "Error", "serviceErrors", "remoteStatus", "remoteReqID", "revokedCertRecs", "certStatus", "challengePhrase", "subjectName", "serialNumber", "serialNoArray", "issuerDN", "certFilter", "keyRecord", "uid"};

    public static boolean isProfileRequest(Request request) {
        String profileId = request.getExtDataInString("profileId");
        return profileId != null && !profileId.equals("");
    }

    public static String[] getTransferAttributes(Request r) {
        if (RequestTransfer.isProfileRequest(r)) {
            logger.debug("RequestTransfer: profile request id = " + r.getRequestId().toString());
            Enumeration<String> e = r.getExtDataKeys();
            Vector<String> v = new Vector<String>();
            while (e.hasMoreElements()) {
                String k = e.nextElement();
                if (k.equals("requestType") || k.equals("requestId") || k.equals("requestVersion") || k.equals("AUTH_TOKEN")) continue;
                if (k.equalsIgnoreCase("requestStatus")) {
                    logger.debug("RequestTransfer : requestStatus=" + r.getExtDataInString("requestStatus"));
                }
                v.addElement(k);
            }
            logger.debug("RequestTransfer: attribute size=" + v.size());
            return v.toArray(new String[v.size()]);
        }
        return transferAttributes;
    }

    public static void transfer(Request src, Request dest) {
        logger.debug("Transfer srcId=" + src.getRequestId().toString() + " destId=" + dest.getRequestId().toString());
        String[] attrs = RequestTransfer.getTransferAttributes(src);
        for (int i = 0; i < attrs.length; ++i) {
            String key = attrs[i];
            if (src.isSimpleExtDataValue(key)) {
                dest.setExtData(key, src.getExtDataInString(key));
                continue;
            }
            dest.setExtData(key, src.getExtDataInHashtable(key));
        }
    }
}

