/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.authorization;

import com.netscape.certsrv.authorization.AuthzMgrPlugin;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.authorization.EAuthzException;
import com.netscape.certsrv.authorization.EAuthzMgrNotFound;
import com.netscape.certsrv.authorization.EAuthzMgrPluginNotFound;
import com.netscape.certsrv.authorization.EAuthzUnknownRealm;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthorizationConfig;
import org.dogtagpki.server.authorization.AuthzManager;
import org.dogtagpki.server.authorization.AuthzManagerConfig;
import org.dogtagpki.server.authorization.AuthzManagerProxy;
import org.dogtagpki.server.authorization.AuthzManagersConfig;
import org.dogtagpki.server.authorization.AuthzToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzSubsystem
extends Subsystem {
    public static Logger logger = LoggerFactory.getLogger(AuthzSubsystem.class);
    public static final String ID = "authz";
    public static final String PROP_CLASS = "class";
    public static final String PROP_IMPL = "impl";
    public Hashtable<String, AuthzMgrPlugin> mAuthzMgrPlugins = new Hashtable();
    public Hashtable<String, AuthzManagerProxy> mAuthzMgrInsts = new Hashtable();
    private String mId = "authz";
    private AuthorizationConfig mConfig;

    @Override
    public void init(ConfigStore config) throws Exception {
        EngineConfig engineConfig = this.engine.getConfig();
        try {
            this.mConfig = engineConfig.getAuthorizationConfig();
            ConfigStore c = this.mConfig.getSubStore(PROP_IMPL, ConfigStore.class);
            Enumeration<String> mImpls = c.getSubStoreNames().elements();
            while (mImpls.hasMoreElements()) {
                String id = mImpls.nextElement();
                String pluginPath = c.getString(id + ".class");
                AuthzMgrPlugin plugin = new AuthzMgrPlugin(id, pluginPath);
                this.mAuthzMgrPlugins.put(id, plugin);
            }
            logger.debug("loaded authz plugins");
            AuthzManagersConfig instancesConfig = this.mConfig.getAuthzManagersConfig();
            Enumeration<String> instances = instancesConfig.getSubStoreNames().elements();
            while (instances.hasMoreElements()) {
                String insName = instances.nextElement();
                AuthzManagerConfig authzMgrConfig = instancesConfig.getAuthzManagerConfig(insName);
                String implName = authzMgrConfig.getPluginName();
                AuthzMgrPlugin plugin = this.mAuthzMgrPlugins.get(implName);
                if (plugin == null) {
                    logger.error("AuthzSubsystem: " + CMS.getLogMessage("CMSCORE_AUTHZ_PLUGIN_NOT_FOUND", implName));
                    throw new EAuthzMgrPluginNotFound(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZMGR_PLUGIN_NOT_FOUND", implName));
                }
                logger.debug(CMS.getLogMessage("CMSCORE_AUTHZ_PLUGIN_FOUND", implName));
                String className = plugin.getClassPath();
                boolean isEnable = false;
                AuthzManager authzMgrInst = null;
                try {
                    authzMgrInst = (AuthzManager)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    authzMgrInst.setCMSEngine(this.engine);
                    authzMgrInst.init(insName, implName, authzMgrConfig);
                    isEnable = true;
                    logger.info("AuthzSubsystem: " + CMS.getLogMessage("CMSCORE_AUTHZ_INSTANCE_ADDED", insName));
                }
                catch (ClassNotFoundException e) {
                    logger.error("AuthzSubsystem: " + CMS.getLogMessage("OPERATION_ERROR", e.getMessage()), (Throwable)e);
                    throw new EAuthzException(CMS.getUserMessage("CMS_AUTHORIZATION_LOAD_CLASS_FAIL", className));
                }
                catch (IllegalAccessException e) {
                    logger.error("AuthzSubsystem: " + CMS.getLogMessage("OPERATION_ERROR", e.getMessage()), (Throwable)e);
                    throw new EAuthzException(CMS.getUserMessage("CMS_AUTHORIZATION_LOAD_CLASS_FAIL", className));
                }
                catch (InstantiationException e) {
                    logger.error("AuthzSubsystem: " + CMS.getLogMessage("OPERATION_ERROR", e.getMessage()), (Throwable)e);
                    throw new EAuthzException(CMS.getUserMessage("CMS_AUTHORIZATION_LOAD_CLASS_FAIL", className));
                }
                catch (Exception e) {
                    logger.warn("AuthzSubsystem: unable to initialize authz instance: " + insName + ": " + e.getMessage(), (Throwable)e);
                }
                this.mAuthzMgrInsts.put(insName, new AuthzManagerProxy(isEnable, authzMgrInst));
                logger.debug("loaded authz instance " + insName + " impl " + implName);
            }
        }
        catch (EBaseException e) {
            logger.error("Unable to initialize AuthzSubsystem: " + e.getMessage(), (Throwable)e);
            if (this.engine.isPreOpMode()) {
                logger.warn("AuthzSubsystem.init(): Swallow exception in pre-op mode");
                return;
            }
            throw e;
        }
        logger.info("AuthzSubsystem: " + CMS.getLogMessage("INIT_DONE", this.getId()));
    }

    public void authzMgrAccessInit(String authzMgrInstName, String accessInfo) throws EAuthzMgrNotFound, EBaseException {
        AuthzManagerProxy proxy = this.mAuthzMgrInsts.get(authzMgrInstName);
        if (proxy == null) {
            throw new EAuthzMgrNotFound(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZMGR_NOT_FOUND", authzMgrInstName));
        }
        if (!proxy.isEnable()) {
            throw new EAuthzMgrNotFound(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZMGR_NOT_FOUND", authzMgrInstName));
        }
        AuthzManager authzMgrInst = proxy.getAuthzManager();
        if (authzMgrInst == null) {
            throw new EAuthzMgrNotFound(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZMGR_NOT_FOUND", authzMgrInstName));
        }
        authzMgrInst.accessInit(accessInfo);
    }

    public void addACLInfo(String aclMethod, String aclInfo) throws EBaseException {
        StringTokenizer tokenizer = new StringTokenizer(aclInfo, "#");
        while (tokenizer.hasMoreTokens()) {
            String acl = tokenizer.nextToken();
            this.authzMgrAccessInit(aclMethod, acl);
        }
    }

    public AuthzToken authorize(String authzMgrInstName, AuthToken authToken, String resource, String operation, String realm) throws EAuthzMgrNotFound, EBaseException {
        AuthzManagerProxy proxy = this.mAuthzMgrInsts.get(authzMgrInstName);
        if (proxy == null) {
            throw new EAuthzMgrNotFound(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZMGR_NOT_FOUND", authzMgrInstName));
        }
        if (!proxy.isEnable()) {
            throw new EAuthzMgrNotFound(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZMGR_NOT_FOUND", authzMgrInstName));
        }
        AuthzManager authzMgrInst = proxy.getAuthzManager();
        if (authzMgrInst == null) {
            throw new EAuthzMgrNotFound(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZMGR_NOT_FOUND", authzMgrInstName));
        }
        if (realm != null && resource != null) {
            resource = realm + "." + (String)resource;
        }
        return authzMgrInst.authorize(authToken, (String)resource, operation);
    }

    public AuthzToken authorize(String authzMgrName, AuthToken authToken, String resource, String operation) throws EBaseException {
        return this.authorize(authzMgrName, authToken, resource, operation, null);
    }

    public AuthzToken authorize(String authzMgrInstName, AuthToken authToken, String exp) throws EAuthzMgrNotFound, EBaseException {
        AuthzManagerProxy proxy = this.mAuthzMgrInsts.get(authzMgrInstName);
        if (proxy == null) {
            throw new EAuthzMgrNotFound(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZMGR_NOT_FOUND", authzMgrInstName));
        }
        if (!proxy.isEnable()) {
            throw new EAuthzMgrNotFound(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZMGR_NOT_FOUND", authzMgrInstName));
        }
        AuthzManager authzMgrInst = proxy.getAuthzManager();
        if (authzMgrInst == null) {
            throw new EAuthzMgrNotFound(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZMGR_NOT_FOUND", authzMgrInstName));
        }
        return authzMgrInst.authorize(authToken, exp);
    }

    public String[] getConfigParams(String implName) throws EAuthzMgrPluginNotFound, EBaseException {
        AuthzMgrPlugin plugin = this.mAuthzMgrPlugins.get(implName);
        if (plugin == null) {
            logger.error("AuthzSubsystem: " + CMS.getLogMessage("CMSCORE_AUTHZ_PLUGIN_NOT_FOUND", implName));
            throw new EAuthzMgrPluginNotFound(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZMGR_PLUGIN_NOT_FOUND", implName));
        }
        AuthzManager authzMgrInst = null;
        String className = plugin.getClassPath();
        try {
            authzMgrInst = (AuthzManager)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return authzMgrInst.getConfigParams();
        }
        catch (Exception e) {
            logger.error("AuthzSubsystem: " + CMS.getLogMessage("CMSCORE_AUTHZ_PLUGIN_NOT_CREATED", e.toString()), (Throwable)e);
            throw new EAuthzException(CMS.getUserMessage("CMS_AUTHORIZATION_LOAD_CLASS_FAIL", className));
        }
    }

    public void add(String name, AuthzManager authzMgrInst) {
        this.mAuthzMgrInsts.put(name, new AuthzManagerProxy(true, authzMgrInst));
    }

    public void delete(String name) {
        this.mAuthzMgrInsts.remove(name);
    }

    public AuthzManager get(String name) {
        AuthzManagerProxy proxy = this.mAuthzMgrInsts.get(name);
        if (proxy == null) {
            return null;
        }
        return proxy.getAuthzManager();
    }

    public Enumeration<AuthzManager> getAuthzManagers() {
        Vector<AuthzManager> inst = new Vector<AuthzManager>();
        Enumeration<String> e = this.mAuthzMgrInsts.keys();
        while (e.hasMoreElements()) {
            AuthzManager p = this.get(e.nextElement());
            if (p == null) continue;
            inst.addElement(p);
        }
        return inst.elements();
    }

    public Enumeration<AuthzMgrPlugin> getAuthzManagerPlugins() {
        return this.mAuthzMgrPlugins.elements();
    }

    public AuthzMgrPlugin getAuthzManagerPluginImpl(String name) {
        return this.mAuthzMgrPlugins.get(name);
    }

    public AuthzManager getAuthzManagerPlugin(String name) {
        AuthzMgrPlugin plugin = this.mAuthzMgrPlugins.get(name);
        String classpath = plugin.getClassPath();
        AuthzManager authzMgrInst = null;
        try {
            authzMgrInst = (AuthzManager)Class.forName(classpath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return authzMgrInst;
        }
        catch (Exception e) {
            logger.warn("AuthzSubsystem: " + CMS.getLogMessage("CMSCORE_AUTHZ_PLUGIN_NOT_CREATED", e.toString()), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    @Override
    public void startup() throws EBaseException {
    }

    @Override
    public void shutdown() {
        for (AuthzManagerProxy proxy : this.mAuthzMgrInsts.values()) {
            AuthzManager mgr = proxy.getAuthzManager();
            if (mgr == null) continue;
            mgr.shutdown();
        }
        this.mAuthzMgrPlugins.clear();
        this.mAuthzMgrInsts.clear();
    }

    public Hashtable<String, AuthzMgrPlugin> getPlugins() {
        return this.mAuthzMgrPlugins;
    }

    public Hashtable<String, AuthzManagerProxy> getInstances() {
        return this.mAuthzMgrInsts;
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public AuthzManager getAuthzManager(String name) {
        return this.get(name);
    }

    public void checkRealm(String realm, AuthToken authToken, String owner, String resource, String operation) throws EBaseException {
        if (realm == null) {
            return;
        }
        if (owner != null && owner.equals(authToken.getInString("userid"))) {
            return;
        }
        String mgrName = this.getAuthzManagerNameByRealm(realm);
        AuthzToken authzToken = this.authorize(mgrName, authToken, resource, operation, realm);
        if (authzToken == null) {
            throw new EAuthzAccessDenied("Not authorized by ACL realm");
        }
    }

    public String getAuthzManagerNameByRealm(String realm) throws EAuthzUnknownRealm {
        for (AuthzManagerProxy proxy : this.mAuthzMgrInsts.values()) {
            AuthzManager mgr = proxy.getAuthzManager();
            if (mgr == null) continue;
            AuthzManagerConfig cfg = mgr.getConfigStore();
            String mgrRealmString = null;
            try {
                mgrRealmString = cfg.getRealmName();
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            if (mgrRealmString == null) continue;
            List<String> mgrRealms = Arrays.asList(mgrRealmString.split(","));
            for (String mgrRealm : mgrRealms) {
                if (!mgrRealm.equals(realm)) continue;
                return mgr.getName();
            }
        }
        throw new EAuthzUnknownRealm("Realm not found");
    }
}

