/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.SecurityDomainSessionTable;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.base.UnauthorizedException;
import com.netscape.certsrv.logging.event.ConfigRoleEvent;
import com.netscape.certsrv.logging.event.RoleAssumeEvent;
import com.netscape.certsrv.system.DomainInfo;
import com.netscape.certsrv.system.InstallToken;
import com.netscape.certsrv.system.SecurityDomainHost;
import com.netscape.certsrv.system.SecurityDomainSubsystem;
import com.netscape.cms.servlet.processors.Processor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.StringWriter;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityDomainProcessor
extends Processor {
    public static Logger logger = LoggerFactory.getLogger(SecurityDomainProcessor.class);
    public static final String[] TYPES = new String[]{"CA", "KRA", "OCSP", "TKS", "RA", "TPS"};
    public static final String SUCCESS = "0";
    public static final String FAILED = "1";

    public SecurityDomainProcessor(Locale locale) {
        super("securitydomain", locale);
    }

    public static String getEnterpriseGroupName(String subsystemname) {
        return "Enterprise " + subsystemname + " Administrators";
    }

    public InstallToken getInstallToken(String user, String host, String subsystem) throws Exception {
        subsystem = subsystem.toUpperCase();
        UGSubsystem ugSubsystem = this.engine.getUGSubsystem();
        Auditor auditor = this.engine.getAuditor();
        String group = SecurityDomainProcessor.getEnterpriseGroupName(subsystem);
        logger.debug("SecurityDomainProcessor: group: " + group);
        if (!ugSubsystem.isMemberOf(user, group)) {
            auditor.log(RoleAssumeEvent.createFailureEvent(user, group));
            throw new UnauthorizedException("User " + user + " is not a member of " + group + " group.");
        }
        auditor.log(RoleAssumeEvent.createSuccessEvent(user, group));
        String ip = "";
        try {
            ip = InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception e) {
            logger.warn("Unable to determine IP address for " + host + ": " + e.getMessage(), (Throwable)e);
        }
        JssSubsystem jssSubsystem = this.engine.getJSSSubsystem();
        SecureRandom random = jssSubsystem.getRandomNumberGenerator();
        Long num = Math.abs(random.nextLong());
        String sessionID = num.toString();
        String auditParams = "operation;;issue_token+token;;" + sessionID + "+ip;;" + ip + "+uid;;" + user + "+groupname;;" + group;
        SecurityDomainSessionTable ctable = this.engine.getSecurityDomainSessionTable();
        try {
            ctable.addEntry(sessionID, ip, user, group);
            String message = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SECURITY_DOMAIN_UPDATE_1", user, "Success", auditParams);
            auditor.log(message);
        }
        catch (Exception e) {
            String message = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SECURITY_DOMAIN_UPDATE_1", user, "Failure", auditParams);
            auditor.log(message);
            throw new PKIException("Unable to create session: " + e.getMessage(), (Throwable)e);
        }
        return new InstallToken(sessionID);
    }

    public DomainInfo getDomainInfo() throws EBaseException {
        DomainInfo domainInfo;
        block17: {
            EngineConfig cs = this.engine.getConfig();
            PKISocketConfig socketConfig = cs.getSocketConfig();
            LdapBoundConnFactory connFactory = null;
            LDAPConnection conn = null;
            try {
                LDAPSearchConstraints cons = null;
                String[] attrs = null;
                LDAPConfig ldapConfig = cs.getInternalDBConfig();
                String basedn = ldapConfig.getBaseDN();
                Object dn = "ou=Security Domain," + basedn;
                String filter = "objectclass=pkiSecurityGroup";
                connFactory = new LdapBoundConnFactory("SecurityDomainProcessor");
                connFactory.setCMSEngine(this.engine);
                connFactory.init(socketConfig, ldapConfig, this.engine.getPasswordStore());
                conn = connFactory.getConn();
                String name = (String)conn.read((String)dn).getAttribute("name").getStringValues().nextElement();
                logger.debug("SecurityDomainProcessor: name: " + name);
                DomainInfo domain = new DomainInfo();
                domain.setName(name);
                LDAPSearchResults res = conn.search((String)dn, 1, filter, attrs, true, cons);
                while (res.hasMoreElements()) {
                    dn = res.next().getDN();
                    String listName = ((String)dn).substring(3, ((String)dn).indexOf(","));
                    String subType = listName.substring(0, listName.indexOf("List"));
                    logger.debug("SecurityDomainProcessor: subtype: " + subType);
                    filter = "objectclass=pkiSubsystem";
                    LDAPSearchResults res2 = conn.search((String)dn, 1, filter, attrs, false, cons);
                    while (res2.hasMoreElements()) {
                        LDAPEntry entry = res2.next();
                        logger.debug("SecurityDomainProcessor:  - " + entry.getDN());
                        SecurityDomainHost host = new SecurityDomainHost();
                        LDAPAttributeSet entryAttrs = entry.getAttributeSet();
                        Enumeration attrsInSet = entryAttrs.getAttributes();
                        while (attrsInSet.hasMoreElements()) {
                            LDAPAttribute nextAttr = (LDAPAttribute)attrsInSet.nextElement();
                            String attrName = nextAttr.getName();
                            String attrValue = (String)nextAttr.getStringValues().nextElement();
                            logger.debug("SecurityDomainProcessor:    - " + attrName + ": " + attrValue);
                            if ("Host".equalsIgnoreCase(attrName)) {
                                host.setHostname(attrValue);
                                continue;
                            }
                            if ("UnSecurePort".equalsIgnoreCase(attrName)) {
                                host.setPort(attrValue);
                                continue;
                            }
                            if ("SecurePort".equalsIgnoreCase(attrName)) {
                                host.setSecurePort(attrValue);
                                continue;
                            }
                            if ("SecureEEClientAuthPort".equalsIgnoreCase(attrName)) {
                                host.setSecureEEClientAuthPort(attrValue);
                                continue;
                            }
                            if ("SecureAgentPort".equalsIgnoreCase(attrName)) {
                                host.setSecureAgentPort(attrValue);
                                continue;
                            }
                            if ("SecureAdminPort".equalsIgnoreCase(attrName)) {
                                host.setSecureAdminPort(attrValue);
                                continue;
                            }
                            if ("Clone".equalsIgnoreCase(attrName)) {
                                host.setClone(attrValue);
                                continue;
                            }
                            if ("SubsystemName".equalsIgnoreCase(attrName)) {
                                host.setSubsystemName(attrValue);
                                continue;
                            }
                            if (!"DomainManager".equalsIgnoreCase(attrName)) continue;
                            host.setDomainManager(attrValue);
                        }
                        String port = host.getSecurePort();
                        if (port == null) {
                            port = host.getSecureEEClientAuthPort();
                        }
                        host.setId(subType + " " + host.getHostname() + " " + port);
                        domain.addHost(subType, host);
                    }
                }
                domainInfo = domain;
                if (conn == null || connFactory == null) break block17;
            }
            catch (Exception e) {
                try {
                    logger.error("SecurityDomainProcessor: Failed to read domain info from ldap " + e.getMessage(), (Throwable)e);
                    throw new EBaseException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (conn != null && connFactory != null) {
                        logger.debug("Releasing ldap connection");
                        connFactory.returnConn(conn);
                    }
                    throw throwable;
                }
            }
            logger.debug("Releasing ldap connection");
            connFactory.returnConn(conn);
        }
        return domainInfo;
    }

    public XMLObject getDomainXML() throws EBaseException, ParserConfigurationException {
        return SecurityDomainProcessor.convertDomainInfoToXMLObject(this.getDomainInfo());
    }

    public static XMLObject convertDomainInfoToXMLObject(DomainInfo domain) throws ParserConfigurationException {
        XMLObject xmlObject = new XMLObject();
        Node domainInfo = xmlObject.createRoot("DomainInfo");
        xmlObject.addItemToContainer(domainInfo, "Name", domain.getName());
        for (String subType : TYPES) {
            int counter;
            SecurityDomainSubsystem subsystem = domain.getSubsystem(subType);
            Node listNode = xmlObject.createContainer(domainInfo, subType + "List");
            if (subsystem == null) {
                counter = 0;
            } else {
                counter = subsystem.getHostArray().length;
                for (SecurityDomainHost host : subsystem.getHostArray()) {
                    Node node = xmlObject.createContainer(listNode, subType);
                    String value = host.getHostname();
                    if (value != null) {
                        xmlObject.addItemToContainer(node, "Host", value);
                    }
                    if ((value = host.getPort()) != null) {
                        xmlObject.addItemToContainer(node, "UnSecurePort", value);
                    }
                    if ((value = host.getSecurePort()) != null) {
                        xmlObject.addItemToContainer(node, "SecurePort", value);
                    }
                    if ((value = host.getSecureEEClientAuthPort()) != null) {
                        xmlObject.addItemToContainer(node, "SecureEEClientAuthPort", value);
                    }
                    if ((value = host.getSecureAgentPort()) != null) {
                        xmlObject.addItemToContainer(node, "SecureAgentPort", value);
                    }
                    if ((value = host.getSecureAdminPort()) != null) {
                        xmlObject.addItemToContainer(node, "SecureAdminPort", value);
                    }
                    if ((value = host.getClone()) != null) {
                        xmlObject.addItemToContainer(node, "Clone", value);
                    }
                    if ((value = host.getSubsystemName()) != null) {
                        xmlObject.addItemToContainer(node, "SubsystemName", value);
                    }
                    if ((value = host.getDomainManager()) == null) continue;
                    xmlObject.addItemToContainer(node, "DomainManager", value);
                }
            }
            xmlObject.addItemToContainer(listNode, "SubsystemCount", Integer.toString(counter));
        }
        return xmlObject;
    }

    public static DomainInfo convertXMLObjectToDomainInfo(XMLObject xmlObject) {
        DomainInfo domain = new DomainInfo();
        Document doc = xmlObject.getDocument();
        Node rootNode = doc.getFirstChild();
        Vector values = xmlObject.getValuesFromContainer(rootNode, "Name");
        if (!values.isEmpty()) {
            domain.setName((String)values.firstElement());
        }
        for (String type : TYPES) {
            NodeList hosts = doc.getElementsByTagName(type);
            for (int j = 0; j < hosts.getLength(); ++j) {
                String port;
                Node hostNode = hosts.item(j);
                SecurityDomainHost host = new SecurityDomainHost();
                values = xmlObject.getValuesFromContainer(hostNode, "Host");
                if (!values.isEmpty()) {
                    host.setHostname((String)values.firstElement());
                }
                if (!(values = xmlObject.getValuesFromContainer(hostNode, "UnSecurePort")).isEmpty()) {
                    host.setPort((String)values.firstElement());
                }
                if (!(values = xmlObject.getValuesFromContainer(hostNode, "SecurePort")).isEmpty()) {
                    host.setSecurePort((String)values.firstElement());
                }
                if (!(values = xmlObject.getValuesFromContainer(hostNode, "SecureEEClientAuthPort")).isEmpty()) {
                    host.setSecureEEClientAuthPort((String)values.firstElement());
                }
                if (!(values = xmlObject.getValuesFromContainer(hostNode, "SecureAgentPort")).isEmpty()) {
                    host.setSecureAgentPort((String)values.firstElement());
                }
                if (!(values = xmlObject.getValuesFromContainer(hostNode, "SecureAdminPort")).isEmpty()) {
                    host.setSecureAdminPort((String)values.firstElement());
                }
                if (!(values = xmlObject.getValuesFromContainer(hostNode, "Clone")).isEmpty()) {
                    host.setClone((String)values.firstElement());
                }
                if (!(values = xmlObject.getValuesFromContainer(hostNode, "SubsystemName")).isEmpty()) {
                    host.setSubsystemName((String)values.firstElement());
                }
                if (!(values = xmlObject.getValuesFromContainer(hostNode, "DomainManager")).isEmpty()) {
                    host.setDomainManager((String)values.firstElement());
                }
                if ((port = host.getSecurePort()) == null) {
                    port = host.getSecureEEClientAuthPort();
                }
                host.setId(type + " " + host.getHostname() + " " + port);
                domain.addHost(type, host);
            }
        }
        return domain;
    }

    public String removeHost(String name, String type, String hostname, String securePort) throws EBaseException {
        EngineConfig cs = this.engine.getConfig();
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        String baseDN = ldapConfig.getBaseDN();
        String listName = type + "List";
        String cn = hostname + ":" + securePort;
        String hostDN = "cn=" + cn + ",cn=" + listName + ",ou=Security Domain," + baseDN;
        logger.info("SecurityDomainProcessor: Removing host " + hostDN);
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String domainAuditParams = "host;;" + hostname + "+name;;" + name + "+sport;;" + securePort + "+type;;" + type + "+operation;;remove";
        String status = this.removeEntry(hostDN);
        if (!status.equals(SUCCESS)) {
            auditor.log(CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SECURITY_DOMAIN_UPDATE_1", auditSubjectID, "Failure", domainAuditParams));
            return status;
        }
        String adminDN = "uid=" + type + "-" + hostname + "-" + securePort + ",ou=People," + baseDN;
        logger.info("SecurityDomainProcessor: Removing admin " + adminDN);
        String usersAuditParams = "Scope;;users+Operation;;OP_DELETE+source;;SecurityDomainProcessor+resource;;" + adminDN;
        status = this.removeEntry(adminDN);
        if (!status.equals(SUCCESS)) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", usersAuditParams));
            auditor.log(CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SECURITY_DOMAIN_UPDATE_1", auditSubjectID, "Failure", domainAuditParams));
            return status;
        }
        auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", usersAuditParams));
        String groupDN = "cn=Subsystem Group, ou=groups," + baseDN;
        logger.info("SecurityDomainProcessor: Removing admin from group " + groupDN);
        String groupsAuditParams = "Scope;;groups+Operation;;OP_DELETE_USER+source;;SecurityDomainProcessor+resource;;Subsystem Group+user;;" + adminDN;
        LDAPModification mod = new LDAPModification(1, new LDAPAttribute("uniqueMember", adminDN));
        status = this.modifyEntry(groupDN, mod);
        if (!status.equals(SUCCESS)) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", groupsAuditParams));
            auditor.log(CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SECURITY_DOMAIN_UPDATE_1", auditSubjectID, "Failure", domainAuditParams));
            return status;
        }
        auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", groupsAuditParams));
        auditor.log(CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SECURITY_DOMAIN_UPDATE_1", auditSubjectID, "Success", domainAuditParams));
        return SUCCESS;
    }

    /*
     * Exception decompiling
     */
    public String addHost(String name, String type, String hostname, String securePort, String unsecurePort, String eeCAPort, String adminSecurePort, String agentSecurePort, String domainManager, String clone) throws EBaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String modifyEntry(String dn, LDAPModification mod) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String removeEntry(String dn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String auditSubjectID() {
        SessionContext auditContext = SessionContext.getExistingContext();
        if (auditContext == null) {
            return "$Unidentified$";
        }
        String subjectID = (String)auditContext.get((Object)"userid");
        if (subjectID == null) {
            return "$NonRoleUser$";
        }
        return subjectID.trim();
    }

    public static void main(String[] args) throws Exception {
        DomainInfo before = new DomainInfo();
        before.setName("EXAMPLE");
        SecurityDomainHost host = new SecurityDomainHost();
        host.setId("CA localhost 8443");
        host.setHostname("localhost");
        host.setPort("8080");
        host.setSecurePort("8443");
        host.setDomainManager("TRUE");
        before.addHost("CA", host);
        System.out.println("Before:");
        System.out.println(before);
        XMLObject xmlObject = SecurityDomainProcessor.convertDomainInfoToXMLObject(before);
        Document document = xmlObject.getDocument();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StringWriter sw = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(sw));
        System.out.println("Domain XML:");
        System.out.println(sw);
        DomainInfo after = SecurityDomainProcessor.convertXMLObjectToDomainInfo(xmlObject);
        System.out.println("After:");
        System.out.println(after);
    }
}

