/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.connector;

import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.connector.IPKIMessage;
import com.netscape.certsrv.logging.event.CertRequestProcessedEvent;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.connector.HttpPKIMessage;
import com.netscape.cmscore.connector.HttpRequestEncoder;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(ConnectorServlet.class);
    private static final long serialVersionUID = 1221916495803185863L;
    public static final String INFO = "Connector Servlet";
    public static final String PROP_AUTHORITY = "authority";
    protected ServletConfig mConfig = null;
    protected IAuthority mAuthority = null;
    protected HttpRequestEncoder mReqEncoder;
    protected AuthSubsystem mAuthSubsystem;
    private static final String SIGNED_AUDIT_PROTECTION_METHOD_SSL = "ssl";

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CMSEngine engine = this.getCMSEngine();
        this.mConfig = sc;
        String authority = sc.getInitParameter(PROP_AUTHORITY);
        if (authority != null) {
            this.mAuthority = (IAuthority)((Object)engine.getSubsystem(authority));
        }
        this.mReqEncoder = new HttpRequestEncoder();
        this.mAuthSubsystem = engine.getAuthSubsystem();
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.serviceImpl(request, response);
        }
        catch (ServletException e) {
            logger.error("ConnectorServlet: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error("ConnectorServlet: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            logger.error("ConnectorServlet: " + t.getMessage(), t);
            throw new RuntimeException(t);
        }
    }

    public void serviceImpl(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        X509Certificate peerCert;
        logger.info("ConnectorServlet: Processing request for " + request.getRequestURI());
        CMSEngine engine = this.getCMSEngine();
        boolean running_state = engine.isInRunningState();
        if (!running_state) {
            logger.error("ConnectorServlet: Server is not ready");
            throw new IOException("Server is not ready");
        }
        HttpServletRequest req = request;
        HttpServletResponse resp = response;
        CMSRequest cmsRequest = this.newCMSRequest();
        cmsRequest.setHttpParams(new ArgBlock(ConnectorServlet.toHashtable(request)));
        cmsRequest.setHttpReq(request);
        cmsRequest.setHttpResp(response);
        cmsRequest.setServletConfig(this.mConfig);
        cmsRequest.setServletContext(this.mConfig.getServletContext());
        char[] content = null;
        String encodedreq = null;
        String method = null;
        int len = -1;
        IPKIMessage msg = null;
        IPKIMessage replymsg = null;
        method = req.getMethod();
        len = request.getContentLength();
        if (len > 0) {
            int done;
            ServletInputStream in = request.getInputStream();
            InputStreamReader inreader = new InputStreamReader((InputStream)in, "UTF8");
            BufferedReader reader = new BufferedReader(inreader, len);
            content = new char[len];
            for (int total = done = reader.read(content, 0, len); done >= 0 && total < len; total += done) {
                done = reader.read(content, total, len - total);
            }
            reader.close();
            encodedreq = new String(content);
        }
        try {
            peerCert = this.getPeerCert(req);
        }
        catch (EBaseException e) {
            logger.warn("ConnectorServlet: Unable to get peer certificate: " + e.getMessage(), (Throwable)e);
            resp.sendError(401);
            return;
        }
        if (peerCert == null) {
            logger.warn("ConnectorServlet: Missing peer certificate");
            resp.sendError(403);
            return;
        }
        String RA_Id = null;
        String raUserId = null;
        AuthToken token = null;
        try {
            token = this.authenticate(request);
            raUserId = token.getInString("userid");
            RA_Id = peerCert.getSubjectDN().toString();
        }
        catch (EInvalidCredentials e) {
            logger.warn("ConnectorServlet: Invalid credentials: " + e.getMessage(), (Throwable)e);
            resp.sendError(401);
            return;
        }
        catch (EBaseException e) {
            logger.warn("ConnectorServlet: " + e.getMessage(), (Throwable)e);
            resp.sendError(403);
            return;
        }
        logger.info("ConnectorServlet: Subject DN: " + peerCert.getSubjectDN());
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, token, this.mAuthzResourceName, "submit");
        }
        catch (Exception e) {
            logger.warn("ConnectorServlet: Unable to get authorization token: " + e.getMessage(), (Throwable)e);
        }
        if (authzToken == null) {
            logger.warn("ConnectorServlet: Missing authorization token");
            cmsRequest.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        if (!method.equalsIgnoreCase("POST")) {
            logger.warn("ConnectorServlet: Method not allowed: " + method);
            resp.sendError(405);
            return;
        }
        if (len <= 0) {
            logger.warn("ConnectorServlet: Missing request content");
            resp.sendError(411);
            return;
        }
        logger.info("ConnectorServlet: RA ID: " + RA_Id);
        try {
            msg = (IPKIMessage)this.mReqEncoder.decode(encodedreq);
            replymsg = this.processRequest(RA_Id, raUserId, msg, token);
        }
        catch (IOException e) {
            logger.error("ConnectorServlet: " + e.getMessage(), (Throwable)e);
            logger.error(CMS.getLogMessage("CMSGW_IO_ERROR_REMOTE_REQUEST", e.toString()));
            resp.sendError(400);
            return;
        }
        catch (EBaseException e) {
            logger.error("ConnectorServlet: " + e.getMessage(), (Throwable)e);
            logger.error(CMS.getLogMessage("CMSGW_IO_ERROR_REMOTE_REQUEST", e.toString()));
            resp.sendError(500);
            return;
        }
        catch (Exception e) {
            logger.warn("ConnectorServlet: service " + e.getMessage(), (Throwable)e);
        }
        logger.info("ConnectorServlet: Request processed");
        try {
            String encodedrep = this.mReqEncoder.encode(replymsg);
            resp.setStatus(200);
            resp.setContentType("text/html");
            resp.setContentLength(encodedrep.length());
            ServletOutputStream out = response.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF8");
            writer.write(encodedrep);
            writer.flush();
            writer.close();
            out.flush();
        }
        catch (Exception e) {
            logger.warn("ConnectorServlet: " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isProfileRequest(Request request) {
        String profileId = request.getExtDataInString("profileId");
        return profileId != null && !profileId.equals("");
    }

    public void normalizeProfileRequest(Request request) {
        X509CertInfo info = null;
        try {
            CertificateAlgorithmId certAlg;
            CertificateExtensions extensions;
            CertificateValidity certValidity;
            CertificateSubjectName certSubject;
            ByteArrayOutputStream byteStream;
            info = request.getExtDataInCertInfo("req_x509info");
            CertificateX509Key certKey = (CertificateX509Key)info.get("key");
            if (certKey != null) {
                byteStream = new ByteArrayOutputStream();
                certKey.encode((OutputStream)byteStream);
                request.setExtData("req_key", byteStream.toByteArray());
            }
            if ((certSubject = (CertificateSubjectName)info.get("subject")) != null) {
                request.setExtData("req_subject_name", certSubject);
            }
            if ((certValidity = (CertificateValidity)info.get("validity")) != null) {
                byteStream = new ByteArrayOutputStream();
                certValidity.encode((OutputStream)byteStream);
                request.setExtData("req_validity", byteStream.toByteArray());
            }
            if ((extensions = (CertificateExtensions)info.get("extensions")) != null) {
                request.setExtData("req_extensions", extensions);
            }
            if ((certAlg = (CertificateAlgorithmId)info.get("algorithmID")) != null) {
                ByteArrayOutputStream certAlgOut = new ByteArrayOutputStream();
                certAlg.encode((OutputStream)certAlgOut);
                request.setExtData("req_signing_alg", certAlgOut.toByteArray());
            }
        }
        catch (Exception e) {
            logger.warn("ConnectorServlet: profile normalization " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPKIMessage processRequest(String source, String sourceUserId, IPKIMessage msg, AuthToken token) throws EBaseException {
        String method = "ConnectorServlet: processRequest: ";
        String auditMessage = null;
        String auditSubjectID = sourceUserId;
        String auditProtectionMethod = SIGNED_AUDIT_PROTECTION_METHOD_SSL;
        String auditRequestType = msg.getReqType();
        String auditRequesterID = msg.getReqId();
        String auditCertificateSubjectName = "<null>";
        String subject = null;
        auditSubjectID = auditSubjectID != null ? auditSubjectID.trim() : "$Unidentified$";
        auditRequestType = auditRequestType != null ? auditRequestType.trim() : "<null>";
        auditRequesterID = auditRequesterID != null ? auditRequesterID.trim() : "$Unidentified$";
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        HttpPKIMessage replymsg = null;
        try {
            RequestQueue queue = engine.getRequestQueue();
            String srcid = source + ":" + msg.getReqId();
            logger.debug(method + "srcid =" + srcid);
            RequestId thisreqid = queue.findRequestBySourceId(srcid);
            Request thisreq = null;
            if (thisreqid != null) {
                logger.debug(method + "thisreqid not null:" + thisreqid);
                thisreq = this.requestRepository.readRequest(thisreqid);
                if (thisreq == null) {
                    String errormsg = "Cannot find request in request queue " + thisreqid;
                    logger.error(method + CMS.getLogMessage("CMSGW_REQUEST_ID_NOT_FOUND_1", thisreqid.toString()));
                    auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_INTER_BOUNDARY_SUCCESS_5", auditSubjectID, "Failure", auditProtectionMethod, auditRequestType, auditRequesterID);
                    auditor.log(auditMessage);
                    throw new EBaseException(errormsg);
                }
                String errormsg = "Found request " + thisreqid + " for " + srcid;
                String sskKeygenStage = thisreq.getExtDataInString("serverSideKeygenStage");
                if (sskKeygenStage != null && sskKeygenStage.equalsIgnoreCase("serverSideKeygenStage_keygen")) {
                    logger.debug("ConnectorServlet:processRequest: Stage=" + sskKeygenStage);
                } else {
                    logger.debug(method + errormsg);
                    replymsg = new HttpPKIMessage();
                    replymsg.fromRequest(thisreq);
                    auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_INTER_BOUNDARY_SUCCESS_5", auditSubjectID, "Success", auditProtectionMethod, auditRequestType, auditRequesterID);
                    auditor.log(auditMessage);
                    return replymsg;
                }
            }
            thisreq = this.requestRepository.createRequest(msg.getReqType());
            logger.debug("ConnectorServlet: created requestId=" + thisreq.getRequestId().toString());
            thisreq.setSourceId(srcid);
            msg.toRequest(thisreq);
            thisreq.setExtData("dbStatus", "NOT_UPDATED");
            thisreq.setExtData("requestStatus", "begin");
            boolean isSSKeygen = false;
            String isSSKeygenStr = thisreq.getExtDataInString("isServerSideKeygen");
            if (isSSKeygenStr != null && isSSKeygenStr.equalsIgnoreCase("true")) {
                logger.debug("ConnectorServlet:isServerSideKeygen = true");
                isSSKeygen = true;
                String sskKeygenStage = thisreq.getExtDataInString("serverSideKeygenStage");
                if (sskKeygenStage != null && sskKeygenStage.equalsIgnoreCase("serverSideKeygenStage_keygen")) {
                    logger.debug(method + "isServerSideKeygen Stage=" + sskKeygenStage);
                    thisreq.setRequestType("asymkeyGenRequest");
                } else if (sskKeygenStage.equalsIgnoreCase("serverSideKeygenStage_key_retrieve")) {
                    logger.debug(method + "isServerSideKeygen Stage=" + sskKeygenStage);
                    thisreq.setRequestType("recovery");
                }
                String clientKeyId = thisreq.getExtDataInString("clientKeyID");
                if (clientKeyId != null) {
                    logger.debug(method + "isServerSideKeygen clientKeyId = " + clientKeyId);
                } else {
                    logger.debug(method + "isServerSideKeygen clientKeyId not found");
                }
            } else {
                logger.debug("ConnectorServlet:isServerSideKeygen = false");
            }
            if (ConnectorServlet.isProfileRequest(thisreq)) {
                X509CertInfo info = thisreq.getExtDataInCertInfo("req_x509info");
                try {
                    CertificateSubjectName sn = (CertificateSubjectName)info.get("subject");
                    if (sn != null && (subject = sn.toString()) != null) {
                        auditCertificateSubjectName = subject.trim();
                    }
                    auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_PROFILE_CERT_REQUEST_5", auditSubjectID, "Success", auditRequesterID, this.auditProfileID(), auditCertificateSubjectName);
                    auditor.log(auditMessage);
                }
                catch (CertificateException e) {
                    logger.warn("ConnectorServlet: processRequest " + e.getMessage(), (Throwable)e);
                    auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_PROFILE_CERT_REQUEST_5", auditSubjectID, "Failure", auditRequesterID, this.auditProfileID(), auditCertificateSubjectName);
                    auditor.log(auditMessage);
                }
                catch (IOException e) {
                    logger.warn("ConnectorServlet: processRequest " + e.getMessage(), (Throwable)e);
                    auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_PROFILE_CERT_REQUEST_5", auditSubjectID, "Failure", auditRequesterID, this.auditProfileID(), auditCertificateSubjectName);
                    auditor.log(auditMessage);
                }
            }
            thisreq.setExtData("AUTH_TOKEN", token);
            if (StringUtils.isNotEmpty((CharSequence)msg.getReqRealm())) {
                thisreq.setRealm(msg.getReqRealm());
            }
            thisreq.setExtData("requestorType", "RA");
            logger.info("ConnectorServlet: Processing remote request " + srcid);
            SessionContext s = SessionContext.getContext();
            if (s.get((Object)"userid") == null) {
                s.put((Object)"userid", (Object)sourceUserId);
            }
            if (s.get((Object)"requesterID") == null) {
                s.put((Object)"requesterID", (Object)msg.getReqId());
            }
            if (ConnectorServlet.isProfileRequest(thisreq)) {
                this.normalizeProfileRequest(thisreq);
            }
            logger.debug("ConnectorServlet: calling processRequest");
            try {
                queue.processRequest(thisreq);
            }
            finally {
                if (ConnectorServlet.isProfileRequest(thisreq)) {
                    X509CertImpl x509cert = thisreq.getExtDataInCert("req_issued_cert");
                    if (x509cert != null) {
                        auditor.log(CertRequestProcessedEvent.createSuccessEvent(auditSubjectID, auditRequesterID, "certificate", x509cert));
                    } else {
                        auditor.log(CertRequestProcessedEvent.createFailureEvent(auditSubjectID, auditRequesterID, "rejectReason", "<null>"));
                    }
                }
            }
            replymsg = new HttpPKIMessage();
            replymsg.fromRequest(thisreq);
            logger.debug("ConnectorServlet: replymsg.reqStatus=" + replymsg.getReqStatus());
            String agentID = sourceUserId;
            String initiative = "fromRemoteAuthority trustedManagerID: " + agentID + " remote reqID " + msg.getReqId();
            String authMgr = "noAuthManager";
            if (token != null) {
                authMgr = token.getInString("authMgrInstName");
            }
            if (ConnectorServlet.isProfileRequest(thisreq)) {
                logger.debug("ConnectorServlet: done requestId=" + thisreq.getRequestId().toString());
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_INTER_BOUNDARY_SUCCESS_5", auditSubjectID, "Success", auditProtectionMethod, auditRequestType, auditRequesterID);
                auditor.log(auditMessage);
                return replymsg;
            }
            X509CertInfo[] x509Info = thisreq.getExtDataInCertInfoArray("CERT_INFO");
            try {
                if (!thisreq.getRequestStatus().equals((Object)RequestStatus.COMPLETE)) {
                    if (x509Info != null) {
                        for (int i = 0; i < x509Info.length; ++i) {
                            logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{thisreq.getRequestType(), thisreq.getRequestId(), initiative, authMgr, thisreq.getRequestStatus(), x509Info[i].get("subject"), ""});
                        }
                    } else {
                        logger.info("{} reqID {} {} authenticated by {} is {}", new Object[]{thisreq.getRequestType(), thisreq.getRequestId(), initiative, authMgr, thisreq.getRequestStatus()});
                    }
                } else if (thisreq.getRequestType().equals("enrollment")) {
                    X509CertImpl[] x509Certs = null;
                    if (x509Info != null) {
                        x509Certs = thisreq.getExtDataInCertArray("issuedCerts");
                    }
                    if (x509Certs != null) {
                        for (int i = 0; i < x509Certs.length; ++i) {
                            logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{thisreq.getRequestType(), thisreq.getRequestId(), initiative, authMgr, "completed", x509Certs[i].getSubjectName(), "cert issued serial number: 0x" + x509Certs[i].getSerialNumber().toString(16)});
                        }
                    } else {
                        logger.info("{} reqID {} {} authenticated by {} is {}", new Object[]{thisreq.getRequestType(), thisreq.getRequestId(), initiative, authMgr, "completed"});
                    }
                } else if (thisreq.getRequestType().equals("renewal")) {
                    X509CertImpl[] certs = thisreq.getExtDataInCertArray("OLD_CERTS");
                    X509CertImpl old_cert = certs[0];
                    certs = thisreq.getExtDataInCertArray("issuedCerts");
                    X509CertImpl renewed_cert = certs[0];
                    if (old_cert != null && renewed_cert != null) {
                        logger.info("Renewal request reqID {} {} authenticated by {} is {}. DN requested: {} old serial number: 0x{} {}", new Object[]{thisreq.getRequestId(), initiative, authMgr, "completed", old_cert.getSubjectName(), old_cert.getSerialNumber().toString(16), "new serial number: 0x" + renewed_cert.getSerialNumber().toString(16)});
                    } else {
                        logger.info("{} reqID {} {} authenticated by {} is {}", new Object[]{thisreq.getRequestType(), thisreq.getRequestId(), initiative, authMgr, "completed with error"});
                    }
                } else if (thisreq.getRequestType().equals("revocation")) {
                    X509CertImpl[] oldCerts = thisreq.getExtDataInCertArray("OLD_CERTS");
                    RevokedCertImpl[] crlentries = thisreq.getExtDataInRevokedCertArray("revokedCerts");
                    CRLExtensions crlExts = crlentries[0].getExtensions();
                    int reason = 0;
                    if (crlExts != null) {
                        Enumeration enum1 = crlExts.getElements();
                        while (enum1.hasMoreElements()) {
                            Extension ext = (Extension)enum1.nextElement();
                            if (!(ext instanceof CRLReasonExtension)) continue;
                            reason = ((CRLReasonExtension)ext).getReason().getCode();
                            break;
                        }
                    }
                    int count = oldCerts.length;
                    Integer result = thisreq.getExtDataInInteger("Result");
                    if (result.equals(Request.RES_ERROR)) {
                        String[] svcErrors = thisreq.getExtDataInStringArray("serviceErrors");
                        if (svcErrors != null && svcErrors.length > 0) {
                            for (int i = 0; i < svcErrors.length; ++i) {
                                String err = svcErrors[i];
                                if (err == null) continue;
                                for (int j = 0; j < count; ++j) {
                                    if (oldCerts[j] == null || !(oldCerts[j] instanceof X509CertImpl)) continue;
                                    X509CertImpl cert = oldCerts[j];
                                    logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{thisreq.getRequestId(), initiative, "completed with error: " + err, cert.getSubjectName(), cert.getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                                }
                            }
                        }
                    } else {
                        for (int j = 0; j < count; ++j) {
                            if (oldCerts[j] == null || !(oldCerts[j] instanceof X509CertImpl)) continue;
                            X509CertImpl cert = oldCerts[j];
                            logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{thisreq.getRequestId(), initiative, "completed", cert.getSubjectName(), cert.getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                        }
                    }
                } else {
                    logger.info("{} reqID {} {} authenticated by {} is {}", new Object[]{thisreq.getRequestType(), thisreq.getRequestId(), initiative, authMgr, "completed"});
                }
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_INTER_BOUNDARY_SUCCESS_5", auditSubjectID, "Success", auditProtectionMethod, auditRequestType, auditRequesterID);
                auditor.log(auditMessage);
            }
            catch (IOException e) {
                logger.warn("ConnectorServlet: process " + e.getMessage(), (Throwable)e);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_INTER_BOUNDARY_SUCCESS_5", auditSubjectID, "Failure", auditProtectionMethod, auditRequestType, auditRequesterID);
                auditor.log(auditMessage);
            }
            catch (CertificateException e) {
                logger.warn("ConnectorServlet: process " + e.getMessage(), (Throwable)e);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_INTER_BOUNDARY_SUCCESS_5", auditSubjectID, "Failure", auditProtectionMethod, auditRequestType, auditRequesterID);
                auditor.log(auditMessage);
            }
            catch (Exception e) {
                logger.warn("ConnectorServlet: process " + e.getMessage(), (Throwable)e);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_INTER_BOUNDARY_SUCCESS_5", auditSubjectID, "Failure", auditProtectionMethod, auditRequestType, auditRequesterID);
                auditor.log(auditMessage);
            }
            finally {
                SessionContext.releaseContext();
            }
            return replymsg;
        }
        catch (EBaseException e) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_INTER_BOUNDARY_SUCCESS_5", auditSubjectID, "Failure", auditProtectionMethod, auditRequestType, auditRequesterID);
            auditor.log(auditMessage);
            return replymsg;
        }
    }

    protected X509Certificate getPeerCert(HttpServletRequest req) throws EBaseException {
        return this.getSSLClientCertificate(req);
    }

    public String getServletInfo() {
        return INFO;
    }

    protected String auditProfileID() {
        String profileID = this.getId();
        profileID = profileID != null ? profileID.trim() : "$Unidentified$";
        return profileID;
    }
}

