/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.realm;

import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.realm.RealmCommon;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.ldapconn.LDAPAuthenticationConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import com.netscape.cmscore.usrgrp.User;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import com.netscape.cmsutil.password.PlainPasswordFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import org.apache.catalina.LifecycleException;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKILDAPRealm
extends RealmCommon {
    public static final Logger logger = LoggerFactory.getLogger(PKILDAPRealm.class);
    String usersDN;
    String groupsDN;
    PKISocketConfig socketConfig;
    LDAPConnectionConfig connConfig;
    LDAPAuthenticationConfig authConfig;
    LdapBoundConnFactory connFactory;

    public void initInternal() throws LifecycleException {
        LDAPConfig ldapConfig;
        PlainPasswordFile ps;
        EngineConfig cs;
        logger.info("Initializing LDAP realm");
        String configFile = this.config.getParameter("configFile");
        if (configFile == null) {
            logger.info("Loading LDAP realm config from realm.conf");
            cs = new EngineConfig();
            ps = new PlainPasswordFile();
            ldapConfig = new LDAPConfig(null);
            block28: for (String name : this.config.getParameterNames()) {
                String value = this.config.getParameter(name);
                switch (name) {
                    case "usersDN": 
                    case "groupsDN": {
                        continue block28;
                    }
                    case "url": {
                        String secureConn;
                        URI url;
                        logger.info("- URL: " + value);
                        try {
                            url = new URI(value);
                        }
                        catch (URISyntaxException e) {
                            throw new LifecycleException("No valid ldap url : " + value, (Throwable)e);
                        }
                        String host = url.getHost();
                        String port = Integer.toString(url.getPort());
                        String protocol = url.getScheme();
                        if ("ldap".equals(protocol)) {
                            secureConn = "false";
                        } else if ("ldaps".equals(protocol)) {
                            secureConn = "true";
                        } else {
                            throw new LifecycleException("Unsupported LDAP protocol: " + protocol);
                        }
                        ldapConfig.put("ldapconn.host", host);
                        ldapConfig.put("ldapconn.port", port);
                        ldapConfig.put("ldapconn.secureConn", secureConn);
                        continue block28;
                    }
                    case "authType": {
                        logger.info("- authentication type: " + value);
                        ldapConfig.put("ldapauth.authtype", value);
                        continue block28;
                    }
                    case "bindDN": {
                        logger.info("- bind DN: " + value);
                        ldapConfig.put("ldapauth.bindDN", value);
                        continue block28;
                    }
                    case "bindPassword": {
                        ldapConfig.put("ldapauth.bindPassword", value);
                        continue block28;
                    }
                    case "nickname": {
                        logger.info("- nickname: " + value);
                        ldapConfig.put("ldapauth.clientCertNickname", value);
                        continue block28;
                    }
                    case "minConns": 
                    case "maxConns": 
                    case "maxResults": 
                    case "errorIfDown": {
                        logger.info("- " + name + ": " + value);
                        ldapConfig.put(name, value);
                        continue block28;
                    }
                }
                if (name.startsWith("ldapauth.") || name.startsWith("ldapconn.")) {
                    logger.info("- " + name + ": " + value);
                    ldapConfig.put(name, value);
                    continue;
                }
                cs.put(name, value);
            }
        } else {
            logger.info("Loading LDAP realm config from " + configFile);
            try {
                cs = new EngineConfig(new FileConfigStorage(configFile));
                cs.load();
                ps = PasswordStore.create((PasswordStoreConfig)cs.getPasswordStoreConfig());
            }
            catch (Exception e) {
                throw new LifecycleException("Cannot load config file " + configFile, (Throwable)e);
            }
            ldapConfig = cs.getInternalDBConfig();
        }
        this.socketConfig = cs.getSocketConfig();
        this.connConfig = ldapConfig.getConnectionConfig();
        this.authConfig = ldapConfig.getAuthenticationConfig();
        this.usersDN = this.config.getParameter("usersDN");
        logger.info("- users DN: " + this.usersDN);
        this.groupsDN = this.config.getParameter("groupsDN");
        logger.info("- groups DN: " + this.groupsDN);
        this.connFactory = new LdapBoundConnFactory("LDAPRealm");
        try {
            this.connFactory.init(this.socketConfig, ldapConfig, (PasswordStore)ps);
        }
        catch (Exception e) {
            throw new LifecycleException("LDAP connection problem:" + e.getMessage(), (Throwable)e);
        }
    }

    public User createUser(LDAPEntry entry) throws Exception {
        LDAPAttribute userCertificate;
        LDAPAttribute phoneAttr;
        LDAPAttribute mailAttr;
        User user = new User();
        user.setUserDN(entry.getDN());
        LDAPAttribute uidAttr = entry.getAttribute("uid");
        String uid = uidAttr.getStringValueArray()[0];
        user.setUserID(uid);
        LDAPAttribute cnAttr = entry.getAttribute("cn");
        if (cnAttr != null) {
            user.setFullName((String)cnAttr.getStringValues().nextElement());
        }
        if ((mailAttr = entry.getAttribute("mail")) != null) {
            user.setEmail((String)mailAttr.getStringValues().nextElement());
        }
        if ((phoneAttr = entry.getAttribute("telephoneNumber")) != null) {
            user.setPhone((String)phoneAttr.getStringValues().nextElement());
        }
        if ((userCertificate = entry.getAttribute("userCertificate")) != null) {
            byte[][] binCerts = userCertificate.getByteValueArray();
            X509Certificate[] certs = new X509Certificate[binCerts.length];
            for (int i = 0; i < binCerts.length; ++i) {
                certs[i] = new X509CertImpl(binCerts[i]);
            }
            user.setX509Certificates(certs);
        }
        return user;
    }

    public List<String> getUserRoles(LDAPConnection conn, String userDN) throws Exception {
        ArrayList<String> roles = new ArrayList<String>();
        String filter = "(uniqueMember=" + userDN + ")";
        logger.info("LDAP search:");
        logger.info("- base DN: " + this.groupsDN);
        logger.info("- filter: " + filter);
        LDAPSearchResults results = conn.search(this.groupsDN, 1, filter, null, false);
        logger.info("User roles:");
        while (results.hasMoreElements()) {
            LDAPEntry groupEntry = results.next();
            logger.info("- " + groupEntry.getDN());
            LDAPAttribute cnAttr = groupEntry.getAttribute("cn");
            String role = (String)cnAttr.getStringValues().nextElement();
            roles.add(role);
        }
        return roles;
    }

    public User findUserByUsername(LDAPConnection conn, String username) throws Exception {
        String filter = "(uid=" + username + ")";
        logger.info("LDAP search:");
        logger.info("- base DN: " + this.usersDN);
        logger.info("- filter: " + filter);
        LDAPSearchResults results = conn.search(this.usersDN, 1, filter, null, false);
        if (!results.hasMoreElements()) {
            return null;
        }
        LDAPEntry entry = results.next();
        logger.info("User: " + entry.getDN());
        return this.createUser(entry);
    }

    public String getCertID(X509Certificate cert) {
        return cert.getVersion() + ";" + cert.getSerialNumber() + ";" + cert.getIssuerDN() + ";" + cert.getSubjectDN();
    }

    public User findUserByCertID(LDAPConnection conn, String certID) throws Exception {
        String filter = "(description=" + certID + ")";
        logger.info("LDAP search:");
        logger.info("- base DN: " + this.usersDN);
        logger.info("- filter: " + filter);
        LDAPSearchResults results = conn.search(this.usersDN, 1, filter, null, false);
        if (!results.hasMoreElements()) {
            return null;
        }
        LDAPEntry entry = results.next();
        logger.info("User: " + entry.getDN());
        return this.createUser(entry);
    }

    @Override
    public Principal authenticate(String username, String password) {
        logger.info("Authenticating user " + username + " with password");
        LDAPConnection conn = null;
        LDAPConnection authConn = null;
        PKIPrincipal principal = null;
        User user = null;
        try {
            conn = this.connFactory.getConn();
            logger.info("Searching for user " + username);
            user = this.findUserByUsername(conn, username);
            if (user == null) {
                logger.warn("Unable to authenticate user " + username + ": User not found");
                Principal principal2 = null;
                return principal2;
            }
            logger.info("Authenticating user " + user.getUserDN() + " with password");
            PKISocketFactory socketFactory = new PKISocketFactory();
            socketFactory.setSecure(this.connConfig.isSecure());
            socketFactory.init(this.socketConfig);
            authConn = new LDAPConnection((LDAPSocketFactory)socketFactory);
            authConn.connect(this.connConfig.getHostname(), this.connConfig.getPort());
            authConn.authenticate(user.getUserDN(), password);
            logger.info("User " + username + " authenticated");
            List<String> roles = this.getUserRoles(conn, user.getUserDN());
            principal = new PKIPrincipal(user, null, roles);
        }
        catch (LDAPException e) {
            StringBuilder msg = new StringBuilder("Unable to authenticate user");
            if (user != null) {
                msg.append(" ").append(user.getUserDN());
            }
            msg.append(": ").append(e.getMessage());
            logger.warn(msg.toString());
            if (e.getLDAPResultCode() == 49) {
                Principal principal3 = null;
                return principal3;
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            logger.error("Problem to verify user credentials", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (authConn != null) {
                authConn.close();
            }
            this.connFactory.returnConn(conn);
        }
        return principal;
    }

    @Override
    public Principal authenticate(X509Certificate[] certChain) {
        User user;
        PKIPrincipal principal;
        LDAPConnection conn;
        block10: {
            X509Certificate[] certs;
            X509Certificate cert;
            block9: {
                block8: {
                    conn = null;
                    principal = null;
                    certChain = Cert.sortCertificateChain((X509Certificate[])certChain, (boolean)true);
                    cert = certChain[0];
                    String certID = this.getCertID(cert);
                    logger.info("Authenticating user with certificate " + certID);
                    conn = this.connFactory.getConn();
                    logger.info("Searching for user with certificate " + certID);
                    user = this.findUserByCertID(conn, certID);
                    if (user != null) break block8;
                    logger.warn("Unable to authenticate user with certificate " + certID + ": User not found");
                    Principal principal2 = null;
                    this.connFactory.returnConn(conn);
                    return principal2;
                }
                logger.info("Searching for matching certificates in user " + user.getUserDN());
                certs = user.getX509Certificates();
                if (certs != null && certs.length != 0) break block9;
                logger.warn("Unable to authenticate user " + user.getUserDN() + ": User has no certificates");
                Principal principal3 = null;
                this.connFactory.returnConn(conn);
                return principal3;
            }
            boolean found = false;
            byte[] data = cert.getEncoded();
            for (X509Certificate c : certs) {
                if (!Arrays.equals(data, c.getEncoded())) continue;
                found = true;
                break;
            }
            if (found) break block10;
            logger.warn("Unable to authenticate user " + user.getUserDN() + ": No matching certificate");
            X509Certificate[] x509CertificateArray = null;
            this.connFactory.returnConn(conn);
            return x509CertificateArray;
        }
        try {
            logger.info("User " + user.getUserDN() + " authenticated");
            List<String> roles = this.getUserRoles(conn, user.getUserDN());
            principal = new PKIPrincipal(user, null, roles);
            this.connFactory.returnConn(conn);
        }
        catch (Exception e) {
            try {
                logger.error("Problem to verify the certificate", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.connFactory.returnConn(conn);
                throw throwable;
            }
        }
        return principal;
    }

    public void stopInternal() throws LifecycleException {
        logger.info("Shutting down LDAP realm");
        if (this.connFactory != null) {
            try {
                this.connFactory.shutdown();
            }
            catch (Exception e) {
                throw new LifecycleException("Cannot close the LDAP connection factory: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

