/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.legacy.server.policy.extensions.AttributeConfig;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.Attribute;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.SubjectDirAttributesExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectDirectoryAttributesExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(SubjectDirectoryAttributesExt.class);
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_ATTRIBUTE = "attribute";
    protected static final String PROP_NUM_ATTRIBUTES = "numAttributes";
    protected static final boolean DEF_CRITICAL = false;
    protected static final int DEF_NUM_ATTRIBUTES = 3;
    protected static final int MAX_NUM_ATTRIBUTES = 10;
    protected boolean mCritical;
    protected int mNumAttributes;
    protected AttributeConfig[] mAttributes = null;
    protected ConfigStore mConfig;
    protected SubjectDirAttributesExtension mExt = null;
    protected Vector<String> mParams = new Vector();
    private String[] mEPI = null;
    protected static Vector<String> mDefParams = new Vector();

    public SubjectDirectoryAttributesExt() {
        this.NAME = "SubjectDirectoryAttributesExtPolicy";
        this.DESC = "Sets Subject Directory Attributes Extension in certificates.";
        this.setExtendedPluginInfo();
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        boolean enabled = config.getBoolean("enabled", false);
        this.mConfig = config;
        this.mCritical = this.mConfig.getBoolean(PROP_CRITICAL, false);
        this.mNumAttributes = this.mConfig.getInteger(PROP_NUM_ATTRIBUTES, 3);
        if (this.mNumAttributes < 1) {
            EBaseException ex = new EBaseException(CMS.getUserMessage((String)"CMS_BASE_MUST_BE_POSITIVE_NUMBER", (String[])new String[]{PROP_NUM_ATTRIBUTES}));
            logger.error(this.NAME + " Error: " + ex.toString(), (Throwable)ex);
            throw ex;
        }
        this.mAttributes = new AttributeConfig[this.mNumAttributes];
        for (int i = 0; i < this.mNumAttributes; ++i) {
            String name = PROP_ATTRIBUTE + i;
            ConfigStore c = this.mConfig.getSubStore(name, ConfigStore.class);
            this.mAttributes[i] = new AttributeConfig(name, c, enabled);
        }
        if (enabled) {
            try {
                this.mExt = this.formExt(null);
            }
            catch (IOException e) {
                logger.error(this.NAME + " Error: " + e.getMessage(), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{"Error forming Subject Directory Attributes Extension. See log file for details."}), (Throwable)e);
            }
        }
        this.setInstanceParams();
    }

    public PolicyResult apply(Request req) {
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult r = this.applyCert(req, ci[i]);
            if (r != PolicyResult.REJECTED) continue;
            return r;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        CertificateExtensions extensions = null;
        try {
            extensions = (CertificateExtensions)certInfo.get("extensions");
            if (extensions == null) {
                extensions = new CertificateExtensions();
                certInfo.set("version", (Object)new CertificateVersion(2));
                certInfo.set("extensions", (Object)extensions);
            } else {
                try {
                    extensions.delete("SubjectDirectoryAttributes");
                }
                catch (IOException ee) {
                    try {
                        extensions.delete("2.5.29.9");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (this.mExt != null) {
                extensions.set("SubjectDirectoryAttributes", (Object)this.mExt);
            } else {
                SubjectDirAttributesExtension ext = this.formExt(req);
                if (ext != null) {
                    extensions.set("SubjectDirectoryAttributes", (Object)this.formExt(req));
                }
            }
            return PolicyResult.ACCEPTED;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Certificate Info Error");
            return PolicyResult.REJECTED;
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"BASE_IO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "IOException Error");
            return PolicyResult.REJECTED;
        }
    }

    public Vector<String> getInstanceParams() {
        return this.mParams;
    }

    public Vector<String> getDefaultParams() {
        return mDefParams;
    }

    public String[] getExtendedPluginInfo() {
        return this.mEPI;
    }

    private void setInstanceParams() {
        this.mParams.addElement("critical=" + this.mCritical);
        this.mParams.addElement("numAttributes=" + this.mNumAttributes);
        for (int i = 0; i < this.mNumAttributes; ++i) {
            this.mAttributes[i].getInstanceParams(this.mParams);
        }
        for (int j = this.mNumAttributes; j < 10; ++j) {
            this.mConfig.removeSubStore(PROP_ATTRIBUTE + j);
        }
    }

    private static void setDefaultParams() {
        mDefParams.addElement("critical=false");
        mDefParams.addElement("numAttributes=3");
        for (int i = 0; i < 3; ++i) {
            AttributeConfig.getDefaultParams(PROP_ATTRIBUTE + i, mDefParams);
        }
    }

    private void setExtendedPluginInfo() {
        Vector<String> v = new Vector<String>();
        v.addElement("critical;boolean;RFC 2459 recommendation: MUST be non-critical.");
        v.addElement("numAttributes;number;Number of Attributes in the extension.");
        for (int i = 0; i < 10; ++i) {
            AttributeConfig.getExtendedPluginInfo(PROP_ATTRIBUTE + i, v);
        }
        v.addElement("HELP_TOKEN;configuration-policyrules-subjectdirectoryattributes");
        v.addElement("HELP_TEXT;Adds Subject Directory Attributes extension. See RFC 2459 (4.2.1.9). It's not recommended as an essential part of the profile, but may be used in local environments.");
        this.mEPI = Utils.getStringArrayFromVector(v);
    }

    private SubjectDirAttributesExtension formExt(Request req) throws IOException {
        int i;
        Vector<Attribute> attrs = new Vector<Attribute>();
        if (req == null) {
            for (i = 0; i < this.mNumAttributes; ++i) {
                if (this.mAttributes[i].mWhereToGetValue != "Request Attribute") continue;
                return null;
            }
        }
        for (i = 0; i < this.mNumAttributes; ++i) {
            if (this.mAttributes[i].mAttribute != null) {
                attrs.addElement(this.mAttributes[i].mAttribute);
                continue;
            }
            Attribute a = this.mAttributes[i].formAttr(req);
            if (a == null) continue;
            attrs.addElement(a);
        }
        if (attrs.size() == 0) {
            return null;
        }
        Object[] attrList = new Attribute[attrs.size()];
        attrs.copyInto(attrList);
        SubjectDirAttributesExtension ext = new SubjectDirAttributesExtension((Attribute[])attrList);
        return ext;
    }

    static {
        SubjectDirectoryAttributesExt.setDefaultParams();
    }
}

