/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.extensions.OCSPNoCheckExtension;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class OCSPNoCheckExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static final String PROP_CRITICAL = "critical";
    private boolean mCritical = false;
    public static final boolean DEFAULT_CRITICALITY = false;
    private OCSPNoCheckExtension mOCSPNoCheck = null;

    public OCSPNoCheckExt() {
        this.NAME = "OCSPNoCheckExt";
        this.DESC = "Sets OCSPNoCheck extension for certificates";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"critical;boolean;RFC 2560 recommendation: SHOULD be non-critical.", "HELP_TOKEN;configuration-policyrules-ocspnocheck", "HELP_TEXT;Adds OCSP signing extension to certificate"};
        return params;
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        try {
            this.mOCSPNoCheck = new OCSPNoCheckExtension();
        }
        catch (IOException e) {
            throw new EBaseException((Exception)e);
        }
        if (this.mOCSPNoCheck != null) {
            this.mCritical = config.getBoolean(PROP_CRITICAL, false);
            this.mOCSPNoCheck.setCritical(this.mCritical);
        }
    }

    public PolicyResult apply(Request req) {
        if (this.mOCSPNoCheck == null) {
            return PolicyResult.ACCEPTED;
        }
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        try {
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            if (extensions == null) {
                certInfo.set("version", (Object)new CertificateVersion(2));
                extensions = new CertificateExtensions();
                certInfo.set("version", (Object)new CertificateVersion(2));
                certInfo.set("extensions", (Object)extensions);
            } else {
                try {
                    extensions.delete("OCSPNoCheckExtension");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            extensions.set("OCSPNoCheckExtension", (Object)this.mOCSPNoCheck);
            return PolicyResult.ACCEPTED;
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"BASE_IO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.warn(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        params.addElement("critical=" + this.mCritical);
        return params;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("critical=false");
        return defParams;
    }
}

