/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSigningAlgDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(UserSigningAlgDefault.class);
    public static final String VAL_ALG_ID = "userSigningAlgID";

    public UserSigningAlgDefault() {
        this.addValueName(VAL_ALG_ID);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_ALG_ID)) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SIGNING_ALGORITHM", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_ALG_ID)) {
            CertificateAlgorithmId algID = null;
            try {
                algID = (CertificateAlgorithmId)info.get("algorithmID");
                AlgorithmId id = (AlgorithmId)algID.get("algorithm");
                return id.toString();
            }
            catch (Exception e) {
                logger.warn("UserSigningAlgDefault: setValue " + e.getMessage(), (Throwable)e);
                return "";
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_USER_SIGNING_ALGORITHM", (String[])new String[0]);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        CertificateAlgorithmId certAlg = null;
        try {
            byte[] certAlgData = request.getExtDataInByteArray("req_signing_alg");
            if (certAlgData != null) {
                certAlg = new CertificateAlgorithmId((InputStream)new ByteArrayInputStream(certAlgData));
            }
            info.set("algorithmID", certAlg);
        }
        catch (Exception e) {
            logger.warn("UserSigningAlgDefault: populate " + e.getMessage(), (Throwable)e);
        }
    }
}

