// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gio_sys;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::Value;
use glib_sys;
use gobject_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use File;
use FileMonitorEvent;

glib_wrapper! {
    pub struct FileMonitor(Object<gio_sys::GFileMonitor, gio_sys::GFileMonitorClass, FileMonitorClass>);

    match fn {
        get_type => || gio_sys::g_file_monitor_get_type(),
    }
}

pub const NONE_FILE_MONITOR: Option<&FileMonitor> = None;

pub trait FileMonitorExt: 'static {
    fn cancel(&self) -> bool;

    fn emit_event<P: IsA<File>, Q: IsA<File>>(
        &self,
        child: &P,
        other_file: &Q,
        event_type: FileMonitorEvent,
    );

    fn is_cancelled(&self) -> bool;

    fn set_rate_limit(&self, limit_msecs: i32);

    fn get_property_cancelled(&self) -> bool;

    fn get_property_rate_limit(&self) -> i32;

    fn connect_changed<F: Fn(&Self, &File, Option<&File>, FileMonitorEvent) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_cancelled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_rate_limit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<FileMonitor>> FileMonitorExt for O {
    fn cancel(&self) -> bool {
        unsafe {
            from_glib(gio_sys::g_file_monitor_cancel(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn emit_event<P: IsA<File>, Q: IsA<File>>(
        &self,
        child: &P,
        other_file: &Q,
        event_type: FileMonitorEvent,
    ) {
        unsafe {
            gio_sys::g_file_monitor_emit_event(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                other_file.as_ref().to_glib_none().0,
                event_type.to_glib(),
            );
        }
    }

    fn is_cancelled(&self) -> bool {
        unsafe {
            from_glib(gio_sys::g_file_monitor_is_cancelled(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_rate_limit(&self, limit_msecs: i32) {
        unsafe {
            gio_sys::g_file_monitor_set_rate_limit(self.as_ref().to_glib_none().0, limit_msecs);
        }
    }

    fn get_property_cancelled(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"cancelled\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `cancelled` getter")
                .unwrap()
        }
    }

    fn get_property_rate_limit(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"rate-limit\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `rate-limit` getter")
                .unwrap()
        }
    }

    fn connect_changed<F: Fn(&Self, &File, Option<&File>, FileMonitorEvent) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn changed_trampoline<
            P,
            F: Fn(&P, &File, Option<&File>, FileMonitorEvent) + 'static,
        >(
            this: *mut gio_sys::GFileMonitor,
            file: *mut gio_sys::GFile,
            other_file: *mut gio_sys::GFile,
            event_type: gio_sys::GFileMonitorEvent,
            f: glib_sys::gpointer,
        ) where
            P: IsA<FileMonitor>,
        {
            let f: &F = &*(f as *const F);
            f(
                &FileMonitor::from_glib_borrow(this).unsafe_cast(),
                &from_glib_borrow(file),
                Option::<File>::from_glib_borrow(other_file).as_ref(),
                from_glib(event_type),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"changed\0".as_ptr() as *const _,
                Some(transmute(changed_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_cancelled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cancelled_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gio_sys::GFileMonitor,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<FileMonitor>,
        {
            let f: &F = &*(f as *const F);
            f(&FileMonitor::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cancelled\0".as_ptr() as *const _,
                Some(transmute(notify_cancelled_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_rate_limit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rate_limit_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gio_sys::GFileMonitor,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<FileMonitor>,
        {
            let f: &F = &*(f as *const F);
            f(&FileMonitor::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rate-limit\0".as_ptr() as *const _,
                Some(transmute(notify_rate_limit_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for FileMonitor {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "FileMonitor")
    }
}
