/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AVAValueConverter;
import org.mozilla.jss.netscape.security.x509.DirStrConverter;
import org.mozilla.jss.netscape.security.x509.IA5StringConverter;
import org.mozilla.jss.netscape.security.x509.PrintableConverter;

public class X500NameAttrMap {
    Hashtable<String, ObjectIdentifier> name2OID = new Hashtable();
    Hashtable<ObjectIdentifier, String> oid2Name = new Hashtable();
    Hashtable<ObjectIdentifier, AVAValueConverter> oid2ValueConverter = new Hashtable();
    private static X500NameAttrMap defMap = new X500NameAttrMap();
    private static X500NameAttrMap defDirMap;

    public String getName(ObjectIdentifier oid) {
        return this.oid2Name.get(oid);
    }

    public ObjectIdentifier getOid(String name) {
        return this.name2OID.get(name.toUpperCase());
    }

    public AVAValueConverter getValueConverter(String name) {
        ObjectIdentifier oid = this.name2OID.get(name.toUpperCase());
        if (oid == null) {
            return null;
        }
        return this.oid2ValueConverter.get(oid);
    }

    public AVAValueConverter getValueConverter(ObjectIdentifier oid) {
        return this.oid2ValueConverter.get(oid);
    }

    public Enumeration<String> getAllNames() {
        return this.name2OID.keys();
    }

    public Enumeration<ObjectIdentifier> getAllOIDs() {
        return this.oid2Name.keys();
    }

    public ObjectIdentifier getOid(ObjectIdentifier oid) {
        String name = this.oid2Name.get(oid);
        if (name == null) {
            return null;
        }
        return this.name2OID.get(name);
    }

    public void addNameOID(String name, ObjectIdentifier oid, AVAValueConverter valueConverter) {
        ObjectIdentifier theOid = this.name2OID.get(name);
        if (theOid != null) {
            Class<?> expValueConverter = this.oid2ValueConverter.get(theOid).getClass();
            if (!theOid.equals(oid) || expValueConverter != valueConverter.getClass()) {
                throw new IllegalArgumentException("Another keyword-oid-valueConverter triple already exists in the X500NameAttrMap ");
            }
            return;
        }
        this.name2OID.put(name.toUpperCase(), oid);
        this.oid2Name.put(oid, name.toUpperCase());
        this.oid2ValueConverter.put(oid, valueConverter);
    }

    public static X500NameAttrMap getDefault() {
        return defMap;
    }

    public static X500NameAttrMap getDirDefault() {
        return defDirMap;
    }

    public static void setDefault(X500NameAttrMap newDefault) {
        defMap = newDefault;
    }

    static {
        DirStrConverter directoryStr = new DirStrConverter();
        IA5StringConverter ia5Str = new IA5StringConverter();
        defMap.addNameOID("CN", new ObjectIdentifier("2.5.4.3"), directoryStr);
        defMap.addNameOID("OU", new ObjectIdentifier("2.5.4.11"), directoryStr);
        defMap.addNameOID("O", new ObjectIdentifier("2.5.4.10"), directoryStr);
        defMap.addNameOID("SERIALNUMBER", new ObjectIdentifier("2.5.4.5"), new PrintableConverter());
        defMap.addNameOID("C", new ObjectIdentifier("2.5.4.6"), new PrintableConverter());
        defMap.addNameOID("L", new ObjectIdentifier("2.5.4.7"), directoryStr);
        defMap.addNameOID("ST", new ObjectIdentifier("2.5.4.8"), directoryStr);
        defMap.addNameOID("STREET", new ObjectIdentifier("2.5.4.9"), directoryStr);
        defMap.addNameOID("TITLE", new ObjectIdentifier("2.5.4.12"), directoryStr);
        defMap.addNameOID("UID", new ObjectIdentifier("0.9.2342.19200300.100.1.1"), directoryStr);
        defMap.addNameOID("MAIL", new ObjectIdentifier("0.9.2342.19200300.100.1.3"), ia5Str);
        defMap.addNameOID("E", new ObjectIdentifier("1.2.840.113549.1.9.1"), ia5Str);
        defMap.addNameOID("DC", new ObjectIdentifier("0.9.2342.19200300.100.1.25"), ia5Str);
        defMap.addNameOID("SN", new ObjectIdentifier("2.5.4.4"), directoryStr);
        defMap.addNameOID("GIVENNAME", new ObjectIdentifier("2.5.4.42"), directoryStr);
        defMap.addNameOID("INITIALS", new ObjectIdentifier("2.5.4.43"), directoryStr);
        defMap.addNameOID("GENERATIONQUALIFIER", new ObjectIdentifier("2.5.4.44"), directoryStr);
        defMap.addNameOID("DNQUALIFIER", new ObjectIdentifier("2.5.4.46"), directoryStr);
        defMap.addNameOID("UNSTRUCTUREDNAME", new ObjectIdentifier("1.2.840.113549.1.9.2"), ia5Str);
        defMap.addNameOID("UNSTRUCTUREDADDRESS", new ObjectIdentifier("1.2.840.113549.1.9.8"), new PrintableConverter());
        defDirMap = new X500NameAttrMap();
        directoryStr = new DirStrConverter();
        defDirMap.addNameOID("CN", new ObjectIdentifier("2.5.4.3"), directoryStr);
        defDirMap.addNameOID("OU", new ObjectIdentifier("2.5.4.11"), directoryStr);
        defDirMap.addNameOID("O", new ObjectIdentifier("2.5.4.10"), directoryStr);
        defDirMap.addNameOID("SERIALNUMBER", new ObjectIdentifier("2.5.4.5"), directoryStr);
        defDirMap.addNameOID("C", new ObjectIdentifier("2.5.4.6"), directoryStr);
        defDirMap.addNameOID("L", new ObjectIdentifier("2.5.4.7"), directoryStr);
        defDirMap.addNameOID("ST", new ObjectIdentifier("2.5.4.8"), directoryStr);
        defDirMap.addNameOID("STREET", new ObjectIdentifier("2.5.4.9"), directoryStr);
        defDirMap.addNameOID("TITLE", new ObjectIdentifier("2.5.4.12"), directoryStr);
        defDirMap.addNameOID("UID", new ObjectIdentifier("0.9.2342.19200300.100.1.1"), directoryStr);
        defDirMap.addNameOID("MAIL", new ObjectIdentifier("0.9.2342.19200300.100.1.3"), directoryStr);
        defDirMap.addNameOID("E", new ObjectIdentifier("1.2.840.113549.1.9.1"), directoryStr);
        defDirMap.addNameOID("DC", new ObjectIdentifier("0.9.2342.19200300.100.1.25"), directoryStr);
        defDirMap.addNameOID("SN", new ObjectIdentifier("2.5.4.4"), directoryStr);
        defDirMap.addNameOID("GIVENNAME", new ObjectIdentifier("2.5.4.42"), directoryStr);
        defDirMap.addNameOID("INITIALS", new ObjectIdentifier("2.5.4.43"), directoryStr);
        defDirMap.addNameOID("GENERATIONQUALIFIER", new ObjectIdentifier("2.5.4.44"), directoryStr);
        defDirMap.addNameOID("DNQUALIFIER", new ObjectIdentifier("2.5.4.46"), directoryStr);
        defDirMap.addNameOID("UNSTRUCTUREDNAME", new ObjectIdentifier("1.2.840.113549.1.9.2"), directoryStr);
        defDirMap.addNameOID("UNSTRUCTUREDADDRESS", new ObjectIdentifier("1.2.840.113549.1.9.8"), directoryStr);
    }
}

