"""Generated message classes for cloudiot version v1.

Registers and manages IoT (Internet of Things) devices that connect to the
Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudiot'


class BindDeviceToGatewayRequest(_messages.Message):
  r"""Request for `BindDeviceToGateway`.

  Fields:
    deviceId: Required. The device to associate with the specified gateway.
      The value of `device_id` can be either the device numeric ID or the
      user-defined device identifier.
    gatewayId: Required. The value of `gateway_id` can be either the device
      numeric ID or the user-defined device identifier.
  """

  deviceId = _messages.StringField(1)
  gatewayId = _messages.StringField(2)


class BindDeviceToGatewayResponse(_messages.Message):
  r"""Response for `BindDeviceToGateway`."""


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CloudiotProjectsLocationsRegistriesBindDeviceToGatewayRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesBindDeviceToGatewayRequest object.

  Fields:
    bindDeviceToGatewayRequest: A BindDeviceToGatewayRequest resource to be
      passed as the request body.
    parent: Required. The name of the registry. For example,
      `projects/example-project/locations/us-central1/registries/my-registry`.
  """

  bindDeviceToGatewayRequest = _messages.MessageField('BindDeviceToGatewayRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesCreateRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesCreateRequest object.

  Fields:
    deviceRegistry: A DeviceRegistry resource to be passed as the request
      body.
    parent: Required. The project and cloud region where this device registry
      must be created. For example, `projects/example-project/locations/us-
      central1`.
  """

  deviceRegistry = _messages.MessageField('DeviceRegistry', 1)
  parent = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesDeleteRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDeleteRequest object.

  Fields:
    name: Required. The name of the device registry. For example,
      `projects/example-project/locations/us-central1/registries/my-registry`.
  """

  name = _messages.StringField(1, required=True)


class CloudiotProjectsLocationsRegistriesDevicesConfigVersionsListRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesConfigVersionsListRequest
  object.

  Fields:
    name: Required. The name of the device. For example,
      `projects/p0/locations/us-central1/registries/registry0/devices/device0`
      or `projects/p0/locations/us-
      central1/registries/registry0/devices/{num_id}`.
    numVersions: The number of versions to list. Versions are listed in
      decreasing order of the version number. The maximum number of versions
      retained is 10. If this value is zero, it will return all the versions
      available.
  """

  name = _messages.StringField(1, required=True)
  numVersions = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class CloudiotProjectsLocationsRegistriesDevicesCreateRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesCreateRequest object.

  Fields:
    device: A Device resource to be passed as the request body.
    parent: Required. The name of the device registry where this device should
      be created. For example, `projects/example-project/locations/us-
      central1/registries/my-registry`.
  """

  device = _messages.MessageField('Device', 1)
  parent = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesDevicesDeleteRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesDeleteRequest object.

  Fields:
    name: Required. The name of the device. For example,
      `projects/p0/locations/us-central1/registries/registry0/devices/device0`
      or `projects/p0/locations/us-
      central1/registries/registry0/devices/{num_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudiotProjectsLocationsRegistriesDevicesGetRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesGetRequest object.

  Fields:
    fieldMask: The fields of the `Device` resource to be returned in the
      response. If the field mask is unset or empty, all fields are returned.
      Fields have to be provided in snake_case format, for example:
      `last_heartbeat_time`.
    name: Required. The name of the device. For example,
      `projects/p0/locations/us-central1/registries/registry0/devices/device0`
      or `projects/p0/locations/us-
      central1/registries/registry0/devices/{num_id}`.
  """

  fieldMask = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesDevicesListRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesListRequest object.

  Enums:
    GatewayListOptionsGatewayTypeValueValuesEnum: If `GATEWAY` is specified,
      only gateways are returned. If `NON_GATEWAY` is specified, only non-
      gateway devices are returned. If `GATEWAY_TYPE_UNSPECIFIED` is
      specified, all devices are returned.

  Fields:
    deviceIds: A list of device string IDs. For example, `['device0',
      'device12']`. If empty, this field is ignored. Maximum IDs: 10,000
    deviceNumIds: A list of device numeric IDs. If empty, this field is
      ignored. Maximum IDs: 10,000.
    fieldMask: The fields of the `Device` resource to be returned in the
      response. The fields `id` and `num_id` are always returned, along with
      any other fields specified in snake_case format, for example:
      `last_heartbeat_time`.
    gatewayListOptions_associationsDeviceId: If set, returns only the gateways
      with which the specified device is associated. The device ID can be
      numeric (`num_id`) or the user-defined string (`id`). For example, if
      `456` is specified, returns only the gateways to which the device with
      `num_id` 456 is bound.
    gatewayListOptions_associationsGatewayId: If set, only devices associated
      with the specified gateway are returned. The gateway ID can be numeric
      (`num_id`) or the user-defined string (`id`). For example, if `123` is
      specified, only devices bound to the gateway with `num_id` 123 are
      returned.
    gatewayListOptions_gatewayType: If `GATEWAY` is specified, only gateways
      are returned. If `NON_GATEWAY` is specified, only non-gateway devices
      are returned. If `GATEWAY_TYPE_UNSPECIFIED` is specified, all devices
      are returned.
    pageSize: The maximum number of devices to return in the response. If this
      value is zero, the service will select a default size. A call may return
      fewer objects than requested. A non-empty `next_page_token` in the
      response indicates that more data is available.
    pageToken: The value returned by the last `ListDevicesResponse`; indicates
      that this is a continuation of a prior `ListDevices` call and the system
      should return the next page of data.
    parent: Required. The device registry path. Required. For example,
      `projects/my-project/locations/us-central1/registries/my-registry`.
  """

  class GatewayListOptionsGatewayTypeValueValuesEnum(_messages.Enum):
    r"""If `GATEWAY` is specified, only gateways are returned. If
    `NON_GATEWAY` is specified, only non-gateway devices are returned. If
    `GATEWAY_TYPE_UNSPECIFIED` is specified, all devices are returned.

    Values:
      GATEWAY_TYPE_UNSPECIFIED: If unspecified, the device is considered a
        non-gateway device.
      GATEWAY: The device is a gateway.
      NON_GATEWAY: The device is not a gateway.
    """
    GATEWAY_TYPE_UNSPECIFIED = 0
    GATEWAY = 1
    NON_GATEWAY = 2

  deviceIds = _messages.StringField(1, repeated=True)
  deviceNumIds = _messages.IntegerField(2, repeated=True, variant=_messages.Variant.UINT64)
  fieldMask = _messages.StringField(3)
  gatewayListOptions_associationsDeviceId = _messages.StringField(4)
  gatewayListOptions_associationsGatewayId = _messages.StringField(5)
  gatewayListOptions_gatewayType = _messages.EnumField('GatewayListOptionsGatewayTypeValueValuesEnum', 6)
  pageSize = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(8)
  parent = _messages.StringField(9, required=True)


class CloudiotProjectsLocationsRegistriesDevicesModifyCloudToDeviceConfigRequest(_messages.Message):
  r"""A
  CloudiotProjectsLocationsRegistriesDevicesModifyCloudToDeviceConfigRequest
  object.

  Fields:
    modifyCloudToDeviceConfigRequest: A ModifyCloudToDeviceConfigRequest
      resource to be passed as the request body.
    name: Required. The name of the device. For example,
      `projects/p0/locations/us-central1/registries/registry0/devices/device0`
      or `projects/p0/locations/us-
      central1/registries/registry0/devices/{num_id}`.
  """

  modifyCloudToDeviceConfigRequest = _messages.MessageField('ModifyCloudToDeviceConfigRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesDevicesPatchRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesPatchRequest object.

  Fields:
    device: A Device resource to be passed as the request body.
    name: The resource path name. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0` or
      `projects/p1/locations/us-
      central1/registries/registry0/devices/{num_id}`. When `name` is
      populated as a response from the service, it always ends in the device
      numeric ID.
    updateMask: Required. Only updates the `device` fields indicated by this
      mask. The field mask must not be empty, and it must not contain fields
      that are immutable or only set by the server. Mutable top-level fields:
      `credentials`, `blocked`, and `metadata`
  """

  device = _messages.MessageField('Device', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudiotProjectsLocationsRegistriesDevicesSendCommandToDeviceRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesSendCommandToDeviceRequest
  object.

  Fields:
    name: Required. The name of the device. For example,
      `projects/p0/locations/us-central1/registries/registry0/devices/device0`
      or `projects/p0/locations/us-
      central1/registries/registry0/devices/{num_id}`.
    sendCommandToDeviceRequest: A SendCommandToDeviceRequest resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  sendCommandToDeviceRequest = _messages.MessageField('SendCommandToDeviceRequest', 2)


class CloudiotProjectsLocationsRegistriesDevicesStatesListRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesDevicesStatesListRequest object.

  Fields:
    name: Required. The name of the device. For example,
      `projects/p0/locations/us-central1/registries/registry0/devices/device0`
      or `projects/p0/locations/us-
      central1/registries/registry0/devices/{num_id}`.
    numStates: The number of states to list. States are listed in descending
      order of update time. The maximum number of states retained is 10. If
      this value is zero, it will return all the states available.
  """

  name = _messages.StringField(1, required=True)
  numStates = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class CloudiotProjectsLocationsRegistriesGetIamPolicyRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesGetRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGetRequest object.

  Fields:
    name: Required. The name of the device registry. For example,
      `projects/example-project/locations/us-central1/registries/my-registry`.
  """

  name = _messages.StringField(1, required=True)


class CloudiotProjectsLocationsRegistriesGroupsDevicesListRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsDevicesListRequest object.

  Enums:
    GatewayListOptionsGatewayTypeValueValuesEnum: If `GATEWAY` is specified,
      only gateways are returned. If `NON_GATEWAY` is specified, only non-
      gateway devices are returned. If `GATEWAY_TYPE_UNSPECIFIED` is
      specified, all devices are returned.

  Fields:
    deviceIds: A list of device string IDs. For example, `['device0',
      'device12']`. If empty, this field is ignored. Maximum IDs: 10,000
    deviceNumIds: A list of device numeric IDs. If empty, this field is
      ignored. Maximum IDs: 10,000.
    fieldMask: The fields of the `Device` resource to be returned in the
      response. The fields `id` and `num_id` are always returned, along with
      any other fields specified in snake_case format, for example:
      `last_heartbeat_time`.
    gatewayListOptions_associationsDeviceId: If set, returns only the gateways
      with which the specified device is associated. The device ID can be
      numeric (`num_id`) or the user-defined string (`id`). For example, if
      `456` is specified, returns only the gateways to which the device with
      `num_id` 456 is bound.
    gatewayListOptions_associationsGatewayId: If set, only devices associated
      with the specified gateway are returned. The gateway ID can be numeric
      (`num_id`) or the user-defined string (`id`). For example, if `123` is
      specified, only devices bound to the gateway with `num_id` 123 are
      returned.
    gatewayListOptions_gatewayType: If `GATEWAY` is specified, only gateways
      are returned. If `NON_GATEWAY` is specified, only non-gateway devices
      are returned. If `GATEWAY_TYPE_UNSPECIFIED` is specified, all devices
      are returned.
    pageSize: The maximum number of devices to return in the response. If this
      value is zero, the service will select a default size. A call may return
      fewer objects than requested. A non-empty `next_page_token` in the
      response indicates that more data is available.
    pageToken: The value returned by the last `ListDevicesResponse`; indicates
      that this is a continuation of a prior `ListDevices` call and the system
      should return the next page of data.
    parent: Required. The device registry path. Required. For example,
      `projects/my-project/locations/us-central1/registries/my-registry`.
  """

  class GatewayListOptionsGatewayTypeValueValuesEnum(_messages.Enum):
    r"""If `GATEWAY` is specified, only gateways are returned. If
    `NON_GATEWAY` is specified, only non-gateway devices are returned. If
    `GATEWAY_TYPE_UNSPECIFIED` is specified, all devices are returned.

    Values:
      GATEWAY_TYPE_UNSPECIFIED: If unspecified, the device is considered a
        non-gateway device.
      GATEWAY: The device is a gateway.
      NON_GATEWAY: The device is not a gateway.
    """
    GATEWAY_TYPE_UNSPECIFIED = 0
    GATEWAY = 1
    NON_GATEWAY = 2

  deviceIds = _messages.StringField(1, repeated=True)
  deviceNumIds = _messages.IntegerField(2, repeated=True, variant=_messages.Variant.UINT64)
  fieldMask = _messages.StringField(3)
  gatewayListOptions_associationsDeviceId = _messages.StringField(4)
  gatewayListOptions_associationsGatewayId = _messages.StringField(5)
  gatewayListOptions_gatewayType = _messages.EnumField('GatewayListOptionsGatewayTypeValueValuesEnum', 6)
  pageSize = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(8)
  parent = _messages.StringField(9, required=True)


class CloudiotProjectsLocationsRegistriesGroupsGetIamPolicyRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesGroupsSetIamPolicyRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudiotProjectsLocationsRegistriesGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesGroupsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudiotProjectsLocationsRegistriesListRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesListRequest object.

  Fields:
    pageSize: The maximum number of registries to return in the response. If
      this value is zero, the service will select a default size. A call may
      return fewer objects than requested. A non-empty `next_page_token` in
      the response indicates that more data is available.
    pageToken: The value returned by the last `ListDeviceRegistriesResponse`;
      indicates that this is a continuation of a prior `ListDeviceRegistries`
      call and the system should return the next page of data.
    parent: Required. The project and cloud region path. For example,
      `projects/example-project/locations/us-central1`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudiotProjectsLocationsRegistriesPatchRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesPatchRequest object.

  Fields:
    deviceRegistry: A DeviceRegistry resource to be passed as the request
      body.
    name: The resource path name. For example, `projects/example-
      project/locations/us-central1/registries/my-registry`.
    updateMask: Required. Only updates the `device_registry` fields indicated
      by this mask. The field mask must not be empty, and it must not contain
      fields that are immutable or only set by the server. Mutable top-level
      fields: `event_notification_config`, `http_config`, `mqtt_config`, and
      `state_notification_config`.
  """

  deviceRegistry = _messages.MessageField('DeviceRegistry', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudiotProjectsLocationsRegistriesSetIamPolicyRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudiotProjectsLocationsRegistriesTestIamPermissionsRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudiotProjectsLocationsRegistriesUnbindDeviceFromGatewayRequest(_messages.Message):
  r"""A CloudiotProjectsLocationsRegistriesUnbindDeviceFromGatewayRequest
  object.

  Fields:
    parent: Required. The name of the registry. For example,
      `projects/example-project/locations/us-central1/registries/my-registry`.
    unbindDeviceFromGatewayRequest: A UnbindDeviceFromGatewayRequest resource
      to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  unbindDeviceFromGatewayRequest = _messages.MessageField('UnbindDeviceFromGatewayRequest', 2)


class Device(_messages.Message):
  r"""The device resource.

  Enums:
    LogLevelValueValuesEnum: **Beta Feature** The logging verbosity for device
      activity. If unspecified, DeviceRegistry.log_level will be used.

  Messages:
    MetadataValue: The metadata key-value pairs assigned to the device. This
      metadata is not interpreted or indexed by Cloud IoT Core. It can be used
      to add contextual information for the device. Keys must conform to the
      regular expression a-zA-Z+ and be less than 128 bytes in length. Values
      are free-form strings. Each value must be less than or equal to 32 KB in
      size. The total size of all keys and values must be less than 256 KB,
      and the maximum number of key-value pairs is 500.

  Fields:
    blocked: If a device is blocked, connections or requests from this device
      will fail. Can be used to temporarily prevent the device from connecting
      if, for example, the sensor is generating bad data and needs
      maintenance.
    config: The most recent device configuration, which is eventually sent
      from Cloud IoT Core to the device. If not present on creation, the
      configuration will be initialized with an empty payload and version
      value of `1`. To update this field after creation, use the
      `DeviceManager.ModifyCloudToDeviceConfig` method.
    credentials: The credentials used to authenticate this device. To allow
      credential rotation without interruption, multiple device credentials
      can be bound to this device. No more than 3 credentials can be bound to
      a single device at a time. When new credentials are added to a device,
      they are verified against the registry credentials. For details, see the
      description of the `DeviceRegistry.credentials` field.
    gatewayConfig: Gateway-related configuration and state.
    id: The user-defined device identifier. The device ID must be unique
      within a device registry.
    lastConfigAckTime: [Output only] The last time a cloud-to-device config
      version acknowledgment was received from the device. This field is only
      for configurations sent through MQTT.
    lastConfigSendTime: [Output only] The last time a cloud-to-device config
      version was sent to the device.
    lastErrorStatus: [Output only] The error message of the most recent error,
      such as a failure to publish to Cloud Pub/Sub. 'last_error_time' is the
      timestamp of this field. If no errors have occurred, this field has an
      empty message and the status code 0 == OK. Otherwise, this field is
      expected to have a status code other than OK.
    lastErrorTime: [Output only] The time the most recent error occurred, such
      as a failure to publish to Cloud Pub/Sub. This field is the timestamp of
      'last_error_status'.
    lastEventTime: [Output only] The last time a telemetry event was received.
      Timestamps are periodically collected and written to storage; they may
      be stale by a few minutes.
    lastHeartbeatTime: [Output only] The last time an MQTT `PINGREQ` was
      received. This field applies only to devices connecting through MQTT.
      MQTT clients usually only send `PINGREQ` messages if the connection is
      idle, and no other messages have been sent. Timestamps are periodically
      collected and written to storage; they may be stale by a few minutes.
    lastStateTime: [Output only] The last time a state event was received.
      Timestamps are periodically collected and written to storage; they may
      be stale by a few minutes.
    logLevel: **Beta Feature** The logging verbosity for device activity. If
      unspecified, DeviceRegistry.log_level will be used.
    metadata: The metadata key-value pairs assigned to the device. This
      metadata is not interpreted or indexed by Cloud IoT Core. It can be used
      to add contextual information for the device. Keys must conform to the
      regular expression a-zA-Z+ and be less than 128 bytes in length. Values
      are free-form strings. Each value must be less than or equal to 32 KB in
      size. The total size of all keys and values must be less than 256 KB,
      and the maximum number of key-value pairs is 500.
    name: The resource path name. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0` or
      `projects/p1/locations/us-
      central1/registries/registry0/devices/{num_id}`. When `name` is
      populated as a response from the service, it always ends in the device
      numeric ID.
    numId: [Output only] A server-defined unique numeric ID for the device.
      This is a more compact way to identify devices, and it is globally
      unique.
    state: [Output only] The state most recently received from the device. If
      no state has been reported, this field is not present.
  """

  class LogLevelValueValuesEnum(_messages.Enum):
    r"""**Beta Feature** The logging verbosity for device activity. If
    unspecified, DeviceRegistry.log_level will be used.

    Values:
      LOG_LEVEL_UNSPECIFIED: No logging specified. If not specified, logging
        will be disabled.
      NONE: Disables logging.
      ERROR: Error events will be logged.
      INFO: Informational events will be logged, such as connections and
        disconnections.
      DEBUG: All events will be logged.
    """
    LOG_LEVEL_UNSPECIFIED = 0
    NONE = 1
    ERROR = 2
    INFO = 3
    DEBUG = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""The metadata key-value pairs assigned to the device. This metadata is
    not interpreted or indexed by Cloud IoT Core. It can be used to add
    contextual information for the device. Keys must conform to the regular
    expression a-zA-Z+ and be less than 128 bytes in length. Values are free-
    form strings. Each value must be less than or equal to 32 KB in size. The
    total size of all keys and values must be less than 256 KB, and the
    maximum number of key-value pairs is 500.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Additional properties of type MetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  blocked = _messages.BooleanField(1)
  config = _messages.MessageField('DeviceConfig', 2)
  credentials = _messages.MessageField('DeviceCredential', 3, repeated=True)
  gatewayConfig = _messages.MessageField('GatewayConfig', 4)
  id = _messages.StringField(5)
  lastConfigAckTime = _messages.StringField(6)
  lastConfigSendTime = _messages.StringField(7)
  lastErrorStatus = _messages.MessageField('Status', 8)
  lastErrorTime = _messages.StringField(9)
  lastEventTime = _messages.StringField(10)
  lastHeartbeatTime = _messages.StringField(11)
  lastStateTime = _messages.StringField(12)
  logLevel = _messages.EnumField('LogLevelValueValuesEnum', 13)
  metadata = _messages.MessageField('MetadataValue', 14)
  name = _messages.StringField(15)
  numId = _messages.IntegerField(16, variant=_messages.Variant.UINT64)
  state = _messages.MessageField('DeviceState', 17)


class DeviceConfig(_messages.Message):
  r"""The device configuration. Eventually delivered to devices.

  Fields:
    binaryData: The device configuration data.
    cloudUpdateTime: [Output only] The time at which this configuration
      version was updated in Cloud IoT Core. This timestamp is set by the
      server.
    deviceAckTime: [Output only] The time at which Cloud IoT Core received the
      acknowledgment from the device, indicating that the device has received
      this configuration version. If this field is not present, the device has
      not yet acknowledged that it received this version. Note that when the
      config was sent to the device, many config versions may have been
      available in Cloud IoT Core while the device was disconnected, and on
      connection, only the latest version is sent to the device. Some versions
      may never be sent to the device, and therefore are never acknowledged.
      This timestamp is set by Cloud IoT Core.
    version: [Output only] The version of this update. The version number is
      assigned by the server, and is always greater than 0 after device
      creation. The version must be 0 on the `CreateDevice` request if a
      `config` is specified; the response of `CreateDevice` will always have a
      value of 1.
  """

  binaryData = _messages.BytesField(1)
  cloudUpdateTime = _messages.StringField(2)
  deviceAckTime = _messages.StringField(3)
  version = _messages.IntegerField(4)


class DeviceCredential(_messages.Message):
  r"""A server-stored device credential used for authentication.

  Fields:
    expirationTime: [Optional] The time at which this credential becomes
      invalid. This credential will be ignored for new client authentication
      requests after this timestamp; however, it will not be automatically
      deleted.
    publicKey: A public key used to verify the signature of JSON Web Tokens
      (JWTs). When adding a new device credential, either via device creation
      or via modifications, this public key credential may be required to be
      signed by one of the registry level certificates. More specifically, if
      the registry contains at least one certificate, any new device
      credential must be signed by one of the registry certificates. As a
      result, when the registry contains certificates, only X.509 certificates
      are accepted as device credentials. However, if the registry does not
      contain a certificate, self-signed certificates and public keys will be
      accepted. New device credentials must be different from every registry-
      level certificate.
  """

  expirationTime = _messages.StringField(1)
  publicKey = _messages.MessageField('PublicKeyCredential', 2)


class DeviceRegistry(_messages.Message):
  r"""A container for a group of devices.

  Enums:
    LogLevelValueValuesEnum: **Beta Feature** The default logging verbosity
      for activity from devices in this registry. The verbosity level can be
      overridden by Device.log_level.

  Fields:
    credentials: The credentials used to verify the device credentials. No
      more than 10 credentials can be bound to a single registry at a time.
      The verification process occurs at the time of device creation or
      update. If this field is empty, no verification is performed. Otherwise,
      the credentials of a newly created device or added credentials of an
      updated device should be signed with one of these registry credentials.
      Note, however, that existing devices will never be affected by
      modifications to this list of credentials: after a device has been
      successfully created in a registry, it should be able to connect even if
      its registry credentials are revoked, deleted, or modified.
    eventNotificationConfigs: The configuration for notification of telemetry
      events received from the device. All telemetry events that were
      successfully published by the device and acknowledged by Cloud IoT Core
      are guaranteed to be delivered to Cloud Pub/Sub. If multiple
      configurations match a message, only the first matching configuration is
      used. If you try to publish a device telemetry event using MQTT without
      specifying a Cloud Pub/Sub topic for the device's registry, the
      connection closes automatically. If you try to do so using an HTTP
      connection, an error is returned. Up to 10 configurations may be
      provided.
    httpConfig: The DeviceService (HTTP) configuration for this device
      registry.
    id: The identifier of this device registry. For example, `myRegistry`.
    logLevel: **Beta Feature** The default logging verbosity for activity from
      devices in this registry. The verbosity level can be overridden by
      Device.log_level.
    mqttConfig: The MQTT configuration for this device registry.
    name: The resource path name. For example, `projects/example-
      project/locations/us-central1/registries/my-registry`.
    stateNotificationConfig: The configuration for notification of new states
      received from the device. State updates are guaranteed to be stored in
      the state history, but notifications to Cloud Pub/Sub are not
      guaranteed. For example, if permissions are misconfigured or the
      specified topic doesn't exist, no notification will be published but the
      state will still be stored in Cloud IoT Core.
  """

  class LogLevelValueValuesEnum(_messages.Enum):
    r"""**Beta Feature** The default logging verbosity for activity from
    devices in this registry. The verbosity level can be overridden by
    Device.log_level.

    Values:
      LOG_LEVEL_UNSPECIFIED: No logging specified. If not specified, logging
        will be disabled.
      NONE: Disables logging.
      ERROR: Error events will be logged.
      INFO: Informational events will be logged, such as connections and
        disconnections.
      DEBUG: All events will be logged.
    """
    LOG_LEVEL_UNSPECIFIED = 0
    NONE = 1
    ERROR = 2
    INFO = 3
    DEBUG = 4

  credentials = _messages.MessageField('RegistryCredential', 1, repeated=True)
  eventNotificationConfigs = _messages.MessageField('EventNotificationConfig', 2, repeated=True)
  httpConfig = _messages.MessageField('HttpConfig', 3)
  id = _messages.StringField(4)
  logLevel = _messages.EnumField('LogLevelValueValuesEnum', 5)
  mqttConfig = _messages.MessageField('MqttConfig', 6)
  name = _messages.StringField(7)
  stateNotificationConfig = _messages.MessageField('StateNotificationConfig', 8)


class DeviceState(_messages.Message):
  r"""The device state, as reported by the device.

  Fields:
    binaryData: The device state data.
    updateTime: [Output only] The time at which this state version was updated
      in Cloud IoT Core.
  """

  binaryData = _messages.BytesField(1)
  updateTime = _messages.StringField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class EventNotificationConfig(_messages.Message):
  r"""The configuration for forwarding telemetry events.

  Fields:
    pubsubTopicName: A Cloud Pub/Sub topic name. For example,
      `projects/myProject/topics/deviceEvents`.
    subfolderMatches: If the subfolder name matches this string exactly, this
      configuration will be used. The string must not include the leading '/'
      character. If empty, all strings are matched. This field is used only
      for telemetry events; subfolders are not supported for state changes.
  """

  pubsubTopicName = _messages.StringField(1)
  subfolderMatches = _messages.StringField(2)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GatewayConfig(_messages.Message):
  r"""Gateway-related configuration and state.

  Enums:
    GatewayAuthMethodValueValuesEnum: Indicates how to authorize and/or
      authenticate devices to access the gateway.
    GatewayTypeValueValuesEnum: Indicates whether the device is a gateway.

  Fields:
    gatewayAuthMethod: Indicates how to authorize and/or authenticate devices
      to access the gateway.
    gatewayType: Indicates whether the device is a gateway.
    lastAccessedGatewayId: [Output only] The ID of the gateway the device
      accessed most recently.
    lastAccessedGatewayTime: [Output only] The most recent time at which the
      device accessed the gateway specified in `last_accessed_gateway`.
  """

  class GatewayAuthMethodValueValuesEnum(_messages.Enum):
    r"""Indicates how to authorize and/or authenticate devices to access the
    gateway.

    Values:
      GATEWAY_AUTH_METHOD_UNSPECIFIED: No authentication/authorization method
        specified. No devices are allowed to access the gateway.
      ASSOCIATION_ONLY: The device is authenticated through the gateway
        association only. Device credentials are ignored even if provided.
      DEVICE_AUTH_TOKEN_ONLY: The device is authenticated through its own
        credentials. Gateway association is not checked.
      ASSOCIATION_AND_DEVICE_AUTH_TOKEN: The device is authenticated through
        both device credentials and gateway association. The device must be
        bound to the gateway and must provide its own credentials.
    """
    GATEWAY_AUTH_METHOD_UNSPECIFIED = 0
    ASSOCIATION_ONLY = 1
    DEVICE_AUTH_TOKEN_ONLY = 2
    ASSOCIATION_AND_DEVICE_AUTH_TOKEN = 3

  class GatewayTypeValueValuesEnum(_messages.Enum):
    r"""Indicates whether the device is a gateway.

    Values:
      GATEWAY_TYPE_UNSPECIFIED: If unspecified, the device is considered a
        non-gateway device.
      GATEWAY: The device is a gateway.
      NON_GATEWAY: The device is not a gateway.
    """
    GATEWAY_TYPE_UNSPECIFIED = 0
    GATEWAY = 1
    NON_GATEWAY = 2

  gatewayAuthMethod = _messages.EnumField('GatewayAuthMethodValueValuesEnum', 1)
  gatewayType = _messages.EnumField('GatewayTypeValueValuesEnum', 2)
  lastAccessedGatewayId = _messages.StringField(3)
  lastAccessedGatewayTime = _messages.StringField(4)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method.

  Fields:
    options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
      `GetIamPolicy`.
  """

  options = _messages.MessageField('GetPolicyOptions', 1)


class GetPolicyOptions(_messages.Message):
  r"""Encapsulates settings provided to GetIamPolicy.

  Fields:
    requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class HttpConfig(_messages.Message):
  r"""The configuration of the HTTP bridge for a device registry.

  Enums:
    HttpEnabledStateValueValuesEnum: If enabled, allows devices to use
      DeviceService via the HTTP protocol. Otherwise, any requests to
      DeviceService will fail for this registry.

  Fields:
    httpEnabledState: If enabled, allows devices to use DeviceService via the
      HTTP protocol. Otherwise, any requests to DeviceService will fail for
      this registry.
  """

  class HttpEnabledStateValueValuesEnum(_messages.Enum):
    r"""If enabled, allows devices to use DeviceService via the HTTP protocol.
    Otherwise, any requests to DeviceService will fail for this registry.

    Values:
      HTTP_STATE_UNSPECIFIED: No HTTP state specified. If not specified,
        DeviceService will be enabled by default.
      HTTP_ENABLED: Enables DeviceService (HTTP) service for the registry.
      HTTP_DISABLED: Disables DeviceService (HTTP) service for the registry.
    """
    HTTP_STATE_UNSPECIFIED = 0
    HTTP_ENABLED = 1
    HTTP_DISABLED = 2

  httpEnabledState = _messages.EnumField('HttpEnabledStateValueValuesEnum', 1)


class ListDeviceConfigVersionsResponse(_messages.Message):
  r"""Response for `ListDeviceConfigVersions`.

  Fields:
    deviceConfigs: The device configuration for the last few versions.
      Versions are listed in decreasing order, starting from the most recent
      one.
  """

  deviceConfigs = _messages.MessageField('DeviceConfig', 1, repeated=True)


class ListDeviceRegistriesResponse(_messages.Message):
  r"""Response for `ListDeviceRegistries`.

  Fields:
    deviceRegistries: The registries that matched the query.
    nextPageToken: If not empty, indicates that there may be more registries
      that match the request; this value should be passed in a new
      `ListDeviceRegistriesRequest`.
  """

  deviceRegistries = _messages.MessageField('DeviceRegistry', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDeviceStatesResponse(_messages.Message):
  r"""Response for `ListDeviceStates`.

  Fields:
    deviceStates: The last few device states. States are listed in descending
      order of server update time, starting from the most recent one.
  """

  deviceStates = _messages.MessageField('DeviceState', 1, repeated=True)


class ListDevicesResponse(_messages.Message):
  r"""Response for `ListDevices`.

  Fields:
    devices: The devices that match the request.
    nextPageToken: If not empty, indicates that there may be more devices that
      match the request; this value should be passed in a new
      `ListDevicesRequest`.
  """

  devices = _messages.MessageField('Device', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ModifyCloudToDeviceConfigRequest(_messages.Message):
  r"""Request for `ModifyCloudToDeviceConfig`.

  Fields:
    binaryData: Required. The configuration data for the device.
    versionToUpdate: The version number to update. If this value is zero, it
      will not check the version number of the server and will always update
      the current version; otherwise, this update will fail if the version
      number found on the server does not match this version number. This is
      used to support multiple simultaneous updates without losing data.
  """

  binaryData = _messages.BytesField(1)
  versionToUpdate = _messages.IntegerField(2)


class MqttConfig(_messages.Message):
  r"""The configuration of MQTT for a device registry.

  Enums:
    MqttEnabledStateValueValuesEnum: If enabled, allows connections using the
      MQTT protocol. Otherwise, MQTT connections to this registry will fail.

  Fields:
    mqttEnabledState: If enabled, allows connections using the MQTT protocol.
      Otherwise, MQTT connections to this registry will fail.
  """

  class MqttEnabledStateValueValuesEnum(_messages.Enum):
    r"""If enabled, allows connections using the MQTT protocol. Otherwise,
    MQTT connections to this registry will fail.

    Values:
      MQTT_STATE_UNSPECIFIED: No MQTT state specified. If not specified, MQTT
        will be enabled by default.
      MQTT_ENABLED: Enables a MQTT connection.
      MQTT_DISABLED: Disables a MQTT connection.
    """
    MQTT_STATE_UNSPECIFIED = 0
    MQTT_ENABLED = 1
    MQTT_DISABLED = 2

  mqttEnabledState = _messages.EnumField('MqttEnabledStateValueValuesEnum', 1)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class PublicKeyCertificate(_messages.Message):
  r"""A public key certificate format and data.

  Enums:
    FormatValueValuesEnum: The certificate format.

  Fields:
    certificate: The certificate data.
    format: The certificate format.
    x509Details: [Output only] The certificate details. Used only for X.509
      certificates.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""The certificate format.

    Values:
      UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT: The format has not been
        specified. This is an invalid default value and must not be used.
      X509_CERTIFICATE_PEM: An X.509v3 certificate
        ([RFC5280](https://www.ietf.org/rfc/rfc5280.txt)), encoded in base64,
        and wrapped by `-----BEGIN CERTIFICATE-----` and `-----END
        CERTIFICATE-----`.
    """
    UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT = 0
    X509_CERTIFICATE_PEM = 1

  certificate = _messages.StringField(1)
  format = _messages.EnumField('FormatValueValuesEnum', 2)
  x509Details = _messages.MessageField('X509CertificateDetails', 3)


class PublicKeyCredential(_messages.Message):
  r"""A public key format and data.

  Enums:
    FormatValueValuesEnum: The format of the key.

  Fields:
    format: The format of the key.
    key: The key data.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""The format of the key.

    Values:
      UNSPECIFIED_PUBLIC_KEY_FORMAT: The format has not been specified. This
        is an invalid default value and must not be used.
      RSA_PEM: An RSA public key encoded in base64, and wrapped by `-----BEGIN
        PUBLIC KEY-----` and `-----END PUBLIC KEY-----`. This can be used to
        verify `RS256` signatures in JWT tokens ([RFC7518](
        https://www.ietf.org/rfc/rfc7518.txt)).
      RSA_X509_PEM: As RSA_PEM, but wrapped in an X.509v3 certificate
        ([RFC5280]( https://www.ietf.org/rfc/rfc5280.txt)), encoded in base64,
        and wrapped by `-----BEGIN CERTIFICATE-----` and `-----END
        CERTIFICATE-----`.
      ES256_PEM: Public key for the ECDSA algorithm using P-256 and SHA-256,
        encoded in base64, and wrapped by `-----BEGIN PUBLIC KEY-----` and
        `-----END PUBLIC KEY-----`. This can be used to verify JWT tokens with
        the `ES256` algorithm
        ([RFC7518](https://www.ietf.org/rfc/rfc7518.txt)). This curve is
        defined in [OpenSSL](https://www.openssl.org/) as the `prime256v1`
        curve.
      ES256_X509_PEM: As ES256_PEM, but wrapped in an X.509v3 certificate
        ([RFC5280]( https://www.ietf.org/rfc/rfc5280.txt)), encoded in base64,
        and wrapped by `-----BEGIN CERTIFICATE-----` and `-----END
        CERTIFICATE-----`.
    """
    UNSPECIFIED_PUBLIC_KEY_FORMAT = 0
    RSA_PEM = 1
    RSA_X509_PEM = 2
    ES256_PEM = 3
    ES256_X509_PEM = 4

  format = _messages.EnumField('FormatValueValuesEnum', 1)
  key = _messages.StringField(2)


class RegistryCredential(_messages.Message):
  r"""A server-stored registry credential used to validate device credentials.

  Fields:
    publicKeyCertificate: A public key certificate used to verify the device
      credentials.
  """

  publicKeyCertificate = _messages.MessageField('PublicKeyCertificate', 1)


class SendCommandToDeviceRequest(_messages.Message):
  r"""Request for `SendCommandToDevice`.

  Fields:
    binaryData: Required. The command data to send to the device.
    subfolder: Optional subfolder for the command. If empty, the command will
      be delivered to the /devices/{device-id}/commands topic, otherwise it
      will be delivered to the /devices/{device-id}/commands/{subfolder}
      topic. Multi-level subfolders are allowed. This field must not have more
      than 256 characters, and must not contain any MQTT wildcards ("+" or
      "#") or null characters.
  """

  binaryData = _messages.BytesField(1)
  subfolder = _messages.StringField(2)


class SendCommandToDeviceResponse(_messages.Message):
  r"""Response for `SendCommandToDevice`."""


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StateNotificationConfig(_messages.Message):
  r"""The configuration for notification of new states received from the
  device.

  Fields:
    pubsubTopicName: A Cloud Pub/Sub topic name. For example,
      `projects/myProject/topics/deviceEvents`.
  """

  pubsubTopicName = _messages.StringField(1)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UnbindDeviceFromGatewayRequest(_messages.Message):
  r"""Request for `UnbindDeviceFromGateway`.

  Fields:
    deviceId: Required. The device to disassociate from the specified gateway.
      The value of `device_id` can be either the device numeric ID or the
      user-defined device identifier.
    gatewayId: Required. The value of `gateway_id` can be either the device
      numeric ID or the user-defined device identifier.
  """

  deviceId = _messages.StringField(1)
  gatewayId = _messages.StringField(2)


class UnbindDeviceFromGatewayResponse(_messages.Message):
  r"""Response for `UnbindDeviceFromGateway`."""


class X509CertificateDetails(_messages.Message):
  r"""Details of an X.509 certificate. For informational purposes only.

  Fields:
    expiryTime: The time the certificate becomes invalid.
    issuer: The entity that signed the certificate.
    publicKeyType: The type of public key in the certificate.
    signatureAlgorithm: The algorithm used to sign the certificate.
    startTime: The time the certificate becomes valid.
    subject: The entity the certificate and public key belong to.
  """

  expiryTime = _messages.StringField(1)
  issuer = _messages.StringField(2)
  publicKeyType = _messages.StringField(3)
  signatureAlgorithm = _messages.StringField(4)
  startTime = _messages.StringField(5)
  subject = _messages.StringField(6)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
