; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-- | FileCheck %s

declare i4 @llvm.uadd.sat.i4(i4, i4)
declare i8 @llvm.uadd.sat.i8(i8, i8)
declare i16 @llvm.uadd.sat.i16(i16, i16)
declare i32 @llvm.uadd.sat.i32(i32, i32)
declare i64 @llvm.uadd.sat.i64(i64, i64)

define i32 @func(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: func:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adds w8, w0, w1
; CHECK-NEXT:    csinv w0, w8, wzr, lo
; CHECK-NEXT:    ret
  %tmp = call i32 @llvm.uadd.sat.i32(i32 %x, i32 %y);
  ret i32 %tmp;
}

define i64 @func2(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: func2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adds x8, x0, x1
; CHECK-NEXT:    csinv x0, x8, xzr, lo
; CHECK-NEXT:    ret
  %tmp = call i64 @llvm.uadd.sat.i64(i64 %x, i64 %y);
  ret i64 %tmp;
}

define i16 @func16(i16 %x, i16 %y) nounwind {
; CHECK-LABEL: func16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xffff
; CHECK-NEXT:    mov w9, #65535 // =0xffff
; CHECK-NEXT:    add w8, w8, w1, uxth
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    csel w0, w8, w9, lo
; CHECK-NEXT:    ret
  %tmp = call i16 @llvm.uadd.sat.i16(i16 %x, i16 %y);
  ret i16 %tmp;
}

define i8 @func8(i8 %x, i8 %y) nounwind {
; CHECK-LABEL: func8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w9, w0, #0xff
; CHECK-NEXT:    mov w8, #255 // =0xff
; CHECK-NEXT:    add w9, w9, w1, uxtb
; CHECK-NEXT:    cmp w9, #255
; CHECK-NEXT:    csel w0, w9, w8, lo
; CHECK-NEXT:    ret
  %tmp = call i8 @llvm.uadd.sat.i8(i8 %x, i8 %y);
  ret i8 %tmp;
}

define i4 @func3(i4 %x, i4 %y) nounwind {
; CHECK-LABEL: func3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w9, w1, #0xf
; CHECK-NEXT:    and w10, w0, #0xf
; CHECK-NEXT:    mov w8, #15 // =0xf
; CHECK-NEXT:    add w9, w10, w9
; CHECK-NEXT:    cmp w9, #15
; CHECK-NEXT:    csel w0, w9, w8, lo
; CHECK-NEXT:    ret
  %tmp = call i4 @llvm.uadd.sat.i4(i4 %x, i4 %y);
  ret i4 %tmp;
}
