; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -mattr=+2e3 | FileCheck %s
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -mattr=+btst16 | FileCheck %s --check-prefix=GENERIC

;EQ
define i32 @brRR_eq(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bt32 .LBB0_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB0_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpne16 a1, a0
; GENERIC-NEXT:    bt16 .LBB0_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB0_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_eq(i32 %x) {
; CHECK-LABEL: brRI_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bt32 .LBB1_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB1_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpnei16 a0, 10
; GENERIC-NEXT:    bt16 .LBB1_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB1_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_eq(i32 %x) {
; CHECK-LABEL: brR0_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bez32 a0, .LBB2_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB2_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    bf16 .LBB2_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB2_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;NE
define i32 @brRR_ne(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bf32 .LBB3_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB3_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpne16 a1, a0
; GENERIC-NEXT:    bf16 .LBB3_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB3_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ne(i32 %x) {
; CHECK-LABEL: brRI_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bf32 .LBB4_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB4_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpnei16 a0, 10
; GENERIC-NEXT:    bf16 .LBB4_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB4_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ne(i32 %x) {
; CHECK-LABEL: brR0_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bez32 a0, .LBB5_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB5_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    bf16 .LBB5_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB5_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UGT
define i32 @brRR_ugt(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bt32 .LBB6_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB6_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    bt16 .LBB6_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB6_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ugt(i32 %x) {
; CHECK-LABEL: brRI_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    bf32 .LBB7_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB7_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphsi16 a0, 11
; GENERIC-NEXT:    bf16 .LBB7_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB7_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ugt(i32 %x) {
; CHECK-LABEL: brR0_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bez32 a0, .LBB8_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB8_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    bf16 .LBB8_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB8_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UGE
define i32 @brRR_uge(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB9_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB9_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_uge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    bf16 .LBB9_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB9_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_uge(i32 %x) {
; CHECK-LABEL: brRI_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    bf32 .LBB10_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB10_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_uge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphsi16 a0, 10
; GENERIC-NEXT:    bf16 .LBB10_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB10_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;ULT
define i32 @brRR_ult(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bt32 .LBB11_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB11_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_ult:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    bt16 .LBB11_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB11_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ult(i32 %x) {
; CHECK-LABEL: brRI_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB12_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB12_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_ult:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 9
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    bf16 .LBB12_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB12_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}


;ULE
define i32 @brRR_ule(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bf32 .LBB13_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB13_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    bf16 .LBB13_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB13_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ule(i32 %x) {
; CHECK-LABEL: brRI_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB14_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB14_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 10
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    bf16 .LBB14_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB14_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ule(i32 %x) {
; CHECK-LABEL: brR0_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bnez32 a0, .LBB15_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB15_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    bt16 .LBB15_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB15_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SGT
define i32 @brRR_sgt(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bf32 .LBB16_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB16_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    bf16 .LBB16_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB16_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_sgt(i32 %x) {
; CHECK-LABEL: brRI_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    bt32 .LBB17_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB17_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplti16 a0, 11
; GENERIC-NEXT:    bt16 .LBB17_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB17_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_sgt(i32 %x) {
; CHECK-LABEL: brR0_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 1
; CHECK-NEXT:    bt32 .LBB18_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB18_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplti16 a0, 1
; GENERIC-NEXT:    bt16 .LBB18_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB18_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SGE
define i32 @brRR_sge(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB19_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB19_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB19_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB19_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_sge(i32 %x) {
; CHECK-LABEL: brRI_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    bt32 .LBB20_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB20_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplti16 a0, 10
; GENERIC-NEXT:    bt16 .LBB20_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB20_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_sge(i32 %x) {
; CHECK-LABEL: brR0_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    blz32 a0, .LBB21_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB21_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    bt16 .LBB21_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB21_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SLT
define i32 @brRR_slt(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB22_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB22_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bf16 .LBB22_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB22_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_slt(i32 %x) {
; CHECK-LABEL: brRI_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB23_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB23_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 9
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB23_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB23_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_slt(i32 %x) {
; CHECK-LABEL: brR0_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 65535
; CHECK-NEXT:    ori32 a1, a1, 65535
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB24_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB24_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a3, a1, 16
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    lsli16 a2, a1, 8
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    or16 a2, a1
; GENERIC-NEXT:    cmplt16 a2, a0
; GENERIC-NEXT:    bf16 .LBB24_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB24_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SLE
define i32 @brRR_sle(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bt32 .LBB25_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB25_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    bt16 .LBB25_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB25_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_sle(i32 %x) {
; CHECK-LABEL: brRI_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB26_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB26_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 10
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB26_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB26_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_sle(i32 %x) {
; CHECK-LABEL: brR0_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bhz32 a0, .LBB27_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB27_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB27_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB27_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}


define i32 @brCBit(i1 %c) {
; CHECK-LABEL: brCBit:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB28_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB28_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brCBit:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB28_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB28_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  br i1 %c, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}


;EQ
define i64 @brRR_i64_eq(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a1, a3
; CHECK-NEXT:    xor16 a0, a2
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bnez32 a0, .LBB29_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB29_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i64_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    xor16 a1, a3
; GENERIC-NEXT:    xor16 a0, a2
; GENERIC-NEXT:    or16 a0, a1
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    bt16 .LBB29_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB29_3
; GENERIC-NEXT:  .LBB29_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB29_3: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_eq(i64 %x) {
; CHECK-LABEL: brR0_i64_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 10
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bnez32 a0, .LBB30_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB30_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i64_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 10
; GENERIC-NEXT:    xor16 a2, a0
; GENERIC-NEXT:    or16 a2, a1
; GENERIC-NEXT:    cmpnei16 a2, 0
; GENERIC-NEXT:    bt16 .LBB30_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB30_3
; GENERIC-NEXT:  .LBB30_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB30_3: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_eq(i64 %x) {
; CHECK-LABEL: brRI_i64_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bez32 a0, .LBB31_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB31_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i64_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    or16 a0, a1
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    bf16 .LBB31_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    br32 .LBB31_3
; GENERIC-NEXT:  .LBB31_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:  .LBB31_3: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;NE
define i64 @brRR_i64_ne(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a1, a3
; CHECK-NEXT:    xor16 a0, a2
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bez32 a0, .LBB32_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB32_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i64_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    xor16 a1, a3
; GENERIC-NEXT:    xor16 a0, a2
; GENERIC-NEXT:    or16 a0, a1
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    bf16 .LBB32_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB32_3
; GENERIC-NEXT:  .LBB32_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB32_3: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_ne(i64 %x) {
; CHECK-LABEL: brRI_i64_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 10
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bez32 a0, .LBB33_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB33_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i64_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 10
; GENERIC-NEXT:    xor16 a2, a0
; GENERIC-NEXT:    or16 a2, a1
; GENERIC-NEXT:    cmpnei16 a2, 0
; GENERIC-NEXT:    bf16 .LBB33_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB33_3
; GENERIC-NEXT:  .LBB33_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB33_3: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_ne(i64 %x) {
; CHECK-LABEL: brR0_i64_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bez32 a0, .LBB34_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB34_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i64_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    or16 a0, a1
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    bf16 .LBB34_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB34_3
; GENERIC-NEXT:  .LBB34_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB34_3: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;UGT
define i64 @brRR_i64_ugt(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    cmphs16 a1, a3
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 12)
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a1, (sp, 12)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB35_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB35_3
; CHECK-NEXT:  .LBB35_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB35_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i64_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    cmphs16 a1, a3
; GENERIC-NEXT:    mvcv16 l1
; GENERIC-NEXT:    movi16 l0, 1
; GENERIC-NEXT:    cmphs16 a0, a2
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB35_3
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    subu16 l0, l1
; GENERIC-NEXT:    btsti16 l0, 0
; GENERIC-NEXT:    bf16 .LBB35_4
; GENERIC-NEXT:  .LBB35_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    br32 .LBB35_5
; GENERIC-NEXT:  .LBB35_3:
; GENERIC-NEXT:    subu16 l0, a0
; GENERIC-NEXT:    btsti16 l0, 0
; GENERIC-NEXT:    bt16 .LBB35_2
; GENERIC-NEXT:  .LBB35_4: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:  .LBB35_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_ugt(i64 %x) {
; CHECK-LABEL: brRI_i64_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB36_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB36_3
; CHECK-NEXT:  .LBB36_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB36_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i64_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphsi16 a0, 11
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB36_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB36_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB36_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB36_5
; GENERIC-NEXT:  .LBB36_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB36_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_ugt(i64 %x) {
; CHECK-LABEL: brR0_i64_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bez32 a0, .LBB37_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB37_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i64_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    or16 a0, a1
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    bf16 .LBB37_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB37_3
; GENERIC-NEXT:  .LBB37_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB37_3: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;UGE
define i64 @brRR_i64_uge(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmphs16 a3, a1
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB38_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB38_3
; CHECK-NEXT:  .LBB38_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB38_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i64_uge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    cmphs16 a3, a1
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    cmphs16 a2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB38_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a0, l0
; GENERIC-NEXT:  .LBB38_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB38_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB38_5
; GENERIC-NEXT:  .LBB38_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB38_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_uge(i64 %x) {
; CHECK-LABEL: brRI_i64_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB39_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB39_3
; CHECK-NEXT:  .LBB39_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB39_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i64_uge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphsi16 a0, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB39_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB39_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB39_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB39_5
; GENERIC-NEXT:  .LBB39_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB39_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;ULT
define i64 @brRR_i64_ult(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    cmphs16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 12)
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a1, (sp, 12)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB40_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB40_3
; CHECK-NEXT:  .LBB40_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB40_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i64_ult:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 8
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    st16.w l1, (sp, 4) # 4-byte Folded Spill
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l1, -4
; GENERIC-NEXT:    .cfi_offset l0, -8
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 12
; GENERIC-NEXT:    cmphs16 a3, a1
; GENERIC-NEXT:    mvcv16 l1
; GENERIC-NEXT:    movi16 l0, 1
; GENERIC-NEXT:    cmphs16 a2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB40_3
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    subu16 l0, l1
; GENERIC-NEXT:    btsti16 l0, 0
; GENERIC-NEXT:    bf16 .LBB40_4
; GENERIC-NEXT:  .LBB40_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    br32 .LBB40_5
; GENERIC-NEXT:  .LBB40_3:
; GENERIC-NEXT:    subu16 l0, a0
; GENERIC-NEXT:    btsti16 l0, 0
; GENERIC-NEXT:    bt16 .LBB40_2
; GENERIC-NEXT:  .LBB40_4: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:  .LBB40_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    ld16.w l1, (sp, 4) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 8
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_ult(i64 %x) {
; CHECK-LABEL: brRI_i64_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a2, 9
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB41_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB41_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i64_ult:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    movi16 a2, 9
; GENERIC-NEXT:    cmphs16 a2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB41_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a1
; GENERIC-NEXT:  .LBB41_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB41_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB41_5
; GENERIC-NEXT:  .LBB41_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB41_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}


;ULE
define i64 @brRR_i64_ule(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmphs16 a1, a3
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB42_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB42_3
; CHECK-NEXT:  .LBB42_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB42_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i64_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    cmphs16 a1, a3
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    cmphs16 a0, a2
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB42_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    mov16 a0, l0
; GENERIC-NEXT:  .LBB42_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB42_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB42_5
; GENERIC-NEXT:  .LBB42_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB42_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_ule(i64 %x) {
; CHECK-LABEL: brRI_i64_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a2, 10
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB43_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB43_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i64_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    movi16 a2, 10
; GENERIC-NEXT:    cmphs16 a2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB43_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a1
; GENERIC-NEXT:  .LBB43_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB43_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB43_5
; GENERIC-NEXT:  .LBB43_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB43_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_ule(i64 %x) {
; CHECK-LABEL: brR0_i64_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bnez32 a0, .LBB44_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB44_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i64_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    or16 a0, a1
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    bt16 .LBB44_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB44_3
; GENERIC-NEXT:  .LBB44_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB44_3: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;SGT
define i64 @brRR_i64_sgt(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    cmplt16 a1, a3
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB45_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB45_3
; CHECK-NEXT:  .LBB45_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB45_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i64_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a0, a2
; GENERIC-NEXT:    mvcv16 a2
; GENERIC-NEXT:    cmplt16 a1, a3
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB45_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a2
; GENERIC-NEXT:  .LBB45_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB45_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB45_5
; GENERIC-NEXT:  .LBB45_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB45_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_sgt(i64 %x) {
; CHECK-LABEL: brRI_i64_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a1, a2
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB46_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB46_3
; CHECK-NEXT:  .LBB46_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB46_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i64_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    cmplt16 a1, a2
; GENERIC-NEXT:    mvcv16 a2
; GENERIC-NEXT:    cmphsi16 a0, 11
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB46_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a2
; GENERIC-NEXT:  .LBB46_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB46_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB46_5
; GENERIC-NEXT:  .LBB46_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB46_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_sgt(i64 %x) {
; CHECK-LABEL: brR0_i64_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a1, a2
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB47_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB47_3
; CHECK-NEXT:  .LBB47_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB47_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i64_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    cmplt16 a1, a2
; GENERIC-NEXT:    mvcv16 a2
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB47_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a2
; GENERIC-NEXT:  .LBB47_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB47_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB47_5
; GENERIC-NEXT:  .LBB47_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB47_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;SGE
define i64 @brRR_i64_sge(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmplt16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB48_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB48_3
; CHECK-NEXT:  .LBB48_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB48_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i64_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    cmplt16 a3, a1
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    cmphs16 a2, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB48_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:  .LBB48_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB48_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB48_5
; GENERIC-NEXT:  .LBB48_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB48_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_sge(i64 %x) {
; CHECK-LABEL: brRI_i64_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a1, a2
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB49_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB49_3
; CHECK-NEXT:  .LBB49_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB49_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i64_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    cmplt16 a1, a2
; GENERIC-NEXT:    mvcv16 a2
; GENERIC-NEXT:    cmphsi16 a0, 10
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB49_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a2
; GENERIC-NEXT:  .LBB49_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB49_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB49_5
; GENERIC-NEXT:  .LBB49_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB49_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_sge(i64 %x) {
; CHECK-LABEL: brR0_i64_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    blz32 a1, .LBB50_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB50_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i64_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB50_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB50_3
; GENERIC-NEXT:  .LBB50_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB50_3: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;SLT
define i64 @brRR_i64_slt(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    cmplt16 a3, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB51_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB51_3
; CHECK-NEXT:  .LBB51_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB51_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i64_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    cmphs16 a2, a0
; GENERIC-NEXT:    mvcv16 a2
; GENERIC-NEXT:    cmplt16 a3, a1
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB51_2
; GENERIC-NEXT:  # %bb.1:
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a2
; GENERIC-NEXT:  .LBB51_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB51_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB51_5
; GENERIC-NEXT:  .LBB51_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB51_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_slt(i64 %x) {
; CHECK-LABEL: brRI_i64_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a2, a1
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 8)
; CHECK-NEXT:    movi16 a2, 9
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB52_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB52_3
; CHECK-NEXT:  .LBB52_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB52_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i64_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    cmplt16 a2, a1
; GENERIC-NEXT:    mvcv16 a2
; GENERIC-NEXT:    movi16 a3, 9
; GENERIC-NEXT:    cmphs16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB52_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a2
; GENERIC-NEXT:  .LBB52_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB52_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB52_5
; GENERIC-NEXT:  .LBB52_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB52_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_slt(i64 %x) {
; CHECK-LABEL: brR0_i64_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a0, 65535
; CHECK-NEXT:    ori32 a0, a0, 65535
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bf32 .LBB53_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB53_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i64_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a0, 255
; GENERIC-NEXT:    lsli16 a2, a0, 24
; GENERIC-NEXT:    lsli16 a3, a0, 16
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    lsli16 a2, a0, 8
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    or16 a2, a0
; GENERIC-NEXT:    cmplt16 a2, a1
; GENERIC-NEXT:    bf16 .LBB53_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    br32 .LBB53_3
; GENERIC-NEXT:  .LBB53_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:  .LBB53_3: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;SLE
define i64 @brRR_i64_sle(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmplt16 a1, a3
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB54_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB54_3
; CHECK-NEXT:  .LBB54_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB54_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i64_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    cmplt16 a1, a3
; GENERIC-NEXT:    mvcv16 l0
; GENERIC-NEXT:    cmphs16 a0, a2
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpne16 a3, a1
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB54_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, l0
; GENERIC-NEXT:  .LBB54_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB54_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB54_5
; GENERIC-NEXT:  .LBB54_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB54_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_sle(i64 %x) {
; CHECK-LABEL: brRI_i64_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a2, a1
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 8)
; CHECK-NEXT:    movi16 a2, 10
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB55_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB55_3
; CHECK-NEXT:  .LBB55_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB55_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i64_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    cmplt16 a2, a1
; GENERIC-NEXT:    mvcv16 a2
; GENERIC-NEXT:    movi16 a3, 10
; GENERIC-NEXT:    cmphs16 a3, a0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB55_2
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    subu16 a0, a2
; GENERIC-NEXT:  .LBB55_2: # %entry
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB55_4
; GENERIC-NEXT:  # %bb.3: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB55_5
; GENERIC-NEXT:  .LBB55_4: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB55_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_sle(i64 %x) {
; CHECK-LABEL: brR0_i64_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a2, a1
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 12)
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a1, (sp, 12)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB56_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB56_3
; CHECK-NEXT:  .LBB56_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB56_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i64_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    cmplt16 a2, a1
; GENERIC-NEXT:    mvcv16 a3
; GENERIC-NEXT:    movi16 a2, 1
; GENERIC-NEXT:    cmpnei16 a0, 0
; GENERIC-NEXT:    mvcv16 a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    mvcv16 a1
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB56_3
; GENERIC-NEXT:  # %bb.1: # %entry
; GENERIC-NEXT:    subu16 a2, a3
; GENERIC-NEXT:    btsti16 a2, 0
; GENERIC-NEXT:    bf16 .LBB56_4
; GENERIC-NEXT:  .LBB56_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    br32 .LBB56_5
; GENERIC-NEXT:  .LBB56_3:
; GENERIC-NEXT:    subu16 a2, a0
; GENERIC-NEXT:    btsti16 a2, 0
; GENERIC-NEXT:    bt16 .LBB56_2
; GENERIC-NEXT:  .LBB56_4: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:  .LBB56_5: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}


define i64 @brCBit_i64(i1 %c) {
; CHECK-LABEL: brCBit_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB57_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB57_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brCBit_i64:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB57_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB57_3
; GENERIC-NEXT:  .LBB57_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB57_3: # %label1
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  br i1 %c, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}


;EQ
define i16 @brRR_i16_eq(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bt32 .LBB58_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB58_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i16_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    lsli16 a3, a2, 24
; GENERIC-NEXT:    lsli16 a2, a2, 16
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    lsli16 l0, a3, 8
; GENERIC-NEXT:    or16 l0, a2
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    and16 a0, l0
; GENERIC-NEXT:    and16 l0, a1
; GENERIC-NEXT:    cmpne16 l0, a0
; GENERIC-NEXT:    bt16 .LBB58_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB58_3
; GENERIC-NEXT:  .LBB58_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB58_3: # %label1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_eq(i16 %x) {
; CHECK-LABEL: brRI_i16_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bt32 .LBB59_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB59_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i16_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a1, a1, 16
; GENERIC-NEXT:    or16 a1, a2
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    lsli16 a3, a2, 8
; GENERIC-NEXT:    or16 a3, a1
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmpnei16 a3, 10
; GENERIC-NEXT:    bt16 .LBB59_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB59_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_eq(i16 %x) {
; CHECK-LABEL: brR0_i16_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB60_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB60_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i16_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a1, a1, 16
; GENERIC-NEXT:    or16 a1, a2
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    lsli16 a3, a2, 8
; GENERIC-NEXT:    or16 a3, a1
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmpnei16 a3, 0
; GENERIC-NEXT:    bf16 .LBB60_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB60_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;NE
define i16 @brRR_i16_ne(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bf32 .LBB61_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB61_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i16_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    lsli16 a3, a2, 24
; GENERIC-NEXT:    lsli16 a2, a2, 16
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    lsli16 l0, a3, 8
; GENERIC-NEXT:    or16 l0, a2
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    and16 a0, l0
; GENERIC-NEXT:    and16 l0, a1
; GENERIC-NEXT:    cmpne16 l0, a0
; GENERIC-NEXT:    bf16 .LBB61_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB61_3
; GENERIC-NEXT:  .LBB61_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB61_3: # %label1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_ne(i16 %x) {
; CHECK-LABEL: brRI_i16_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bf32 .LBB62_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB62_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i16_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a1, a1, 16
; GENERIC-NEXT:    or16 a1, a2
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    lsli16 a3, a2, 8
; GENERIC-NEXT:    or16 a3, a1
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmpnei16 a3, 10
; GENERIC-NEXT:    bf16 .LBB62_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB62_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_ne(i16 %x) {
; CHECK-LABEL: brR0_i16_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB63_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB63_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i16_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a1, a1, 16
; GENERIC-NEXT:    or16 a1, a2
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    lsli16 a3, a2, 8
; GENERIC-NEXT:    or16 a3, a1
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmpnei16 a3, 0
; GENERIC-NEXT:    bf16 .LBB63_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB63_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;UGT
define i16 @brRR_i16_ugt(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bt32 .LBB64_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB64_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i16_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    lsli16 a3, a2, 24
; GENERIC-NEXT:    lsli16 a2, a2, 16
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    lsli16 l0, a3, 8
; GENERIC-NEXT:    or16 l0, a2
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    and16 a1, l0
; GENERIC-NEXT:    and16 l0, a0
; GENERIC-NEXT:    cmphs16 l0, a1
; GENERIC-NEXT:    bt16 .LBB64_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB64_3
; GENERIC-NEXT:  .LBB64_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB64_3: # %label1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_ugt(i16 %x) {
; CHECK-LABEL: brRI_i16_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    bf32 .LBB65_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB65_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i16_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a1, a1, 16
; GENERIC-NEXT:    or16 a1, a2
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    lsli16 a3, a2, 8
; GENERIC-NEXT:    or16 a3, a1
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmphsi16 a3, 11
; GENERIC-NEXT:    bf16 .LBB65_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB65_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_ugt(i16 %x) {
; CHECK-LABEL: brR0_i16_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB66_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB66_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i16_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a1, a1, 16
; GENERIC-NEXT:    or16 a1, a2
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    lsli16 a3, a2, 8
; GENERIC-NEXT:    or16 a3, a1
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmpnei16 a3, 0
; GENERIC-NEXT:    bf16 .LBB66_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB66_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;UGE
define i16 @brRR_i16_uge(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB67_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB67_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i16_uge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    lsli16 a3, a2, 24
; GENERIC-NEXT:    lsli16 a2, a2, 16
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    lsli16 l0, a3, 8
; GENERIC-NEXT:    or16 l0, a2
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    and16 a0, l0
; GENERIC-NEXT:    and16 l0, a1
; GENERIC-NEXT:    cmphs16 l0, a0
; GENERIC-NEXT:    bf16 .LBB67_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB67_3
; GENERIC-NEXT:  .LBB67_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB67_3: # %label1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_uge(i16 %x) {
; CHECK-LABEL: brRI_i16_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    bf32 .LBB68_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB68_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i16_uge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a1, a1, 16
; GENERIC-NEXT:    or16 a1, a2
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    lsli16 a3, a2, 8
; GENERIC-NEXT:    or16 a3, a1
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmphsi16 a3, 10
; GENERIC-NEXT:    bf16 .LBB68_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB68_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;ULT
define i16 @brRR_i16_ult(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bt32 .LBB69_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB69_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i16_ult:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    lsli16 a3, a2, 24
; GENERIC-NEXT:    lsli16 a2, a2, 16
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    lsli16 l0, a3, 8
; GENERIC-NEXT:    or16 l0, a2
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    and16 a0, l0
; GENERIC-NEXT:    and16 l0, a1
; GENERIC-NEXT:    cmphs16 l0, a0
; GENERIC-NEXT:    bt16 .LBB69_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB69_3
; GENERIC-NEXT:  .LBB69_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB69_3: # %label1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_ult(i16 %x) {
; CHECK-LABEL: brRI_i16_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB70_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB70_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i16_ult:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a1, a1, 16
; GENERIC-NEXT:    or16 a1, a2
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    lsli16 a3, a2, 8
; GENERIC-NEXT:    or16 a3, a1
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    movi16 a0, 9
; GENERIC-NEXT:    cmphs16 a0, a3
; GENERIC-NEXT:    bf16 .LBB70_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB70_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}


;ULE
define i16 @brRR_i16_ule(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bf32 .LBB71_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB71_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i16_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; GENERIC-NEXT:    .cfi_offset l0, -4
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 8
; GENERIC-NEXT:    movi16 a2, 0
; GENERIC-NEXT:    lsli16 a3, a2, 24
; GENERIC-NEXT:    lsli16 a2, a2, 16
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    movi16 a3, 255
; GENERIC-NEXT:    lsli16 l0, a3, 8
; GENERIC-NEXT:    or16 l0, a2
; GENERIC-NEXT:    or16 l0, a3
; GENERIC-NEXT:    and16 a1, l0
; GENERIC-NEXT:    and16 l0, a0
; GENERIC-NEXT:    cmphs16 l0, a1
; GENERIC-NEXT:    bf16 .LBB71_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    br32 .LBB71_3
; GENERIC-NEXT:  .LBB71_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:  .LBB71_3: # %label1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_ule(i16 %x) {
; CHECK-LABEL: brRI_i16_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB72_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB72_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i16_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a1, a1, 16
; GENERIC-NEXT:    or16 a1, a2
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    lsli16 a3, a2, 8
; GENERIC-NEXT:    or16 a3, a1
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    movi16 a0, 10
; GENERIC-NEXT:    cmphs16 a0, a3
; GENERIC-NEXT:    bf16 .LBB72_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB72_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_ule(i16 %x) {
; CHECK-LABEL: brR0_i16_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    bnez32 a0, .LBB73_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB73_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i16_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a1, a1, 16
; GENERIC-NEXT:    or16 a1, a2
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    lsli16 a3, a2, 8
; GENERIC-NEXT:    or16 a3, a1
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    and16 a3, a0
; GENERIC-NEXT:    cmpnei16 a3, 0
; GENERIC-NEXT:    bt16 .LBB73_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB73_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;SGT
define i16 @brRR_i16_sgt(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bf32 .LBB74_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB74_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i16_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a1, a1
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    bf16 .LBB74_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB74_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_sgt(i16 %x) {
; CHECK-LABEL: brRI_i16_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    bt32 .LBB75_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB75_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i16_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    cmplti16 a0, 11
; GENERIC-NEXT:    bt16 .LBB75_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB75_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_sgt(i16 %x) {
; CHECK-LABEL: brR0_i16_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 1
; CHECK-NEXT:    bt32 .LBB76_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB76_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i16_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    cmplti16 a0, 1
; GENERIC-NEXT:    bt16 .LBB76_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB76_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;SGE
define i16 @brRR_i16_sge(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB77_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB77_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i16_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    sexth16 a1, a1
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB77_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB77_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_sge(i16 %x) {
; CHECK-LABEL: brRI_i16_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    bt32 .LBB78_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB78_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i16_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    cmplti16 a0, 10
; GENERIC-NEXT:    bt16 .LBB78_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB78_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_sge(i16 %x) {
; CHECK-LABEL: brR0_i16_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    blz32 a0, .LBB79_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB79_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i16_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    bt16 .LBB79_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB79_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;SLT
define i16 @brRR_i16_slt(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB80_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB80_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i16_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    sexth16 a1, a1
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bf16 .LBB80_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB80_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_slt(i16 %x) {
; CHECK-LABEL: brRI_i16_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB81_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB81_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i16_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    movi16 a1, 9
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB81_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB81_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_slt(i16 %x) {
; CHECK-LABEL: brR0_i16_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movih32 a1, 65535
; CHECK-NEXT:    ori32 a1, a1, 65535
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB82_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB82_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i16_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a3, a1, 16
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    lsli16 a2, a1, 8
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    or16 a2, a1
; GENERIC-NEXT:    cmplt16 a2, a0
; GENERIC-NEXT:    bf16 .LBB82_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB82_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;SLE
define i16 @brRR_i16_sle(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bt32 .LBB83_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB83_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i16_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a1, a1
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    bt16 .LBB83_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB83_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_sle(i16 %x) {
; CHECK-LABEL: brRI_i16_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB84_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB84_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i16_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    movi16 a1, 10
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB84_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB84_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_sle(i16 %x) {
; CHECK-LABEL: brR0_i16_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    bhz32 a0, .LBB85_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB85_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i16_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sexth16 a0, a0
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB85_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB85_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}


define i16 @brCBit_i16(i1 %c) {
; CHECK-LABEL: brCBit_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB86_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB86_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brCBit_i16:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB86_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB86_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  br i1 %c, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}


;EQ
define i8 @brRR_i8_eq(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bt32 .LBB87_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB87_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i8_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    cmpne16 a1, a0
; GENERIC-NEXT:    bt16 .LBB87_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB87_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_eq(i8 %x) {
; CHECK-LABEL: brRI_i8_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bt32 .LBB88_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB88_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i8_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 10
; GENERIC-NEXT:    bt16 .LBB88_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB88_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_eq(i8 %x) {
; CHECK-LABEL: brR0_i8_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB89_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB89_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i8_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB89_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB89_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;NE
define i8 @brRR_i8_ne(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bf32 .LBB90_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB90_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i8_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    cmpne16 a1, a0
; GENERIC-NEXT:    bf16 .LBB90_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB90_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_ne(i8 %x) {
; CHECK-LABEL: brRI_i8_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bf32 .LBB91_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB91_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i8_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 10
; GENERIC-NEXT:    bf16 .LBB91_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB91_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_ne(i8 %x) {
; CHECK-LABEL: brR0_i8_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB92_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB92_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i8_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB92_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB92_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;UGT
define i8 @brRR_i8_ugt(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bt32 .LBB93_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB93_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i8_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    bt16 .LBB93_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB93_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_ugt(i8 %x) {
; CHECK-LABEL: brRI_i8_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    bf32 .LBB94_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB94_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i8_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmphsi16 a1, 11
; GENERIC-NEXT:    bf16 .LBB94_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB94_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_ugt(i8 %x) {
; CHECK-LABEL: brR0_i8_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB95_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB95_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i8_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB95_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB95_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;UGE
define i8 @brRR_i8_uge(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB96_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB96_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i8_uge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    bf16 .LBB96_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB96_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_uge(i8 %x) {
; CHECK-LABEL: brRI_i8_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    bf32 .LBB97_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB97_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i8_uge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmphsi16 a1, 10
; GENERIC-NEXT:    bf16 .LBB97_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB97_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;ULT
define i8 @brRR_i8_ult(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bt32 .LBB98_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB98_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i8_ult:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    bt16 .LBB98_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB98_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_ult(i8 %x) {
; CHECK-LABEL: brRI_i8_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB99_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB99_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i8_ult:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    movi16 a0, 9
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    bf16 .LBB99_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB99_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}


;ULE
define i8 @brRR_i8_ule(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bf32 .LBB100_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB100_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i8_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 255
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    bf16 .LBB100_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB100_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_ule(i8 %x) {
; CHECK-LABEL: brRI_i8_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB101_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB101_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i8_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    movi16 a0, 10
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    bf16 .LBB101_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB101_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_ule(i8 %x) {
; CHECK-LABEL: brR0_i8_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    bnez32 a0, .LBB102_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB102_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i8_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bt16 .LBB102_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB102_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;SGT
define i8 @brRR_i8_sgt(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bf32 .LBB103_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB103_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i8_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a1, a1
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    bf16 .LBB103_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB103_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_sgt(i8 %x) {
; CHECK-LABEL: brRI_i8_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    bt32 .LBB104_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB104_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i8_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    cmplti16 a0, 11
; GENERIC-NEXT:    bt16 .LBB104_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB104_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_sgt(i8 %x) {
; CHECK-LABEL: brR0_i8_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 1
; CHECK-NEXT:    bt32 .LBB105_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB105_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i8_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    cmplti16 a0, 1
; GENERIC-NEXT:    bt16 .LBB105_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB105_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;SGE
define i8 @brRR_i8_sge(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB106_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB106_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i8_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    sextb16 a1, a1
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB106_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB106_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_sge(i8 %x) {
; CHECK-LABEL: brRI_i8_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    bt32 .LBB107_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB107_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i8_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    cmplti16 a0, 10
; GENERIC-NEXT:    bt16 .LBB107_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB107_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_sge(i8 %x) {
; CHECK-LABEL: brR0_i8_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    blz32 a0, .LBB108_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB108_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i8_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    bt16 .LBB108_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB108_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;SLT
define i8 @brRR_i8_slt(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB109_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB109_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i8_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    sextb16 a1, a1
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bf16 .LBB109_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB109_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_slt(i8 %x) {
; CHECK-LABEL: brRI_i8_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB110_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB110_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i8_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    movi16 a1, 9
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB110_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB110_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_slt(i8 %x) {
; CHECK-LABEL: brR0_i8_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movih32 a1, 65535
; CHECK-NEXT:    ori32 a1, a1, 65535
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB111_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB111_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i8_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    movi16 a1, 255
; GENERIC-NEXT:    lsli16 a2, a1, 24
; GENERIC-NEXT:    lsli16 a3, a1, 16
; GENERIC-NEXT:    or16 a3, a2
; GENERIC-NEXT:    lsli16 a2, a1, 8
; GENERIC-NEXT:    or16 a2, a3
; GENERIC-NEXT:    or16 a2, a1
; GENERIC-NEXT:    cmplt16 a2, a0
; GENERIC-NEXT:    bf16 .LBB111_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB111_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;SLE
define i8 @brRR_i8_sle(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bt32 .LBB112_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB112_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i8_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a1, a1
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    bt16 .LBB112_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB112_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_sle(i8 %x) {
; CHECK-LABEL: brRI_i8_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB113_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB113_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i8_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    movi16 a1, 10
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB113_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB113_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_sle(i8 %x) {
; CHECK-LABEL: brR0_i8_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    bhz32 a0, .LBB114_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB114_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i8_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    sextb16 a0, a0
; GENERIC-NEXT:    movi16 a1, 0
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB114_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB114_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}


define i8 @brCBit_i8(i1 %c) {
; CHECK-LABEL: brCBit_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB115_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB115_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brCBit_i8:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB115_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB115_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  br i1 %c, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}


;EQ
define i1 @brRR_i1_eq(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bt32 .LBB116_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB116_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i1_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 1
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    cmpne16 a1, a0
; GENERIC-NEXT:    bt16 .LBB116_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB116_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_eq(i1 %x) {
; CHECK-LABEL: brRI_i1_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bf32 .LBB117_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB117_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i1_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB117_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB117_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_eq(i1 %x) {
; CHECK-LABEL: brR0_i1_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bf32 .LBB118_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB118_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i1_eq:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bf16 .LBB118_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB118_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;NE
define i1 @brRR_i1_ne(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bf32 .LBB119_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB119_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i1_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 1
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    cmpne16 a1, a0
; GENERIC-NEXT:    bf16 .LBB119_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB119_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_ne(i1 %x) {
; CHECK-LABEL: brRI_i1_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB120_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB120_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i1_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB120_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB120_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_ne(i1 %x) {
; CHECK-LABEL: brR0_i1_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB121_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB121_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i1_ne:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB121_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB121_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;UGT
define i1 @brRR_i1_ugt(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bt32 .LBB122_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB122_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i1_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 1
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    bt16 .LBB122_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB122_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_ugt(i1 %x) {
; CHECK-LABEL: brRI_i1_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB123_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB123_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i1_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB123_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB123_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_ugt(i1 %x) {
; CHECK-LABEL: brR0_i1_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB124_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB124_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i1_ugt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB124_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB124_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;UGE
define i1 @brRR_i1_uge(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB125_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB125_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i1_uge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 1
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    bf16 .LBB125_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB125_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_uge(i1 %x) {
; CHECK-LABEL: brRI_i1_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB126_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB126_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i1_uge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB126_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB126_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;ULT
define i1 @brRR_i1_ult(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bt32 .LBB127_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB127_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i1_ult:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 1
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    cmphs16 a1, a0
; GENERIC-NEXT:    bt16 .LBB127_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB127_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_ult(i1 %x) {
; CHECK-LABEL: brRI_i1_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB128_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB128_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i1_ult:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB128_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB128_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}


;ULE
define i1 @brRR_i1_ule(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bf32 .LBB129_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB129_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i1_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a2, 1
; GENERIC-NEXT:    and16 a1, a2
; GENERIC-NEXT:    and16 a0, a2
; GENERIC-NEXT:    cmphs16 a0, a1
; GENERIC-NEXT:    bf16 .LBB129_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB129_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_ule(i1 %x) {
; CHECK-LABEL: brRI_i1_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB130_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB130_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i1_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB130_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB130_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_ule(i1 %x) {
; CHECK-LABEL: brR0_i1_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB131_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB131_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i1_ule:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB131_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB131_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;SGT
define i1 @brRR_i1_sgt(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sext32 a1, a1, 0, 0
; CHECK-NEXT:    sext32 a0, a0, 0, 0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bf32 .LBB132_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB132_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i1_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    lsli16 a1, a1, 7
; GENERIC-NEXT:    asri16 a1, a1, 7
; GENERIC-NEXT:    lsli16 a0, a0, 7
; GENERIC-NEXT:    asri16 a0, a0, 7
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    bf16 .LBB132_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB132_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_sgt(i1 %x) {
; CHECK-LABEL: brRI_i1_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB133_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB133_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i1_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB133_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB133_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_sgt(i1 %x) {
; CHECK-LABEL: brR0_i1_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB134_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB134_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i1_sgt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB134_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB134_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;SGE
define i1 @brRR_i1_sge(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sext32 a0, a0, 0, 0
; CHECK-NEXT:    sext32 a1, a1, 0, 0
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB135_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB135_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i1_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    lsli16 a0, a0, 7
; GENERIC-NEXT:    asri16 a0, a0, 7
; GENERIC-NEXT:    lsli16 a1, a1, 7
; GENERIC-NEXT:    asri16 a1, a1, 7
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bt16 .LBB135_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB135_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_sge(i1 %x) {
; CHECK-LABEL: brRI_i1_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB136_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB136_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i1_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB136_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB136_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_sge(i1 %x) {
; CHECK-LABEL: brR0_i1_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB137_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB137_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i1_sge:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    btsti16 a1, 0
; GENERIC-NEXT:    bt16 .LBB137_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB137_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;SLT
define i1 @brRR_i1_slt(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sext32 a0, a0, 0, 0
; CHECK-NEXT:    sext32 a1, a1, 0, 0
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB138_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB138_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i1_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    lsli16 a0, a0, 7
; GENERIC-NEXT:    asri16 a0, a0, 7
; GENERIC-NEXT:    lsli16 a1, a1, 7
; GENERIC-NEXT:    asri16 a1, a1, 7
; GENERIC-NEXT:    cmplt16 a1, a0
; GENERIC-NEXT:    bf16 .LBB138_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB138_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_slt(i1 %x) {
; CHECK-LABEL: brRI_i1_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bnez32 a0, .LBB139_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB139_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i1_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bt16 .LBB139_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB139_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_slt(i1 %x) {
; CHECK-LABEL: brR0_i1_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bnez32 a0, .LBB140_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB140_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i1_slt:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bt16 .LBB140_2
; GENERIC-NEXT:  # %bb.1: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB140_2: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;SLE
define i1 @brRR_i1_sle(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sext32 a1, a1, 0, 0
; CHECK-NEXT:    sext32 a0, a0, 0, 0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bt32 .LBB141_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB141_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRR_i1_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    lsli16 a1, a1, 7
; GENERIC-NEXT:    asri16 a1, a1, 7
; GENERIC-NEXT:    lsli16 a0, a0, 7
; GENERIC-NEXT:    asri16 a0, a0, 7
; GENERIC-NEXT:    cmplt16 a0, a1
; GENERIC-NEXT:    bt16 .LBB141_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB141_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_sle(i1 %x) {
; CHECK-LABEL: brRI_i1_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB142_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB142_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brRI_i1_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB142_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB142_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_sle(i1 %x) {
; CHECK-LABEL: brR0_i1_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB143_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB143_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brR0_i1_sle:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    btsti16 a0, 0
; GENERIC-NEXT:    bt16 .LBB143_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB143_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}


define i1 @brCBit_i1(i1 %c) {
; CHECK-LABEL: brCBit_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB144_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB144_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
;
; GENERIC-LABEL: brCBit_i1:
; GENERIC:       # %bb.0: # %entry
; GENERIC-NEXT:    .cfi_def_cfa_offset 0
; GENERIC-NEXT:    subi16 sp, sp, 4
; GENERIC-NEXT:    .cfi_def_cfa_offset 4
; GENERIC-NEXT:    movi16 a1, 1
; GENERIC-NEXT:    and16 a1, a0
; GENERIC-NEXT:    cmpnei16 a1, 0
; GENERIC-NEXT:    bf16 .LBB144_2
; GENERIC-NEXT:  # %bb.1: # %label1
; GENERIC-NEXT:    movi16 a0, 1
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
; GENERIC-NEXT:  .LBB144_2: # %label2
; GENERIC-NEXT:    movi16 a0, 0
; GENERIC-NEXT:    addi16 sp, sp, 4
; GENERIC-NEXT:    rts16
entry:
  br i1 %c, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}
