%%%%%%%%
This directory contains the package

     name: knowledge
     license: LaTeX Project Public License version 1.2 or above
     version: v1.28
     date: 2022/02/12
     author: Thomas Colcombet
     mail: thomas.colcombet@irif.fr
     web: https://ctan.org/pkg/knowledge

### Purpose:
 The knowledge package for LaTeX offers a systematic way to handle
 notions/concepts/terms throughout a document. In combination with
 `hyperref`, it is used for easily handling links inside a document (every
 use of a concept is linked to its introduction), or outside the document
 (for centralizing the url's in a separate part). It also helps building an
 index, and deals with scoping of concepts as well as mathematics.
 It is designed to--as much as possible--not interfere with the writing of
 the document.

### Install:
 It is sufficient to have the file knowledge.sty accessible by LaTeX.
 It can be produced by `make knowledge.sty` if necessary.
 The documentation is in the file `knowledge.pdf`.
 A starting example can be found in `knowledge-example.tex`.

### Content of knowledge-sources.zip:
 - README.md: this file generated while compiling knowledge.ins,
   the content is in knowledge-code.dtx
 - knowledge.sty: the package file (generated using knowledge.ins)
 - knowledge.pdf: the user documentation (generated by compiling
   knowledge.tex)
 - knowledge.tex: the tex file producing the knowledge.pdf.
 - makefile: the makefile. Use 'make all' to generate knowledge.sty
   and knowledge.pdf. It can also: clean the directory, make zip
   version of the sources, or ready for CTAN.
 - knowledge.ins: is the file generating knowledge.sty and
   README.md from knowledge-code.dtx (using docstrip).
 - knowledge-code.dtx: most of the code. Can be compiled to
   provided a longer documentation.
 - knowledge-configuration.dtx: file containing part of the configuration.
 - knowledge-utils.dtx: file containing several pieces of code not really
   related specifically to knowledge
 - knowledge-example.tex: an example file.


