"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useSpinner = void 0;
const tslib_1 = require("tslib");
const ora_1 = tslib_1.__importDefault(require("ora"));
const useSpinner = (label, fn, killProcess = true) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const spinner = (0, ora_1.default)(label);
    spinner.start();
    try {
        yield fn();
        spinner.succeed();
    }
    catch (err) {
        spinner.fail(err.message || err);
        if (err.stdout) {
            console.error(err.stdout);
        }
        else if (err.message) {
            // Return stack trace if error object
            console.trace(err); // eslint-disable-line no-console
        }
        if (killProcess) {
            process.exit(1);
        }
    }
});
exports.useSpinner = useSpinner;
//# sourceMappingURL=useSpinner.js.map