import { isDomError, isDomException, isError, isErrorEvent, isEvent, isObject } from '@grafana/agent-core';
import { domErrorType, domExceptionType, objectEventValue } from './const';
import { getStackFramesFromError } from './stackFrames';
export function getErrorDetails(event) {
    let value;
    let type;
    let stackFrames = [];
    let isDomErrorRes;
    let isEventRes;
    if (isErrorEvent(event) && event.error) {
        value = event.error.message;
        type = event.error.name;
        stackFrames = getStackFramesFromError(event.error);
    }
    else if ((isDomErrorRes = isDomError(event)) || isDomException(event)) {
        const { name, message } = event;
        type = name !== null && name !== void 0 ? name : (isDomErrorRes ? domErrorType : domExceptionType);
        value = message ? `${type}: ${message}` : type;
    }
    else if (isError(event)) {
        value = event.message;
        stackFrames = getStackFramesFromError(event);
    }
    else if (isObject(event) || (isEventRes = isEvent(event))) {
        type = isEventRes ? event.constructor.name : undefined;
        value = `${objectEventValue} ${Object.keys(event)}`;
    }
    return [value, type, stackFrames];
}
//# sourceMappingURL=getErrorDetails.js.map