import { TransportItemType } from './types';
const transportItemTypeToBodyKey = {
    [TransportItemType.EXCEPTION]: 'exceptions',
    [TransportItemType.LOG]: 'logs',
    [TransportItemType.MEASUREMENT]: 'measurements',
    [TransportItemType.TRACE]: 'traces',
};
export function getTransportBody(item) {
    return {
        [transportItemTypeToBodyKey[item.type]]: item.type === TransportItemType.TRACE ? item.payload : [item.payload],
        meta: item.meta,
    };
}
//# sourceMappingURL=utils.js.map