import React from 'react';
import PropTypes from 'prop-types';

const UilImageSearch = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M19,13a1,1,0,0,0-1,1v.39l-1.48-1.48a2.79,2.79,0,0,0-3.93,0l-.7.7L9.41,11.12a2.87,2.87,0,0,0-3.93,0L4,12.61V7A1,1,0,0,1,5,6H9A1,1,0,0,0,9,4H5A3,3,0,0,0,2,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V14A1,1,0,0,0,19,13ZM5,20a1,1,0,0,1-1-1V15.43l2.9-2.89a.79.79,0,0,1,1.09,0l3.17,3.17,0,0L15.45,20Zm13-1a1,1,0,0,1-.18.54L13.31,15l.7-.69a.77.77,0,0,1,1.1,0L18,17.22Zm3.71-8.71L20,8.57a4.31,4.31,0,1,0-6.72.79,4.27,4.27,0,0,0,3,1.26A4.34,4.34,0,0,0,18.57,10l1.72,1.73a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,10.29ZM18,8a2.32,2.32,0,1,1,0-3.27A2.32,2.32,0,0,1,18,8Z'
  }));
};

UilImageSearch.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilImageSearch.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilImageSearch;