// Copyright 2020 The TensorFlow Runtime Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This test is auto generated by: //utils/eigen:gen_conv2d_batch_norm_tests

// RUN: bef_executor %s.bef | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:1 | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:2 | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:4 | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:8 | FileCheck %s --dump-input=always

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 0
  %filter_index   = tfrt.constant.i32 1
  %scale_index    = tfrt.constant.i32 2
  %offset_index   = tfrt.constant.i32 3
  %mean_index     = tfrt.constant.i32 4
  %var_index      = tfrt.constant.i32 5
  %expected_index = tfrt.constant.i32 6
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 7
  %filter_index   = tfrt.constant.i32 8
  %scale_index    = tfrt.constant.i32 9
  %offset_index   = tfrt.constant.i32 10
  %mean_index     = tfrt.constant.i32 11
  %var_index      = tfrt.constant.i32 12
  %expected_index = tfrt.constant.i32 13
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 14
  %filter_index   = tfrt.constant.i32 15
  %scale_index    = tfrt.constant.i32 16
  %offset_index   = tfrt.constant.i32 17
  %mean_index     = tfrt.constant.i32 18
  %var_index      = tfrt.constant.i32 19
  %expected_index = tfrt.constant.i32 20
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 21
  %filter_index   = tfrt.constant.i32 22
  %scale_index    = tfrt.constant.i32 23
  %offset_index   = tfrt.constant.i32 24
  %mean_index     = tfrt.constant.i32 25
  %var_index      = tfrt.constant.i32 26
  %expected_index = tfrt.constant.i32 27
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 28
  %filter_index   = tfrt.constant.i32 29
  %scale_index    = tfrt.constant.i32 30
  %offset_index   = tfrt.constant.i32 31
  %mean_index     = tfrt.constant.i32 32
  %var_index      = tfrt.constant.i32 33
  %expected_index = tfrt.constant.i32 34
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 35
  %filter_index   = tfrt.constant.i32 36
  %scale_index    = tfrt.constant.i32 37
  %offset_index   = tfrt.constant.i32 38
  %mean_index     = tfrt.constant.i32 39
  %var_index      = tfrt.constant.i32 40
  %expected_index = tfrt.constant.i32 41
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 42
  %filter_index   = tfrt.constant.i32 43
  %scale_index    = tfrt.constant.i32 44
  %offset_index   = tfrt.constant.i32 45
  %mean_index     = tfrt.constant.i32 46
  %var_index      = tfrt.constant.i32 47
  %expected_index = tfrt.constant.i32 48
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 49
  %filter_index   = tfrt.constant.i32 50
  %scale_index    = tfrt.constant.i32 51
  %offset_index   = tfrt.constant.i32 52
  %mean_index     = tfrt.constant.i32 53
  %var_index      = tfrt.constant.i32 54
  %expected_index = tfrt.constant.i32 55
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 56
  %filter_index   = tfrt.constant.i32 57
  %scale_index    = tfrt.constant.i32 58
  %offset_index   = tfrt.constant.i32 59
  %mean_index     = tfrt.constant.i32 60
  %var_index      = tfrt.constant.i32 61
  %expected_index = tfrt.constant.i32 62
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 63
  %filter_index   = tfrt.constant.i32 64
  %scale_index    = tfrt.constant.i32 65
  %offset_index   = tfrt.constant.i32 66
  %mean_index     = tfrt.constant.i32 67
  %var_index      = tfrt.constant.i32 68
  %expected_index = tfrt.constant.i32 69
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 70
  %filter_index   = tfrt.constant.i32 71
  %scale_index    = tfrt.constant.i32 72
  %offset_index   = tfrt.constant.i32 73
  %mean_index     = tfrt.constant.i32 74
  %var_index      = tfrt.constant.i32 75
  %expected_index = tfrt.constant.i32 76
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 77
  %filter_index   = tfrt.constant.i32 78
  %scale_index    = tfrt.constant.i32 79
  %offset_index   = tfrt.constant.i32 80
  %mean_index     = tfrt.constant.i32 81
  %var_index      = tfrt.constant.i32 82
  %expected_index = tfrt.constant.i32 83
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 84
  %filter_index   = tfrt.constant.i32 85
  %scale_index    = tfrt.constant.i32 86
  %offset_index   = tfrt.constant.i32 87
  %mean_index     = tfrt.constant.i32 88
  %var_index      = tfrt.constant.i32 89
  %expected_index = tfrt.constant.i32 90
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 91
  %filter_index   = tfrt.constant.i32 92
  %scale_index    = tfrt.constant.i32 93
  %offset_index   = tfrt.constant.i32 94
  %mean_index     = tfrt.constant.i32 95
  %var_index      = tfrt.constant.i32 96
  %expected_index = tfrt.constant.i32 97
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 98
  %filter_index   = tfrt.constant.i32 99
  %scale_index    = tfrt.constant.i32 100
  %offset_index   = tfrt.constant.i32 101
  %mean_index     = tfrt.constant.i32 102
  %var_index      = tfrt.constant.i32 103
  %expected_index = tfrt.constant.i32 104
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_1x1_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 105
  %filter_index   = tfrt.constant.i32 106
  %scale_index    = tfrt.constant.i32 107
  %offset_index   = tfrt.constant.i32 108
  %mean_index     = tfrt.constant.i32 109
  %var_index      = tfrt.constant.i32 110
  %expected_index = tfrt.constant.i32 111
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 112
  %filter_index   = tfrt.constant.i32 113
  %scale_index    = tfrt.constant.i32 114
  %offset_index   = tfrt.constant.i32 115
  %mean_index     = tfrt.constant.i32 116
  %var_index      = tfrt.constant.i32 117
  %expected_index = tfrt.constant.i32 118
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 119
  %filter_index   = tfrt.constant.i32 120
  %scale_index    = tfrt.constant.i32 121
  %offset_index   = tfrt.constant.i32 122
  %mean_index     = tfrt.constant.i32 123
  %var_index      = tfrt.constant.i32 124
  %expected_index = tfrt.constant.i32 125
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 126
  %filter_index   = tfrt.constant.i32 127
  %scale_index    = tfrt.constant.i32 128
  %offset_index   = tfrt.constant.i32 129
  %mean_index     = tfrt.constant.i32 130
  %var_index      = tfrt.constant.i32 131
  %expected_index = tfrt.constant.i32 132
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 133
  %filter_index   = tfrt.constant.i32 134
  %scale_index    = tfrt.constant.i32 135
  %offset_index   = tfrt.constant.i32 136
  %mean_index     = tfrt.constant.i32 137
  %var_index      = tfrt.constant.i32 138
  %expected_index = tfrt.constant.i32 139
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 140
  %filter_index   = tfrt.constant.i32 141
  %scale_index    = tfrt.constant.i32 142
  %offset_index   = tfrt.constant.i32 143
  %mean_index     = tfrt.constant.i32 144
  %var_index      = tfrt.constant.i32 145
  %expected_index = tfrt.constant.i32 146
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 147
  %filter_index   = tfrt.constant.i32 148
  %scale_index    = tfrt.constant.i32 149
  %offset_index   = tfrt.constant.i32 150
  %mean_index     = tfrt.constant.i32 151
  %var_index      = tfrt.constant.i32 152
  %expected_index = tfrt.constant.i32 153
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 154
  %filter_index   = tfrt.constant.i32 155
  %scale_index    = tfrt.constant.i32 156
  %offset_index   = tfrt.constant.i32 157
  %mean_index     = tfrt.constant.i32 158
  %var_index      = tfrt.constant.i32 159
  %expected_index = tfrt.constant.i32 160
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 161
  %filter_index   = tfrt.constant.i32 162
  %scale_index    = tfrt.constant.i32 163
  %offset_index   = tfrt.constant.i32 164
  %mean_index     = tfrt.constant.i32 165
  %var_index      = tfrt.constant.i32 166
  %expected_index = tfrt.constant.i32 167
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 168
  %filter_index   = tfrt.constant.i32 169
  %scale_index    = tfrt.constant.i32 170
  %offset_index   = tfrt.constant.i32 171
  %mean_index     = tfrt.constant.i32 172
  %var_index      = tfrt.constant.i32 173
  %expected_index = tfrt.constant.i32 174
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 175
  %filter_index   = tfrt.constant.i32 176
  %scale_index    = tfrt.constant.i32 177
  %offset_index   = tfrt.constant.i32 178
  %mean_index     = tfrt.constant.i32 179
  %var_index      = tfrt.constant.i32 180
  %expected_index = tfrt.constant.i32 181
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 182
  %filter_index   = tfrt.constant.i32 183
  %scale_index    = tfrt.constant.i32 184
  %offset_index   = tfrt.constant.i32 185
  %mean_index     = tfrt.constant.i32 186
  %var_index      = tfrt.constant.i32 187
  %expected_index = tfrt.constant.i32 188
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 189
  %filter_index   = tfrt.constant.i32 190
  %scale_index    = tfrt.constant.i32 191
  %offset_index   = tfrt.constant.i32 192
  %mean_index     = tfrt.constant.i32 193
  %var_index      = tfrt.constant.i32 194
  %expected_index = tfrt.constant.i32 195
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 196
  %filter_index   = tfrt.constant.i32 197
  %scale_index    = tfrt.constant.i32 198
  %offset_index   = tfrt.constant.i32 199
  %mean_index     = tfrt.constant.i32 200
  %var_index      = tfrt.constant.i32 201
  %expected_index = tfrt.constant.i32 202
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 203
  %filter_index   = tfrt.constant.i32 204
  %scale_index    = tfrt.constant.i32 205
  %offset_index   = tfrt.constant.i32 206
  %mean_index     = tfrt.constant.i32 207
  %var_index      = tfrt.constant.i32 208
  %expected_index = tfrt.constant.i32 209
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 210
  %filter_index   = tfrt.constant.i32 211
  %scale_index    = tfrt.constant.i32 212
  %offset_index   = tfrt.constant.i32 213
  %mean_index     = tfrt.constant.i32 214
  %var_index      = tfrt.constant.i32 215
  %expected_index = tfrt.constant.i32 216
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 217
  %filter_index   = tfrt.constant.i32 218
  %scale_index    = tfrt.constant.i32 219
  %offset_index   = tfrt.constant.i32 220
  %mean_index     = tfrt.constant.i32 221
  %var_index      = tfrt.constant.i32 222
  %expected_index = tfrt.constant.i32 223
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 224
  %filter_index   = tfrt.constant.i32 225
  %scale_index    = tfrt.constant.i32 226
  %offset_index   = tfrt.constant.i32 227
  %mean_index     = tfrt.constant.i32 228
  %var_index      = tfrt.constant.i32 229
  %expected_index = tfrt.constant.i32 230
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 231
  %filter_index   = tfrt.constant.i32 232
  %scale_index    = tfrt.constant.i32 233
  %offset_index   = tfrt.constant.i32 234
  %mean_index     = tfrt.constant.i32 235
  %var_index      = tfrt.constant.i32 236
  %expected_index = tfrt.constant.i32 237
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 238
  %filter_index   = tfrt.constant.i32 239
  %scale_index    = tfrt.constant.i32 240
  %offset_index   = tfrt.constant.i32 241
  %mean_index     = tfrt.constant.i32 242
  %var_index      = tfrt.constant.i32 243
  %expected_index = tfrt.constant.i32 244
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 245
  %filter_index   = tfrt.constant.i32 246
  %scale_index    = tfrt.constant.i32 247
  %offset_index   = tfrt.constant.i32 248
  %mean_index     = tfrt.constant.i32 249
  %var_index      = tfrt.constant.i32 250
  %expected_index = tfrt.constant.i32 251
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 252
  %filter_index   = tfrt.constant.i32 253
  %scale_index    = tfrt.constant.i32 254
  %offset_index   = tfrt.constant.i32 255
  %mean_index     = tfrt.constant.i32 256
  %var_index      = tfrt.constant.i32 257
  %expected_index = tfrt.constant.i32 258
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 259
  %filter_index   = tfrt.constant.i32 260
  %scale_index    = tfrt.constant.i32 261
  %offset_index   = tfrt.constant.i32 262
  %mean_index     = tfrt.constant.i32 263
  %var_index      = tfrt.constant.i32 264
  %expected_index = tfrt.constant.i32 265
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 266
  %filter_index   = tfrt.constant.i32 267
  %scale_index    = tfrt.constant.i32 268
  %offset_index   = tfrt.constant.i32 269
  %mean_index     = tfrt.constant.i32 270
  %var_index      = tfrt.constant.i32 271
  %expected_index = tfrt.constant.i32 272
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 273
  %filter_index   = tfrt.constant.i32 274
  %scale_index    = tfrt.constant.i32 275
  %offset_index   = tfrt.constant.i32 276
  %mean_index     = tfrt.constant.i32 277
  %var_index      = tfrt.constant.i32 278
  %expected_index = tfrt.constant.i32 279
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 280
  %filter_index   = tfrt.constant.i32 281
  %scale_index    = tfrt.constant.i32 282
  %offset_index   = tfrt.constant.i32 283
  %mean_index     = tfrt.constant.i32 284
  %var_index      = tfrt.constant.i32 285
  %expected_index = tfrt.constant.i32 286
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 287
  %filter_index   = tfrt.constant.i32 288
  %scale_index    = tfrt.constant.i32 289
  %offset_index   = tfrt.constant.i32 290
  %mean_index     = tfrt.constant.i32 291
  %var_index      = tfrt.constant.i32 292
  %expected_index = tfrt.constant.i32 293
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 294
  %filter_index   = tfrt.constant.i32 295
  %scale_index    = tfrt.constant.i32 296
  %offset_index   = tfrt.constant.i32 297
  %mean_index     = tfrt.constant.i32 298
  %var_index      = tfrt.constant.i32 299
  %expected_index = tfrt.constant.i32 300
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 301
  %filter_index   = tfrt.constant.i32 302
  %scale_index    = tfrt.constant.i32 303
  %offset_index   = tfrt.constant.i32 304
  %mean_index     = tfrt.constant.i32 305
  %var_index      = tfrt.constant.i32 306
  %expected_index = tfrt.constant.i32 307
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 308
  %filter_index   = tfrt.constant.i32 309
  %scale_index    = tfrt.constant.i32 310
  %offset_index   = tfrt.constant.i32 311
  %mean_index     = tfrt.constant.i32 312
  %var_index      = tfrt.constant.i32 313
  %expected_index = tfrt.constant.i32 314
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 315
  %filter_index   = tfrt.constant.i32 316
  %scale_index    = tfrt.constant.i32 317
  %offset_index   = tfrt.constant.i32 318
  %mean_index     = tfrt.constant.i32 319
  %var_index      = tfrt.constant.i32 320
  %expected_index = tfrt.constant.i32 321
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 322
  %filter_index   = tfrt.constant.i32 323
  %scale_index    = tfrt.constant.i32 324
  %offset_index   = tfrt.constant.i32 325
  %mean_index     = tfrt.constant.i32 326
  %var_index      = tfrt.constant.i32 327
  %expected_index = tfrt.constant.i32 328
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_2x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 329
  %filter_index   = tfrt.constant.i32 330
  %scale_index    = tfrt.constant.i32 331
  %offset_index   = tfrt.constant.i32 332
  %mean_index     = tfrt.constant.i32 333
  %var_index      = tfrt.constant.i32 334
  %expected_index = tfrt.constant.i32 335
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 336
  %filter_index   = tfrt.constant.i32 337
  %scale_index    = tfrt.constant.i32 338
  %offset_index   = tfrt.constant.i32 339
  %mean_index     = tfrt.constant.i32 340
  %var_index      = tfrt.constant.i32 341
  %expected_index = tfrt.constant.i32 342
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 343
  %filter_index   = tfrt.constant.i32 344
  %scale_index    = tfrt.constant.i32 345
  %offset_index   = tfrt.constant.i32 346
  %mean_index     = tfrt.constant.i32 347
  %var_index      = tfrt.constant.i32 348
  %expected_index = tfrt.constant.i32 349
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 350
  %filter_index   = tfrt.constant.i32 351
  %scale_index    = tfrt.constant.i32 352
  %offset_index   = tfrt.constant.i32 353
  %mean_index     = tfrt.constant.i32 354
  %var_index      = tfrt.constant.i32 355
  %expected_index = tfrt.constant.i32 356
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 357
  %filter_index   = tfrt.constant.i32 358
  %scale_index    = tfrt.constant.i32 359
  %offset_index   = tfrt.constant.i32 360
  %mean_index     = tfrt.constant.i32 361
  %var_index      = tfrt.constant.i32 362
  %expected_index = tfrt.constant.i32 363
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 364
  %filter_index   = tfrt.constant.i32 365
  %scale_index    = tfrt.constant.i32 366
  %offset_index   = tfrt.constant.i32 367
  %mean_index     = tfrt.constant.i32 368
  %var_index      = tfrt.constant.i32 369
  %expected_index = tfrt.constant.i32 370
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 371
  %filter_index   = tfrt.constant.i32 372
  %scale_index    = tfrt.constant.i32 373
  %offset_index   = tfrt.constant.i32 374
  %mean_index     = tfrt.constant.i32 375
  %var_index      = tfrt.constant.i32 376
  %expected_index = tfrt.constant.i32 377
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 378
  %filter_index   = tfrt.constant.i32 379
  %scale_index    = tfrt.constant.i32 380
  %offset_index   = tfrt.constant.i32 381
  %mean_index     = tfrt.constant.i32 382
  %var_index      = tfrt.constant.i32 383
  %expected_index = tfrt.constant.i32 384
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 385
  %filter_index   = tfrt.constant.i32 386
  %scale_index    = tfrt.constant.i32 387
  %offset_index   = tfrt.constant.i32 388
  %mean_index     = tfrt.constant.i32 389
  %var_index      = tfrt.constant.i32 390
  %expected_index = tfrt.constant.i32 391
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 392
  %filter_index   = tfrt.constant.i32 393
  %scale_index    = tfrt.constant.i32 394
  %offset_index   = tfrt.constant.i32 395
  %mean_index     = tfrt.constant.i32 396
  %var_index      = tfrt.constant.i32 397
  %expected_index = tfrt.constant.i32 398
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 399
  %filter_index   = tfrt.constant.i32 400
  %scale_index    = tfrt.constant.i32 401
  %offset_index   = tfrt.constant.i32 402
  %mean_index     = tfrt.constant.i32 403
  %var_index      = tfrt.constant.i32 404
  %expected_index = tfrt.constant.i32 405
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 406
  %filter_index   = tfrt.constant.i32 407
  %scale_index    = tfrt.constant.i32 408
  %offset_index   = tfrt.constant.i32 409
  %mean_index     = tfrt.constant.i32 410
  %var_index      = tfrt.constant.i32 411
  %expected_index = tfrt.constant.i32 412
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 413
  %filter_index   = tfrt.constant.i32 414
  %scale_index    = tfrt.constant.i32 415
  %offset_index   = tfrt.constant.i32 416
  %mean_index     = tfrt.constant.i32 417
  %var_index      = tfrt.constant.i32 418
  %expected_index = tfrt.constant.i32 419
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 420
  %filter_index   = tfrt.constant.i32 421
  %scale_index    = tfrt.constant.i32 422
  %offset_index   = tfrt.constant.i32 423
  %mean_index     = tfrt.constant.i32 424
  %var_index      = tfrt.constant.i32 425
  %expected_index = tfrt.constant.i32 426
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 427
  %filter_index   = tfrt.constant.i32 428
  %scale_index    = tfrt.constant.i32 429
  %offset_index   = tfrt.constant.i32 430
  %mean_index     = tfrt.constant.i32 431
  %var_index      = tfrt.constant.i32 432
  %expected_index = tfrt.constant.i32 433
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 434
  %filter_index   = tfrt.constant.i32 435
  %scale_index    = tfrt.constant.i32 436
  %offset_index   = tfrt.constant.i32 437
  %mean_index     = tfrt.constant.i32 438
  %var_index      = tfrt.constant.i32 439
  %expected_index = tfrt.constant.i32 440
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x8_f_3x2_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 441
  %filter_index   = tfrt.constant.i32 442
  %scale_index    = tfrt.constant.i32 443
  %offset_index   = tfrt.constant.i32 444
  %mean_index     = tfrt.constant.i32 445
  %var_index      = tfrt.constant.i32 446
  %expected_index = tfrt.constant.i32 447
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 448
  %filter_index   = tfrt.constant.i32 449
  %scale_index    = tfrt.constant.i32 450
  %offset_index   = tfrt.constant.i32 451
  %mean_index     = tfrt.constant.i32 452
  %var_index      = tfrt.constant.i32 453
  %expected_index = tfrt.constant.i32 454
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 455
  %filter_index   = tfrt.constant.i32 456
  %scale_index    = tfrt.constant.i32 457
  %offset_index   = tfrt.constant.i32 458
  %mean_index     = tfrt.constant.i32 459
  %var_index      = tfrt.constant.i32 460
  %expected_index = tfrt.constant.i32 461
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 462
  %filter_index   = tfrt.constant.i32 463
  %scale_index    = tfrt.constant.i32 464
  %offset_index   = tfrt.constant.i32 465
  %mean_index     = tfrt.constant.i32 466
  %var_index      = tfrt.constant.i32 467
  %expected_index = tfrt.constant.i32 468
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 469
  %filter_index   = tfrt.constant.i32 470
  %scale_index    = tfrt.constant.i32 471
  %offset_index   = tfrt.constant.i32 472
  %mean_index     = tfrt.constant.i32 473
  %var_index      = tfrt.constant.i32 474
  %expected_index = tfrt.constant.i32 475
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 476
  %filter_index   = tfrt.constant.i32 477
  %scale_index    = tfrt.constant.i32 478
  %offset_index   = tfrt.constant.i32 479
  %mean_index     = tfrt.constant.i32 480
  %var_index      = tfrt.constant.i32 481
  %expected_index = tfrt.constant.i32 482
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 483
  %filter_index   = tfrt.constant.i32 484
  %scale_index    = tfrt.constant.i32 485
  %offset_index   = tfrt.constant.i32 486
  %mean_index     = tfrt.constant.i32 487
  %var_index      = tfrt.constant.i32 488
  %expected_index = tfrt.constant.i32 489
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 490
  %filter_index   = tfrt.constant.i32 491
  %scale_index    = tfrt.constant.i32 492
  %offset_index   = tfrt.constant.i32 493
  %mean_index     = tfrt.constant.i32 494
  %var_index      = tfrt.constant.i32 495
  %expected_index = tfrt.constant.i32 496
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 497
  %filter_index   = tfrt.constant.i32 498
  %scale_index    = tfrt.constant.i32 499
  %offset_index   = tfrt.constant.i32 500
  %mean_index     = tfrt.constant.i32 501
  %var_index      = tfrt.constant.i32 502
  %expected_index = tfrt.constant.i32 503
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 504
  %filter_index   = tfrt.constant.i32 505
  %scale_index    = tfrt.constant.i32 506
  %offset_index   = tfrt.constant.i32 507
  %mean_index     = tfrt.constant.i32 508
  %var_index      = tfrt.constant.i32 509
  %expected_index = tfrt.constant.i32 510
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 511
  %filter_index   = tfrt.constant.i32 512
  %scale_index    = tfrt.constant.i32 513
  %offset_index   = tfrt.constant.i32 514
  %mean_index     = tfrt.constant.i32 515
  %var_index      = tfrt.constant.i32 516
  %expected_index = tfrt.constant.i32 517
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 518
  %filter_index   = tfrt.constant.i32 519
  %scale_index    = tfrt.constant.i32 520
  %offset_index   = tfrt.constant.i32 521
  %mean_index     = tfrt.constant.i32 522
  %var_index      = tfrt.constant.i32 523
  %expected_index = tfrt.constant.i32 524
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 525
  %filter_index   = tfrt.constant.i32 526
  %scale_index    = tfrt.constant.i32 527
  %offset_index   = tfrt.constant.i32 528
  %mean_index     = tfrt.constant.i32 529
  %var_index      = tfrt.constant.i32 530
  %expected_index = tfrt.constant.i32 531
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 532
  %filter_index   = tfrt.constant.i32 533
  %scale_index    = tfrt.constant.i32 534
  %offset_index   = tfrt.constant.i32 535
  %mean_index     = tfrt.constant.i32 536
  %var_index      = tfrt.constant.i32 537
  %expected_index = tfrt.constant.i32 538
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 539
  %filter_index   = tfrt.constant.i32 540
  %scale_index    = tfrt.constant.i32 541
  %offset_index   = tfrt.constant.i32 542
  %mean_index     = tfrt.constant.i32 543
  %var_index      = tfrt.constant.i32 544
  %expected_index = tfrt.constant.i32 545
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 546
  %filter_index   = tfrt.constant.i32 547
  %scale_index    = tfrt.constant.i32 548
  %offset_index   = tfrt.constant.i32 549
  %mean_index     = tfrt.constant.i32 550
  %var_index      = tfrt.constant.i32 551
  %expected_index = tfrt.constant.i32 552
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_1x1_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 553
  %filter_index   = tfrt.constant.i32 554
  %scale_index    = tfrt.constant.i32 555
  %offset_index   = tfrt.constant.i32 556
  %mean_index     = tfrt.constant.i32 557
  %var_index      = tfrt.constant.i32 558
  %expected_index = tfrt.constant.i32 559
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 560
  %filter_index   = tfrt.constant.i32 561
  %scale_index    = tfrt.constant.i32 562
  %offset_index   = tfrt.constant.i32 563
  %mean_index     = tfrt.constant.i32 564
  %var_index      = tfrt.constant.i32 565
  %expected_index = tfrt.constant.i32 566
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 567
  %filter_index   = tfrt.constant.i32 568
  %scale_index    = tfrt.constant.i32 569
  %offset_index   = tfrt.constant.i32 570
  %mean_index     = tfrt.constant.i32 571
  %var_index      = tfrt.constant.i32 572
  %expected_index = tfrt.constant.i32 573
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 574
  %filter_index   = tfrt.constant.i32 575
  %scale_index    = tfrt.constant.i32 576
  %offset_index   = tfrt.constant.i32 577
  %mean_index     = tfrt.constant.i32 578
  %var_index      = tfrt.constant.i32 579
  %expected_index = tfrt.constant.i32 580
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 581
  %filter_index   = tfrt.constant.i32 582
  %scale_index    = tfrt.constant.i32 583
  %offset_index   = tfrt.constant.i32 584
  %mean_index     = tfrt.constant.i32 585
  %var_index      = tfrt.constant.i32 586
  %expected_index = tfrt.constant.i32 587
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 588
  %filter_index   = tfrt.constant.i32 589
  %scale_index    = tfrt.constant.i32 590
  %offset_index   = tfrt.constant.i32 591
  %mean_index     = tfrt.constant.i32 592
  %var_index      = tfrt.constant.i32 593
  %expected_index = tfrt.constant.i32 594
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 595
  %filter_index   = tfrt.constant.i32 596
  %scale_index    = tfrt.constant.i32 597
  %offset_index   = tfrt.constant.i32 598
  %mean_index     = tfrt.constant.i32 599
  %var_index      = tfrt.constant.i32 600
  %expected_index = tfrt.constant.i32 601
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 602
  %filter_index   = tfrt.constant.i32 603
  %scale_index    = tfrt.constant.i32 604
  %offset_index   = tfrt.constant.i32 605
  %mean_index     = tfrt.constant.i32 606
  %var_index      = tfrt.constant.i32 607
  %expected_index = tfrt.constant.i32 608
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 609
  %filter_index   = tfrt.constant.i32 610
  %scale_index    = tfrt.constant.i32 611
  %offset_index   = tfrt.constant.i32 612
  %mean_index     = tfrt.constant.i32 613
  %var_index      = tfrt.constant.i32 614
  %expected_index = tfrt.constant.i32 615
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 616
  %filter_index   = tfrt.constant.i32 617
  %scale_index    = tfrt.constant.i32 618
  %offset_index   = tfrt.constant.i32 619
  %mean_index     = tfrt.constant.i32 620
  %var_index      = tfrt.constant.i32 621
  %expected_index = tfrt.constant.i32 622
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 623
  %filter_index   = tfrt.constant.i32 624
  %scale_index    = tfrt.constant.i32 625
  %offset_index   = tfrt.constant.i32 626
  %mean_index     = tfrt.constant.i32 627
  %var_index      = tfrt.constant.i32 628
  %expected_index = tfrt.constant.i32 629
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 630
  %filter_index   = tfrt.constant.i32 631
  %scale_index    = tfrt.constant.i32 632
  %offset_index   = tfrt.constant.i32 633
  %mean_index     = tfrt.constant.i32 634
  %var_index      = tfrt.constant.i32 635
  %expected_index = tfrt.constant.i32 636
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 637
  %filter_index   = tfrt.constant.i32 638
  %scale_index    = tfrt.constant.i32 639
  %offset_index   = tfrt.constant.i32 640
  %mean_index     = tfrt.constant.i32 641
  %var_index      = tfrt.constant.i32 642
  %expected_index = tfrt.constant.i32 643
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 644
  %filter_index   = tfrt.constant.i32 645
  %scale_index    = tfrt.constant.i32 646
  %offset_index   = tfrt.constant.i32 647
  %mean_index     = tfrt.constant.i32 648
  %var_index      = tfrt.constant.i32 649
  %expected_index = tfrt.constant.i32 650
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 651
  %filter_index   = tfrt.constant.i32 652
  %scale_index    = tfrt.constant.i32 653
  %offset_index   = tfrt.constant.i32 654
  %mean_index     = tfrt.constant.i32 655
  %var_index      = tfrt.constant.i32 656
  %expected_index = tfrt.constant.i32 657
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 658
  %filter_index   = tfrt.constant.i32 659
  %scale_index    = tfrt.constant.i32 660
  %offset_index   = tfrt.constant.i32 661
  %mean_index     = tfrt.constant.i32 662
  %var_index      = tfrt.constant.i32 663
  %expected_index = tfrt.constant.i32 664
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 665
  %filter_index   = tfrt.constant.i32 666
  %scale_index    = tfrt.constant.i32 667
  %offset_index   = tfrt.constant.i32 668
  %mean_index     = tfrt.constant.i32 669
  %var_index      = tfrt.constant.i32 670
  %expected_index = tfrt.constant.i32 671
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 672
  %filter_index   = tfrt.constant.i32 673
  %scale_index    = tfrt.constant.i32 674
  %offset_index   = tfrt.constant.i32 675
  %mean_index     = tfrt.constant.i32 676
  %var_index      = tfrt.constant.i32 677
  %expected_index = tfrt.constant.i32 678
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 679
  %filter_index   = tfrt.constant.i32 680
  %scale_index    = tfrt.constant.i32 681
  %offset_index   = tfrt.constant.i32 682
  %mean_index     = tfrt.constant.i32 683
  %var_index      = tfrt.constant.i32 684
  %expected_index = tfrt.constant.i32 685
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 686
  %filter_index   = tfrt.constant.i32 687
  %scale_index    = tfrt.constant.i32 688
  %offset_index   = tfrt.constant.i32 689
  %mean_index     = tfrt.constant.i32 690
  %var_index      = tfrt.constant.i32 691
  %expected_index = tfrt.constant.i32 692
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 693
  %filter_index   = tfrt.constant.i32 694
  %scale_index    = tfrt.constant.i32 695
  %offset_index   = tfrt.constant.i32 696
  %mean_index     = tfrt.constant.i32 697
  %var_index      = tfrt.constant.i32 698
  %expected_index = tfrt.constant.i32 699
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 700
  %filter_index   = tfrt.constant.i32 701
  %scale_index    = tfrt.constant.i32 702
  %offset_index   = tfrt.constant.i32 703
  %mean_index     = tfrt.constant.i32 704
  %var_index      = tfrt.constant.i32 705
  %expected_index = tfrt.constant.i32 706
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 707
  %filter_index   = tfrt.constant.i32 708
  %scale_index    = tfrt.constant.i32 709
  %offset_index   = tfrt.constant.i32 710
  %mean_index     = tfrt.constant.i32 711
  %var_index      = tfrt.constant.i32 712
  %expected_index = tfrt.constant.i32 713
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 714
  %filter_index   = tfrt.constant.i32 715
  %scale_index    = tfrt.constant.i32 716
  %offset_index   = tfrt.constant.i32 717
  %mean_index     = tfrt.constant.i32 718
  %var_index      = tfrt.constant.i32 719
  %expected_index = tfrt.constant.i32 720
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 721
  %filter_index   = tfrt.constant.i32 722
  %scale_index    = tfrt.constant.i32 723
  %offset_index   = tfrt.constant.i32 724
  %mean_index     = tfrt.constant.i32 725
  %var_index      = tfrt.constant.i32 726
  %expected_index = tfrt.constant.i32 727
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 728
  %filter_index   = tfrt.constant.i32 729
  %scale_index    = tfrt.constant.i32 730
  %offset_index   = tfrt.constant.i32 731
  %mean_index     = tfrt.constant.i32 732
  %var_index      = tfrt.constant.i32 733
  %expected_index = tfrt.constant.i32 734
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 735
  %filter_index   = tfrt.constant.i32 736
  %scale_index    = tfrt.constant.i32 737
  %offset_index   = tfrt.constant.i32 738
  %mean_index     = tfrt.constant.i32 739
  %var_index      = tfrt.constant.i32 740
  %expected_index = tfrt.constant.i32 741
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 742
  %filter_index   = tfrt.constant.i32 743
  %scale_index    = tfrt.constant.i32 744
  %offset_index   = tfrt.constant.i32 745
  %mean_index     = tfrt.constant.i32 746
  %var_index      = tfrt.constant.i32 747
  %expected_index = tfrt.constant.i32 748
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 749
  %filter_index   = tfrt.constant.i32 750
  %scale_index    = tfrt.constant.i32 751
  %offset_index   = tfrt.constant.i32 752
  %mean_index     = tfrt.constant.i32 753
  %var_index      = tfrt.constant.i32 754
  %expected_index = tfrt.constant.i32 755
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 756
  %filter_index   = tfrt.constant.i32 757
  %scale_index    = tfrt.constant.i32 758
  %offset_index   = tfrt.constant.i32 759
  %mean_index     = tfrt.constant.i32 760
  %var_index      = tfrt.constant.i32 761
  %expected_index = tfrt.constant.i32 762
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 763
  %filter_index   = tfrt.constant.i32 764
  %scale_index    = tfrt.constant.i32 765
  %offset_index   = tfrt.constant.i32 766
  %mean_index     = tfrt.constant.i32 767
  %var_index      = tfrt.constant.i32 768
  %expected_index = tfrt.constant.i32 769
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 770
  %filter_index   = tfrt.constant.i32 771
  %scale_index    = tfrt.constant.i32 772
  %offset_index   = tfrt.constant.i32 773
  %mean_index     = tfrt.constant.i32 774
  %var_index      = tfrt.constant.i32 775
  %expected_index = tfrt.constant.i32 776
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_2x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 777
  %filter_index   = tfrt.constant.i32 778
  %scale_index    = tfrt.constant.i32 779
  %offset_index   = tfrt.constant.i32 780
  %mean_index     = tfrt.constant.i32 781
  %var_index      = tfrt.constant.i32 782
  %expected_index = tfrt.constant.i32 783
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 784
  %filter_index   = tfrt.constant.i32 785
  %scale_index    = tfrt.constant.i32 786
  %offset_index   = tfrt.constant.i32 787
  %mean_index     = tfrt.constant.i32 788
  %var_index      = tfrt.constant.i32 789
  %expected_index = tfrt.constant.i32 790
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 6 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 791
  %filter_index   = tfrt.constant.i32 792
  %scale_index    = tfrt.constant.i32 793
  %offset_index   = tfrt.constant.i32 794
  %mean_index     = tfrt.constant.i32 795
  %var_index      = tfrt.constant.i32 796
  %expected_index = tfrt.constant.i32 797
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 6 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 798
  %filter_index   = tfrt.constant.i32 799
  %scale_index    = tfrt.constant.i32 800
  %offset_index   = tfrt.constant.i32 801
  %mean_index     = tfrt.constant.i32 802
  %var_index      = tfrt.constant.i32 803
  %expected_index = tfrt.constant.i32 804
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 805
  %filter_index   = tfrt.constant.i32 806
  %scale_index    = tfrt.constant.i32 807
  %offset_index   = tfrt.constant.i32 808
  %mean_index     = tfrt.constant.i32 809
  %var_index      = tfrt.constant.i32 810
  %expected_index = tfrt.constant.i32 811
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 812
  %filter_index   = tfrt.constant.i32 813
  %scale_index    = tfrt.constant.i32 814
  %offset_index   = tfrt.constant.i32 815
  %mean_index     = tfrt.constant.i32 816
  %var_index      = tfrt.constant.i32 817
  %expected_index = tfrt.constant.i32 818
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 6 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 819
  %filter_index   = tfrt.constant.i32 820
  %scale_index    = tfrt.constant.i32 821
  %offset_index   = tfrt.constant.i32 822
  %mean_index     = tfrt.constant.i32 823
  %var_index      = tfrt.constant.i32 824
  %expected_index = tfrt.constant.i32 825
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 6 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 826
  %filter_index   = tfrt.constant.i32 827
  %scale_index    = tfrt.constant.i32 828
  %offset_index   = tfrt.constant.i32 829
  %mean_index     = tfrt.constant.i32 830
  %var_index      = tfrt.constant.i32 831
  %expected_index = tfrt.constant.i32 832
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 833
  %filter_index   = tfrt.constant.i32 834
  %scale_index    = tfrt.constant.i32 835
  %offset_index   = tfrt.constant.i32 836
  %mean_index     = tfrt.constant.i32 837
  %var_index      = tfrt.constant.i32 838
  %expected_index = tfrt.constant.i32 839
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 840
  %filter_index   = tfrt.constant.i32 841
  %scale_index    = tfrt.constant.i32 842
  %offset_index   = tfrt.constant.i32 843
  %mean_index     = tfrt.constant.i32 844
  %var_index      = tfrt.constant.i32 845
  %expected_index = tfrt.constant.i32 846
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 847
  %filter_index   = tfrt.constant.i32 848
  %scale_index    = tfrt.constant.i32 849
  %offset_index   = tfrt.constant.i32 850
  %mean_index     = tfrt.constant.i32 851
  %var_index      = tfrt.constant.i32 852
  %expected_index = tfrt.constant.i32 853
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 854
  %filter_index   = tfrt.constant.i32 855
  %scale_index    = tfrt.constant.i32 856
  %offset_index   = tfrt.constant.i32 857
  %mean_index     = tfrt.constant.i32 858
  %var_index      = tfrt.constant.i32 859
  %expected_index = tfrt.constant.i32 860
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 861
  %filter_index   = tfrt.constant.i32 862
  %scale_index    = tfrt.constant.i32 863
  %offset_index   = tfrt.constant.i32 864
  %mean_index     = tfrt.constant.i32 865
  %var_index      = tfrt.constant.i32 866
  %expected_index = tfrt.constant.i32 867
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 868
  %filter_index   = tfrt.constant.i32 869
  %scale_index    = tfrt.constant.i32 870
  %offset_index   = tfrt.constant.i32 871
  %mean_index     = tfrt.constant.i32 872
  %var_index      = tfrt.constant.i32 873
  %expected_index = tfrt.constant.i32 874
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 875
  %filter_index   = tfrt.constant.i32 876
  %scale_index    = tfrt.constant.i32 877
  %offset_index   = tfrt.constant.i32 878
  %mean_index     = tfrt.constant.i32 879
  %var_index      = tfrt.constant.i32 880
  %expected_index = tfrt.constant.i32 881
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 882
  %filter_index   = tfrt.constant.i32 883
  %scale_index    = tfrt.constant.i32 884
  %offset_index   = tfrt.constant.i32 885
  %mean_index     = tfrt.constant.i32 886
  %var_index      = tfrt.constant.i32 887
  %expected_index = tfrt.constant.i32 888
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x8_f_3x2_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 889
  %filter_index   = tfrt.constant.i32 890
  %scale_index    = tfrt.constant.i32 891
  %offset_index   = tfrt.constant.i32 892
  %mean_index     = tfrt.constant.i32 893
  %var_index      = tfrt.constant.i32 894
  %expected_index = tfrt.constant.i32 895
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 896
  %filter_index   = tfrt.constant.i32 897
  %scale_index    = tfrt.constant.i32 898
  %offset_index   = tfrt.constant.i32 899
  %mean_index     = tfrt.constant.i32 900
  %var_index      = tfrt.constant.i32 901
  %expected_index = tfrt.constant.i32 902
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 903
  %filter_index   = tfrt.constant.i32 904
  %scale_index    = tfrt.constant.i32 905
  %offset_index   = tfrt.constant.i32 906
  %mean_index     = tfrt.constant.i32 907
  %var_index      = tfrt.constant.i32 908
  %expected_index = tfrt.constant.i32 909
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 910
  %filter_index   = tfrt.constant.i32 911
  %scale_index    = tfrt.constant.i32 912
  %offset_index   = tfrt.constant.i32 913
  %mean_index     = tfrt.constant.i32 914
  %var_index      = tfrt.constant.i32 915
  %expected_index = tfrt.constant.i32 916
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 917
  %filter_index   = tfrt.constant.i32 918
  %scale_index    = tfrt.constant.i32 919
  %offset_index   = tfrt.constant.i32 920
  %mean_index     = tfrt.constant.i32 921
  %var_index      = tfrt.constant.i32 922
  %expected_index = tfrt.constant.i32 923
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 924
  %filter_index   = tfrt.constant.i32 925
  %scale_index    = tfrt.constant.i32 926
  %offset_index   = tfrt.constant.i32 927
  %mean_index     = tfrt.constant.i32 928
  %var_index      = tfrt.constant.i32 929
  %expected_index = tfrt.constant.i32 930
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 931
  %filter_index   = tfrt.constant.i32 932
  %scale_index    = tfrt.constant.i32 933
  %offset_index   = tfrt.constant.i32 934
  %mean_index     = tfrt.constant.i32 935
  %var_index      = tfrt.constant.i32 936
  %expected_index = tfrt.constant.i32 937
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 938
  %filter_index   = tfrt.constant.i32 939
  %scale_index    = tfrt.constant.i32 940
  %offset_index   = tfrt.constant.i32 941
  %mean_index     = tfrt.constant.i32 942
  %var_index      = tfrt.constant.i32 943
  %expected_index = tfrt.constant.i32 944
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 945
  %filter_index   = tfrt.constant.i32 946
  %scale_index    = tfrt.constant.i32 947
  %offset_index   = tfrt.constant.i32 948
  %mean_index     = tfrt.constant.i32 949
  %var_index      = tfrt.constant.i32 950
  %expected_index = tfrt.constant.i32 951
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 952
  %filter_index   = tfrt.constant.i32 953
  %scale_index    = tfrt.constant.i32 954
  %offset_index   = tfrt.constant.i32 955
  %mean_index     = tfrt.constant.i32 956
  %var_index      = tfrt.constant.i32 957
  %expected_index = tfrt.constant.i32 958
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 959
  %filter_index   = tfrt.constant.i32 960
  %scale_index    = tfrt.constant.i32 961
  %offset_index   = tfrt.constant.i32 962
  %mean_index     = tfrt.constant.i32 963
  %var_index      = tfrt.constant.i32 964
  %expected_index = tfrt.constant.i32 965
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 966
  %filter_index   = tfrt.constant.i32 967
  %scale_index    = tfrt.constant.i32 968
  %offset_index   = tfrt.constant.i32 969
  %mean_index     = tfrt.constant.i32 970
  %var_index      = tfrt.constant.i32 971
  %expected_index = tfrt.constant.i32 972
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 973
  %filter_index   = tfrt.constant.i32 974
  %scale_index    = tfrt.constant.i32 975
  %offset_index   = tfrt.constant.i32 976
  %mean_index     = tfrt.constant.i32 977
  %var_index      = tfrt.constant.i32 978
  %expected_index = tfrt.constant.i32 979
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 980
  %filter_index   = tfrt.constant.i32 981
  %scale_index    = tfrt.constant.i32 982
  %offset_index   = tfrt.constant.i32 983
  %mean_index     = tfrt.constant.i32 984
  %var_index      = tfrt.constant.i32 985
  %expected_index = tfrt.constant.i32 986
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 987
  %filter_index   = tfrt.constant.i32 988
  %scale_index    = tfrt.constant.i32 989
  %offset_index   = tfrt.constant.i32 990
  %mean_index     = tfrt.constant.i32 991
  %var_index      = tfrt.constant.i32 992
  %expected_index = tfrt.constant.i32 993
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 994
  %filter_index   = tfrt.constant.i32 995
  %scale_index    = tfrt.constant.i32 996
  %offset_index   = tfrt.constant.i32 997
  %mean_index     = tfrt.constant.i32 998
  %var_index      = tfrt.constant.i32 999
  %expected_index = tfrt.constant.i32 1000
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_1x1_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1001
  %filter_index   = tfrt.constant.i32 1002
  %scale_index    = tfrt.constant.i32 1003
  %offset_index   = tfrt.constant.i32 1004
  %mean_index     = tfrt.constant.i32 1005
  %var_index      = tfrt.constant.i32 1006
  %expected_index = tfrt.constant.i32 1007
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1008
  %filter_index   = tfrt.constant.i32 1009
  %scale_index    = tfrt.constant.i32 1010
  %offset_index   = tfrt.constant.i32 1011
  %mean_index     = tfrt.constant.i32 1012
  %var_index      = tfrt.constant.i32 1013
  %expected_index = tfrt.constant.i32 1014
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1015
  %filter_index   = tfrt.constant.i32 1016
  %scale_index    = tfrt.constant.i32 1017
  %offset_index   = tfrt.constant.i32 1018
  %mean_index     = tfrt.constant.i32 1019
  %var_index      = tfrt.constant.i32 1020
  %expected_index = tfrt.constant.i32 1021
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1022
  %filter_index   = tfrt.constant.i32 1023
  %scale_index    = tfrt.constant.i32 1024
  %offset_index   = tfrt.constant.i32 1025
  %mean_index     = tfrt.constant.i32 1026
  %var_index      = tfrt.constant.i32 1027
  %expected_index = tfrt.constant.i32 1028
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1029
  %filter_index   = tfrt.constant.i32 1030
  %scale_index    = tfrt.constant.i32 1031
  %offset_index   = tfrt.constant.i32 1032
  %mean_index     = tfrt.constant.i32 1033
  %var_index      = tfrt.constant.i32 1034
  %expected_index = tfrt.constant.i32 1035
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1036
  %filter_index   = tfrt.constant.i32 1037
  %scale_index    = tfrt.constant.i32 1038
  %offset_index   = tfrt.constant.i32 1039
  %mean_index     = tfrt.constant.i32 1040
  %var_index      = tfrt.constant.i32 1041
  %expected_index = tfrt.constant.i32 1042
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1043
  %filter_index   = tfrt.constant.i32 1044
  %scale_index    = tfrt.constant.i32 1045
  %offset_index   = tfrt.constant.i32 1046
  %mean_index     = tfrt.constant.i32 1047
  %var_index      = tfrt.constant.i32 1048
  %expected_index = tfrt.constant.i32 1049
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1050
  %filter_index   = tfrt.constant.i32 1051
  %scale_index    = tfrt.constant.i32 1052
  %offset_index   = tfrt.constant.i32 1053
  %mean_index     = tfrt.constant.i32 1054
  %var_index      = tfrt.constant.i32 1055
  %expected_index = tfrt.constant.i32 1056
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1057
  %filter_index   = tfrt.constant.i32 1058
  %scale_index    = tfrt.constant.i32 1059
  %offset_index   = tfrt.constant.i32 1060
  %mean_index     = tfrt.constant.i32 1061
  %var_index      = tfrt.constant.i32 1062
  %expected_index = tfrt.constant.i32 1063
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1064
  %filter_index   = tfrt.constant.i32 1065
  %scale_index    = tfrt.constant.i32 1066
  %offset_index   = tfrt.constant.i32 1067
  %mean_index     = tfrt.constant.i32 1068
  %var_index      = tfrt.constant.i32 1069
  %expected_index = tfrt.constant.i32 1070
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1071
  %filter_index   = tfrt.constant.i32 1072
  %scale_index    = tfrt.constant.i32 1073
  %offset_index   = tfrt.constant.i32 1074
  %mean_index     = tfrt.constant.i32 1075
  %var_index      = tfrt.constant.i32 1076
  %expected_index = tfrt.constant.i32 1077
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1078
  %filter_index   = tfrt.constant.i32 1079
  %scale_index    = tfrt.constant.i32 1080
  %offset_index   = tfrt.constant.i32 1081
  %mean_index     = tfrt.constant.i32 1082
  %var_index      = tfrt.constant.i32 1083
  %expected_index = tfrt.constant.i32 1084
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1085
  %filter_index   = tfrt.constant.i32 1086
  %scale_index    = tfrt.constant.i32 1087
  %offset_index   = tfrt.constant.i32 1088
  %mean_index     = tfrt.constant.i32 1089
  %var_index      = tfrt.constant.i32 1090
  %expected_index = tfrt.constant.i32 1091
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1092
  %filter_index   = tfrt.constant.i32 1093
  %scale_index    = tfrt.constant.i32 1094
  %offset_index   = tfrt.constant.i32 1095
  %mean_index     = tfrt.constant.i32 1096
  %var_index      = tfrt.constant.i32 1097
  %expected_index = tfrt.constant.i32 1098
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1099
  %filter_index   = tfrt.constant.i32 1100
  %scale_index    = tfrt.constant.i32 1101
  %offset_index   = tfrt.constant.i32 1102
  %mean_index     = tfrt.constant.i32 1103
  %var_index      = tfrt.constant.i32 1104
  %expected_index = tfrt.constant.i32 1105
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1106
  %filter_index   = tfrt.constant.i32 1107
  %scale_index    = tfrt.constant.i32 1108
  %offset_index   = tfrt.constant.i32 1109
  %mean_index     = tfrt.constant.i32 1110
  %var_index      = tfrt.constant.i32 1111
  %expected_index = tfrt.constant.i32 1112
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1113
  %filter_index   = tfrt.constant.i32 1114
  %scale_index    = tfrt.constant.i32 1115
  %offset_index   = tfrt.constant.i32 1116
  %mean_index     = tfrt.constant.i32 1117
  %var_index      = tfrt.constant.i32 1118
  %expected_index = tfrt.constant.i32 1119
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1120
  %filter_index   = tfrt.constant.i32 1121
  %scale_index    = tfrt.constant.i32 1122
  %offset_index   = tfrt.constant.i32 1123
  %mean_index     = tfrt.constant.i32 1124
  %var_index      = tfrt.constant.i32 1125
  %expected_index = tfrt.constant.i32 1126
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1127
  %filter_index   = tfrt.constant.i32 1128
  %scale_index    = tfrt.constant.i32 1129
  %offset_index   = tfrt.constant.i32 1130
  %mean_index     = tfrt.constant.i32 1131
  %var_index      = tfrt.constant.i32 1132
  %expected_index = tfrt.constant.i32 1133
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1134
  %filter_index   = tfrt.constant.i32 1135
  %scale_index    = tfrt.constant.i32 1136
  %offset_index   = tfrt.constant.i32 1137
  %mean_index     = tfrt.constant.i32 1138
  %var_index      = tfrt.constant.i32 1139
  %expected_index = tfrt.constant.i32 1140
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1141
  %filter_index   = tfrt.constant.i32 1142
  %scale_index    = tfrt.constant.i32 1143
  %offset_index   = tfrt.constant.i32 1144
  %mean_index     = tfrt.constant.i32 1145
  %var_index      = tfrt.constant.i32 1146
  %expected_index = tfrt.constant.i32 1147
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1148
  %filter_index   = tfrt.constant.i32 1149
  %scale_index    = tfrt.constant.i32 1150
  %offset_index   = tfrt.constant.i32 1151
  %mean_index     = tfrt.constant.i32 1152
  %var_index      = tfrt.constant.i32 1153
  %expected_index = tfrt.constant.i32 1154
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1155
  %filter_index   = tfrt.constant.i32 1156
  %scale_index    = tfrt.constant.i32 1157
  %offset_index   = tfrt.constant.i32 1158
  %mean_index     = tfrt.constant.i32 1159
  %var_index      = tfrt.constant.i32 1160
  %expected_index = tfrt.constant.i32 1161
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1162
  %filter_index   = tfrt.constant.i32 1163
  %scale_index    = tfrt.constant.i32 1164
  %offset_index   = tfrt.constant.i32 1165
  %mean_index     = tfrt.constant.i32 1166
  %var_index      = tfrt.constant.i32 1167
  %expected_index = tfrt.constant.i32 1168
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1169
  %filter_index   = tfrt.constant.i32 1170
  %scale_index    = tfrt.constant.i32 1171
  %offset_index   = tfrt.constant.i32 1172
  %mean_index     = tfrt.constant.i32 1173
  %var_index      = tfrt.constant.i32 1174
  %expected_index = tfrt.constant.i32 1175
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1176
  %filter_index   = tfrt.constant.i32 1177
  %scale_index    = tfrt.constant.i32 1178
  %offset_index   = tfrt.constant.i32 1179
  %mean_index     = tfrt.constant.i32 1180
  %var_index      = tfrt.constant.i32 1181
  %expected_index = tfrt.constant.i32 1182
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1183
  %filter_index   = tfrt.constant.i32 1184
  %scale_index    = tfrt.constant.i32 1185
  %offset_index   = tfrt.constant.i32 1186
  %mean_index     = tfrt.constant.i32 1187
  %var_index      = tfrt.constant.i32 1188
  %expected_index = tfrt.constant.i32 1189
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1190
  %filter_index   = tfrt.constant.i32 1191
  %scale_index    = tfrt.constant.i32 1192
  %offset_index   = tfrt.constant.i32 1193
  %mean_index     = tfrt.constant.i32 1194
  %var_index      = tfrt.constant.i32 1195
  %expected_index = tfrt.constant.i32 1196
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1197
  %filter_index   = tfrt.constant.i32 1198
  %scale_index    = tfrt.constant.i32 1199
  %offset_index   = tfrt.constant.i32 1200
  %mean_index     = tfrt.constant.i32 1201
  %var_index      = tfrt.constant.i32 1202
  %expected_index = tfrt.constant.i32 1203
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1204
  %filter_index   = tfrt.constant.i32 1205
  %scale_index    = tfrt.constant.i32 1206
  %offset_index   = tfrt.constant.i32 1207
  %mean_index     = tfrt.constant.i32 1208
  %var_index      = tfrt.constant.i32 1209
  %expected_index = tfrt.constant.i32 1210
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1211
  %filter_index   = tfrt.constant.i32 1212
  %scale_index    = tfrt.constant.i32 1213
  %offset_index   = tfrt.constant.i32 1214
  %mean_index     = tfrt.constant.i32 1215
  %var_index      = tfrt.constant.i32 1216
  %expected_index = tfrt.constant.i32 1217
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1218
  %filter_index   = tfrt.constant.i32 1219
  %scale_index    = tfrt.constant.i32 1220
  %offset_index   = tfrt.constant.i32 1221
  %mean_index     = tfrt.constant.i32 1222
  %var_index      = tfrt.constant.i32 1223
  %expected_index = tfrt.constant.i32 1224
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_2x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1225
  %filter_index   = tfrt.constant.i32 1226
  %scale_index    = tfrt.constant.i32 1227
  %offset_index   = tfrt.constant.i32 1228
  %mean_index     = tfrt.constant.i32 1229
  %var_index      = tfrt.constant.i32 1230
  %expected_index = tfrt.constant.i32 1231
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1232
  %filter_index   = tfrt.constant.i32 1233
  %scale_index    = tfrt.constant.i32 1234
  %offset_index   = tfrt.constant.i32 1235
  %mean_index     = tfrt.constant.i32 1236
  %var_index      = tfrt.constant.i32 1237
  %expected_index = tfrt.constant.i32 1238
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1239
  %filter_index   = tfrt.constant.i32 1240
  %scale_index    = tfrt.constant.i32 1241
  %offset_index   = tfrt.constant.i32 1242
  %mean_index     = tfrt.constant.i32 1243
  %var_index      = tfrt.constant.i32 1244
  %expected_index = tfrt.constant.i32 1245
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1246
  %filter_index   = tfrt.constant.i32 1247
  %scale_index    = tfrt.constant.i32 1248
  %offset_index   = tfrt.constant.i32 1249
  %mean_index     = tfrt.constant.i32 1250
  %var_index      = tfrt.constant.i32 1251
  %expected_index = tfrt.constant.i32 1252
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1253
  %filter_index   = tfrt.constant.i32 1254
  %scale_index    = tfrt.constant.i32 1255
  %offset_index   = tfrt.constant.i32 1256
  %mean_index     = tfrt.constant.i32 1257
  %var_index      = tfrt.constant.i32 1258
  %expected_index = tfrt.constant.i32 1259
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1260
  %filter_index   = tfrt.constant.i32 1261
  %scale_index    = tfrt.constant.i32 1262
  %offset_index   = tfrt.constant.i32 1263
  %mean_index     = tfrt.constant.i32 1264
  %var_index      = tfrt.constant.i32 1265
  %expected_index = tfrt.constant.i32 1266
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1267
  %filter_index   = tfrt.constant.i32 1268
  %scale_index    = tfrt.constant.i32 1269
  %offset_index   = tfrt.constant.i32 1270
  %mean_index     = tfrt.constant.i32 1271
  %var_index      = tfrt.constant.i32 1272
  %expected_index = tfrt.constant.i32 1273
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1274
  %filter_index   = tfrt.constant.i32 1275
  %scale_index    = tfrt.constant.i32 1276
  %offset_index   = tfrt.constant.i32 1277
  %mean_index     = tfrt.constant.i32 1278
  %var_index      = tfrt.constant.i32 1279
  %expected_index = tfrt.constant.i32 1280
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1281
  %filter_index   = tfrt.constant.i32 1282
  %scale_index    = tfrt.constant.i32 1283
  %offset_index   = tfrt.constant.i32 1284
  %mean_index     = tfrt.constant.i32 1285
  %var_index      = tfrt.constant.i32 1286
  %expected_index = tfrt.constant.i32 1287
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1288
  %filter_index   = tfrt.constant.i32 1289
  %scale_index    = tfrt.constant.i32 1290
  %offset_index   = tfrt.constant.i32 1291
  %mean_index     = tfrt.constant.i32 1292
  %var_index      = tfrt.constant.i32 1293
  %expected_index = tfrt.constant.i32 1294
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1295
  %filter_index   = tfrt.constant.i32 1296
  %scale_index    = tfrt.constant.i32 1297
  %offset_index   = tfrt.constant.i32 1298
  %mean_index     = tfrt.constant.i32 1299
  %var_index      = tfrt.constant.i32 1300
  %expected_index = tfrt.constant.i32 1301
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1302
  %filter_index   = tfrt.constant.i32 1303
  %scale_index    = tfrt.constant.i32 1304
  %offset_index   = tfrt.constant.i32 1305
  %mean_index     = tfrt.constant.i32 1306
  %var_index      = tfrt.constant.i32 1307
  %expected_index = tfrt.constant.i32 1308
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1309
  %filter_index   = tfrt.constant.i32 1310
  %scale_index    = tfrt.constant.i32 1311
  %offset_index   = tfrt.constant.i32 1312
  %mean_index     = tfrt.constant.i32 1313
  %var_index      = tfrt.constant.i32 1314
  %expected_index = tfrt.constant.i32 1315
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1316
  %filter_index   = tfrt.constant.i32 1317
  %scale_index    = tfrt.constant.i32 1318
  %offset_index   = tfrt.constant.i32 1319
  %mean_index     = tfrt.constant.i32 1320
  %var_index      = tfrt.constant.i32 1321
  %expected_index = tfrt.constant.i32 1322
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1323
  %filter_index   = tfrt.constant.i32 1324
  %scale_index    = tfrt.constant.i32 1325
  %offset_index   = tfrt.constant.i32 1326
  %mean_index     = tfrt.constant.i32 1327
  %var_index      = tfrt.constant.i32 1328
  %expected_index = tfrt.constant.i32 1329
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1330
  %filter_index   = tfrt.constant.i32 1331
  %scale_index    = tfrt.constant.i32 1332
  %offset_index   = tfrt.constant.i32 1333
  %mean_index     = tfrt.constant.i32 1334
  %var_index      = tfrt.constant.i32 1335
  %expected_index = tfrt.constant.i32 1336
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x8_f_3x2_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1337
  %filter_index   = tfrt.constant.i32 1338
  %scale_index    = tfrt.constant.i32 1339
  %offset_index   = tfrt.constant.i32 1340
  %mean_index     = tfrt.constant.i32 1341
  %var_index      = tfrt.constant.i32 1342
  %expected_index = tfrt.constant.i32 1343
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1344
  %filter_index   = tfrt.constant.i32 1345
  %scale_index    = tfrt.constant.i32 1346
  %offset_index   = tfrt.constant.i32 1347
  %mean_index     = tfrt.constant.i32 1348
  %var_index      = tfrt.constant.i32 1349
  %expected_index = tfrt.constant.i32 1350
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1351
  %filter_index   = tfrt.constant.i32 1352
  %scale_index    = tfrt.constant.i32 1353
  %offset_index   = tfrt.constant.i32 1354
  %mean_index     = tfrt.constant.i32 1355
  %var_index      = tfrt.constant.i32 1356
  %expected_index = tfrt.constant.i32 1357
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1358
  %filter_index   = tfrt.constant.i32 1359
  %scale_index    = tfrt.constant.i32 1360
  %offset_index   = tfrt.constant.i32 1361
  %mean_index     = tfrt.constant.i32 1362
  %var_index      = tfrt.constant.i32 1363
  %expected_index = tfrt.constant.i32 1364
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1365
  %filter_index   = tfrt.constant.i32 1366
  %scale_index    = tfrt.constant.i32 1367
  %offset_index   = tfrt.constant.i32 1368
  %mean_index     = tfrt.constant.i32 1369
  %var_index      = tfrt.constant.i32 1370
  %expected_index = tfrt.constant.i32 1371
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1372
  %filter_index   = tfrt.constant.i32 1373
  %scale_index    = tfrt.constant.i32 1374
  %offset_index   = tfrt.constant.i32 1375
  %mean_index     = tfrt.constant.i32 1376
  %var_index      = tfrt.constant.i32 1377
  %expected_index = tfrt.constant.i32 1378
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1379
  %filter_index   = tfrt.constant.i32 1380
  %scale_index    = tfrt.constant.i32 1381
  %offset_index   = tfrt.constant.i32 1382
  %mean_index     = tfrt.constant.i32 1383
  %var_index      = tfrt.constant.i32 1384
  %expected_index = tfrt.constant.i32 1385
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1386
  %filter_index   = tfrt.constant.i32 1387
  %scale_index    = tfrt.constant.i32 1388
  %offset_index   = tfrt.constant.i32 1389
  %mean_index     = tfrt.constant.i32 1390
  %var_index      = tfrt.constant.i32 1391
  %expected_index = tfrt.constant.i32 1392
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1393
  %filter_index   = tfrt.constant.i32 1394
  %scale_index    = tfrt.constant.i32 1395
  %offset_index   = tfrt.constant.i32 1396
  %mean_index     = tfrt.constant.i32 1397
  %var_index      = tfrt.constant.i32 1398
  %expected_index = tfrt.constant.i32 1399
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1400
  %filter_index   = tfrt.constant.i32 1401
  %scale_index    = tfrt.constant.i32 1402
  %offset_index   = tfrt.constant.i32 1403
  %mean_index     = tfrt.constant.i32 1404
  %var_index      = tfrt.constant.i32 1405
  %expected_index = tfrt.constant.i32 1406
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1407
  %filter_index   = tfrt.constant.i32 1408
  %scale_index    = tfrt.constant.i32 1409
  %offset_index   = tfrt.constant.i32 1410
  %mean_index     = tfrt.constant.i32 1411
  %var_index      = tfrt.constant.i32 1412
  %expected_index = tfrt.constant.i32 1413
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1414
  %filter_index   = tfrt.constant.i32 1415
  %scale_index    = tfrt.constant.i32 1416
  %offset_index   = tfrt.constant.i32 1417
  %mean_index     = tfrt.constant.i32 1418
  %var_index      = tfrt.constant.i32 1419
  %expected_index = tfrt.constant.i32 1420
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1421
  %filter_index   = tfrt.constant.i32 1422
  %scale_index    = tfrt.constant.i32 1423
  %offset_index   = tfrt.constant.i32 1424
  %mean_index     = tfrt.constant.i32 1425
  %var_index      = tfrt.constant.i32 1426
  %expected_index = tfrt.constant.i32 1427
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1428
  %filter_index   = tfrt.constant.i32 1429
  %scale_index    = tfrt.constant.i32 1430
  %offset_index   = tfrt.constant.i32 1431
  %mean_index     = tfrt.constant.i32 1432
  %var_index      = tfrt.constant.i32 1433
  %expected_index = tfrt.constant.i32 1434
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1435
  %filter_index   = tfrt.constant.i32 1436
  %scale_index    = tfrt.constant.i32 1437
  %offset_index   = tfrt.constant.i32 1438
  %mean_index     = tfrt.constant.i32 1439
  %var_index      = tfrt.constant.i32 1440
  %expected_index = tfrt.constant.i32 1441
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1442
  %filter_index   = tfrt.constant.i32 1443
  %scale_index    = tfrt.constant.i32 1444
  %offset_index   = tfrt.constant.i32 1445
  %mean_index     = tfrt.constant.i32 1446
  %var_index      = tfrt.constant.i32 1447
  %expected_index = tfrt.constant.i32 1448
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_1x1_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1449
  %filter_index   = tfrt.constant.i32 1450
  %scale_index    = tfrt.constant.i32 1451
  %offset_index   = tfrt.constant.i32 1452
  %mean_index     = tfrt.constant.i32 1453
  %var_index      = tfrt.constant.i32 1454
  %expected_index = tfrt.constant.i32 1455
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1456
  %filter_index   = tfrt.constant.i32 1457
  %scale_index    = tfrt.constant.i32 1458
  %offset_index   = tfrt.constant.i32 1459
  %mean_index     = tfrt.constant.i32 1460
  %var_index      = tfrt.constant.i32 1461
  %expected_index = tfrt.constant.i32 1462
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1463
  %filter_index   = tfrt.constant.i32 1464
  %scale_index    = tfrt.constant.i32 1465
  %offset_index   = tfrt.constant.i32 1466
  %mean_index     = tfrt.constant.i32 1467
  %var_index      = tfrt.constant.i32 1468
  %expected_index = tfrt.constant.i32 1469
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1470
  %filter_index   = tfrt.constant.i32 1471
  %scale_index    = tfrt.constant.i32 1472
  %offset_index   = tfrt.constant.i32 1473
  %mean_index     = tfrt.constant.i32 1474
  %var_index      = tfrt.constant.i32 1475
  %expected_index = tfrt.constant.i32 1476
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1477
  %filter_index   = tfrt.constant.i32 1478
  %scale_index    = tfrt.constant.i32 1479
  %offset_index   = tfrt.constant.i32 1480
  %mean_index     = tfrt.constant.i32 1481
  %var_index      = tfrt.constant.i32 1482
  %expected_index = tfrt.constant.i32 1483
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1484
  %filter_index   = tfrt.constant.i32 1485
  %scale_index    = tfrt.constant.i32 1486
  %offset_index   = tfrt.constant.i32 1487
  %mean_index     = tfrt.constant.i32 1488
  %var_index      = tfrt.constant.i32 1489
  %expected_index = tfrt.constant.i32 1490
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1491
  %filter_index   = tfrt.constant.i32 1492
  %scale_index    = tfrt.constant.i32 1493
  %offset_index   = tfrt.constant.i32 1494
  %mean_index     = tfrt.constant.i32 1495
  %var_index      = tfrt.constant.i32 1496
  %expected_index = tfrt.constant.i32 1497
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1498
  %filter_index   = tfrt.constant.i32 1499
  %scale_index    = tfrt.constant.i32 1500
  %offset_index   = tfrt.constant.i32 1501
  %mean_index     = tfrt.constant.i32 1502
  %var_index      = tfrt.constant.i32 1503
  %expected_index = tfrt.constant.i32 1504
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1505
  %filter_index   = tfrt.constant.i32 1506
  %scale_index    = tfrt.constant.i32 1507
  %offset_index   = tfrt.constant.i32 1508
  %mean_index     = tfrt.constant.i32 1509
  %var_index      = tfrt.constant.i32 1510
  %expected_index = tfrt.constant.i32 1511
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1512
  %filter_index   = tfrt.constant.i32 1513
  %scale_index    = tfrt.constant.i32 1514
  %offset_index   = tfrt.constant.i32 1515
  %mean_index     = tfrt.constant.i32 1516
  %var_index      = tfrt.constant.i32 1517
  %expected_index = tfrt.constant.i32 1518
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1519
  %filter_index   = tfrt.constant.i32 1520
  %scale_index    = tfrt.constant.i32 1521
  %offset_index   = tfrt.constant.i32 1522
  %mean_index     = tfrt.constant.i32 1523
  %var_index      = tfrt.constant.i32 1524
  %expected_index = tfrt.constant.i32 1525
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1526
  %filter_index   = tfrt.constant.i32 1527
  %scale_index    = tfrt.constant.i32 1528
  %offset_index   = tfrt.constant.i32 1529
  %mean_index     = tfrt.constant.i32 1530
  %var_index      = tfrt.constant.i32 1531
  %expected_index = tfrt.constant.i32 1532
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1533
  %filter_index   = tfrt.constant.i32 1534
  %scale_index    = tfrt.constant.i32 1535
  %offset_index   = tfrt.constant.i32 1536
  %mean_index     = tfrt.constant.i32 1537
  %var_index      = tfrt.constant.i32 1538
  %expected_index = tfrt.constant.i32 1539
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1540
  %filter_index   = tfrt.constant.i32 1541
  %scale_index    = tfrt.constant.i32 1542
  %offset_index   = tfrt.constant.i32 1543
  %mean_index     = tfrt.constant.i32 1544
  %var_index      = tfrt.constant.i32 1545
  %expected_index = tfrt.constant.i32 1546
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1547
  %filter_index   = tfrt.constant.i32 1548
  %scale_index    = tfrt.constant.i32 1549
  %offset_index   = tfrt.constant.i32 1550
  %mean_index     = tfrt.constant.i32 1551
  %var_index      = tfrt.constant.i32 1552
  %expected_index = tfrt.constant.i32 1553
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1554
  %filter_index   = tfrt.constant.i32 1555
  %scale_index    = tfrt.constant.i32 1556
  %offset_index   = tfrt.constant.i32 1557
  %mean_index     = tfrt.constant.i32 1558
  %var_index      = tfrt.constant.i32 1559
  %expected_index = tfrt.constant.i32 1560
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1561
  %filter_index   = tfrt.constant.i32 1562
  %scale_index    = tfrt.constant.i32 1563
  %offset_index   = tfrt.constant.i32 1564
  %mean_index     = tfrt.constant.i32 1565
  %var_index      = tfrt.constant.i32 1566
  %expected_index = tfrt.constant.i32 1567
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1568
  %filter_index   = tfrt.constant.i32 1569
  %scale_index    = tfrt.constant.i32 1570
  %offset_index   = tfrt.constant.i32 1571
  %mean_index     = tfrt.constant.i32 1572
  %var_index      = tfrt.constant.i32 1573
  %expected_index = tfrt.constant.i32 1574
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1575
  %filter_index   = tfrt.constant.i32 1576
  %scale_index    = tfrt.constant.i32 1577
  %offset_index   = tfrt.constant.i32 1578
  %mean_index     = tfrt.constant.i32 1579
  %var_index      = tfrt.constant.i32 1580
  %expected_index = tfrt.constant.i32 1581
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1582
  %filter_index   = tfrt.constant.i32 1583
  %scale_index    = tfrt.constant.i32 1584
  %offset_index   = tfrt.constant.i32 1585
  %mean_index     = tfrt.constant.i32 1586
  %var_index      = tfrt.constant.i32 1587
  %expected_index = tfrt.constant.i32 1588
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1589
  %filter_index   = tfrt.constant.i32 1590
  %scale_index    = tfrt.constant.i32 1591
  %offset_index   = tfrt.constant.i32 1592
  %mean_index     = tfrt.constant.i32 1593
  %var_index      = tfrt.constant.i32 1594
  %expected_index = tfrt.constant.i32 1595
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1596
  %filter_index   = tfrt.constant.i32 1597
  %scale_index    = tfrt.constant.i32 1598
  %offset_index   = tfrt.constant.i32 1599
  %mean_index     = tfrt.constant.i32 1600
  %var_index      = tfrt.constant.i32 1601
  %expected_index = tfrt.constant.i32 1602
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1603
  %filter_index   = tfrt.constant.i32 1604
  %scale_index    = tfrt.constant.i32 1605
  %offset_index   = tfrt.constant.i32 1606
  %mean_index     = tfrt.constant.i32 1607
  %var_index      = tfrt.constant.i32 1608
  %expected_index = tfrt.constant.i32 1609
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1610
  %filter_index   = tfrt.constant.i32 1611
  %scale_index    = tfrt.constant.i32 1612
  %offset_index   = tfrt.constant.i32 1613
  %mean_index     = tfrt.constant.i32 1614
  %var_index      = tfrt.constant.i32 1615
  %expected_index = tfrt.constant.i32 1616
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1617
  %filter_index   = tfrt.constant.i32 1618
  %scale_index    = tfrt.constant.i32 1619
  %offset_index   = tfrt.constant.i32 1620
  %mean_index     = tfrt.constant.i32 1621
  %var_index      = tfrt.constant.i32 1622
  %expected_index = tfrt.constant.i32 1623
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1624
  %filter_index   = tfrt.constant.i32 1625
  %scale_index    = tfrt.constant.i32 1626
  %offset_index   = tfrt.constant.i32 1627
  %mean_index     = tfrt.constant.i32 1628
  %var_index      = tfrt.constant.i32 1629
  %expected_index = tfrt.constant.i32 1630
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1631
  %filter_index   = tfrt.constant.i32 1632
  %scale_index    = tfrt.constant.i32 1633
  %offset_index   = tfrt.constant.i32 1634
  %mean_index     = tfrt.constant.i32 1635
  %var_index      = tfrt.constant.i32 1636
  %expected_index = tfrt.constant.i32 1637
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1638
  %filter_index   = tfrt.constant.i32 1639
  %scale_index    = tfrt.constant.i32 1640
  %offset_index   = tfrt.constant.i32 1641
  %mean_index     = tfrt.constant.i32 1642
  %var_index      = tfrt.constant.i32 1643
  %expected_index = tfrt.constant.i32 1644
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1645
  %filter_index   = tfrt.constant.i32 1646
  %scale_index    = tfrt.constant.i32 1647
  %offset_index   = tfrt.constant.i32 1648
  %mean_index     = tfrt.constant.i32 1649
  %var_index      = tfrt.constant.i32 1650
  %expected_index = tfrt.constant.i32 1651
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1652
  %filter_index   = tfrt.constant.i32 1653
  %scale_index    = tfrt.constant.i32 1654
  %offset_index   = tfrt.constant.i32 1655
  %mean_index     = tfrt.constant.i32 1656
  %var_index      = tfrt.constant.i32 1657
  %expected_index = tfrt.constant.i32 1658
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1659
  %filter_index   = tfrt.constant.i32 1660
  %scale_index    = tfrt.constant.i32 1661
  %offset_index   = tfrt.constant.i32 1662
  %mean_index     = tfrt.constant.i32 1663
  %var_index      = tfrt.constant.i32 1664
  %expected_index = tfrt.constant.i32 1665
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1666
  %filter_index   = tfrt.constant.i32 1667
  %scale_index    = tfrt.constant.i32 1668
  %offset_index   = tfrt.constant.i32 1669
  %mean_index     = tfrt.constant.i32 1670
  %var_index      = tfrt.constant.i32 1671
  %expected_index = tfrt.constant.i32 1672
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_2x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1673
  %filter_index   = tfrt.constant.i32 1674
  %scale_index    = tfrt.constant.i32 1675
  %offset_index   = tfrt.constant.i32 1676
  %mean_index     = tfrt.constant.i32 1677
  %var_index      = tfrt.constant.i32 1678
  %expected_index = tfrt.constant.i32 1679
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1680
  %filter_index   = tfrt.constant.i32 1681
  %scale_index    = tfrt.constant.i32 1682
  %offset_index   = tfrt.constant.i32 1683
  %mean_index     = tfrt.constant.i32 1684
  %var_index      = tfrt.constant.i32 1685
  %expected_index = tfrt.constant.i32 1686
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1687
  %filter_index   = tfrt.constant.i32 1688
  %scale_index    = tfrt.constant.i32 1689
  %offset_index   = tfrt.constant.i32 1690
  %mean_index     = tfrt.constant.i32 1691
  %var_index      = tfrt.constant.i32 1692
  %expected_index = tfrt.constant.i32 1693
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1694
  %filter_index   = tfrt.constant.i32 1695
  %scale_index    = tfrt.constant.i32 1696
  %offset_index   = tfrt.constant.i32 1697
  %mean_index     = tfrt.constant.i32 1698
  %var_index      = tfrt.constant.i32 1699
  %expected_index = tfrt.constant.i32 1700
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1701
  %filter_index   = tfrt.constant.i32 1702
  %scale_index    = tfrt.constant.i32 1703
  %offset_index   = tfrt.constant.i32 1704
  %mean_index     = tfrt.constant.i32 1705
  %var_index      = tfrt.constant.i32 1706
  %expected_index = tfrt.constant.i32 1707
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1708
  %filter_index   = tfrt.constant.i32 1709
  %scale_index    = tfrt.constant.i32 1710
  %offset_index   = tfrt.constant.i32 1711
  %mean_index     = tfrt.constant.i32 1712
  %var_index      = tfrt.constant.i32 1713
  %expected_index = tfrt.constant.i32 1714
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1715
  %filter_index   = tfrt.constant.i32 1716
  %scale_index    = tfrt.constant.i32 1717
  %offset_index   = tfrt.constant.i32 1718
  %mean_index     = tfrt.constant.i32 1719
  %var_index      = tfrt.constant.i32 1720
  %expected_index = tfrt.constant.i32 1721
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1722
  %filter_index   = tfrt.constant.i32 1723
  %scale_index    = tfrt.constant.i32 1724
  %offset_index   = tfrt.constant.i32 1725
  %mean_index     = tfrt.constant.i32 1726
  %var_index      = tfrt.constant.i32 1727
  %expected_index = tfrt.constant.i32 1728
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1729
  %filter_index   = tfrt.constant.i32 1730
  %scale_index    = tfrt.constant.i32 1731
  %offset_index   = tfrt.constant.i32 1732
  %mean_index     = tfrt.constant.i32 1733
  %var_index      = tfrt.constant.i32 1734
  %expected_index = tfrt.constant.i32 1735
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1736
  %filter_index   = tfrt.constant.i32 1737
  %scale_index    = tfrt.constant.i32 1738
  %offset_index   = tfrt.constant.i32 1739
  %mean_index     = tfrt.constant.i32 1740
  %var_index      = tfrt.constant.i32 1741
  %expected_index = tfrt.constant.i32 1742
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1743
  %filter_index   = tfrt.constant.i32 1744
  %scale_index    = tfrt.constant.i32 1745
  %offset_index   = tfrt.constant.i32 1746
  %mean_index     = tfrt.constant.i32 1747
  %var_index      = tfrt.constant.i32 1748
  %expected_index = tfrt.constant.i32 1749
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1750
  %filter_index   = tfrt.constant.i32 1751
  %scale_index    = tfrt.constant.i32 1752
  %offset_index   = tfrt.constant.i32 1753
  %mean_index     = tfrt.constant.i32 1754
  %var_index      = tfrt.constant.i32 1755
  %expected_index = tfrt.constant.i32 1756
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1757
  %filter_index   = tfrt.constant.i32 1758
  %scale_index    = tfrt.constant.i32 1759
  %offset_index   = tfrt.constant.i32 1760
  %mean_index     = tfrt.constant.i32 1761
  %var_index      = tfrt.constant.i32 1762
  %expected_index = tfrt.constant.i32 1763
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1764
  %filter_index   = tfrt.constant.i32 1765
  %scale_index    = tfrt.constant.i32 1766
  %offset_index   = tfrt.constant.i32 1767
  %mean_index     = tfrt.constant.i32 1768
  %var_index      = tfrt.constant.i32 1769
  %expected_index = tfrt.constant.i32 1770
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1771
  %filter_index   = tfrt.constant.i32 1772
  %scale_index    = tfrt.constant.i32 1773
  %offset_index   = tfrt.constant.i32 1774
  %mean_index     = tfrt.constant.i32 1775
  %var_index      = tfrt.constant.i32 1776
  %expected_index = tfrt.constant.i32 1777
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1778
  %filter_index   = tfrt.constant.i32 1779
  %scale_index    = tfrt.constant.i32 1780
  %offset_index   = tfrt.constant.i32 1781
  %mean_index     = tfrt.constant.i32 1782
  %var_index      = tfrt.constant.i32 1783
  %expected_index = tfrt.constant.i32 1784
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x9x10_f_3x2_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1785
  %filter_index   = tfrt.constant.i32 1786
  %scale_index    = tfrt.constant.i32 1787
  %offset_index   = tfrt.constant.i32 1788
  %mean_index     = tfrt.constant.i32 1789
  %var_index      = tfrt.constant.i32 1790
  %expected_index = tfrt.constant.i32 1791
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1792
  %filter_index   = tfrt.constant.i32 1793
  %scale_index    = tfrt.constant.i32 1794
  %offset_index   = tfrt.constant.i32 1795
  %mean_index     = tfrt.constant.i32 1796
  %var_index      = tfrt.constant.i32 1797
  %expected_index = tfrt.constant.i32 1798
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1799
  %filter_index   = tfrt.constant.i32 1800
  %scale_index    = tfrt.constant.i32 1801
  %offset_index   = tfrt.constant.i32 1802
  %mean_index     = tfrt.constant.i32 1803
  %var_index      = tfrt.constant.i32 1804
  %expected_index = tfrt.constant.i32 1805
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1806
  %filter_index   = tfrt.constant.i32 1807
  %scale_index    = tfrt.constant.i32 1808
  %offset_index   = tfrt.constant.i32 1809
  %mean_index     = tfrt.constant.i32 1810
  %var_index      = tfrt.constant.i32 1811
  %expected_index = tfrt.constant.i32 1812
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1813
  %filter_index   = tfrt.constant.i32 1814
  %scale_index    = tfrt.constant.i32 1815
  %offset_index   = tfrt.constant.i32 1816
  %mean_index     = tfrt.constant.i32 1817
  %var_index      = tfrt.constant.i32 1818
  %expected_index = tfrt.constant.i32 1819
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1820
  %filter_index   = tfrt.constant.i32 1821
  %scale_index    = tfrt.constant.i32 1822
  %offset_index   = tfrt.constant.i32 1823
  %mean_index     = tfrt.constant.i32 1824
  %var_index      = tfrt.constant.i32 1825
  %expected_index = tfrt.constant.i32 1826
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1827
  %filter_index   = tfrt.constant.i32 1828
  %scale_index    = tfrt.constant.i32 1829
  %offset_index   = tfrt.constant.i32 1830
  %mean_index     = tfrt.constant.i32 1831
  %var_index      = tfrt.constant.i32 1832
  %expected_index = tfrt.constant.i32 1833
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1834
  %filter_index   = tfrt.constant.i32 1835
  %scale_index    = tfrt.constant.i32 1836
  %offset_index   = tfrt.constant.i32 1837
  %mean_index     = tfrt.constant.i32 1838
  %var_index      = tfrt.constant.i32 1839
  %expected_index = tfrt.constant.i32 1840
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1841
  %filter_index   = tfrt.constant.i32 1842
  %scale_index    = tfrt.constant.i32 1843
  %offset_index   = tfrt.constant.i32 1844
  %mean_index     = tfrt.constant.i32 1845
  %var_index      = tfrt.constant.i32 1846
  %expected_index = tfrt.constant.i32 1847
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1848
  %filter_index   = tfrt.constant.i32 1849
  %scale_index    = tfrt.constant.i32 1850
  %offset_index   = tfrt.constant.i32 1851
  %mean_index     = tfrt.constant.i32 1852
  %var_index      = tfrt.constant.i32 1853
  %expected_index = tfrt.constant.i32 1854
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1855
  %filter_index   = tfrt.constant.i32 1856
  %scale_index    = tfrt.constant.i32 1857
  %offset_index   = tfrt.constant.i32 1858
  %mean_index     = tfrt.constant.i32 1859
  %var_index      = tfrt.constant.i32 1860
  %expected_index = tfrt.constant.i32 1861
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1862
  %filter_index   = tfrt.constant.i32 1863
  %scale_index    = tfrt.constant.i32 1864
  %offset_index   = tfrt.constant.i32 1865
  %mean_index     = tfrt.constant.i32 1866
  %var_index      = tfrt.constant.i32 1867
  %expected_index = tfrt.constant.i32 1868
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1869
  %filter_index   = tfrt.constant.i32 1870
  %scale_index    = tfrt.constant.i32 1871
  %offset_index   = tfrt.constant.i32 1872
  %mean_index     = tfrt.constant.i32 1873
  %var_index      = tfrt.constant.i32 1874
  %expected_index = tfrt.constant.i32 1875
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1876
  %filter_index   = tfrt.constant.i32 1877
  %scale_index    = tfrt.constant.i32 1878
  %offset_index   = tfrt.constant.i32 1879
  %mean_index     = tfrt.constant.i32 1880
  %var_index      = tfrt.constant.i32 1881
  %expected_index = tfrt.constant.i32 1882
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1883
  %filter_index   = tfrt.constant.i32 1884
  %scale_index    = tfrt.constant.i32 1885
  %offset_index   = tfrt.constant.i32 1886
  %mean_index     = tfrt.constant.i32 1887
  %var_index      = tfrt.constant.i32 1888
  %expected_index = tfrt.constant.i32 1889
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1890
  %filter_index   = tfrt.constant.i32 1891
  %scale_index    = tfrt.constant.i32 1892
  %offset_index   = tfrt.constant.i32 1893
  %mean_index     = tfrt.constant.i32 1894
  %var_index      = tfrt.constant.i32 1895
  %expected_index = tfrt.constant.i32 1896
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_1x1_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1897
  %filter_index   = tfrt.constant.i32 1898
  %scale_index    = tfrt.constant.i32 1899
  %offset_index   = tfrt.constant.i32 1900
  %mean_index     = tfrt.constant.i32 1901
  %var_index      = tfrt.constant.i32 1902
  %expected_index = tfrt.constant.i32 1903
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1904
  %filter_index   = tfrt.constant.i32 1905
  %scale_index    = tfrt.constant.i32 1906
  %offset_index   = tfrt.constant.i32 1907
  %mean_index     = tfrt.constant.i32 1908
  %var_index      = tfrt.constant.i32 1909
  %expected_index = tfrt.constant.i32 1910
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1911
  %filter_index   = tfrt.constant.i32 1912
  %scale_index    = tfrt.constant.i32 1913
  %offset_index   = tfrt.constant.i32 1914
  %mean_index     = tfrt.constant.i32 1915
  %var_index      = tfrt.constant.i32 1916
  %expected_index = tfrt.constant.i32 1917
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1918
  %filter_index   = tfrt.constant.i32 1919
  %scale_index    = tfrt.constant.i32 1920
  %offset_index   = tfrt.constant.i32 1921
  %mean_index     = tfrt.constant.i32 1922
  %var_index      = tfrt.constant.i32 1923
  %expected_index = tfrt.constant.i32 1924
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1925
  %filter_index   = tfrt.constant.i32 1926
  %scale_index    = tfrt.constant.i32 1927
  %offset_index   = tfrt.constant.i32 1928
  %mean_index     = tfrt.constant.i32 1929
  %var_index      = tfrt.constant.i32 1930
  %expected_index = tfrt.constant.i32 1931
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1932
  %filter_index   = tfrt.constant.i32 1933
  %scale_index    = tfrt.constant.i32 1934
  %offset_index   = tfrt.constant.i32 1935
  %mean_index     = tfrt.constant.i32 1936
  %var_index      = tfrt.constant.i32 1937
  %expected_index = tfrt.constant.i32 1938
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1939
  %filter_index   = tfrt.constant.i32 1940
  %scale_index    = tfrt.constant.i32 1941
  %offset_index   = tfrt.constant.i32 1942
  %mean_index     = tfrt.constant.i32 1943
  %var_index      = tfrt.constant.i32 1944
  %expected_index = tfrt.constant.i32 1945
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1946
  %filter_index   = tfrt.constant.i32 1947
  %scale_index    = tfrt.constant.i32 1948
  %offset_index   = tfrt.constant.i32 1949
  %mean_index     = tfrt.constant.i32 1950
  %var_index      = tfrt.constant.i32 1951
  %expected_index = tfrt.constant.i32 1952
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1953
  %filter_index   = tfrt.constant.i32 1954
  %scale_index    = tfrt.constant.i32 1955
  %offset_index   = tfrt.constant.i32 1956
  %mean_index     = tfrt.constant.i32 1957
  %var_index      = tfrt.constant.i32 1958
  %expected_index = tfrt.constant.i32 1959
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1960
  %filter_index   = tfrt.constant.i32 1961
  %scale_index    = tfrt.constant.i32 1962
  %offset_index   = tfrt.constant.i32 1963
  %mean_index     = tfrt.constant.i32 1964
  %var_index      = tfrt.constant.i32 1965
  %expected_index = tfrt.constant.i32 1966
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1967
  %filter_index   = tfrt.constant.i32 1968
  %scale_index    = tfrt.constant.i32 1969
  %offset_index   = tfrt.constant.i32 1970
  %mean_index     = tfrt.constant.i32 1971
  %var_index      = tfrt.constant.i32 1972
  %expected_index = tfrt.constant.i32 1973
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1974
  %filter_index   = tfrt.constant.i32 1975
  %scale_index    = tfrt.constant.i32 1976
  %offset_index   = tfrt.constant.i32 1977
  %mean_index     = tfrt.constant.i32 1978
  %var_index      = tfrt.constant.i32 1979
  %expected_index = tfrt.constant.i32 1980
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1981
  %filter_index   = tfrt.constant.i32 1982
  %scale_index    = tfrt.constant.i32 1983
  %offset_index   = tfrt.constant.i32 1984
  %mean_index     = tfrt.constant.i32 1985
  %var_index      = tfrt.constant.i32 1986
  %expected_index = tfrt.constant.i32 1987
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1988
  %filter_index   = tfrt.constant.i32 1989
  %scale_index    = tfrt.constant.i32 1990
  %offset_index   = tfrt.constant.i32 1991
  %mean_index     = tfrt.constant.i32 1992
  %var_index      = tfrt.constant.i32 1993
  %expected_index = tfrt.constant.i32 1994
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1995
  %filter_index   = tfrt.constant.i32 1996
  %scale_index    = tfrt.constant.i32 1997
  %offset_index   = tfrt.constant.i32 1998
  %mean_index     = tfrt.constant.i32 1999
  %var_index      = tfrt.constant.i32 2000
  %expected_index = tfrt.constant.i32 2001
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2002
  %filter_index   = tfrt.constant.i32 2003
  %scale_index    = tfrt.constant.i32 2004
  %offset_index   = tfrt.constant.i32 2005
  %mean_index     = tfrt.constant.i32 2006
  %var_index      = tfrt.constant.i32 2007
  %expected_index = tfrt.constant.i32 2008
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2009
  %filter_index   = tfrt.constant.i32 2010
  %scale_index    = tfrt.constant.i32 2011
  %offset_index   = tfrt.constant.i32 2012
  %mean_index     = tfrt.constant.i32 2013
  %var_index      = tfrt.constant.i32 2014
  %expected_index = tfrt.constant.i32 2015
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2016
  %filter_index   = tfrt.constant.i32 2017
  %scale_index    = tfrt.constant.i32 2018
  %offset_index   = tfrt.constant.i32 2019
  %mean_index     = tfrt.constant.i32 2020
  %var_index      = tfrt.constant.i32 2021
  %expected_index = tfrt.constant.i32 2022
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2023
  %filter_index   = tfrt.constant.i32 2024
  %scale_index    = tfrt.constant.i32 2025
  %offset_index   = tfrt.constant.i32 2026
  %mean_index     = tfrt.constant.i32 2027
  %var_index      = tfrt.constant.i32 2028
  %expected_index = tfrt.constant.i32 2029
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2030
  %filter_index   = tfrt.constant.i32 2031
  %scale_index    = tfrt.constant.i32 2032
  %offset_index   = tfrt.constant.i32 2033
  %mean_index     = tfrt.constant.i32 2034
  %var_index      = tfrt.constant.i32 2035
  %expected_index = tfrt.constant.i32 2036
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2037
  %filter_index   = tfrt.constant.i32 2038
  %scale_index    = tfrt.constant.i32 2039
  %offset_index   = tfrt.constant.i32 2040
  %mean_index     = tfrt.constant.i32 2041
  %var_index      = tfrt.constant.i32 2042
  %expected_index = tfrt.constant.i32 2043
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2044
  %filter_index   = tfrt.constant.i32 2045
  %scale_index    = tfrt.constant.i32 2046
  %offset_index   = tfrt.constant.i32 2047
  %mean_index     = tfrt.constant.i32 2048
  %var_index      = tfrt.constant.i32 2049
  %expected_index = tfrt.constant.i32 2050
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2051
  %filter_index   = tfrt.constant.i32 2052
  %scale_index    = tfrt.constant.i32 2053
  %offset_index   = tfrt.constant.i32 2054
  %mean_index     = tfrt.constant.i32 2055
  %var_index      = tfrt.constant.i32 2056
  %expected_index = tfrt.constant.i32 2057
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2058
  %filter_index   = tfrt.constant.i32 2059
  %scale_index    = tfrt.constant.i32 2060
  %offset_index   = tfrt.constant.i32 2061
  %mean_index     = tfrt.constant.i32 2062
  %var_index      = tfrt.constant.i32 2063
  %expected_index = tfrt.constant.i32 2064
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2065
  %filter_index   = tfrt.constant.i32 2066
  %scale_index    = tfrt.constant.i32 2067
  %offset_index   = tfrt.constant.i32 2068
  %mean_index     = tfrt.constant.i32 2069
  %var_index      = tfrt.constant.i32 2070
  %expected_index = tfrt.constant.i32 2071
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2072
  %filter_index   = tfrt.constant.i32 2073
  %scale_index    = tfrt.constant.i32 2074
  %offset_index   = tfrt.constant.i32 2075
  %mean_index     = tfrt.constant.i32 2076
  %var_index      = tfrt.constant.i32 2077
  %expected_index = tfrt.constant.i32 2078
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2079
  %filter_index   = tfrt.constant.i32 2080
  %scale_index    = tfrt.constant.i32 2081
  %offset_index   = tfrt.constant.i32 2082
  %mean_index     = tfrt.constant.i32 2083
  %var_index      = tfrt.constant.i32 2084
  %expected_index = tfrt.constant.i32 2085
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2086
  %filter_index   = tfrt.constant.i32 2087
  %scale_index    = tfrt.constant.i32 2088
  %offset_index   = tfrt.constant.i32 2089
  %mean_index     = tfrt.constant.i32 2090
  %var_index      = tfrt.constant.i32 2091
  %expected_index = tfrt.constant.i32 2092
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2093
  %filter_index   = tfrt.constant.i32 2094
  %scale_index    = tfrt.constant.i32 2095
  %offset_index   = tfrt.constant.i32 2096
  %mean_index     = tfrt.constant.i32 2097
  %var_index      = tfrt.constant.i32 2098
  %expected_index = tfrt.constant.i32 2099
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2100
  %filter_index   = tfrt.constant.i32 2101
  %scale_index    = tfrt.constant.i32 2102
  %offset_index   = tfrt.constant.i32 2103
  %mean_index     = tfrt.constant.i32 2104
  %var_index      = tfrt.constant.i32 2105
  %expected_index = tfrt.constant.i32 2106
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2107
  %filter_index   = tfrt.constant.i32 2108
  %scale_index    = tfrt.constant.i32 2109
  %offset_index   = tfrt.constant.i32 2110
  %mean_index     = tfrt.constant.i32 2111
  %var_index      = tfrt.constant.i32 2112
  %expected_index = tfrt.constant.i32 2113
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2114
  %filter_index   = tfrt.constant.i32 2115
  %scale_index    = tfrt.constant.i32 2116
  %offset_index   = tfrt.constant.i32 2117
  %mean_index     = tfrt.constant.i32 2118
  %var_index      = tfrt.constant.i32 2119
  %expected_index = tfrt.constant.i32 2120
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_2x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2121
  %filter_index   = tfrt.constant.i32 2122
  %scale_index    = tfrt.constant.i32 2123
  %offset_index   = tfrt.constant.i32 2124
  %mean_index     = tfrt.constant.i32 2125
  %var_index      = tfrt.constant.i32 2126
  %expected_index = tfrt.constant.i32 2127
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2128
  %filter_index   = tfrt.constant.i32 2129
  %scale_index    = tfrt.constant.i32 2130
  %offset_index   = tfrt.constant.i32 2131
  %mean_index     = tfrt.constant.i32 2132
  %var_index      = tfrt.constant.i32 2133
  %expected_index = tfrt.constant.i32 2134
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 6 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2135
  %filter_index   = tfrt.constant.i32 2136
  %scale_index    = tfrt.constant.i32 2137
  %offset_index   = tfrt.constant.i32 2138
  %mean_index     = tfrt.constant.i32 2139
  %var_index      = tfrt.constant.i32 2140
  %expected_index = tfrt.constant.i32 2141
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 6 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2142
  %filter_index   = tfrt.constant.i32 2143
  %scale_index    = tfrt.constant.i32 2144
  %offset_index   = tfrt.constant.i32 2145
  %mean_index     = tfrt.constant.i32 2146
  %var_index      = tfrt.constant.i32 2147
  %expected_index = tfrt.constant.i32 2148
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2149
  %filter_index   = tfrt.constant.i32 2150
  %scale_index    = tfrt.constant.i32 2151
  %offset_index   = tfrt.constant.i32 2152
  %mean_index     = tfrt.constant.i32 2153
  %var_index      = tfrt.constant.i32 2154
  %expected_index = tfrt.constant.i32 2155
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2156
  %filter_index   = tfrt.constant.i32 2157
  %scale_index    = tfrt.constant.i32 2158
  %offset_index   = tfrt.constant.i32 2159
  %mean_index     = tfrt.constant.i32 2160
  %var_index      = tfrt.constant.i32 2161
  %expected_index = tfrt.constant.i32 2162
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 6 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2163
  %filter_index   = tfrt.constant.i32 2164
  %scale_index    = tfrt.constant.i32 2165
  %offset_index   = tfrt.constant.i32 2166
  %mean_index     = tfrt.constant.i32 2167
  %var_index      = tfrt.constant.i32 2168
  %expected_index = tfrt.constant.i32 2169
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 6 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2170
  %filter_index   = tfrt.constant.i32 2171
  %scale_index    = tfrt.constant.i32 2172
  %offset_index   = tfrt.constant.i32 2173
  %mean_index     = tfrt.constant.i32 2174
  %var_index      = tfrt.constant.i32 2175
  %expected_index = tfrt.constant.i32 2176
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2177
  %filter_index   = tfrt.constant.i32 2178
  %scale_index    = tfrt.constant.i32 2179
  %offset_index   = tfrt.constant.i32 2180
  %mean_index     = tfrt.constant.i32 2181
  %var_index      = tfrt.constant.i32 2182
  %expected_index = tfrt.constant.i32 2183
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2184
  %filter_index   = tfrt.constant.i32 2185
  %scale_index    = tfrt.constant.i32 2186
  %offset_index   = tfrt.constant.i32 2187
  %mean_index     = tfrt.constant.i32 2188
  %var_index      = tfrt.constant.i32 2189
  %expected_index = tfrt.constant.i32 2190
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2191
  %filter_index   = tfrt.constant.i32 2192
  %scale_index    = tfrt.constant.i32 2193
  %offset_index   = tfrt.constant.i32 2194
  %mean_index     = tfrt.constant.i32 2195
  %var_index      = tfrt.constant.i32 2196
  %expected_index = tfrt.constant.i32 2197
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2198
  %filter_index   = tfrt.constant.i32 2199
  %scale_index    = tfrt.constant.i32 2200
  %offset_index   = tfrt.constant.i32 2201
  %mean_index     = tfrt.constant.i32 2202
  %var_index      = tfrt.constant.i32 2203
  %expected_index = tfrt.constant.i32 2204
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2205
  %filter_index   = tfrt.constant.i32 2206
  %scale_index    = tfrt.constant.i32 2207
  %offset_index   = tfrt.constant.i32 2208
  %mean_index     = tfrt.constant.i32 2209
  %var_index      = tfrt.constant.i32 2210
  %expected_index = tfrt.constant.i32 2211
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2212
  %filter_index   = tfrt.constant.i32 2213
  %scale_index    = tfrt.constant.i32 2214
  %offset_index   = tfrt.constant.i32 2215
  %mean_index     = tfrt.constant.i32 2216
  %var_index      = tfrt.constant.i32 2217
  %expected_index = tfrt.constant.i32 2218
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2219
  %filter_index   = tfrt.constant.i32 2220
  %scale_index    = tfrt.constant.i32 2221
  %offset_index   = tfrt.constant.i32 2222
  %mean_index     = tfrt.constant.i32 2223
  %var_index      = tfrt.constant.i32 2224
  %expected_index = tfrt.constant.i32 2225
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2226
  %filter_index   = tfrt.constant.i32 2227
  %scale_index    = tfrt.constant.i32 2228
  %offset_index   = tfrt.constant.i32 2229
  %mean_index     = tfrt.constant.i32 2230
  %var_index      = tfrt.constant.i32 2231
  %expected_index = tfrt.constant.i32 2232
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x9x7x10_f_3x2_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2233
  %filter_index   = tfrt.constant.i32 2234
  %scale_index    = tfrt.constant.i32 2235
  %offset_index   = tfrt.constant.i32 2236
  %mean_index     = tfrt.constant.i32 2237
  %var_index      = tfrt.constant.i32 2238
  %expected_index = tfrt.constant.i32 2239
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2240
  %filter_index   = tfrt.constant.i32 2241
  %scale_index    = tfrt.constant.i32 2242
  %offset_index   = tfrt.constant.i32 2243
  %mean_index     = tfrt.constant.i32 2244
  %var_index      = tfrt.constant.i32 2245
  %expected_index = tfrt.constant.i32 2246
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2247
  %filter_index   = tfrt.constant.i32 2248
  %scale_index    = tfrt.constant.i32 2249
  %offset_index   = tfrt.constant.i32 2250
  %mean_index     = tfrt.constant.i32 2251
  %var_index      = tfrt.constant.i32 2252
  %expected_index = tfrt.constant.i32 2253
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2254
  %filter_index   = tfrt.constant.i32 2255
  %scale_index    = tfrt.constant.i32 2256
  %offset_index   = tfrt.constant.i32 2257
  %mean_index     = tfrt.constant.i32 2258
  %var_index      = tfrt.constant.i32 2259
  %expected_index = tfrt.constant.i32 2260
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2261
  %filter_index   = tfrt.constant.i32 2262
  %scale_index    = tfrt.constant.i32 2263
  %offset_index   = tfrt.constant.i32 2264
  %mean_index     = tfrt.constant.i32 2265
  %var_index      = tfrt.constant.i32 2266
  %expected_index = tfrt.constant.i32 2267
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2268
  %filter_index   = tfrt.constant.i32 2269
  %scale_index    = tfrt.constant.i32 2270
  %offset_index   = tfrt.constant.i32 2271
  %mean_index     = tfrt.constant.i32 2272
  %var_index      = tfrt.constant.i32 2273
  %expected_index = tfrt.constant.i32 2274
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2275
  %filter_index   = tfrt.constant.i32 2276
  %scale_index    = tfrt.constant.i32 2277
  %offset_index   = tfrt.constant.i32 2278
  %mean_index     = tfrt.constant.i32 2279
  %var_index      = tfrt.constant.i32 2280
  %expected_index = tfrt.constant.i32 2281
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2282
  %filter_index   = tfrt.constant.i32 2283
  %scale_index    = tfrt.constant.i32 2284
  %offset_index   = tfrt.constant.i32 2285
  %mean_index     = tfrt.constant.i32 2286
  %var_index      = tfrt.constant.i32 2287
  %expected_index = tfrt.constant.i32 2288
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2289
  %filter_index   = tfrt.constant.i32 2290
  %scale_index    = tfrt.constant.i32 2291
  %offset_index   = tfrt.constant.i32 2292
  %mean_index     = tfrt.constant.i32 2293
  %var_index      = tfrt.constant.i32 2294
  %expected_index = tfrt.constant.i32 2295
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2296
  %filter_index   = tfrt.constant.i32 2297
  %scale_index    = tfrt.constant.i32 2298
  %offset_index   = tfrt.constant.i32 2299
  %mean_index     = tfrt.constant.i32 2300
  %var_index      = tfrt.constant.i32 2301
  %expected_index = tfrt.constant.i32 2302
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2303
  %filter_index   = tfrt.constant.i32 2304
  %scale_index    = tfrt.constant.i32 2305
  %offset_index   = tfrt.constant.i32 2306
  %mean_index     = tfrt.constant.i32 2307
  %var_index      = tfrt.constant.i32 2308
  %expected_index = tfrt.constant.i32 2309
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2310
  %filter_index   = tfrt.constant.i32 2311
  %scale_index    = tfrt.constant.i32 2312
  %offset_index   = tfrt.constant.i32 2313
  %mean_index     = tfrt.constant.i32 2314
  %var_index      = tfrt.constant.i32 2315
  %expected_index = tfrt.constant.i32 2316
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2317
  %filter_index   = tfrt.constant.i32 2318
  %scale_index    = tfrt.constant.i32 2319
  %offset_index   = tfrt.constant.i32 2320
  %mean_index     = tfrt.constant.i32 2321
  %var_index      = tfrt.constant.i32 2322
  %expected_index = tfrt.constant.i32 2323
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2324
  %filter_index   = tfrt.constant.i32 2325
  %scale_index    = tfrt.constant.i32 2326
  %offset_index   = tfrt.constant.i32 2327
  %mean_index     = tfrt.constant.i32 2328
  %var_index      = tfrt.constant.i32 2329
  %expected_index = tfrt.constant.i32 2330
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2331
  %filter_index   = tfrt.constant.i32 2332
  %scale_index    = tfrt.constant.i32 2333
  %offset_index   = tfrt.constant.i32 2334
  %mean_index     = tfrt.constant.i32 2335
  %var_index      = tfrt.constant.i32 2336
  %expected_index = tfrt.constant.i32 2337
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2338
  %filter_index   = tfrt.constant.i32 2339
  %scale_index    = tfrt.constant.i32 2340
  %offset_index   = tfrt.constant.i32 2341
  %mean_index     = tfrt.constant.i32 2342
  %var_index      = tfrt.constant.i32 2343
  %expected_index = tfrt.constant.i32 2344
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_1x1_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2345
  %filter_index   = tfrt.constant.i32 2346
  %scale_index    = tfrt.constant.i32 2347
  %offset_index   = tfrt.constant.i32 2348
  %mean_index     = tfrt.constant.i32 2349
  %var_index      = tfrt.constant.i32 2350
  %expected_index = tfrt.constant.i32 2351
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2352
  %filter_index   = tfrt.constant.i32 2353
  %scale_index    = tfrt.constant.i32 2354
  %offset_index   = tfrt.constant.i32 2355
  %mean_index     = tfrt.constant.i32 2356
  %var_index      = tfrt.constant.i32 2357
  %expected_index = tfrt.constant.i32 2358
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2359
  %filter_index   = tfrt.constant.i32 2360
  %scale_index    = tfrt.constant.i32 2361
  %offset_index   = tfrt.constant.i32 2362
  %mean_index     = tfrt.constant.i32 2363
  %var_index      = tfrt.constant.i32 2364
  %expected_index = tfrt.constant.i32 2365
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2366
  %filter_index   = tfrt.constant.i32 2367
  %scale_index    = tfrt.constant.i32 2368
  %offset_index   = tfrt.constant.i32 2369
  %mean_index     = tfrt.constant.i32 2370
  %var_index      = tfrt.constant.i32 2371
  %expected_index = tfrt.constant.i32 2372
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2373
  %filter_index   = tfrt.constant.i32 2374
  %scale_index    = tfrt.constant.i32 2375
  %offset_index   = tfrt.constant.i32 2376
  %mean_index     = tfrt.constant.i32 2377
  %var_index      = tfrt.constant.i32 2378
  %expected_index = tfrt.constant.i32 2379
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2380
  %filter_index   = tfrt.constant.i32 2381
  %scale_index    = tfrt.constant.i32 2382
  %offset_index   = tfrt.constant.i32 2383
  %mean_index     = tfrt.constant.i32 2384
  %var_index      = tfrt.constant.i32 2385
  %expected_index = tfrt.constant.i32 2386
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2387
  %filter_index   = tfrt.constant.i32 2388
  %scale_index    = tfrt.constant.i32 2389
  %offset_index   = tfrt.constant.i32 2390
  %mean_index     = tfrt.constant.i32 2391
  %var_index      = tfrt.constant.i32 2392
  %expected_index = tfrt.constant.i32 2393
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2394
  %filter_index   = tfrt.constant.i32 2395
  %scale_index    = tfrt.constant.i32 2396
  %offset_index   = tfrt.constant.i32 2397
  %mean_index     = tfrt.constant.i32 2398
  %var_index      = tfrt.constant.i32 2399
  %expected_index = tfrt.constant.i32 2400
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2401
  %filter_index   = tfrt.constant.i32 2402
  %scale_index    = tfrt.constant.i32 2403
  %offset_index   = tfrt.constant.i32 2404
  %mean_index     = tfrt.constant.i32 2405
  %var_index      = tfrt.constant.i32 2406
  %expected_index = tfrt.constant.i32 2407
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2408
  %filter_index   = tfrt.constant.i32 2409
  %scale_index    = tfrt.constant.i32 2410
  %offset_index   = tfrt.constant.i32 2411
  %mean_index     = tfrt.constant.i32 2412
  %var_index      = tfrt.constant.i32 2413
  %expected_index = tfrt.constant.i32 2414
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2415
  %filter_index   = tfrt.constant.i32 2416
  %scale_index    = tfrt.constant.i32 2417
  %offset_index   = tfrt.constant.i32 2418
  %mean_index     = tfrt.constant.i32 2419
  %var_index      = tfrt.constant.i32 2420
  %expected_index = tfrt.constant.i32 2421
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2422
  %filter_index   = tfrt.constant.i32 2423
  %scale_index    = tfrt.constant.i32 2424
  %offset_index   = tfrt.constant.i32 2425
  %mean_index     = tfrt.constant.i32 2426
  %var_index      = tfrt.constant.i32 2427
  %expected_index = tfrt.constant.i32 2428
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2429
  %filter_index   = tfrt.constant.i32 2430
  %scale_index    = tfrt.constant.i32 2431
  %offset_index   = tfrt.constant.i32 2432
  %mean_index     = tfrt.constant.i32 2433
  %var_index      = tfrt.constant.i32 2434
  %expected_index = tfrt.constant.i32 2435
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2436
  %filter_index   = tfrt.constant.i32 2437
  %scale_index    = tfrt.constant.i32 2438
  %offset_index   = tfrt.constant.i32 2439
  %mean_index     = tfrt.constant.i32 2440
  %var_index      = tfrt.constant.i32 2441
  %expected_index = tfrt.constant.i32 2442
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2443
  %filter_index   = tfrt.constant.i32 2444
  %scale_index    = tfrt.constant.i32 2445
  %offset_index   = tfrt.constant.i32 2446
  %mean_index     = tfrt.constant.i32 2447
  %var_index      = tfrt.constant.i32 2448
  %expected_index = tfrt.constant.i32 2449
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2450
  %filter_index   = tfrt.constant.i32 2451
  %scale_index    = tfrt.constant.i32 2452
  %offset_index   = tfrt.constant.i32 2453
  %mean_index     = tfrt.constant.i32 2454
  %var_index      = tfrt.constant.i32 2455
  %expected_index = tfrt.constant.i32 2456
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2457
  %filter_index   = tfrt.constant.i32 2458
  %scale_index    = tfrt.constant.i32 2459
  %offset_index   = tfrt.constant.i32 2460
  %mean_index     = tfrt.constant.i32 2461
  %var_index      = tfrt.constant.i32 2462
  %expected_index = tfrt.constant.i32 2463
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2464
  %filter_index   = tfrt.constant.i32 2465
  %scale_index    = tfrt.constant.i32 2466
  %offset_index   = tfrt.constant.i32 2467
  %mean_index     = tfrt.constant.i32 2468
  %var_index      = tfrt.constant.i32 2469
  %expected_index = tfrt.constant.i32 2470
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2471
  %filter_index   = tfrt.constant.i32 2472
  %scale_index    = tfrt.constant.i32 2473
  %offset_index   = tfrt.constant.i32 2474
  %mean_index     = tfrt.constant.i32 2475
  %var_index      = tfrt.constant.i32 2476
  %expected_index = tfrt.constant.i32 2477
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2478
  %filter_index   = tfrt.constant.i32 2479
  %scale_index    = tfrt.constant.i32 2480
  %offset_index   = tfrt.constant.i32 2481
  %mean_index     = tfrt.constant.i32 2482
  %var_index      = tfrt.constant.i32 2483
  %expected_index = tfrt.constant.i32 2484
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2485
  %filter_index   = tfrt.constant.i32 2486
  %scale_index    = tfrt.constant.i32 2487
  %offset_index   = tfrt.constant.i32 2488
  %mean_index     = tfrt.constant.i32 2489
  %var_index      = tfrt.constant.i32 2490
  %expected_index = tfrt.constant.i32 2491
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2492
  %filter_index   = tfrt.constant.i32 2493
  %scale_index    = tfrt.constant.i32 2494
  %offset_index   = tfrt.constant.i32 2495
  %mean_index     = tfrt.constant.i32 2496
  %var_index      = tfrt.constant.i32 2497
  %expected_index = tfrt.constant.i32 2498
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2499
  %filter_index   = tfrt.constant.i32 2500
  %scale_index    = tfrt.constant.i32 2501
  %offset_index   = tfrt.constant.i32 2502
  %mean_index     = tfrt.constant.i32 2503
  %var_index      = tfrt.constant.i32 2504
  %expected_index = tfrt.constant.i32 2505
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2506
  %filter_index   = tfrt.constant.i32 2507
  %scale_index    = tfrt.constant.i32 2508
  %offset_index   = tfrt.constant.i32 2509
  %mean_index     = tfrt.constant.i32 2510
  %var_index      = tfrt.constant.i32 2511
  %expected_index = tfrt.constant.i32 2512
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2513
  %filter_index   = tfrt.constant.i32 2514
  %scale_index    = tfrt.constant.i32 2515
  %offset_index   = tfrt.constant.i32 2516
  %mean_index     = tfrt.constant.i32 2517
  %var_index      = tfrt.constant.i32 2518
  %expected_index = tfrt.constant.i32 2519
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2520
  %filter_index   = tfrt.constant.i32 2521
  %scale_index    = tfrt.constant.i32 2522
  %offset_index   = tfrt.constant.i32 2523
  %mean_index     = tfrt.constant.i32 2524
  %var_index      = tfrt.constant.i32 2525
  %expected_index = tfrt.constant.i32 2526
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2527
  %filter_index   = tfrt.constant.i32 2528
  %scale_index    = tfrt.constant.i32 2529
  %offset_index   = tfrt.constant.i32 2530
  %mean_index     = tfrt.constant.i32 2531
  %var_index      = tfrt.constant.i32 2532
  %expected_index = tfrt.constant.i32 2533
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2534
  %filter_index   = tfrt.constant.i32 2535
  %scale_index    = tfrt.constant.i32 2536
  %offset_index   = tfrt.constant.i32 2537
  %mean_index     = tfrt.constant.i32 2538
  %var_index      = tfrt.constant.i32 2539
  %expected_index = tfrt.constant.i32 2540
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2541
  %filter_index   = tfrt.constant.i32 2542
  %scale_index    = tfrt.constant.i32 2543
  %offset_index   = tfrt.constant.i32 2544
  %mean_index     = tfrt.constant.i32 2545
  %var_index      = tfrt.constant.i32 2546
  %expected_index = tfrt.constant.i32 2547
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2548
  %filter_index   = tfrt.constant.i32 2549
  %scale_index    = tfrt.constant.i32 2550
  %offset_index   = tfrt.constant.i32 2551
  %mean_index     = tfrt.constant.i32 2552
  %var_index      = tfrt.constant.i32 2553
  %expected_index = tfrt.constant.i32 2554
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2555
  %filter_index   = tfrt.constant.i32 2556
  %scale_index    = tfrt.constant.i32 2557
  %offset_index   = tfrt.constant.i32 2558
  %mean_index     = tfrt.constant.i32 2559
  %var_index      = tfrt.constant.i32 2560
  %expected_index = tfrt.constant.i32 2561
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2562
  %filter_index   = tfrt.constant.i32 2563
  %scale_index    = tfrt.constant.i32 2564
  %offset_index   = tfrt.constant.i32 2565
  %mean_index     = tfrt.constant.i32 2566
  %var_index      = tfrt.constant.i32 2567
  %expected_index = tfrt.constant.i32 2568
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_2x3_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2569
  %filter_index   = tfrt.constant.i32 2570
  %scale_index    = tfrt.constant.i32 2571
  %offset_index   = tfrt.constant.i32 2572
  %mean_index     = tfrt.constant.i32 2573
  %var_index      = tfrt.constant.i32 2574
  %expected_index = tfrt.constant.i32 2575
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2576
  %filter_index   = tfrt.constant.i32 2577
  %scale_index    = tfrt.constant.i32 2578
  %offset_index   = tfrt.constant.i32 2579
  %mean_index     = tfrt.constant.i32 2580
  %var_index      = tfrt.constant.i32 2581
  %expected_index = tfrt.constant.i32 2582
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2583
  %filter_index   = tfrt.constant.i32 2584
  %scale_index    = tfrt.constant.i32 2585
  %offset_index   = tfrt.constant.i32 2586
  %mean_index     = tfrt.constant.i32 2587
  %var_index      = tfrt.constant.i32 2588
  %expected_index = tfrt.constant.i32 2589
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2590
  %filter_index   = tfrt.constant.i32 2591
  %scale_index    = tfrt.constant.i32 2592
  %offset_index   = tfrt.constant.i32 2593
  %mean_index     = tfrt.constant.i32 2594
  %var_index      = tfrt.constant.i32 2595
  %expected_index = tfrt.constant.i32 2596
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2597
  %filter_index   = tfrt.constant.i32 2598
  %scale_index    = tfrt.constant.i32 2599
  %offset_index   = tfrt.constant.i32 2600
  %mean_index     = tfrt.constant.i32 2601
  %var_index      = tfrt.constant.i32 2602
  %expected_index = tfrt.constant.i32 2603
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2604
  %filter_index   = tfrt.constant.i32 2605
  %scale_index    = tfrt.constant.i32 2606
  %offset_index   = tfrt.constant.i32 2607
  %mean_index     = tfrt.constant.i32 2608
  %var_index      = tfrt.constant.i32 2609
  %expected_index = tfrt.constant.i32 2610
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2611
  %filter_index   = tfrt.constant.i32 2612
  %scale_index    = tfrt.constant.i32 2613
  %offset_index   = tfrt.constant.i32 2614
  %mean_index     = tfrt.constant.i32 2615
  %var_index      = tfrt.constant.i32 2616
  %expected_index = tfrt.constant.i32 2617
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 8 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2618
  %filter_index   = tfrt.constant.i32 2619
  %scale_index    = tfrt.constant.i32 2620
  %offset_index   = tfrt.constant.i32 2621
  %mean_index     = tfrt.constant.i32 2622
  %var_index      = tfrt.constant.i32 2623
  %expected_index = tfrt.constant.i32 2624
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_valid_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2625
  %filter_index   = tfrt.constant.i32 2626
  %scale_index    = tfrt.constant.i32 2627
  %offset_index   = tfrt.constant.i32 2628
  %mean_index     = tfrt.constant.i32 2629
  %var_index      = tfrt.constant.i32 2630
  %expected_index = tfrt.constant.i32 2631
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "valid",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_1x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_1x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2632
  %filter_index   = tfrt.constant.i32 2633
  %scale_index    = tfrt.constant.i32 2634
  %offset_index   = tfrt.constant.i32 2635
  %mean_index     = tfrt.constant.i32 2636
  %var_index      = tfrt.constant.i32 2637
  %expected_index = tfrt.constant.i32 2638
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_1x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_1x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2639
  %filter_index   = tfrt.constant.i32 2640
  %scale_index    = tfrt.constant.i32 2641
  %offset_index   = tfrt.constant.i32 2642
  %mean_index     = tfrt.constant.i32 2643
  %var_index      = tfrt.constant.i32 2644
  %expected_index = tfrt.constant.i32 2645
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_1x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_1x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2646
  %filter_index   = tfrt.constant.i32 2647
  %scale_index    = tfrt.constant.i32 2648
  %offset_index   = tfrt.constant.i32 2649
  %mean_index     = tfrt.constant.i32 2650
  %var_index      = tfrt.constant.i32 2651
  %expected_index = tfrt.constant.i32 2652
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_1x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_1x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2653
  %filter_index   = tfrt.constant.i32 2654
  %scale_index    = tfrt.constant.i32 2655
  %offset_index   = tfrt.constant.i32 2656
  %mean_index     = tfrt.constant.i32 2657
  %var_index      = tfrt.constant.i32 2658
  %expected_index = tfrt.constant.i32 2659
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_2x1_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_2x1_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2660
  %filter_index   = tfrt.constant.i32 2661
  %scale_index    = tfrt.constant.i32 2662
  %offset_index   = tfrt.constant.i32 2663
  %mean_index     = tfrt.constant.i32 2664
  %var_index      = tfrt.constant.i32 2665
  %expected_index = tfrt.constant.i32 2666
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_2x1_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_2x1_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2667
  %filter_index   = tfrt.constant.i32 2668
  %scale_index    = tfrt.constant.i32 2669
  %offset_index   = tfrt.constant.i32 2670
  %mean_index     = tfrt.constant.i32 2671
  %var_index      = tfrt.constant.i32 2672
  %expected_index = tfrt.constant.i32 2673
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_2x2_eps0.01'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_2x2_eps0.01() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2674
  %filter_index   = tfrt.constant.i32 2675
  %scale_index    = tfrt.constant.i32 2676
  %offset_index   = tfrt.constant.i32 2677
  %mean_index     = tfrt.constant.i32 2678
  %var_index      = tfrt.constant.i32 2679
  %expected_index = tfrt.constant.i32 2680
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.01 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_2x2_eps0.001'
func.func @test_conv2d_batch_norm_in_1x7x9x10_f_3x2_c16_padding_same_s_2x2_eps0.001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2681
  %filter_index   = tfrt.constant.i32 2682
  %scale_index    = tfrt.constant.i32 2683
  %offset_index   = tfrt.constant.i32 2684
  %mean_index     = tfrt.constant.i32 2685
  %var_index      = tfrt.constant.i32 2686
  %expected_index = tfrt.constant.i32 2687
  
  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %scale = "btf.read_dense_tensor.f32.1"(%path, %scale_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %offset = "btf.read_dense_tensor.f32.1"(%path, %offset_index)
    : (!tfrt.string, i32) -> (!t.tensor)    
    
  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)
    
  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)        

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 16 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.batch_norm.f32"(%input, %filter, %scale, %offset, %mean,
                                       %var, %output, %ch0)
    {  epsilon = 0.001 : f32, padding = "same",
        strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !t.tensor, !t.tensor, !tfrt.chain
      ) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}
