; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   -riscv-experimental-rv64-legal-i32 | FileCheck -check-prefix=RV64I %s

; Check indexed and unindexed, sext, zext and anyext loads

define void @lb(ptr %a, ptr %b) nounwind {
; RV64I-LABEL: lb:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lb a2, 1(a0)
; RV64I-NEXT:    lbu zero, 0(a0)
; RV64I-NEXT:    sw a2, 0(a1)
; RV64I-NEXT:    ret
  %1 = getelementptr i8, ptr %a, i32 1
  %2 = load i8, ptr %1
  %3 = sext i8 %2 to i32
  ; the unused load will produce an anyext for selection
  %4 = load volatile i8, ptr %a
  store i32 %3, ptr %b
  ret void
}

define void @lbu(ptr %a, ptr %b) nounwind {
; RV64I-LABEL: lbu:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a0, 1(a0)
; RV64I-NEXT:    sw a0, 0(a1)
; RV64I-NEXT:    ret
  %1 = getelementptr i8, ptr %a, i32 1
  %2 = load i8, ptr %1
  %3 = zext i8 %2 to i32
  store i32 %3, ptr %b
  ret void
}

define void @lh(ptr %a, ptr %b) nounwind {
; RV64I-LABEL: lh:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lh a2, 2(a0)
; RV64I-NEXT:    lh zero, 0(a0)
; RV64I-NEXT:    sw a2, 0(a1)
; RV64I-NEXT:    ret
  %1 = getelementptr i16, ptr %a, i32 1
  %2 = load i16, ptr %1
  %3 = sext i16 %2 to i32
  ; the unused load will produce an anyext for selection
  %4 = load volatile i16, ptr %a
  store i32 %3, ptr %b
  ret void
}

define void @lhu(ptr %a, ptr %b) nounwind {
; RV64I-LABEL: lhu:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lhu a0, 2(a0)
; RV64I-NEXT:    sw a0, 0(a1)
; RV64I-NEXT:    ret
  %1 = getelementptr i16, ptr %a, i32 1
  %2 = load i16, ptr %1
  %3 = zext i16 %2 to i32
  store i32 %3, ptr %b
  ret void
}

define void @lw(ptr %a, ptr %b) nounwind {
; RV64I-LABEL: lw:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lw a2, 4(a0)
; RV64I-NEXT:    lw zero, 0(a0)
; RV64I-NEXT:    sd a2, 0(a1)
; RV64I-NEXT:    ret
  %1 = getelementptr i32, ptr %a, i64 1
  %2 = load i32, ptr %1
  %3 = sext i32 %2 to i64
  ; the unused load will produce an anyext for selection
  %4 = load volatile i32, ptr %a
  store i64 %3, ptr %b
  ret void
}

define void @lwu(ptr %a, ptr %b) nounwind {
; RV64I-LABEL: lwu:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lwu a0, 4(a0)
; RV64I-NEXT:    sd a0, 0(a1)
; RV64I-NEXT:    ret
  %1 = getelementptr i32, ptr %a, i64 1
  %2 = load i32, ptr %1
  %3 = zext i32 %2 to i64
  store i64 %3, ptr %b
  ret void
}
