import { Channel } from '@storybook/channels';
import KnobStore from './KnobStore';
import { Knob, KnobType, Mutable } from './type-defs';
interface KnobManagerOptions {
    escapeHTML?: boolean;
    disableDebounce?: boolean;
    disableForceUpdate?: boolean;
}
export default class KnobManager {
    knobStore: KnobStore;
    channel: Channel | undefined;
    options: KnobManagerOptions;
    calling: boolean;
    setChannel(channel: Channel): void;
    setOptions(options: KnobManagerOptions): void;
    getKnobValue({ value }: Knob): any;
    knob<T extends KnobType = any>(name: string, options: Knob<T>): Mutable<Knob<T>['value']>;
    _mayCallChannel(): void;
}
export {};
