import { Knob, KnobType, Mutable } from './type-defs';
import { NumberTypeKnobOptions, ButtonTypeOnClickProp, RadiosTypeOptionsProp, SelectTypeOptionsProp, SelectTypeKnobValue, OptionsTypeKnobValue, OptionsTypeOptionsProp, OptionsTypeKnobSingleValue, OptionsKnobOptions, RadiosTypeKnobValue, ArrayTypeKnobValue } from './components/types';
export declare function knob<T extends KnobType, V = Mutable<Knob<T>['value']>>(name: string, options: Knob<T>): V;
export declare function text(name: string, value: string, groupId?: string): string;
export declare function boolean(name: string, value: boolean, groupId?: string): boolean;
export declare function number(name: string, value: number, options?: NumberTypeKnobOptions, groupId?: string): number;
export declare function color(name: string, value: string, groupId?: string): string;
export declare function object<T>(name: string, value: T, groupId?: string): T;
export declare function select<T extends SelectTypeKnobValue>(name: string, options: SelectTypeOptionsProp<T>, value: T, groupId?: string): T;
export declare function radios<T extends RadiosTypeKnobValue>(name: string, options: RadiosTypeOptionsProp<T>, value: T, groupId?: string): T;
export declare function array(name: string, value: ArrayTypeKnobValue, separator?: string, groupId?: string): string[];
export declare function date(name: string, value?: Date, groupId?: string): number;
export declare function button(name: string, callback: ButtonTypeOnClickProp, groupId?: string): undefined;
export declare function files(name: string, accept: string, value?: string[], groupId?: string): string[];
export declare function optionsKnob<T extends OptionsTypeKnobSingleValue>(name: string, valuesObj: OptionsTypeOptionsProp<T>, value: OptionsTypeKnobValue<T>, optionsObj: OptionsKnobOptions, groupId?: string): T;
export declare const withKnobs: (...args: any) => any;
export * from './shared';
