"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.promise");

require("regenerator-runtime/runtime");

var _sveltedocParser = _interopRequireDefault(require("sveltedoc-parser"));

var fs = _interopRequireWildcard(require("fs"));

var _extractArgTypes = require("./extractArgTypes");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var content = fs.readFileSync("".concat(__dirname, "/sample/MockButton.svelte"), 'utf-8');
describe('Extracting Arguments', function () {
  it('should be svelte', function () {
    expect(content).toMatchInlineSnapshot("\n      <script>\n        import { createEventDispatcher, afterUpdate } from 'svelte';\n        export let text = '';\n        export let rounded = true;\n\n        const dispatch = createEventDispatcher();\n\n        function onClick(event) {\n          rounded = !rounded;\n\n          dispatch('click', event);\n        }\n\n        afterUpdate(() => {\n          dispatch('afterUpdate');\n        });\n      </script>\n      <style>\n        .rounded {\n          border-radius: 35px;\n        }\n\n        .button {\n          border: 3px solid;\n          padding: 10px 20px;\n          background-color: white;\n          outline: none;\n        }\n      </style>\n      <svelte:options accessors=\"{true}\">\n      </svelte:options>\n      <button class=\"button\"\n              class:rounded\n              on:click=\"{onClick}\"\n      >\n        <strong>\n          {rounded ? 'Round' : 'Square'} corners\n        </strong>\n        <br>\n        {text}\n        <slot>\n        </slot>\n      </button>\n    ");
  });
  it('should generate ArgTypes', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
    var doc, results;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return _sveltedocParser["default"].parse({
              fileContent: content,
              version: 3
            });

          case 2:
            doc = _context.sent;
            results = (0, _extractArgTypes.createArgTypes)(doc);
            expect(results).toMatchInlineSnapshot("\n      Object {\n        \"rounded\": Object {\n          \"control\": Object {\n            \"type\": \"boolean\",\n          },\n          \"defaultValue\": true,\n          \"description\": null,\n          \"name\": \"rounded\",\n          \"table\": Object {\n            \"defaultValue\": Object {\n              \"summary\": true,\n            },\n          },\n          \"type\": Object {},\n        },\n        \"text\": Object {\n          \"control\": Object {\n            \"type\": \"text\",\n          },\n          \"defaultValue\": \"\",\n          \"description\": null,\n          \"name\": \"text\",\n          \"table\": Object {\n            \"defaultValue\": Object {\n              \"summary\": \"\",\n            },\n          },\n          \"type\": Object {},\n        },\n      }\n    ");

          case 5:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })));
});