"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.index-of");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.date.to-string");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.create");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.get-prototype-of");

require("core-js/modules/es.object.keys");

require("core-js/modules/es.object.set-prototype-of");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.reflect.construct");

require("core-js/modules/es.regexp.exec");

require("core-js/modules/es.regexp.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/es.string.replace");

require("core-js/modules/web.dom-collections.for-each");

require("core-js/modules/web.dom-collections.iterator");

var _react = _interopRequireDefault(require("react"));

var _docgen = require("../../../lib/docgen");

var _handleProp = require("./handleProp");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var DOCGEN_SECTION = 'props';

function ReactComponent() {
  return /*#__PURE__*/_react["default"].createElement("div", null, "React Component!");
}

function createDocgenSection(docgenInfo) {
  return _defineProperty({}, DOCGEN_SECTION, Object.assign({}, docgenInfo));
}

function createDocgenProp(_ref2) {
  var name = _ref2.name,
      tsType = _ref2.tsType,
      others = _objectWithoutProperties(_ref2, ["name", "tsType"]);

  return _defineProperty({}, name, Object.assign({
    tsType: tsType,
    required: false
  }, others));
} // eslint-disable-next-line react/forbid-foreign-prop-types


function createComponent(_ref4) {
  var _ref4$propTypes = _ref4.propTypes,
      propTypes = _ref4$propTypes === void 0 ? {} : _ref4$propTypes,
      _ref4$defaultProps = _ref4.defaultProps,
      defaultProps = _ref4$defaultProps === void 0 ? {} : _ref4$defaultProps,
      _ref4$docgenInfo = _ref4.docgenInfo,
      docgenInfo = _ref4$docgenInfo === void 0 ? {} : _ref4$docgenInfo;

  var component = function component() {
    return /*#__PURE__*/_react["default"].createElement("div", null, "Hey!");
  };

  component.propTypes = propTypes;
  component.defaultProps = defaultProps; // @ts-ignore

  component.__docgenInfo = createDocgenSection(docgenInfo);
  return component;
}

function createDefaultValue(defaultValue) {
  return {
    value: defaultValue
  };
}

function extractPropDef(component, rawDefaultProp) {
  return (0, _handleProp.enhanceTypeScriptProp)((0, _docgen.extractComponentProps)(component, DOCGEN_SECTION)[0], rawDefaultProp);
}

describe('enhanceTypeScriptProp', function () {
  describe('defaultValue', function () {
    function createTestComponent(defaultValue) {
      var typeName = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'anything-is-fine';
      return createComponent({
        docgenInfo: Object.assign({}, createDocgenProp({
          name: 'prop',
          tsType: {
            name: typeName
          },
          defaultValue: defaultValue
        }))
      });
    }

    it('should support short object', function () {
      var component = createTestComponent(createDefaultValue("{ foo: 'foo', bar: 'bar' }"));

      var _extractPropDef = extractPropDef(component),
          defaultValue = _extractPropDef.defaultValue;

      var expectedSummary = "{ foo: 'foo', bar: 'bar' }";
      expect(defaultValue.summary.replace(/\s/g, '')).toBe(expectedSummary.replace(/\s/g, ''));
      expect(defaultValue.detail).toBeUndefined();
    });
    it('should support long object', function () {
      var component = createTestComponent(createDefaultValue("{ foo: 'foo', bar: 'bar', another: 'another' }"));

      var _extractPropDef2 = extractPropDef(component),
          defaultValue = _extractPropDef2.defaultValue;

      expect(defaultValue.summary).toBe('object');
      var expectedDetail = "{\n        foo: 'foo',\n        bar: 'bar',\n        another: 'another'\n      }";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should not have deep object in summary', function () {
      var component = createTestComponent(createDefaultValue("{ foo: 'foo', bar: { hey: 'ho' } }"));

      var _extractPropDef3 = extractPropDef(component),
          defaultValue = _extractPropDef3.defaultValue;

      expect(defaultValue.summary).toBe('object');
    });
    it('should support short function', function () {
      var component = createTestComponent(createDefaultValue('() => {}'));

      var _extractPropDef4 = extractPropDef(component),
          defaultValue = _extractPropDef4.defaultValue;

      expect(defaultValue.summary).toBe('() => {}');
      expect(defaultValue.detail).toBeUndefined();
    });
    it('should support long function', function () {
      var component = createTestComponent(createDefaultValue('(foo, bar) => {\n  const concat = foo + bar;\n  const append = concat + " hey!";\n  \n  return append;\n}'));

      var _extractPropDef5 = extractPropDef(component),
          defaultValue = _extractPropDef5.defaultValue;

      expect(defaultValue.summary).toBe('func');
      var expectedDetail = "(foo, bar) => {\n        const concat = foo + bar;\n        const append = concat + ' hey!';\n        return append\n      }";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should use the name of function when available and indicate that args are present', function () {
      var component = createTestComponent(createDefaultValue('function concat(a, b) {\n  return a + b;\n}'));

      var _extractPropDef6 = extractPropDef(component),
          defaultValue = _extractPropDef6.defaultValue;

      expect(defaultValue.summary).toBe('concat( ... )');
      var expectedDetail = "function concat(a, b) {\n        return a + b\n      }";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should use the name of function when available', function () {
      var component = createTestComponent(createDefaultValue('function hello() {\n  return "hello";\n}'));

      var _extractPropDef7 = extractPropDef(component),
          defaultValue = _extractPropDef7.defaultValue;

      expect(defaultValue.summary).toBe('hello()');
      var expectedDetail = "function hello() {\n        return 'hello'\n      }";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should support short element', function () {
      var component = createTestComponent(createDefaultValue('<div>Hey!</div>'));

      var _extractPropDef8 = extractPropDef(component),
          defaultValue = _extractPropDef8.defaultValue;

      expect(defaultValue.summary).toBe('<div>Hey!</div>');
      expect(defaultValue.detail).toBeUndefined();
    });
    it('should support long element', function () {
      var component = createTestComponent(createDefaultValue('<div>Hey! Hey! Hey!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</div>'));

      var _extractPropDef9 = extractPropDef(component),
          defaultValue = _extractPropDef9.defaultValue;

      expect(defaultValue.summary).toBe('element');
      expect(defaultValue.detail).toBe('<div>Hey! Hey! Hey!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</div>');
    });
    it('should support element with props', function () {
      var component = createTestComponent(createDefaultValue('<Component className="toto" />'));

      var _extractPropDef10 = extractPropDef(component),
          defaultValue = _extractPropDef10.defaultValue;

      expect(defaultValue.summary).toBe('<Component />');
      expect(defaultValue.detail).toBe('<Component className="toto" />');
    });
    it("should use the name of the React component when it's available", function () {
      var component = createTestComponent(createDefaultValue('function InlinedFunctionalComponent() {\n  return <div>Inlined FunctionalComponent!</div>;\n}'));

      var _extractPropDef11 = extractPropDef(component),
          defaultValue = _extractPropDef11.defaultValue;

      expect(defaultValue.summary).toBe('<InlinedFunctionalComponent />');
      var expectedDetail = "function InlinedFunctionalComponent() {\n        return <div>Inlined FunctionalComponent!</div>;\n      }";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should not use the name of an HTML element', function () {
      var component = createTestComponent(createDefaultValue('<div>Hey!</div>'));

      var _extractPropDef12 = extractPropDef(component),
          defaultValue = _extractPropDef12.defaultValue;

      expect(defaultValue.summary).not.toBe('<div />');
    });
    it('should support short array', function () {
      var component = createTestComponent(createDefaultValue('[1]'));

      var _extractPropDef13 = extractPropDef(component),
          defaultValue = _extractPropDef13.defaultValue;

      expect(defaultValue.summary).toBe('[1]');
      expect(defaultValue.detail).toBeUndefined();
    });
    it('should support long array', function () {
      var component = createTestComponent(createDefaultValue('[\n  {\n    thing: {\n      id: 2,\n      func: () => {},\n      arr: [],\n    },\n  },\n]'));

      var _extractPropDef14 = extractPropDef(component),
          defaultValue = _extractPropDef14.defaultValue;

      expect(defaultValue.summary).toBe('array');
      var expectedDetail = "[{\n          thing: {\n            id: 2,\n            func: () => {\n            },\n            arr: []\n          }\n        }]";
      expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
    });
    it('should not have deep array in summary', function () {
      var component = createTestComponent(createDefaultValue('[[[1]]]'));

      var _extractPropDef15 = extractPropDef(component),
          defaultValue = _extractPropDef15.defaultValue;

      expect(defaultValue.summary).toBe('array');
    });
    describe('fromRawDefaultProp', function () {
      [{
        type: 'string',
        defaultProp: 'foo'
      }, {
        type: 'number',
        defaultProp: 1
      }, {
        type: 'boolean',
        defaultProp: true
      }, {
        type: 'symbol',
        defaultProp: Symbol('hey!')
      }].forEach(function (x) {
        it("should support ".concat(x.type), function () {
          var component = createTestComponent(null);

          var _extractPropDef16 = extractPropDef(component, x.defaultProp),
              defaultValue = _extractPropDef16.defaultValue;

          expect(defaultValue.summary).toBe(x.defaultProp.toString());
          expect(defaultValue.detail).toBeUndefined();
        });
      });
      it('should support array of primitives', function () {
        var component = createTestComponent(null);

        var _extractPropDef17 = extractPropDef(component, [1, 2, 3]),
            defaultValue = _extractPropDef17.defaultValue;

        expect(defaultValue.summary).toBe('[1,    2,    3]');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support array of short object', function () {
        var component = createTestComponent(null);

        var _extractPropDef18 = extractPropDef(component, [{
          foo: 'bar'
        }]),
            defaultValue = _extractPropDef18.defaultValue;

        expect(defaultValue.summary).toBe("[{ 'foo': 'bar' }]");
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support array of long object', function () {
        var component = createTestComponent(null);

        var _extractPropDef19 = extractPropDef(component, [{
          foo: 'bar',
          bar: 'foo',
          hey: 'ho'
        }]),
            defaultValue = _extractPropDef19.defaultValue;

        expect(defaultValue.summary).toBe('array');
        var expectedDetail = "[{\n          'foo': 'bar',\n          'bar': 'foo',\n          'hey': 'ho'\n        }]";
        expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
      });
      it('should support short object', function () {
        var component = createTestComponent(null);

        var _extractPropDef20 = extractPropDef(component, {
          foo: 'bar'
        }),
            defaultValue = _extractPropDef20.defaultValue;

        expect(defaultValue.summary).toBe("{ 'foo': 'bar' }");
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support long object', function () {
        var component = createTestComponent(null);

        var _extractPropDef21 = extractPropDef(component, {
          foo: 'bar',
          bar: 'foo',
          hey: 'ho'
        }),
            defaultValue = _extractPropDef21.defaultValue;

        expect(defaultValue.summary).toBe('object');
        var expectedDetail = "{\n          'foo': 'bar',\n          'bar': 'foo',\n          'hey': 'ho'\n        }";
        expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
      });
      it('should support anonymous function', function () {
        var component = createTestComponent(null);

        var _extractPropDef22 = extractPropDef(component, function () {
          return 'hey!';
        }),
            defaultValue = _extractPropDef22.defaultValue;

        expect(defaultValue.summary).toBe('func');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support named function', function () {
        var component = createTestComponent(null);

        var _extractPropDef23 = extractPropDef(component, function hello() {
          return 'world!';
        }),
            defaultValue = _extractPropDef23.defaultValue;

        expect(defaultValue.summary).toBe('hello()');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support named function with params', function () {
        var component = createTestComponent(null);

        var _extractPropDef24 = extractPropDef(component, function add(a, b) {
          return a + b;
        }),
            defaultValue = _extractPropDef24.defaultValue;

        expect(defaultValue.summary).toBe('add( ... )');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support React element', function () {
        var component = createTestComponent(null);

        var defaultProp = /*#__PURE__*/_react["default"].createElement(ReactComponent, null); // Simulate babel-plugin-add-react-displayname.


        defaultProp.type.displayName = 'ReactComponent';

        var _extractPropDef25 = extractPropDef(component, defaultProp),
            defaultValue = _extractPropDef25.defaultValue;

        expect(defaultValue.summary).toBe('<ReactComponent />');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support React element with props', function () {
        var component = createTestComponent(null); // @ts-ignore

        var defaultProp = /*#__PURE__*/_react["default"].createElement(ReactComponent, {
          className: "toto"
        }); // Simulate babel-plugin-add-react-displayname.


        defaultProp.type.displayName = 'ReactComponent';

        var _extractPropDef26 = extractPropDef(component, defaultProp),
            defaultValue = _extractPropDef26.defaultValue;

        expect(defaultValue.summary).toBe('<ReactComponent />');
        expect(defaultValue.detail).toBe('<ReactComponent className="toto" />');
      });
      it('should support short HTML element', function () {
        var component = createTestComponent(null);

        var _extractPropDef27 = extractPropDef(component, /*#__PURE__*/_react["default"].createElement("div", null, "HTML element")),
            defaultValue = _extractPropDef27.defaultValue;

        expect(defaultValue.summary).toBe('<div>HTML element</div>');
        expect(defaultValue.detail).toBeUndefined();
      });
      it('should support long HTML element', function () {
        var component = createTestComponent(null);

        var _extractPropDef28 = extractPropDef(component, /*#__PURE__*/_react["default"].createElement("div", null, "HTML element!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")),
            defaultValue = _extractPropDef28.defaultValue;

        expect(defaultValue.summary).toBe('element');
        var expectedDetail = "<div>\n          HTML element!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n        </div>";
        expect(defaultValue.detail.replace(/\s/g, '')).toBe(expectedDetail.replace(/\s/g, ''));
      });
      ['element', 'elementType'].forEach(function (x) {
        it("should support inlined React class component for ".concat(x), function () {
          var component = createTestComponent(null, x);

          var _extractPropDef29 = extractPropDef(component, /*#__PURE__*/function (_React$PureComponent) {
            _inherits(InlinedClassComponent, _React$PureComponent);

            var _super = _createSuper(InlinedClassComponent);

            function InlinedClassComponent() {
              _classCallCheck(this, InlinedClassComponent);

              return _super.apply(this, arguments);
            }

            _createClass(InlinedClassComponent, [{
              key: "render",
              value: function render() {
                return /*#__PURE__*/_react["default"].createElement("div", null, "Inlined ClassComponent!");
              }
            }]);

            return InlinedClassComponent;
          }(_react["default"].PureComponent)),
              defaultValue = _extractPropDef29.defaultValue;

          expect(defaultValue.summary).toBe('<InlinedClassComponent />');
          expect(defaultValue.detail).toBeUndefined();
        });
        it("should support inlined anonymous React functional component for ".concat(x), function () {
          var component = createTestComponent(null, x);

          var _extractPropDef30 = extractPropDef(component, function () {
            return /*#__PURE__*/_react["default"].createElement("div", null, "Inlined FunctionalComponent!");
          }),
              defaultValue = _extractPropDef30.defaultValue;

          expect(defaultValue.summary).toBe('element');
          expect(defaultValue.detail).toBeUndefined();
        });
        it("should support inlined anonymous React functional component with props for ".concat(x), function () {
          var component = createTestComponent(null, x);

          var _extractPropDef31 = extractPropDef(component, function (_ref5) {
            var foo = _ref5.foo;
            return /*#__PURE__*/_react["default"].createElement("div", null, foo);
          }),
              defaultValue = _extractPropDef31.defaultValue;

          expect(defaultValue.summary).toBe('element');
          expect(defaultValue.detail).toBeUndefined();
        });
        it("should support inlined named React functional component for ".concat(x), function () {
          var component = createTestComponent(null, x);

          var _extractPropDef32 = extractPropDef(component, function InlinedFunctionalComponent() {
            return /*#__PURE__*/_react["default"].createElement("div", null, "Inlined FunctionalComponent!");
          }),
              defaultValue = _extractPropDef32.defaultValue;

          expect(defaultValue.summary).toBe('<InlinedFunctionalComponent />');
          expect(defaultValue.detail).toBeUndefined();
        });
        it("should support inlined named React functional component with props for ".concat(x), function () {
          var component = createTestComponent(null, x);

          var _extractPropDef33 = extractPropDef(component, function InlinedFunctionalComponent(_ref6) {
            var foo = _ref6.foo;
            return /*#__PURE__*/_react["default"].createElement("div", null, foo);
          }),
              defaultValue = _extractPropDef33.defaultValue;

          expect(defaultValue.summary).toBe('<InlinedFunctionalComponent />');
          expect(defaultValue.detail).toBeUndefined();
        });
      });
    });
  });
});