"use strict";

require("core-js/modules/es.array.find");

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.join");

require("core-js/modules/es.function.name");

require("core-js/modules/web.dom-collections.for-each");

require("jest-specific-snapshot");

var _path = _interopRequireDefault(require("path"));

var _fs = _interopRequireDefault(require("fs"));

var _tmp = _interopRequireDefault(require("tmp"));

var _crossSpawn = require("cross-spawn");

var _compodoc = require("./compodoc");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// File hierarchy: __testfixtures__ / some-test-case / input.*
var inputRegExp = /^input\..*$/;

var runCompodoc = function runCompodoc(inputPath) {
  var testDir = _path["default"].dirname(inputPath);

  var _tmp$dirSync = _tmp["default"].dirSync(),
      tmpDir = _tmp$dirSync.name,
      removeCallback = _tmp$dirSync.removeCallback; // FIXME: for now, this requires a tsconfig.json for each test case. Tried generating
  // one dynamically in tmpDir, but compodoc doesn't handle absolute paths properly
  // (and screwed around with relative paths as well, but couldn't get it working)


  (0, _crossSpawn.sync)('compodoc', ['-p', "".concat(testDir, "/tsconfig.json"), '-e', 'json', '-d', tmpDir], {
    stdio: 'inherit'
  });

  var output = _fs["default"].readFileSync("".concat(tmpDir, "/documentation.json"), 'utf8');

  try {
    removeCallback();
  } catch (e) {//
  }

  return output;
};

describe('angular component properties', function () {
  var fixturesDir = _path["default"].join(__dirname, '__testfixtures__');

  _fs["default"].readdirSync(fixturesDir, {
    withFileTypes: true
  }).forEach(function (testEntry) {
    if (testEntry.isDirectory()) {
      var testDir = _path["default"].join(fixturesDir, testEntry.name);

      var testFile = _fs["default"].readdirSync(testDir).find(function (fileName) {
        return inputRegExp.test(fileName);
      });

      if (testFile) {
        it(testEntry.name, function () {
          var inputPath = _path["default"].join(testDir, testFile); // snapshot the output of compodoc


          var compodocOutput = runCompodoc(inputPath);
          var compodocJson = JSON.parse(compodocOutput);
          expect(compodocJson).toMatchSpecificSnapshot(_path["default"].join(testDir, 'compodoc.snapshot')); // snapshot the output of addon-docs angular-properties

          var componentData = (0, _compodoc.findComponentByName)('InputComponent', compodocJson);
          var argTypes = (0, _compodoc.extractArgTypesFromData)(componentData);
          expect(argTypes).toMatchSpecificSnapshot(_path["default"].join(testDir, 'argtypes.snapshot'));
        });
      }
    }
  });
});