"use strict";

require("core-js/modules/es.regexp.exec");

require("core-js/modules/es.string.replace");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Heading = void 0;

var _react = _interopRequireDefault(require("react"));

var _html = require("@storybook/components/html");

var _mdx = require("./mdx");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var Heading = function Heading(_ref) {
  var children = _ref.children,
      disableAnchor = _ref.disableAnchor;

  if (disableAnchor || typeof children !== 'string') {
    return /*#__PURE__*/_react["default"].createElement(_html.H2, null, children);
  }

  var tagID = children.toLowerCase().replace(/[^a-z0-9]/gi, '-');
  return /*#__PURE__*/_react["default"].createElement(_mdx.HeaderMdx, {
    as: "h2",
    id: tagID
  }, children);
};

exports.Heading = Heading;