/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "ntdomain.h"
#include "librpc/rpc/dcesrv_core.h"
#include "librpc/gen_ndr/ndr_spoolss.h"
#include "librpc/gen_ndr/ndr_winspool.h"
#include "librpc/gen_ndr/ndr_winspool_scompat.h"
#include "librpc/gen_ndr/ndr_spoolss_scompat.h"
#include "rpc_server/rpc_config.h"
#include "rpc_server/rpc_server.h"

static bool forward_opnum_to_spoolss(uint16_t opnum) {
	switch (opnum) {
	case 58: /* winspool_SyncRegisterForRemoteNotifications */
	case 59: /* winspool_SyncUnRegisterForRemoteNotifications */
	case 60: /* winspool_SyncRefreshRemoteNotifications */
	case 61: /* winspool_AsyncGetRemoteNotifications */
	case 62: /* winspool_AsyncInstallPrinterDriverFromPackage */
	case 63: /* winspool_AsyncUploadPrinterDriverPackage */
	case 65: /* winspool_AsyncCorePrinterDriverInstalled */
	case 67: /* winspool_AsyncDeletePrinterDriverPackage */
		return false;
	default:
		break;
	}
	return true;
}

/* iremotewinspool - dcerpc server boilerplate generated by pidl */
static NTSTATUS iremotewinspool__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IREMOTEWINSPOOL_BIND
	return DCESRV_INTERFACE_IREMOTEWINSPOOL_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void iremotewinspool__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IREMOTEWINSPOOL_UNBIND
	DCESRV_INTERFACE_IREMOTEWINSPOOL_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS iremotewinspool__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (forward_opnum_to_spoolss(opnum)) {
		return spoolss__op_ndr_pull(dce_call, mem_ctx, pull, r);
	}

	if (opnum >= ndr_table_iremotewinspool.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_iremotewinspool.calls[opnum].struct_size, "struct %s", ndr_table_iremotewinspool.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_iremotewinspool.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS iremotewinspool__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, bool rpcint_call)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	if (forward_opnum_to_spoolss(opnum)) {
		return spoolss__op_dispatch(dce_call, mem_ctx, r);
	}

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (!rpcint_call) {
		impersonated = become_authenticated_pipe_user(
			dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* winspool_AsyncOpenPrinter */
		struct winspool_AsyncOpenPrinter *r2 = (struct winspool_AsyncOpenPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncOpenPrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pHandle = talloc_zero(r2, struct policy_handle);
		if (r2->out.pHandle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncOpenPrinter(p, r2);
		break;
	}
	case 1: { /* winspool_AsyncAddPrinter */
		struct winspool_AsyncAddPrinter *r2 = (struct winspool_AsyncAddPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddPrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pHandle = talloc_zero(r2, struct policy_handle);
		if (r2->out.pHandle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncAddPrinter(p, r2);
		break;
	}
	case 2: { /* winspool_AsyncSetJob */
		struct winspool_AsyncSetJob *r2 = (struct winspool_AsyncSetJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetJob, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncSetJob(p, r2);
		break;
	}
	case 3: { /* winspool_AsyncGetJob */
		struct winspool_AsyncGetJob *r2 = (struct winspool_AsyncGetJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetJob, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pJob = r2->in.pJob;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetJob(p, r2);
		break;
	}
	case 4: { /* winspool_AsyncEnumJobs */
		struct winspool_AsyncEnumJobs *r2 = (struct winspool_AsyncEnumJobs *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumJobs, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pJob = r2->in.pJob;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcReturned = talloc_zero(r2, uint32_t);
		if (r2->out.pcReturned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumJobs(p, r2);
		break;
	}
	case 5: { /* winspool_AsyncAddJob */
		struct winspool_AsyncAddJob *r2 = (struct winspool_AsyncAddJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddJob, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pAddJob = r2->in.pAddJob;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncAddJob(p, r2);
		break;
	}
	case 6: { /* winspool_AsyncScheduleJob */
		struct winspool_AsyncScheduleJob *r2 = (struct winspool_AsyncScheduleJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncScheduleJob, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncScheduleJob(p, r2);
		break;
	}
	case 7: { /* winspool_AsyncDeletePrinter */
		struct winspool_AsyncDeletePrinter *r2 = (struct winspool_AsyncDeletePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinter, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeletePrinter(p, r2);
		break;
	}
	case 8: { /* winspool_AsyncSetPrinter */
		struct winspool_AsyncSetPrinter *r2 = (struct winspool_AsyncSetPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetPrinter, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncSetPrinter(p, r2);
		break;
	}
	case 9: { /* winspool_AsyncGetPrinter */
		struct winspool_AsyncGetPrinter *r2 = (struct winspool_AsyncGetPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pPrinter = r2->in.pPrinter;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetPrinter(p, r2);
		break;
	}
	case 10: { /* winspool_AsyncStartDocPrinter */
		struct winspool_AsyncStartDocPrinter *r2 = (struct winspool_AsyncStartDocPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncStartDocPrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pJobId = talloc_zero(r2, uint32_t);
		if (r2->out.pJobId == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncStartDocPrinter(p, r2);
		break;
	}
	case 11: { /* winspool_AsyncStartPagePrinter */
		struct winspool_AsyncStartPagePrinter *r2 = (struct winspool_AsyncStartPagePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncStartPagePrinter, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncStartPagePrinter(p, r2);
		break;
	}
	case 12: { /* winspool_AsyncWritePrinter */
		struct winspool_AsyncWritePrinter *r2 = (struct winspool_AsyncWritePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncWritePrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pcWritten = talloc_zero(r2, uint32_t);
		if (r2->out.pcWritten == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncWritePrinter(p, r2);
		break;
	}
	case 13: { /* winspool_AsyncEndPagePrinter */
		struct winspool_AsyncEndPagePrinter *r2 = (struct winspool_AsyncEndPagePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEndPagePrinter, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncEndPagePrinter(p, r2);
		break;
	}
	case 14: { /* winspool_AsyncEndDocPrinter */
		struct winspool_AsyncEndDocPrinter *r2 = (struct winspool_AsyncEndDocPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEndDocPrinter, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncEndDocPrinter(p, r2);
		break;
	}
	case 15: { /* winspool_AsyncAbortPrinter */
		struct winspool_AsyncAbortPrinter *r2 = (struct winspool_AsyncAbortPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAbortPrinter, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncAbortPrinter(p, r2);
		break;
	}
	case 16: { /* winspool_AsyncGetPrinterData */
		struct winspool_AsyncGetPrinterData *r2 = (struct winspool_AsyncGetPrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinterData, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pType = talloc_zero(r2, uint32_t);
		if (r2->out.pType == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pData = talloc_zero_array(r2, uint8_t, r2->in.nSize);
		if (r2->out.pData == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetPrinterData(p, r2);
		break;
	}
	case 17: { /* winspool_AsyncGetPrinterDataEx */
		struct winspool_AsyncGetPrinterDataEx *r2 = (struct winspool_AsyncGetPrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinterDataEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pType = talloc_zero(r2, uint32_t);
		if (r2->out.pType == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pData = talloc_zero_array(r2, uint8_t, r2->in.nSize);
		if (r2->out.pData == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetPrinterDataEx(p, r2);
		break;
	}
	case 18: { /* winspool_AsyncSetPrinterData */
		struct winspool_AsyncSetPrinterData *r2 = (struct winspool_AsyncSetPrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetPrinterData, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncSetPrinterData(p, r2);
		break;
	}
	case 19: { /* winspool_AsyncSetPrinterDataEx */
		struct winspool_AsyncSetPrinterDataEx *r2 = (struct winspool_AsyncSetPrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetPrinterDataEx, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncSetPrinterDataEx(p, r2);
		break;
	}
	case 20: { /* winspool_AsyncClosePrinter */
		struct winspool_AsyncClosePrinter *r2 = (struct winspool_AsyncClosePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncClosePrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.phPrinter = r2->in.phPrinter;
		r2->out.result = _winspool_AsyncClosePrinter(p, r2);
		break;
	}
	case 21: { /* winspool_AsyncAddForm */
		struct winspool_AsyncAddForm *r2 = (struct winspool_AsyncAddForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddForm, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncAddForm(p, r2);
		break;
	}
	case 22: { /* winspool_AsyncDeleteForm */
		struct winspool_AsyncDeleteForm *r2 = (struct winspool_AsyncDeleteForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeleteForm, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeleteForm(p, r2);
		break;
	}
	case 23: { /* winspool_AsyncGetForm */
		struct winspool_AsyncGetForm *r2 = (struct winspool_AsyncGetForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetForm, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pForm = r2->in.pForm;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetForm(p, r2);
		break;
	}
	case 24: { /* winspool_AsyncSetForm */
		struct winspool_AsyncSetForm *r2 = (struct winspool_AsyncSetForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetForm, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncSetForm(p, r2);
		break;
	}
	case 25: { /* winspool_AsyncEnumForms */
		struct winspool_AsyncEnumForms *r2 = (struct winspool_AsyncEnumForms *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumForms, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pForm = r2->in.pForm;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcReturned = talloc_zero(r2, uint32_t);
		if (r2->out.pcReturned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumForms(p, r2);
		break;
	}
	case 26: { /* winspool_AsyncGetPrinterDriver */
		struct winspool_AsyncGetPrinterDriver *r2 = (struct winspool_AsyncGetPrinterDriver *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinterDriver, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pDriver = r2->in.pDriver;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pdwServerMaxVersion = talloc_zero(r2, uint32_t);
		if (r2->out.pdwServerMaxVersion == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pdwServerMinVersion = talloc_zero(r2, uint32_t);
		if (r2->out.pdwServerMinVersion == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetPrinterDriver(p, r2);
		break;
	}
	case 27: { /* winspool_AsyncEnumPrinterData */
		struct winspool_AsyncEnumPrinterData *r2 = (struct winspool_AsyncEnumPrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrinterData, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pValueName = talloc_zero_array(r2, uint16_t, r2->in.cbValueName / 2);
		if (r2->out.pValueName == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcbValueName = talloc_zero(r2, uint32_t);
		if (r2->out.pcbValueName == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pType = talloc_zero(r2, uint32_t);
		if (r2->out.pType == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pData = talloc_zero_array(r2, uint8_t, r2->in.cbData);
		if (r2->out.pData == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcbData = talloc_zero(r2, uint32_t);
		if (r2->out.pcbData == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumPrinterData(p, r2);
		break;
	}
	case 28: { /* winspool_AsyncEnumPrinterDataEx */
		struct winspool_AsyncEnumPrinterDataEx *r2 = (struct winspool_AsyncEnumPrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrinterDataEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pEnumValues = talloc_zero_array(r2, uint8_t, r2->in.cbEnumValues);
		if (r2->out.pEnumValues == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcbEnumValues = talloc_zero(r2, uint32_t);
		if (r2->out.pcbEnumValues == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pnEnumValues = talloc_zero(r2, uint32_t);
		if (r2->out.pnEnumValues == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumPrinterDataEx(p, r2);
		break;
	}
	case 29: { /* winspool_AsyncEnumPrinterKey */
		struct winspool_AsyncEnumPrinterKey *r2 = (struct winspool_AsyncEnumPrinterKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrinterKey, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pSubkey = talloc_zero_array(r2, uint16_t, r2->in.cbSubkey / 2);
		if (r2->out.pSubkey == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcbSubkey = talloc_zero(r2, uint32_t);
		if (r2->out.pcbSubkey == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumPrinterKey(p, r2);
		break;
	}
	case 30: { /* winspool_AsyncDeletePrinterData */
		struct winspool_AsyncDeletePrinterData *r2 = (struct winspool_AsyncDeletePrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterData, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeletePrinterData(p, r2);
		break;
	}
	case 31: { /* winspool_AsyncDeletePrinterDataEx */
		struct winspool_AsyncDeletePrinterDataEx *r2 = (struct winspool_AsyncDeletePrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterDataEx, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeletePrinterDataEx(p, r2);
		break;
	}
	case 32: { /* winspool_AsyncDeletePrinterKey */
		struct winspool_AsyncDeletePrinterKey *r2 = (struct winspool_AsyncDeletePrinterKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterKey, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeletePrinterKey(p, r2);
		break;
	}
	case 33: { /* winspool_AsyncXcvData */
		struct winspool_AsyncXcvData *r2 = (struct winspool_AsyncXcvData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncXcvData, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pdwStatus = r2->in.pdwStatus;
		r2->out.pOutputData = talloc_zero_array(r2, uint8_t, r2->in.cbOutputData);
		if (r2->out.pOutputData == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcbOutputNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbOutputNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncXcvData(p, r2);
		break;
	}
	case 34: { /* winspool_AsyncSendRecvBidiData */
		struct winspool_AsyncSendRecvBidiData *r2 = (struct winspool_AsyncSendRecvBidiData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSendRecvBidiData, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ppRespData = talloc_zero(r2, struct RPC_BIDI_RESPONSE_CONTAINER *);
		if (r2->out.ppRespData == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncSendRecvBidiData(p, r2);
		break;
	}
	case 35: { /* winspool_AsyncCreatePrinterIC */
		struct winspool_AsyncCreatePrinterIC *r2 = (struct winspool_AsyncCreatePrinterIC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncCreatePrinterIC, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pHandle = talloc_zero(r2, struct policy_handle);
		if (r2->out.pHandle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncCreatePrinterIC(p, r2);
		break;
	}
	case 36: { /* winspool_AsyncPlayGdiScriptOnPrinterIC */
		struct winspool_AsyncPlayGdiScriptOnPrinterIC *r2 = (struct winspool_AsyncPlayGdiScriptOnPrinterIC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncPlayGdiScriptOnPrinterIC, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pOut = talloc_zero_array(r2, uint8_t, r2->in.cOut);
		if (r2->out.pOut == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncPlayGdiScriptOnPrinterIC(p, r2);
		break;
	}
	case 37: { /* winspool_AsyncDeletePrinterIC */
		struct winspool_AsyncDeletePrinterIC *r2 = (struct winspool_AsyncDeletePrinterIC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterIC, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.phPrinterIC = r2->in.phPrinterIC;
		r2->out.result = _winspool_AsyncDeletePrinterIC(p, r2);
		break;
	}
	case 38: { /* winspool_AsyncEnumPrinters */
		struct winspool_AsyncEnumPrinters *r2 = (struct winspool_AsyncEnumPrinters *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrinters, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pPrinterEnum = r2->in.pPrinterEnum;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcReturned = talloc_zero(r2, uint32_t);
		if (r2->out.pcReturned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumPrinters(p, r2);
		break;
	}
	case 39: { /* winspool_AsyncAddPrinterDriver */
		struct winspool_AsyncAddPrinterDriver *r2 = (struct winspool_AsyncAddPrinterDriver *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddPrinterDriver, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncAddPrinterDriver(p, r2);
		break;
	}
	case 40: { /* winspool_AsyncEnumPrinterDrivers */
		struct winspool_AsyncEnumPrinterDrivers *r2 = (struct winspool_AsyncEnumPrinterDrivers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrinterDrivers, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pDrivers = r2->in.pDrivers;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcReturned = talloc_zero(r2, uint32_t);
		if (r2->out.pcReturned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumPrinterDrivers(p, r2);
		break;
	}
	case 41: { /* winspool_AsyncGetPrinterDriverDirectory */
		struct winspool_AsyncGetPrinterDriverDirectory *r2 = (struct winspool_AsyncGetPrinterDriverDirectory *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinterDriverDirectory, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pDriverDirectory = r2->in.pDriverDirectory;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetPrinterDriverDirectory(p, r2);
		break;
	}
	case 42: { /* winspool_AsyncDeletePrinterDriver */
		struct winspool_AsyncDeletePrinterDriver *r2 = (struct winspool_AsyncDeletePrinterDriver *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterDriver, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeletePrinterDriver(p, r2);
		break;
	}
	case 43: { /* winspool_AsyncDeletePrinterDriverEx */
		struct winspool_AsyncDeletePrinterDriverEx *r2 = (struct winspool_AsyncDeletePrinterDriverEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterDriverEx, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeletePrinterDriverEx(p, r2);
		break;
	}
	case 44: { /* winspool_AsyncAddPrintProcessor */
		struct winspool_AsyncAddPrintProcessor *r2 = (struct winspool_AsyncAddPrintProcessor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddPrintProcessor, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncAddPrintProcessor(p, r2);
		break;
	}
	case 45: { /* winspool_AsyncEnumPrintProcessors */
		struct winspool_AsyncEnumPrintProcessors *r2 = (struct winspool_AsyncEnumPrintProcessors *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrintProcessors, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pPrintProcessorInfo = r2->in.pPrintProcessorInfo;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcReturned = talloc_zero(r2, uint32_t);
		if (r2->out.pcReturned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumPrintProcessors(p, r2);
		break;
	}
	case 46: { /* winspool_AsyncGetPrintProcessorDirectory */
		struct winspool_AsyncGetPrintProcessorDirectory *r2 = (struct winspool_AsyncGetPrintProcessorDirectory *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrintProcessorDirectory, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pPrintProcessorDirectory = r2->in.pPrintProcessorDirectory;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetPrintProcessorDirectory(p, r2);
		break;
	}
	case 47: { /* winspool_AsyncEnumPorts */
		struct winspool_AsyncEnumPorts *r2 = (struct winspool_AsyncEnumPorts *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPorts, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pPort = r2->in.pPort;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcReturned = talloc_zero(r2, uint32_t);
		if (r2->out.pcReturned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumPorts(p, r2);
		break;
	}
	case 48: { /* winspool_AsyncEnumMonitors */
		struct winspool_AsyncEnumMonitors *r2 = (struct winspool_AsyncEnumMonitors *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumMonitors, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pMonitor = r2->in.pMonitor;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcReturned = talloc_zero(r2, uint32_t);
		if (r2->out.pcReturned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumMonitors(p, r2);
		break;
	}
	case 49: { /* winspool_AsyncAddPort */
		struct winspool_AsyncAddPort *r2 = (struct winspool_AsyncAddPort *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddPort, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncAddPort(p, r2);
		break;
	}
	case 50: { /* winspool_AsyncSetPort */
		struct winspool_AsyncSetPort *r2 = (struct winspool_AsyncSetPort *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetPort, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncSetPort(p, r2);
		break;
	}
	case 51: { /* winspool_AsyncAddMonitor */
		struct winspool_AsyncAddMonitor *r2 = (struct winspool_AsyncAddMonitor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddMonitor, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncAddMonitor(p, r2);
		break;
	}
	case 52: { /* winspool_AsyncDeleteMonitor */
		struct winspool_AsyncDeleteMonitor *r2 = (struct winspool_AsyncDeleteMonitor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeleteMonitor, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeleteMonitor(p, r2);
		break;
	}
	case 53: { /* winspool_AsyncDeletePrintProcessor */
		struct winspool_AsyncDeletePrintProcessor *r2 = (struct winspool_AsyncDeletePrintProcessor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrintProcessor, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeletePrintProcessor(p, r2);
		break;
	}
	case 54: { /* winspool_AsyncEnumPrintProcessorDatatypes */
		struct winspool_AsyncEnumPrintProcessorDatatypes *r2 = (struct winspool_AsyncEnumPrintProcessorDatatypes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrintProcessorDatatypes, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pDatatypes = r2->in.pDatatypes;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcReturned = talloc_zero(r2, uint32_t);
		if (r2->out.pcReturned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumPrintProcessorDatatypes(p, r2);
		break;
	}
	case 55: { /* winspool_AsyncAddPerMachineConnection */
		struct winspool_AsyncAddPerMachineConnection *r2 = (struct winspool_AsyncAddPerMachineConnection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddPerMachineConnection, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncAddPerMachineConnection(p, r2);
		break;
	}
	case 56: { /* winspool_AsyncDeletePerMachineConnection */
		struct winspool_AsyncDeletePerMachineConnection *r2 = (struct winspool_AsyncDeletePerMachineConnection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePerMachineConnection, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeletePerMachineConnection(p, r2);
		break;
	}
	case 57: { /* winspool_AsyncEnumPerMachineConnections */
		struct winspool_AsyncEnumPerMachineConnections *r2 = (struct winspool_AsyncEnumPerMachineConnections *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPerMachineConnections, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pPrinterEnum = r2->in.pPrinterEnum;
		r2->out.pcbNeeded = talloc_zero(r2, uint32_t);
		if (r2->out.pcbNeeded == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcReturned = talloc_zero(r2, uint32_t);
		if (r2->out.pcReturned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumPerMachineConnections(p, r2);
		break;
	}
	case 58: { /* winspool_SyncRegisterForRemoteNotifications */
		struct winspool_SyncRegisterForRemoteNotifications *r2 = (struct winspool_SyncRegisterForRemoteNotifications *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_SyncRegisterForRemoteNotifications, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.phRpcHandle = talloc_zero(r2, struct policy_handle);
		if (r2->out.phRpcHandle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_SyncRegisterForRemoteNotifications(p, r2);
		break;
	}
	case 59: { /* winspool_SyncUnRegisterForRemoteNotifications */
		struct winspool_SyncUnRegisterForRemoteNotifications *r2 = (struct winspool_SyncUnRegisterForRemoteNotifications *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_SyncUnRegisterForRemoteNotifications, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.phRpcHandle = r2->in.phRpcHandle;
		r2->out.result = _winspool_SyncUnRegisterForRemoteNotifications(p, r2);
		break;
	}
	case 60: { /* winspool_SyncRefreshRemoteNotifications */
		struct winspool_SyncRefreshRemoteNotifications *r2 = (struct winspool_SyncRefreshRemoteNotifications *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_SyncRefreshRemoteNotifications, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ppNotifyData = talloc_zero(r2, struct winspool_PrintPropertiesCollection *);
		if (r2->out.ppNotifyData == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_SyncRefreshRemoteNotifications(p, r2);
		break;
	}
	case 61: { /* winspool_AsyncGetRemoteNotifications */
		struct winspool_AsyncGetRemoteNotifications *r2 = (struct winspool_AsyncGetRemoteNotifications *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetRemoteNotifications, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ppNotifyData = talloc_zero(r2, struct winspool_PrintPropertiesCollection *);
		if (r2->out.ppNotifyData == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetRemoteNotifications(p, r2);
		break;
	}
	case 62: { /* winspool_AsyncInstallPrinterDriverFromPackage */
		struct winspool_AsyncInstallPrinterDriverFromPackage *r2 = (struct winspool_AsyncInstallPrinterDriverFromPackage *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncInstallPrinterDriverFromPackage, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncInstallPrinterDriverFromPackage(p, r2);
		break;
	}
	case 63: { /* winspool_AsyncUploadPrinterDriverPackage */
		struct winspool_AsyncUploadPrinterDriverPackage *r2 = (struct winspool_AsyncUploadPrinterDriverPackage *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncUploadPrinterDriverPackage, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pszDestInfPath = r2->in.pszDestInfPath;
		r2->out.pcchDestInfPath = r2->in.pcchDestInfPath;
		r2->out.result = _winspool_AsyncUploadPrinterDriverPackage(p, r2);
		break;
	}
	case 64: { /* winspool_AsyncGetCorePrinterDrivers */
		struct winspool_AsyncGetCorePrinterDrivers *r2 = (struct winspool_AsyncGetCorePrinterDrivers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetCorePrinterDrivers, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pCorePrinterDrivers = talloc_zero_array(r2, struct spoolss_CorePrinterDriver, r2->in.cCorePrinterDrivers);
		if (r2->out.pCorePrinterDrivers == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetCorePrinterDrivers(p, r2);
		break;
	}
	case 65: { /* winspool_AsyncCorePrinterDriverInstalled */
		struct winspool_AsyncCorePrinterDriverInstalled *r2 = (struct winspool_AsyncCorePrinterDriverInstalled *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncCorePrinterDriverInstalled, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pbDriverInstalled = talloc_zero(r2, int32_t);
		if (r2->out.pbDriverInstalled == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncCorePrinterDriverInstalled(p, r2);
		break;
	}
	case 66: { /* winspool_AsyncGetPrinterDriverPackagePath */
		struct winspool_AsyncGetPrinterDriverPackagePath *r2 = (struct winspool_AsyncGetPrinterDriverPackagePath *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinterDriverPackagePath, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pszDriverPackageCab = r2->in.pszDriverPackageCab;
		r2->out.pcchRequiredSize = talloc_zero(r2, uint32_t);
		if (r2->out.pcchRequiredSize == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetPrinterDriverPackagePath(p, r2);
		break;
	}
	case 67: { /* winspool_AsyncDeletePrinterDriverPackage */
		struct winspool_AsyncDeletePrinterDriverPackage *r2 = (struct winspool_AsyncDeletePrinterDriverPackage *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterDriverPackage, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeletePrinterDriverPackage(p, r2);
		break;
	}
	case 68: { /* winspool_AsyncReadPrinter */
		struct winspool_AsyncReadPrinter *r2 = (struct winspool_AsyncReadPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncReadPrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pBuf = talloc_zero_array(r2, uint8_t, r2->in.cbBuf);
		if (r2->out.pBuf == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pcNoBytesRead = talloc_zero(r2, uint32_t);
		if (r2->out.pcNoBytesRead == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncReadPrinter(p, r2);
		break;
	}
	case 69: { /* winspool_AsyncResetPrinter */
		struct winspool_AsyncResetPrinter *r2 = (struct winspool_AsyncResetPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncResetPrinter, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncResetPrinter(p, r2);
		break;
	}
	case 70: { /* winspool_AsyncGetJobNamedPropertyValue */
		struct winspool_AsyncGetJobNamedPropertyValue *r2 = (struct winspool_AsyncGetJobNamedPropertyValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetJobNamedPropertyValue, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pValue = talloc_zero(r2, struct spoolss_PrintPropertyValue);
		if (r2->out.pValue == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncGetJobNamedPropertyValue(p, r2);
		break;
	}
	case 71: { /* winspool_AsyncSetJobNamedProperty */
		struct winspool_AsyncSetJobNamedProperty *r2 = (struct winspool_AsyncSetJobNamedProperty *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetJobNamedProperty, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncSetJobNamedProperty(p, r2);
		break;
	}
	case 72: { /* winspool_AsyncDeleteJobNamedProperty */
		struct winspool_AsyncDeleteJobNamedProperty *r2 = (struct winspool_AsyncDeleteJobNamedProperty *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeleteJobNamedProperty, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncDeleteJobNamedProperty(p, r2);
		break;
	}
	case 73: { /* winspool_AsyncEnumJobNamedProperties */
		struct winspool_AsyncEnumJobNamedProperties *r2 = (struct winspool_AsyncEnumJobNamedProperties *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumJobNamedProperties, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pcProperties = talloc_zero(r2, uint32_t);
		if (r2->out.pcProperties == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.ppProperties = talloc_zero(r2, struct spoolss_PrintNamedProperty *);
		if (r2->out.ppProperties == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winspool_AsyncEnumJobNamedProperties(p, r2);
		break;
	}
	case 74: { /* winspool_AsyncLogJobInfoForBranchOffice */
		struct winspool_AsyncLogJobInfoForBranchOffice *r2 = (struct winspool_AsyncLogJobInfoForBranchOffice *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncLogJobInfoForBranchOffice, NDR_IN, r2);
		}
		r2->out.result = _winspool_AsyncLogJobInfoForBranchOffice(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS iremotewinspool__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return iremotewinspool__op_dispatch_internal(dce_call, mem_ctx, r, false);
}

NTSTATUS iremotewinspool__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	if (forward_opnum_to_spoolss(opnum)) {
		return spoolss__op_reply(dce_call, mem_ctx, r);
	}

	switch (opnum) {
	case 0: { /* winspool_AsyncOpenPrinter */
		struct winspool_AsyncOpenPrinter *r2 = (struct winspool_AsyncOpenPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncOpenPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncOpenPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncOpenPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* winspool_AsyncAddPrinter */
		struct winspool_AsyncAddPrinter *r2 = (struct winspool_AsyncAddPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncAddPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncAddPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* winspool_AsyncSetJob */
		struct winspool_AsyncSetJob *r2 = (struct winspool_AsyncSetJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncSetJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncSetJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* winspool_AsyncGetJob */
		struct winspool_AsyncGetJob *r2 = (struct winspool_AsyncGetJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* winspool_AsyncEnumJobs */
		struct winspool_AsyncEnumJobs *r2 = (struct winspool_AsyncEnumJobs *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumJobs replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumJobs, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumJobs\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* winspool_AsyncAddJob */
		struct winspool_AsyncAddJob *r2 = (struct winspool_AsyncAddJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncAddJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncAddJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* winspool_AsyncScheduleJob */
		struct winspool_AsyncScheduleJob *r2 = (struct winspool_AsyncScheduleJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncScheduleJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncScheduleJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncScheduleJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* winspool_AsyncDeletePrinter */
		struct winspool_AsyncDeletePrinter *r2 = (struct winspool_AsyncDeletePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeletePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeletePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* winspool_AsyncSetPrinter */
		struct winspool_AsyncSetPrinter *r2 = (struct winspool_AsyncSetPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncSetPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncSetPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* winspool_AsyncGetPrinter */
		struct winspool_AsyncGetPrinter *r2 = (struct winspool_AsyncGetPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* winspool_AsyncStartDocPrinter */
		struct winspool_AsyncStartDocPrinter *r2 = (struct winspool_AsyncStartDocPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncStartDocPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncStartDocPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncStartDocPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* winspool_AsyncStartPagePrinter */
		struct winspool_AsyncStartPagePrinter *r2 = (struct winspool_AsyncStartPagePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncStartPagePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncStartPagePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncStartPagePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* winspool_AsyncWritePrinter */
		struct winspool_AsyncWritePrinter *r2 = (struct winspool_AsyncWritePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncWritePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncWritePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncWritePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* winspool_AsyncEndPagePrinter */
		struct winspool_AsyncEndPagePrinter *r2 = (struct winspool_AsyncEndPagePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEndPagePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEndPagePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEndPagePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* winspool_AsyncEndDocPrinter */
		struct winspool_AsyncEndDocPrinter *r2 = (struct winspool_AsyncEndDocPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEndDocPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEndDocPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEndDocPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* winspool_AsyncAbortPrinter */
		struct winspool_AsyncAbortPrinter *r2 = (struct winspool_AsyncAbortPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncAbortPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAbortPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncAbortPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* winspool_AsyncGetPrinterData */
		struct winspool_AsyncGetPrinterData *r2 = (struct winspool_AsyncGetPrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetPrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetPrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* winspool_AsyncGetPrinterDataEx */
		struct winspool_AsyncGetPrinterDataEx *r2 = (struct winspool_AsyncGetPrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetPrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetPrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* winspool_AsyncSetPrinterData */
		struct winspool_AsyncSetPrinterData *r2 = (struct winspool_AsyncSetPrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncSetPrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetPrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncSetPrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* winspool_AsyncSetPrinterDataEx */
		struct winspool_AsyncSetPrinterDataEx *r2 = (struct winspool_AsyncSetPrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncSetPrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetPrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncSetPrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* winspool_AsyncClosePrinter */
		struct winspool_AsyncClosePrinter *r2 = (struct winspool_AsyncClosePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncClosePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncClosePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncClosePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* winspool_AsyncAddForm */
		struct winspool_AsyncAddForm *r2 = (struct winspool_AsyncAddForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncAddForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncAddForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* winspool_AsyncDeleteForm */
		struct winspool_AsyncDeleteForm *r2 = (struct winspool_AsyncDeleteForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeleteForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeleteForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeleteForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 23: { /* winspool_AsyncGetForm */
		struct winspool_AsyncGetForm *r2 = (struct winspool_AsyncGetForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 24: { /* winspool_AsyncSetForm */
		struct winspool_AsyncSetForm *r2 = (struct winspool_AsyncSetForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncSetForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncSetForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 25: { /* winspool_AsyncEnumForms */
		struct winspool_AsyncEnumForms *r2 = (struct winspool_AsyncEnumForms *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumForms replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumForms, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumForms\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 26: { /* winspool_AsyncGetPrinterDriver */
		struct winspool_AsyncGetPrinterDriver *r2 = (struct winspool_AsyncGetPrinterDriver *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetPrinterDriver replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinterDriver, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetPrinterDriver\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 27: { /* winspool_AsyncEnumPrinterData */
		struct winspool_AsyncEnumPrinterData *r2 = (struct winspool_AsyncEnumPrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumPrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumPrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 28: { /* winspool_AsyncEnumPrinterDataEx */
		struct winspool_AsyncEnumPrinterDataEx *r2 = (struct winspool_AsyncEnumPrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumPrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumPrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 29: { /* winspool_AsyncEnumPrinterKey */
		struct winspool_AsyncEnumPrinterKey *r2 = (struct winspool_AsyncEnumPrinterKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumPrinterKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrinterKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumPrinterKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 30: { /* winspool_AsyncDeletePrinterData */
		struct winspool_AsyncDeletePrinterData *r2 = (struct winspool_AsyncDeletePrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeletePrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeletePrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 31: { /* winspool_AsyncDeletePrinterDataEx */
		struct winspool_AsyncDeletePrinterDataEx *r2 = (struct winspool_AsyncDeletePrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeletePrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeletePrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 32: { /* winspool_AsyncDeletePrinterKey */
		struct winspool_AsyncDeletePrinterKey *r2 = (struct winspool_AsyncDeletePrinterKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeletePrinterKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeletePrinterKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 33: { /* winspool_AsyncXcvData */
		struct winspool_AsyncXcvData *r2 = (struct winspool_AsyncXcvData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncXcvData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncXcvData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncXcvData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 34: { /* winspool_AsyncSendRecvBidiData */
		struct winspool_AsyncSendRecvBidiData *r2 = (struct winspool_AsyncSendRecvBidiData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncSendRecvBidiData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSendRecvBidiData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncSendRecvBidiData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 35: { /* winspool_AsyncCreatePrinterIC */
		struct winspool_AsyncCreatePrinterIC *r2 = (struct winspool_AsyncCreatePrinterIC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncCreatePrinterIC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncCreatePrinterIC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncCreatePrinterIC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 36: { /* winspool_AsyncPlayGdiScriptOnPrinterIC */
		struct winspool_AsyncPlayGdiScriptOnPrinterIC *r2 = (struct winspool_AsyncPlayGdiScriptOnPrinterIC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncPlayGdiScriptOnPrinterIC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncPlayGdiScriptOnPrinterIC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncPlayGdiScriptOnPrinterIC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 37: { /* winspool_AsyncDeletePrinterIC */
		struct winspool_AsyncDeletePrinterIC *r2 = (struct winspool_AsyncDeletePrinterIC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeletePrinterIC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterIC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeletePrinterIC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 38: { /* winspool_AsyncEnumPrinters */
		struct winspool_AsyncEnumPrinters *r2 = (struct winspool_AsyncEnumPrinters *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumPrinters replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrinters, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumPrinters\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 39: { /* winspool_AsyncAddPrinterDriver */
		struct winspool_AsyncAddPrinterDriver *r2 = (struct winspool_AsyncAddPrinterDriver *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncAddPrinterDriver replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddPrinterDriver, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncAddPrinterDriver\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 40: { /* winspool_AsyncEnumPrinterDrivers */
		struct winspool_AsyncEnumPrinterDrivers *r2 = (struct winspool_AsyncEnumPrinterDrivers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumPrinterDrivers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrinterDrivers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumPrinterDrivers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 41: { /* winspool_AsyncGetPrinterDriverDirectory */
		struct winspool_AsyncGetPrinterDriverDirectory *r2 = (struct winspool_AsyncGetPrinterDriverDirectory *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetPrinterDriverDirectory replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinterDriverDirectory, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetPrinterDriverDirectory\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 42: { /* winspool_AsyncDeletePrinterDriver */
		struct winspool_AsyncDeletePrinterDriver *r2 = (struct winspool_AsyncDeletePrinterDriver *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeletePrinterDriver replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterDriver, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeletePrinterDriver\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 43: { /* winspool_AsyncDeletePrinterDriverEx */
		struct winspool_AsyncDeletePrinterDriverEx *r2 = (struct winspool_AsyncDeletePrinterDriverEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeletePrinterDriverEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterDriverEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeletePrinterDriverEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 44: { /* winspool_AsyncAddPrintProcessor */
		struct winspool_AsyncAddPrintProcessor *r2 = (struct winspool_AsyncAddPrintProcessor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncAddPrintProcessor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddPrintProcessor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncAddPrintProcessor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 45: { /* winspool_AsyncEnumPrintProcessors */
		struct winspool_AsyncEnumPrintProcessors *r2 = (struct winspool_AsyncEnumPrintProcessors *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumPrintProcessors replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrintProcessors, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumPrintProcessors\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 46: { /* winspool_AsyncGetPrintProcessorDirectory */
		struct winspool_AsyncGetPrintProcessorDirectory *r2 = (struct winspool_AsyncGetPrintProcessorDirectory *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetPrintProcessorDirectory replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrintProcessorDirectory, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetPrintProcessorDirectory\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 47: { /* winspool_AsyncEnumPorts */
		struct winspool_AsyncEnumPorts *r2 = (struct winspool_AsyncEnumPorts *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumPorts replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPorts, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumPorts\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 48: { /* winspool_AsyncEnumMonitors */
		struct winspool_AsyncEnumMonitors *r2 = (struct winspool_AsyncEnumMonitors *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumMonitors replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumMonitors, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumMonitors\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 49: { /* winspool_AsyncAddPort */
		struct winspool_AsyncAddPort *r2 = (struct winspool_AsyncAddPort *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncAddPort replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddPort, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncAddPort\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 50: { /* winspool_AsyncSetPort */
		struct winspool_AsyncSetPort *r2 = (struct winspool_AsyncSetPort *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncSetPort replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetPort, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncSetPort\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 51: { /* winspool_AsyncAddMonitor */
		struct winspool_AsyncAddMonitor *r2 = (struct winspool_AsyncAddMonitor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncAddMonitor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddMonitor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncAddMonitor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 52: { /* winspool_AsyncDeleteMonitor */
		struct winspool_AsyncDeleteMonitor *r2 = (struct winspool_AsyncDeleteMonitor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeleteMonitor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeleteMonitor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeleteMonitor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 53: { /* winspool_AsyncDeletePrintProcessor */
		struct winspool_AsyncDeletePrintProcessor *r2 = (struct winspool_AsyncDeletePrintProcessor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeletePrintProcessor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrintProcessor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeletePrintProcessor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 54: { /* winspool_AsyncEnumPrintProcessorDatatypes */
		struct winspool_AsyncEnumPrintProcessorDatatypes *r2 = (struct winspool_AsyncEnumPrintProcessorDatatypes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumPrintProcessorDatatypes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPrintProcessorDatatypes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumPrintProcessorDatatypes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 55: { /* winspool_AsyncAddPerMachineConnection */
		struct winspool_AsyncAddPerMachineConnection *r2 = (struct winspool_AsyncAddPerMachineConnection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncAddPerMachineConnection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncAddPerMachineConnection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncAddPerMachineConnection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 56: { /* winspool_AsyncDeletePerMachineConnection */
		struct winspool_AsyncDeletePerMachineConnection *r2 = (struct winspool_AsyncDeletePerMachineConnection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeletePerMachineConnection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePerMachineConnection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeletePerMachineConnection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 57: { /* winspool_AsyncEnumPerMachineConnections */
		struct winspool_AsyncEnumPerMachineConnections *r2 = (struct winspool_AsyncEnumPerMachineConnections *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumPerMachineConnections replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumPerMachineConnections, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumPerMachineConnections\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 58: { /* winspool_SyncRegisterForRemoteNotifications */
		struct winspool_SyncRegisterForRemoteNotifications *r2 = (struct winspool_SyncRegisterForRemoteNotifications *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_SyncRegisterForRemoteNotifications replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_SyncRegisterForRemoteNotifications, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_SyncRegisterForRemoteNotifications\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 59: { /* winspool_SyncUnRegisterForRemoteNotifications */
		struct winspool_SyncUnRegisterForRemoteNotifications *r2 = (struct winspool_SyncUnRegisterForRemoteNotifications *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_SyncUnRegisterForRemoteNotifications replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_SyncUnRegisterForRemoteNotifications, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_SyncUnRegisterForRemoteNotifications\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 60: { /* winspool_SyncRefreshRemoteNotifications */
		struct winspool_SyncRefreshRemoteNotifications *r2 = (struct winspool_SyncRefreshRemoteNotifications *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_SyncRefreshRemoteNotifications replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_SyncRefreshRemoteNotifications, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_SyncRefreshRemoteNotifications\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 61: { /* winspool_AsyncGetRemoteNotifications */
		struct winspool_AsyncGetRemoteNotifications *r2 = (struct winspool_AsyncGetRemoteNotifications *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetRemoteNotifications replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetRemoteNotifications, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetRemoteNotifications\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 62: { /* winspool_AsyncInstallPrinterDriverFromPackage */
		struct winspool_AsyncInstallPrinterDriverFromPackage *r2 = (struct winspool_AsyncInstallPrinterDriverFromPackage *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncInstallPrinterDriverFromPackage replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncInstallPrinterDriverFromPackage, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncInstallPrinterDriverFromPackage\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 63: { /* winspool_AsyncUploadPrinterDriverPackage */
		struct winspool_AsyncUploadPrinterDriverPackage *r2 = (struct winspool_AsyncUploadPrinterDriverPackage *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncUploadPrinterDriverPackage replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncUploadPrinterDriverPackage, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncUploadPrinterDriverPackage\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 64: { /* winspool_AsyncGetCorePrinterDrivers */
		struct winspool_AsyncGetCorePrinterDrivers *r2 = (struct winspool_AsyncGetCorePrinterDrivers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetCorePrinterDrivers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetCorePrinterDrivers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetCorePrinterDrivers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 65: { /* winspool_AsyncCorePrinterDriverInstalled */
		struct winspool_AsyncCorePrinterDriverInstalled *r2 = (struct winspool_AsyncCorePrinterDriverInstalled *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncCorePrinterDriverInstalled replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncCorePrinterDriverInstalled, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncCorePrinterDriverInstalled\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 66: { /* winspool_AsyncGetPrinterDriverPackagePath */
		struct winspool_AsyncGetPrinterDriverPackagePath *r2 = (struct winspool_AsyncGetPrinterDriverPackagePath *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetPrinterDriverPackagePath replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetPrinterDriverPackagePath, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetPrinterDriverPackagePath\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 67: { /* winspool_AsyncDeletePrinterDriverPackage */
		struct winspool_AsyncDeletePrinterDriverPackage *r2 = (struct winspool_AsyncDeletePrinterDriverPackage *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeletePrinterDriverPackage replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterDriverPackage, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeletePrinterDriverPackage\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 68: { /* winspool_AsyncReadPrinter */
		struct winspool_AsyncReadPrinter *r2 = (struct winspool_AsyncReadPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncReadPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncReadPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncReadPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 69: { /* winspool_AsyncResetPrinter */
		struct winspool_AsyncResetPrinter *r2 = (struct winspool_AsyncResetPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncResetPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncResetPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncResetPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 70: { /* winspool_AsyncGetJobNamedPropertyValue */
		struct winspool_AsyncGetJobNamedPropertyValue *r2 = (struct winspool_AsyncGetJobNamedPropertyValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncGetJobNamedPropertyValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetJobNamedPropertyValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncGetJobNamedPropertyValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 71: { /* winspool_AsyncSetJobNamedProperty */
		struct winspool_AsyncSetJobNamedProperty *r2 = (struct winspool_AsyncSetJobNamedProperty *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncSetJobNamedProperty replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncSetJobNamedProperty, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncSetJobNamedProperty\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 72: { /* winspool_AsyncDeleteJobNamedProperty */
		struct winspool_AsyncDeleteJobNamedProperty *r2 = (struct winspool_AsyncDeleteJobNamedProperty *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncDeleteJobNamedProperty replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeleteJobNamedProperty, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncDeleteJobNamedProperty\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 73: { /* winspool_AsyncEnumJobNamedProperties */
		struct winspool_AsyncEnumJobNamedProperties *r2 = (struct winspool_AsyncEnumJobNamedProperties *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncEnumJobNamedProperties replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncEnumJobNamedProperties, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncEnumJobNamedProperties\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 74: { /* winspool_AsyncLogJobInfoForBranchOffice */
		struct winspool_AsyncLogJobInfoForBranchOffice *r2 = (struct winspool_AsyncLogJobInfoForBranchOffice *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winspool_AsyncLogJobInfoForBranchOffice replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncLogJobInfoForBranchOffice, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winspool_AsyncLogJobInfoForBranchOffice\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS iremotewinspool__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	if (forward_opnum_to_spoolss(opnum)) {
		return spoolss__op_ndr_push(dce_call, mem_ctx, push, r);
	}

	ndr_err = ndr_table_iremotewinspool.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS iremotewinspool__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return iremotewinspool__op_dispatch_internal(dce_call, mem_ctx, r, true);
}

static const struct dcesrv_interface dcesrv_iremotewinspool_interface = {
	.name      = "iremotewinspool",
	.syntax_id = {{0x76f03f96,0xcdfd,0x44fc,{0xa2,0x2c},{0x64,0x95,0x0a,0x00,0x12,0x09}},1.0},
	.bind      = iremotewinspool__op_bind,
	.unbind    = iremotewinspool__op_unbind,
	.ndr_pull  = iremotewinspool__op_ndr_pull,
	.dispatch  = iremotewinspool__op_dispatch,
	.reply     = iremotewinspool__op_reply,
	.ndr_push  = iremotewinspool__op_ndr_push,
	.local     = iremotewinspool__op_local,
#ifdef DCESRV_INTERFACE_IREMOTEWINSPOOL_FLAGS
	.flags     = DCESRV_INTERFACE_IREMOTEWINSPOOL_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS iremotewinspool__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_IREMOTEWINSPOOL_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_IREMOTEWINSPOOL_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_iremotewinspool.endpoints->count;i++) {
		const char *name = ndr_table_iremotewinspool.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_iremotewinspool_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS iremotewinspool__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool iremotewinspool__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_iremotewinspool_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_iremotewinspool_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_iremotewinspool_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool iremotewinspool__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_iremotewinspool_interface.name, name)==0) {
		memcpy(iface, &dcesrv_iremotewinspool_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server iremotewinspool_ep_server = {
	/* fill in our name */
	.name = "iremotewinspool",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_IREMOTEWINSPOOL_INIT_SERVER
	.init_server = DCESRV_INTERFACE_IREMOTEWINSPOOL_INIT_SERVER,
#else
	.init_server = iremotewinspool__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_IREMOTEWINSPOOL_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_IREMOTEWINSPOOL_SHUTDOWN_SERVER,
#else
	.shutdown_server = iremotewinspool__op_shutdown_server,
#endif
	.interface_by_uuid = iremotewinspool__op_interface_by_uuid,
	.interface_by_name = iremotewinspool__op_interface_by_name
};

const struct dcesrv_endpoint_server *iremotewinspool_get_ep_server(void)
{
	return &iremotewinspool_ep_server;
}
