/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.LdapContextImpl;
import com.netscape.jndi.ldap.LdapNameParser;
import com.netscape.jndi.ldap.LdapService;
import com.netscape.jndi.ldap.ObjectMapper;
import com.netscape.jndi.ldap.ProviderUtils;
import com.netscape.jndi.ldap.common.Debug;
import com.netscape.jndi.ldap.common.ExceptionMapper;
import java.util.EventObject;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.controls.LDAPEntryChangeControl;
import netscape.ldap.controls.LDAPPersistSearchControl;

class EventService
implements Runnable {
    LdapService m_ldapSvc;
    Vector<EventEntry> m_eventList = new Vector();
    Thread m_monitorThread;
    LDAPSearchListener m_msgQueue;

    public EventService(LdapService ldapSvc) {
        this.m_ldapSvc = ldapSvc;
    }

    synchronized void addListener(LdapContextImpl ctx, String name, String filter, SearchControls jndiCtrls, NamingListener l) throws NamingException {
        EventEntry event = null;
        LDAPSearchListener sl = null;
        Debug.println(1, "ADD LISTENER");
        Object base = ctx.getDN();
        if (name.length() > 0) {
            base = ((String)base).length() > 0 ? name + "," + (String)base : name;
        }
        LDAPConnection ld = (LDAPConnection)this.m_ldapSvc.getConnection().clone();
        LDAPSearchConstraints cons = ld.getSearchConstraints();
        LDAPPersistSearchControl psearchCtrl = this.createSrchCtrl(l);
        cons.setServerControls((LDAPControl)psearchCtrl);
        boolean returnObjs = jndiCtrls.getReturningObjFlag();
        String[] attrs = new String[]{"javaclassname"};
        int scope = ProviderUtils.jndiSearchScopeToLdap(jndiCtrls.getSearchScope());
        for (int i = 0; i < this.m_eventList.size(); ++i) {
            EventEntry ee = this.m_eventList.elementAt(i);
            if (!ee.isEqualEvent((String)base, scope, filter, attrs, cons)) continue;
            event = ee;
            break;
        }
        if (event == null) {
            try {
                Debug.println(1, "Do persistent search for " + (String)base);
                sl = ld.search((String)base, scope, filter, attrs, false, null, cons);
                int[] ids = sl.getMessageIDs();
                int id = ids[ids.length - 1];
                event = new EventEntry(id, ctx, (String)base, scope, filter, attrs, cons);
                this.m_eventList.addElement(event);
            }
            catch (Exception ex) {
                throw ExceptionMapper.getNamingException(ex);
            }
        }
        event.addListener(l);
        if (this.m_msgQueue == null) {
            this.m_msgQueue = sl;
        } else {
            this.m_msgQueue.merge(sl);
        }
        if (this.m_monitorThread == null) {
            this.m_monitorThread = new Thread((Runnable)this, "EventService");
            this.m_monitorThread.setDaemon(true);
            this.m_monitorThread.start();
        }
    }

    synchronized void removeListener(NamingListener listener) throws NamingException {
        boolean removed = false;
        for (int i = this.m_eventList.size() - 1; i >= 0; --i) {
            EventEntry ee = this.m_eventList.elementAt(i);
            if (!ee.removeListener(listener)) continue;
            removed = true;
            if (!ee.isEmpty()) continue;
            this.abandonRequest(ee.id);
            this.m_eventList.removeElement(ee);
        }
        if (this.m_eventList.size() == 0) {
            this.m_monitorThread = null;
        }
        if (!removed) {
            throw new NamingException("Listener not found");
        }
    }

    private void abandonRequest(int id) {
        LDAPConnection ldc = this.m_ldapSvc.getConnection();
        try {
            ldc.abandon(id);
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LDAPMessage msg = null;
        while (this.m_monitorThread != null) {
            try {
                msg = this.m_msgQueue.getResponse();
            }
            catch (LDAPException ex) {
                this.processNetworkError(ex);
            }
            if (msg == null) {
                Debug.println(1, "No more messages, bye");
                this.m_monitorThread = null;
                return;
            }
            EventService eventService = this;
            synchronized (eventService) {
                EventEntry eventEntry = this.getEventEntry(msg.getMessageID());
                if (eventEntry == null) {
                    Debug.println(1, "Received ldap msg with unknown id=" + msg.getMessageID());
                    if (!(msg instanceof LDAPResponse)) {
                        this.abandonRequest(msg.getMessageID());
                    }
                    continue;
                }
                if (msg instanceof LDAPResponse) {
                    this.processResponseMsg((LDAPResponse)msg, eventEntry);
                } else if (msg instanceof LDAPSearchResultReference) {
                    this.processSearchResultRef((LDAPSearchResultReference)msg, eventEntry);
                } else if (msg instanceof LDAPSearchResult) {
                    this.processSearchResultMsg((LDAPSearchResult)msg, eventEntry);
                }
            }
        }
    }

    private void processNetworkError(LDAPException ex) {
        NamingException nameEx = ExceptionMapper.getNamingException((Exception)((Object)ex));
        for (int i = 0; i < this.m_eventList.size(); ++i) {
            EventEntry ee = this.m_eventList.elementAt(i);
            this.dispatchEvent(new NamingExceptionEvent(ee.ctx, nameEx), ee);
        }
    }

    private void processResponseMsg(LDAPResponse rsp, EventEntry ee) {
        if (rsp.getResultCode() == 0) {
            return;
        }
        if (rsp.getResultCode() == 10) {
            return;
        }
        int resultCode = rsp.getResultCode();
        LDAPException ex = new LDAPException(LDAPException.errorCodeToString((int)resultCode), resultCode, rsp.getErrorMessage(), rsp.getMatchedDN());
        NamingException nameEx = ExceptionMapper.getNamingException((Exception)((Object)ex));
        this.dispatchEvent(new NamingExceptionEvent(ee.ctx, nameEx), ee);
    }

    private void processSearchResultMsg(LDAPSearchResult res, EventEntry ee) {
        LDAPEntry modEntry = res.getEntry();
        Debug.println(1, "Changed " + modEntry.getDN());
        LDAPControl[] ctrls = res.getControls();
        if (ctrls == null) {
            NamingException ex = new NamingException("Can not create NamingEvent, no change control info");
            this.dispatchEvent(new NamingExceptionEvent(ee.ctx, ex), ee);
        }
        for (int i = 0; i < ctrls.length; ++i) {
            LDAPEntryChangeControl changeCtrl = null;
            if (!(ctrls[i] instanceof LDAPEntryChangeControl)) continue;
            changeCtrl = (LDAPEntryChangeControl)ctrls[i];
            if (changeCtrl.getChangeType() == -1) {
                NamingException ex = new NamingException("Can not create NamingEvent, no change control info");
                this.dispatchEvent(new NamingExceptionEvent(ee.ctx, ex), ee);
            }
            try {
                NamingEvent event = this.createNamingEvent(ee.ctx, modEntry, changeCtrl);
                this.dispatchEvent(event, ee);
                continue;
            }
            catch (NamingException ex) {
                this.dispatchEvent(new NamingExceptionEvent(ee.ctx, ex), ee);
            }
        }
    }

    private void processSearchResultRef(LDAPSearchResultReference ref, EventEntry ee) {
    }

    private EventEntry getEventEntry(int id) {
        for (int i = 0; i < this.m_eventList.size(); ++i) {
            EventEntry ee = this.m_eventList.elementAt(i);
            if (ee.id != id) continue;
            return ee;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(EventObject event, EventEntry eventEntry) {
        NamingListener[] dispatchList = null;
        EventEntry eventEntry2 = eventEntry;
        synchronized (eventEntry2) {
            dispatchList = new NamingListener[eventEntry.listeners.size()];
            for (int i = 0; i < dispatchList.length; ++i) {
                dispatchList[i] = eventEntry.listeners.elementAt(i);
            }
        }
        for (int i = 0; i < dispatchList.length; ++i) {
            if (event instanceof NamingEvent) {
                ((NamingEvent)event).dispatch(dispatchList[i]);
                continue;
            }
            ((NamingExceptionEvent)event).dispatch(dispatchList[i]);
        }
    }

    private NamingEvent createNamingEvent(LdapContextImpl ctx, LDAPEntry entry, LDAPEntryChangeControl changeCtrl) throws NamingException {
        Binding oldBd = null;
        Binding newBd = null;
        int eventType = -1;
        Integer changeInfo = null;
        String oldName = null;
        String newName = null;
        String className = ObjectMapper.getClassName(entry);
        int changeType = changeCtrl.getChangeType();
        switch (changeType) {
            case 1: {
                eventType = 0;
                newName = LdapNameParser.getRelativeName(ctx.m_ctxDN, entry.getDN());
                break;
            }
            case 2: {
                eventType = 1;
                oldName = LdapNameParser.getRelativeName(ctx.m_ctxDN, entry.getDN());
                break;
            }
            case 4: {
                eventType = 3;
                oldName = newName = LdapNameParser.getRelativeName(ctx.m_ctxDN, entry.getDN());
                break;
            }
            case 8: {
                eventType = 2;
                String oldDN = changeCtrl.getPreviousDN();
                if (oldDN != null) {
                    oldName = LdapNameParser.getRelativeName(ctx.m_ctxDN, oldDN);
                }
                try {
                    newName = LdapNameParser.getRelativeName(ctx.m_ctxDN, entry.getDN());
                    break;
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        changeInfo = changeCtrl.getChangeNumber();
        if (oldName != null) {
            oldBd = new Binding(oldName, className, null, true);
        }
        if (newName != null) {
            newBd = new Binding(newName, className, null, true);
        }
        return new NamingEvent(ctx, eventType, newBd, oldBd, changeInfo);
    }

    private LDAPPersistSearchControl createSrchCtrl(NamingListener listener) throws NamingException {
        int op = 0;
        if (listener instanceof ObjectChangeListener) {
            op = 4;
        }
        if (listener instanceof NamespaceChangeListener) {
            op |= 0xB;
        }
        if (op == 0) {
            throw new NamingException("Non supported listener type " + listener.getClass().getName());
        }
        return new LDAPPersistSearchControl(op, true, true, true);
    }

    private static class EventEntry {
        LdapContextImpl ctx;
        String base;
        String filter;
        String[] attrs;
        int scope;
        LDAPSearchConstraints cons;
        int id;
        Vector<NamingListener> listeners = new Vector();

        EventEntry(int id, LdapContextImpl ctx, String base, int scope, String filter, String[] attrs, LDAPSearchConstraints cons) {
            this.id = id;
            this.ctx = ctx;
            this.base = base;
            this.scope = scope;
            this.filter = filter;
            this.attrs = attrs;
            this.cons = cons;
        }

        synchronized void addListener(NamingListener l) {
            this.listeners.addElement(l);
        }

        synchronized boolean removeListener(NamingListener l) {
            return this.listeners.removeElement(l);
        }

        boolean isEmpty() {
            return this.listeners.size() == 0;
        }

        boolean isEqualEvent(String base, int scope, String filter, String[] attrs, LDAPSearchConstraints cons) {
            int types2;
            if (!this.base.equals(base) || this.scope != scope || !this.filter.equals(filter)) {
                return false;
            }
            if (this.attrs == null) {
                if (attrs != null) {
                    return false;
                }
            } else {
                if (attrs == null) {
                    return false;
                }
                if (this.attrs.length != attrs.length) {
                    return false;
                }
                for (int i = 0; i < this.attrs.length; ++i) {
                    boolean found = false;
                    for (int j = 0; j < this.attrs.length; ++j) {
                        if (!this.attrs[i].equals(attrs[j])) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
            }
            LDAPPersistSearchControl psearch1 = (LDAPPersistSearchControl)this.cons.getServerControls()[0];
            LDAPPersistSearchControl psearch2 = (LDAPPersistSearchControl)cons.getServerControls()[0];
            int types1 = psearch1.getChangeTypes();
            return types1 == (types2 = psearch2.getChangeTypes());
        }

        public String toString() {
            LDAPPersistSearchControl psearch = (LDAPPersistSearchControl)this.cons.getServerControls()[0];
            String str = "[EventEntry] base=" + this.base + " scope=" + this.scope + " filter=" + this.filter + " attrs={";
            for (int i = 0; i < this.attrs.length; ++i) {
                if (i > 0) {
                    str = str + " ";
                }
                str = str + this.attrs[i];
            }
            str = str + "} chanageTypes=" + psearch.getChangeTypes();
            str = str + " listeners=" + this.listeners.size();
            str = str + " id=" + this.id;
            return str;
        }
    }
}

