// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gl_1_autogen.cpp:
//   Capture functions for the OpenGL ES Desktop GL 1.x entry points.

#include "libANGLE/capture/capture_gl_1_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/validationGL1_autogen.h"

using namespace angle;

namespace gl
{

// GL 1.0
CallCapture CaptureAccum(const State &glState, bool isCallValid, GLenum op, GLfloat value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("op", BigGLEnum::AccumOp, ParamType::TGLenum, op);
    paramBuffer.addValueParam("value", ParamType::TGLfloat, value);

    return CallCapture(angle::EntryPoint::GLAccum, std::move(paramBuffer));
}

CallCapture CaptureBegin(const State &glState, bool isCallValid, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", BigGLEnum::PrimitiveType, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLBegin, std::move(paramBuffer));
}

CallCapture CaptureBitmap(const State &glState,
                          bool isCallValid,
                          GLsizei width,
                          GLsizei height,
                          GLfloat xorig,
                          GLfloat yorig,
                          GLfloat xmove,
                          GLfloat ymove,
                          const GLubyte *bitmap)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("xorig", ParamType::TGLfloat, xorig);
    paramBuffer.addValueParam("yorig", ParamType::TGLfloat, yorig);
    paramBuffer.addValueParam("xmove", ParamType::TGLfloat, xmove);
    paramBuffer.addValueParam("ymove", ParamType::TGLfloat, ymove);

    if (isCallValid)
    {
        ParamCapture bitmapParam("bitmap", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, bitmap, &bitmapParam.value);
        CaptureBitmap_bitmap(glState, isCallValid, width, height, xorig, yorig, xmove, ymove,
                             bitmap, &bitmapParam);
        paramBuffer.addParam(std::move(bitmapParam));
    }
    else
    {
        ParamCapture bitmapParam("bitmap", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, static_cast<const GLubyte *>(nullptr),
                       &bitmapParam.value);
        paramBuffer.addParam(std::move(bitmapParam));
    }

    return CallCapture(angle::EntryPoint::GLBitmap, std::move(paramBuffer));
}

CallCapture CaptureCallList(const State &glState, bool isCallValid, GLuint list)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("list", ParamType::TGLuint, list);

    return CallCapture(angle::EntryPoint::GLCallList, std::move(paramBuffer));
}

CallCapture CaptureCallLists(const State &glState,
                             bool isCallValid,
                             GLsizei n,
                             GLenum type,
                             const void *lists)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);
    paramBuffer.addEnumParam("type", BigGLEnum::ListNameType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture listsParam("lists", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, lists, &listsParam.value);
        CaptureCallLists_lists(glState, isCallValid, n, type, lists, &listsParam);
        paramBuffer.addParam(std::move(listsParam));
    }
    else
    {
        ParamCapture listsParam("lists", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &listsParam.value);
        paramBuffer.addParam(std::move(listsParam));
    }

    return CallCapture(angle::EntryPoint::GLCallLists, std::move(paramBuffer));
}

CallCapture CaptureClearAccum(const State &glState,
                              bool isCallValid,
                              GLfloat red,
                              GLfloat green,
                              GLfloat blue,
                              GLfloat alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfloat, red);
    paramBuffer.addValueParam("green", ParamType::TGLfloat, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfloat, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfloat, alpha);

    return CallCapture(angle::EntryPoint::GLClearAccum, std::move(paramBuffer));
}

CallCapture CaptureClearDepth(const State &glState, bool isCallValid, GLdouble depth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("depth", ParamType::TGLdouble, depth);

    return CallCapture(angle::EntryPoint::GLClearDepth, std::move(paramBuffer));
}

CallCapture CaptureClearIndex(const State &glState, bool isCallValid, GLfloat c)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("c", ParamType::TGLfloat, c);

    return CallCapture(angle::EntryPoint::GLClearIndex, std::move(paramBuffer));
}

CallCapture CaptureClipPlane(const State &glState,
                             bool isCallValid,
                             GLenum plane,
                             const GLdouble *equation)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("plane", BigGLEnum::ClipPlaneName, ParamType::TGLenum, plane);

    if (isCallValid)
    {
        ParamCapture equationParam("equation", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, equation, &equationParam.value);
        CaptureClipPlane_equation(glState, isCallValid, plane, equation, &equationParam);
        paramBuffer.addParam(std::move(equationParam));
    }
    else
    {
        ParamCapture equationParam("equation", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &equationParam.value);
        paramBuffer.addParam(std::move(equationParam));
    }

    return CallCapture(angle::EntryPoint::GLClipPlane, std::move(paramBuffer));
}

CallCapture CaptureColor3b(const State &glState,
                           bool isCallValid,
                           GLbyte red,
                           GLbyte green,
                           GLbyte blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLbyte, red);
    paramBuffer.addValueParam("green", ParamType::TGLbyte, green);
    paramBuffer.addValueParam("blue", ParamType::TGLbyte, blue);

    return CallCapture(angle::EntryPoint::GLColor3b, std::move(paramBuffer));
}

CallCapture CaptureColor3bv(const State &glState, bool isCallValid, const GLbyte *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLbyteConstPointer);
        InitParamValue(ParamType::TGLbyteConstPointer, v, &vParam.value);
        CaptureColor3bv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLbyteConstPointer);
        InitParamValue(ParamType::TGLbyteConstPointer, static_cast<const GLbyte *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor3bv, std::move(paramBuffer));
}

CallCapture CaptureColor3d(const State &glState,
                           bool isCallValid,
                           GLdouble red,
                           GLdouble green,
                           GLdouble blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLdouble, red);
    paramBuffer.addValueParam("green", ParamType::TGLdouble, green);
    paramBuffer.addValueParam("blue", ParamType::TGLdouble, blue);

    return CallCapture(angle::EntryPoint::GLColor3d, std::move(paramBuffer));
}

CallCapture CaptureColor3dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureColor3dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor3dv, std::move(paramBuffer));
}

CallCapture CaptureColor3f(const State &glState,
                           bool isCallValid,
                           GLfloat red,
                           GLfloat green,
                           GLfloat blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfloat, red);
    paramBuffer.addValueParam("green", ParamType::TGLfloat, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfloat, blue);

    return CallCapture(angle::EntryPoint::GLColor3f, std::move(paramBuffer));
}

CallCapture CaptureColor3fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureColor3fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor3fv, std::move(paramBuffer));
}

CallCapture CaptureColor3i(const State &glState,
                           bool isCallValid,
                           GLint red,
                           GLint green,
                           GLint blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLint, red);
    paramBuffer.addValueParam("green", ParamType::TGLint, green);
    paramBuffer.addValueParam("blue", ParamType::TGLint, blue);

    return CallCapture(angle::EntryPoint::GLColor3i, std::move(paramBuffer));
}

CallCapture CaptureColor3iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureColor3iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor3iv, std::move(paramBuffer));
}

CallCapture CaptureColor3s(const State &glState,
                           bool isCallValid,
                           GLshort red,
                           GLshort green,
                           GLshort blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLshort, red);
    paramBuffer.addValueParam("green", ParamType::TGLshort, green);
    paramBuffer.addValueParam("blue", ParamType::TGLshort, blue);

    return CallCapture(angle::EntryPoint::GLColor3s, std::move(paramBuffer));
}

CallCapture CaptureColor3sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureColor3sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor3sv, std::move(paramBuffer));
}

CallCapture CaptureColor3ub(const State &glState,
                            bool isCallValid,
                            GLubyte red,
                            GLubyte green,
                            GLubyte blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLubyte, red);
    paramBuffer.addValueParam("green", ParamType::TGLubyte, green);
    paramBuffer.addValueParam("blue", ParamType::TGLubyte, blue);

    return CallCapture(angle::EntryPoint::GLColor3ub, std::move(paramBuffer));
}

CallCapture CaptureColor3ubv(const State &glState, bool isCallValid, const GLubyte *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, v, &vParam.value);
        CaptureColor3ubv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, static_cast<const GLubyte *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor3ubv, std::move(paramBuffer));
}

CallCapture CaptureColor3ui(const State &glState,
                            bool isCallValid,
                            GLuint red,
                            GLuint green,
                            GLuint blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLuint, red);
    paramBuffer.addValueParam("green", ParamType::TGLuint, green);
    paramBuffer.addValueParam("blue", ParamType::TGLuint, blue);

    return CallCapture(angle::EntryPoint::GLColor3ui, std::move(paramBuffer));
}

CallCapture CaptureColor3uiv(const State &glState, bool isCallValid, const GLuint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, v, &vParam.value);
        CaptureColor3uiv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor3uiv, std::move(paramBuffer));
}

CallCapture CaptureColor3us(const State &glState,
                            bool isCallValid,
                            GLushort red,
                            GLushort green,
                            GLushort blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLushort, red);
    paramBuffer.addValueParam("green", ParamType::TGLushort, green);
    paramBuffer.addValueParam("blue", ParamType::TGLushort, blue);

    return CallCapture(angle::EntryPoint::GLColor3us, std::move(paramBuffer));
}

CallCapture CaptureColor3usv(const State &glState, bool isCallValid, const GLushort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLushortConstPointer);
        InitParamValue(ParamType::TGLushortConstPointer, v, &vParam.value);
        CaptureColor3usv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLushortConstPointer);
        InitParamValue(ParamType::TGLushortConstPointer, static_cast<const GLushort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor3usv, std::move(paramBuffer));
}

CallCapture CaptureColor4b(const State &glState,
                           bool isCallValid,
                           GLbyte red,
                           GLbyte green,
                           GLbyte blue,
                           GLbyte alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLbyte, red);
    paramBuffer.addValueParam("green", ParamType::TGLbyte, green);
    paramBuffer.addValueParam("blue", ParamType::TGLbyte, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLbyte, alpha);

    return CallCapture(angle::EntryPoint::GLColor4b, std::move(paramBuffer));
}

CallCapture CaptureColor4bv(const State &glState, bool isCallValid, const GLbyte *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLbyteConstPointer);
        InitParamValue(ParamType::TGLbyteConstPointer, v, &vParam.value);
        CaptureColor4bv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLbyteConstPointer);
        InitParamValue(ParamType::TGLbyteConstPointer, static_cast<const GLbyte *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor4bv, std::move(paramBuffer));
}

CallCapture CaptureColor4d(const State &glState,
                           bool isCallValid,
                           GLdouble red,
                           GLdouble green,
                           GLdouble blue,
                           GLdouble alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLdouble, red);
    paramBuffer.addValueParam("green", ParamType::TGLdouble, green);
    paramBuffer.addValueParam("blue", ParamType::TGLdouble, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLdouble, alpha);

    return CallCapture(angle::EntryPoint::GLColor4d, std::move(paramBuffer));
}

CallCapture CaptureColor4dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureColor4dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor4dv, std::move(paramBuffer));
}

CallCapture CaptureColor4fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureColor4fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor4fv, std::move(paramBuffer));
}

CallCapture CaptureColor4i(const State &glState,
                           bool isCallValid,
                           GLint red,
                           GLint green,
                           GLint blue,
                           GLint alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLint, red);
    paramBuffer.addValueParam("green", ParamType::TGLint, green);
    paramBuffer.addValueParam("blue", ParamType::TGLint, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLint, alpha);

    return CallCapture(angle::EntryPoint::GLColor4i, std::move(paramBuffer));
}

CallCapture CaptureColor4iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureColor4iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor4iv, std::move(paramBuffer));
}

CallCapture CaptureColor4s(const State &glState,
                           bool isCallValid,
                           GLshort red,
                           GLshort green,
                           GLshort blue,
                           GLshort alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLshort, red);
    paramBuffer.addValueParam("green", ParamType::TGLshort, green);
    paramBuffer.addValueParam("blue", ParamType::TGLshort, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLshort, alpha);

    return CallCapture(angle::EntryPoint::GLColor4s, std::move(paramBuffer));
}

CallCapture CaptureColor4sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureColor4sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor4sv, std::move(paramBuffer));
}

CallCapture CaptureColor4ubv(const State &glState, bool isCallValid, const GLubyte *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, v, &vParam.value);
        CaptureColor4ubv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, static_cast<const GLubyte *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor4ubv, std::move(paramBuffer));
}

CallCapture CaptureColor4ui(const State &glState,
                            bool isCallValid,
                            GLuint red,
                            GLuint green,
                            GLuint blue,
                            GLuint alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLuint, red);
    paramBuffer.addValueParam("green", ParamType::TGLuint, green);
    paramBuffer.addValueParam("blue", ParamType::TGLuint, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLuint, alpha);

    return CallCapture(angle::EntryPoint::GLColor4ui, std::move(paramBuffer));
}

CallCapture CaptureColor4uiv(const State &glState, bool isCallValid, const GLuint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, v, &vParam.value);
        CaptureColor4uiv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor4uiv, std::move(paramBuffer));
}

CallCapture CaptureColor4us(const State &glState,
                            bool isCallValid,
                            GLushort red,
                            GLushort green,
                            GLushort blue,
                            GLushort alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLushort, red);
    paramBuffer.addValueParam("green", ParamType::TGLushort, green);
    paramBuffer.addValueParam("blue", ParamType::TGLushort, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLushort, alpha);

    return CallCapture(angle::EntryPoint::GLColor4us, std::move(paramBuffer));
}

CallCapture CaptureColor4usv(const State &glState, bool isCallValid, const GLushort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLushortConstPointer);
        InitParamValue(ParamType::TGLushortConstPointer, v, &vParam.value);
        CaptureColor4usv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLushortConstPointer);
        InitParamValue(ParamType::TGLushortConstPointer, static_cast<const GLushort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLColor4usv, std::move(paramBuffer));
}

CallCapture CaptureColorMaterial(const State &glState, bool isCallValid, GLenum face, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", BigGLEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addEnumParam("mode", BigGLEnum::ColorMaterialParameter, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLColorMaterial, std::move(paramBuffer));
}

CallCapture CaptureCopyPixels(const State &glState,
                              bool isCallValid,
                              GLint x,
                              GLint y,
                              GLsizei width,
                              GLsizei height,
                              GLenum type)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelCopyType, ParamType::TGLenum, type);

    return CallCapture(angle::EntryPoint::GLCopyPixels, std::move(paramBuffer));
}

CallCapture CaptureDeleteLists(const State &glState, bool isCallValid, GLuint list, GLsizei range)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("list", ParamType::TGLuint, list);
    paramBuffer.addValueParam("range", ParamType::TGLsizei, range);

    return CallCapture(angle::EntryPoint::GLDeleteLists, std::move(paramBuffer));
}

CallCapture CaptureDepthRange(const State &glState, bool isCallValid, GLdouble n, GLdouble f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLdouble, n);
    paramBuffer.addValueParam("f", ParamType::TGLdouble, f);

    return CallCapture(angle::EntryPoint::GLDepthRange, std::move(paramBuffer));
}

CallCapture CaptureDrawBuffer(const State &glState, bool isCallValid, GLenum buf)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("buf", BigGLEnum::DrawBufferMode, ParamType::TGLenum, buf);

    return CallCapture(angle::EntryPoint::GLDrawBuffer, std::move(paramBuffer));
}

CallCapture CaptureDrawPixels(const State &glState,
                              bool isCallValid,
                              GLsizei width,
                              GLsizei height,
                              GLenum format,
                              GLenum type,
                              const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureDrawPixels_pixels(glState, isCallValid, width, height, format, type, pixels,
                                 &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLDrawPixels, std::move(paramBuffer));
}

CallCapture CaptureEdgeFlag(const State &glState, bool isCallValid, GLboolean flag)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("flag", ParamType::TGLboolean, flag);

    return CallCapture(angle::EntryPoint::GLEdgeFlag, std::move(paramBuffer));
}

CallCapture CaptureEdgeFlagv(const State &glState, bool isCallValid, const GLboolean *flag)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture flagParam("flag", ParamType::TGLbooleanConstPointer);
        InitParamValue(ParamType::TGLbooleanConstPointer, flag, &flagParam.value);
        CaptureEdgeFlagv_flag(glState, isCallValid, flag, &flagParam);
        paramBuffer.addParam(std::move(flagParam));
    }
    else
    {
        ParamCapture flagParam("flag", ParamType::TGLbooleanConstPointer);
        InitParamValue(ParamType::TGLbooleanConstPointer, static_cast<const GLboolean *>(nullptr),
                       &flagParam.value);
        paramBuffer.addParam(std::move(flagParam));
    }

    return CallCapture(angle::EntryPoint::GLEdgeFlagv, std::move(paramBuffer));
}

CallCapture CaptureEnd(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLEnd, std::move(paramBuffer));
}

CallCapture CaptureEndList(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLEndList, std::move(paramBuffer));
}

CallCapture CaptureEvalCoord1d(const State &glState, bool isCallValid, GLdouble u)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("u", ParamType::TGLdouble, u);

    return CallCapture(angle::EntryPoint::GLEvalCoord1d, std::move(paramBuffer));
}

CallCapture CaptureEvalCoord1dv(const State &glState, bool isCallValid, const GLdouble *u)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture uParam("u", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, u, &uParam.value);
        CaptureEvalCoord1dv_u(glState, isCallValid, u, &uParam);
        paramBuffer.addParam(std::move(uParam));
    }
    else
    {
        ParamCapture uParam("u", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &uParam.value);
        paramBuffer.addParam(std::move(uParam));
    }

    return CallCapture(angle::EntryPoint::GLEvalCoord1dv, std::move(paramBuffer));
}

CallCapture CaptureEvalCoord1f(const State &glState, bool isCallValid, GLfloat u)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("u", ParamType::TGLfloat, u);

    return CallCapture(angle::EntryPoint::GLEvalCoord1f, std::move(paramBuffer));
}

CallCapture CaptureEvalCoord1fv(const State &glState, bool isCallValid, const GLfloat *u)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture uParam("u", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, u, &uParam.value);
        CaptureEvalCoord1fv_u(glState, isCallValid, u, &uParam);
        paramBuffer.addParam(std::move(uParam));
    }
    else
    {
        ParamCapture uParam("u", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &uParam.value);
        paramBuffer.addParam(std::move(uParam));
    }

    return CallCapture(angle::EntryPoint::GLEvalCoord1fv, std::move(paramBuffer));
}

CallCapture CaptureEvalCoord2d(const State &glState, bool isCallValid, GLdouble u, GLdouble v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("u", ParamType::TGLdouble, u);
    paramBuffer.addValueParam("v", ParamType::TGLdouble, v);

    return CallCapture(angle::EntryPoint::GLEvalCoord2d, std::move(paramBuffer));
}

CallCapture CaptureEvalCoord2dv(const State &glState, bool isCallValid, const GLdouble *u)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture uParam("u", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, u, &uParam.value);
        CaptureEvalCoord2dv_u(glState, isCallValid, u, &uParam);
        paramBuffer.addParam(std::move(uParam));
    }
    else
    {
        ParamCapture uParam("u", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &uParam.value);
        paramBuffer.addParam(std::move(uParam));
    }

    return CallCapture(angle::EntryPoint::GLEvalCoord2dv, std::move(paramBuffer));
}

CallCapture CaptureEvalCoord2f(const State &glState, bool isCallValid, GLfloat u, GLfloat v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("u", ParamType::TGLfloat, u);
    paramBuffer.addValueParam("v", ParamType::TGLfloat, v);

    return CallCapture(angle::EntryPoint::GLEvalCoord2f, std::move(paramBuffer));
}

CallCapture CaptureEvalCoord2fv(const State &glState, bool isCallValid, const GLfloat *u)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture uParam("u", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, u, &uParam.value);
        CaptureEvalCoord2fv_u(glState, isCallValid, u, &uParam);
        paramBuffer.addParam(std::move(uParam));
    }
    else
    {
        ParamCapture uParam("u", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &uParam.value);
        paramBuffer.addParam(std::move(uParam));
    }

    return CallCapture(angle::EntryPoint::GLEvalCoord2fv, std::move(paramBuffer));
}

CallCapture CaptureEvalMesh1(const State &glState,
                             bool isCallValid,
                             GLenum mode,
                             GLint i1,
                             GLint i2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", BigGLEnum::MeshMode1, ParamType::TGLenum, mode);
    paramBuffer.addValueParam("i1", ParamType::TGLint, i1);
    paramBuffer.addValueParam("i2", ParamType::TGLint, i2);

    return CallCapture(angle::EntryPoint::GLEvalMesh1, std::move(paramBuffer));
}

CallCapture CaptureEvalMesh2(const State &glState,
                             bool isCallValid,
                             GLenum mode,
                             GLint i1,
                             GLint i2,
                             GLint j1,
                             GLint j2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", BigGLEnum::MeshMode2, ParamType::TGLenum, mode);
    paramBuffer.addValueParam("i1", ParamType::TGLint, i1);
    paramBuffer.addValueParam("i2", ParamType::TGLint, i2);
    paramBuffer.addValueParam("j1", ParamType::TGLint, j1);
    paramBuffer.addValueParam("j2", ParamType::TGLint, j2);

    return CallCapture(angle::EntryPoint::GLEvalMesh2, std::move(paramBuffer));
}

CallCapture CaptureEvalPoint1(const State &glState, bool isCallValid, GLint i)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("i", ParamType::TGLint, i);

    return CallCapture(angle::EntryPoint::GLEvalPoint1, std::move(paramBuffer));
}

CallCapture CaptureEvalPoint2(const State &glState, bool isCallValid, GLint i, GLint j)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("i", ParamType::TGLint, i);
    paramBuffer.addValueParam("j", ParamType::TGLint, j);

    return CallCapture(angle::EntryPoint::GLEvalPoint2, std::move(paramBuffer));
}

CallCapture CaptureFeedbackBuffer(const State &glState,
                                  bool isCallValid,
                                  GLsizei size,
                                  GLenum type,
                                  GLfloat *buffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLsizei, size);
    paramBuffer.addEnumParam("type", BigGLEnum::FeedbackType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture bufferParam("buffer", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, buffer, &bufferParam.value);
        CaptureFeedbackBuffer_buffer(glState, isCallValid, size, type, buffer, &bufferParam);
        paramBuffer.addParam(std::move(bufferParam));
    }
    else
    {
        ParamCapture bufferParam("buffer", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &bufferParam.value);
        paramBuffer.addParam(std::move(bufferParam));
    }

    return CallCapture(angle::EntryPoint::GLFeedbackBuffer, std::move(paramBuffer));
}

CallCapture CaptureFogi(const State &glState, bool isCallValid, GLenum pname, GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", BigGLEnum::FogParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLFogi, std::move(paramBuffer));
}

CallCapture CaptureFogiv(const State &glState, bool isCallValid, GLenum pname, const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", BigGLEnum::FogParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureFogiv_params(glState, isCallValid, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLFogiv, std::move(paramBuffer));
}

CallCapture CaptureFrustum(const State &glState,
                           bool isCallValid,
                           GLdouble left,
                           GLdouble right,
                           GLdouble bottom,
                           GLdouble top,
                           GLdouble zNear,
                           GLdouble zFar)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("left", ParamType::TGLdouble, left);
    paramBuffer.addValueParam("right", ParamType::TGLdouble, right);
    paramBuffer.addValueParam("bottom", ParamType::TGLdouble, bottom);
    paramBuffer.addValueParam("top", ParamType::TGLdouble, top);
    paramBuffer.addValueParam("zNear", ParamType::TGLdouble, zNear);
    paramBuffer.addValueParam("zFar", ParamType::TGLdouble, zFar);

    return CallCapture(angle::EntryPoint::GLFrustum, std::move(paramBuffer));
}

CallCapture CaptureGenLists(const State &glState,
                            bool isCallValid,
                            GLsizei range,
                            GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("range", ParamType::TGLsizei, range);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGenLists, std::move(paramBuffer));
}

CallCapture CaptureGetClipPlane(const State &glState,
                                bool isCallValid,
                                GLenum plane,
                                GLdouble *equation)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("plane", BigGLEnum::ClipPlaneName, ParamType::TGLenum, plane);

    if (isCallValid)
    {
        ParamCapture equationParam("equation", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, equation, &equationParam.value);
        CaptureGetClipPlane_equation(glState, isCallValid, plane, equation, &equationParam);
        paramBuffer.addParam(std::move(equationParam));
    }
    else
    {
        ParamCapture equationParam("equation", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, static_cast<GLdouble *>(nullptr),
                       &equationParam.value);
        paramBuffer.addParam(std::move(equationParam));
    }

    return CallCapture(angle::EntryPoint::GLGetClipPlane, std::move(paramBuffer));
}

CallCapture CaptureGetDoublev(const State &glState, bool isCallValid, GLenum pname, GLdouble *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", BigGLEnum::GetPName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, data, &dataParam.value);
        CaptureGetDoublev_data(glState, isCallValid, pname, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, static_cast<GLdouble *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetDoublev, std::move(paramBuffer));
}

CallCapture CaptureGetLightiv(const State &glState,
                              bool isCallValid,
                              GLenum light,
                              GLenum pname,
                              GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", BigGLEnum::LightName, ParamType::TGLenum, light);
    paramBuffer.addEnumParam("pname", BigGLEnum::LightParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetLightiv_params(glState, isCallValid, light, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetLightiv, std::move(paramBuffer));
}

CallCapture CaptureGetMapdv(const State &glState,
                            bool isCallValid,
                            GLenum target,
                            GLenum query,
                            GLdouble *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::MapTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("query", BigGLEnum::GetMapQuery, ParamType::TGLenum, query);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, v, &vParam.value);
        CaptureGetMapdv_v(glState, isCallValid, target, query, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, static_cast<GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLGetMapdv, std::move(paramBuffer));
}

CallCapture CaptureGetMapfv(const State &glState,
                            bool isCallValid,
                            GLenum target,
                            GLenum query,
                            GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::MapTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("query", BigGLEnum::GetMapQuery, ParamType::TGLenum, query);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, v, &vParam.value);
        CaptureGetMapfv_v(glState, isCallValid, target, query, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr), &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLGetMapfv, std::move(paramBuffer));
}

CallCapture CaptureGetMapiv(const State &glState,
                            bool isCallValid,
                            GLenum target,
                            GLenum query,
                            GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::MapTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("query", BigGLEnum::GetMapQuery, ParamType::TGLenum, query);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, v, &vParam.value);
        CaptureGetMapiv_v(glState, isCallValid, target, query, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLGetMapiv, std::move(paramBuffer));
}

CallCapture CaptureGetMaterialiv(const State &glState,
                                 bool isCallValid,
                                 GLenum face,
                                 GLenum pname,
                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", BigGLEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addEnumParam("pname", BigGLEnum::MaterialParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetMaterialiv_params(glState, isCallValid, face, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetMaterialiv, std::move(paramBuffer));
}

CallCapture CaptureGetPixelMapfv(const State &glState,
                                 bool isCallValid,
                                 GLenum map,
                                 GLfloat *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("map", BigGLEnum::PixelMap, ParamType::TGLenum, map);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, values, &valuesParam.value);
        CaptureGetPixelMapfv_values(glState, isCallValid, map, values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPixelMapfv, std::move(paramBuffer));
}

CallCapture CaptureGetPixelMapuiv(const State &glState,
                                  bool isCallValid,
                                  GLenum map,
                                  GLuint *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("map", BigGLEnum::PixelMap, ParamType::TGLenum, map);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, values, &valuesParam.value);
        CaptureGetPixelMapuiv_values(glState, isCallValid, map, values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPixelMapuiv, std::move(paramBuffer));
}

CallCapture CaptureGetPixelMapusv(const State &glState,
                                  bool isCallValid,
                                  GLenum map,
                                  GLushort *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("map", BigGLEnum::PixelMap, ParamType::TGLenum, map);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLushortPointer);
        InitParamValue(ParamType::TGLushortPointer, values, &valuesParam.value);
        CaptureGetPixelMapusv_values(glState, isCallValid, map, values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLushortPointer);
        InitParamValue(ParamType::TGLushortPointer, static_cast<GLushort *>(nullptr),
                       &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPixelMapusv, std::move(paramBuffer));
}

CallCapture CaptureGetPolygonStipple(const State &glState, bool isCallValid, GLubyte *mask)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture maskParam("mask", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, mask, &maskParam.value);
        CaptureGetPolygonStipple_mask(glState, isCallValid, mask, &maskParam);
        paramBuffer.addParam(std::move(maskParam));
    }
    else
    {
        ParamCapture maskParam("mask", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, static_cast<GLubyte *>(nullptr),
                       &maskParam.value);
        paramBuffer.addParam(std::move(maskParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPolygonStipple, std::move(paramBuffer));
}

CallCapture CaptureGetTexGendv(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               GLdouble *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", BigGLEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, params, &paramsParam.value);
        CaptureGetTexGendv_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, static_cast<GLdouble *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexGendv, std::move(paramBuffer));
}

CallCapture CaptureGetTexGenfv(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", BigGLEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexGenfv_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexGenfv, std::move(paramBuffer));
}

CallCapture CaptureGetTexGeniv(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", BigGLEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexGeniv_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexGeniv, std::move(paramBuffer));
}

CallCapture CaptureGetTexImage(const State &glState,
                               bool isCallValid,
                               TextureTarget targetPacked,
                               GLint level,
                               GLenum format,
                               GLenum type,
                               void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetTexImage_pixels(glState, isCallValid, targetPacked, level, format, type, pixels,
                                  &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexImage, std::move(paramBuffer));
}

CallCapture CaptureIndexMask(const State &glState, bool isCallValid, GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(angle::EntryPoint::GLIndexMask, std::move(paramBuffer));
}

CallCapture CaptureIndexd(const State &glState, bool isCallValid, GLdouble c)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("c", ParamType::TGLdouble, c);

    return CallCapture(angle::EntryPoint::GLIndexd, std::move(paramBuffer));
}

CallCapture CaptureIndexdv(const State &glState, bool isCallValid, const GLdouble *c)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture cParam("c", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, c, &cParam.value);
        CaptureIndexdv_c(glState, isCallValid, c, &cParam);
        paramBuffer.addParam(std::move(cParam));
    }
    else
    {
        ParamCapture cParam("c", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &cParam.value);
        paramBuffer.addParam(std::move(cParam));
    }

    return CallCapture(angle::EntryPoint::GLIndexdv, std::move(paramBuffer));
}

CallCapture CaptureIndexf(const State &glState, bool isCallValid, GLfloat c)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("c", ParamType::TGLfloat, c);

    return CallCapture(angle::EntryPoint::GLIndexf, std::move(paramBuffer));
}

CallCapture CaptureIndexfv(const State &glState, bool isCallValid, const GLfloat *c)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture cParam("c", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, c, &cParam.value);
        CaptureIndexfv_c(glState, isCallValid, c, &cParam);
        paramBuffer.addParam(std::move(cParam));
    }
    else
    {
        ParamCapture cParam("c", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &cParam.value);
        paramBuffer.addParam(std::move(cParam));
    }

    return CallCapture(angle::EntryPoint::GLIndexfv, std::move(paramBuffer));
}

CallCapture CaptureIndexi(const State &glState, bool isCallValid, GLint c)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("c", ParamType::TGLint, c);

    return CallCapture(angle::EntryPoint::GLIndexi, std::move(paramBuffer));
}

CallCapture CaptureIndexiv(const State &glState, bool isCallValid, const GLint *c)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture cParam("c", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, c, &cParam.value);
        CaptureIndexiv_c(glState, isCallValid, c, &cParam);
        paramBuffer.addParam(std::move(cParam));
    }
    else
    {
        ParamCapture cParam("c", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &cParam.value);
        paramBuffer.addParam(std::move(cParam));
    }

    return CallCapture(angle::EntryPoint::GLIndexiv, std::move(paramBuffer));
}

CallCapture CaptureIndexs(const State &glState, bool isCallValid, GLshort c)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("c", ParamType::TGLshort, c);

    return CallCapture(angle::EntryPoint::GLIndexs, std::move(paramBuffer));
}

CallCapture CaptureIndexsv(const State &glState, bool isCallValid, const GLshort *c)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture cParam("c", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, c, &cParam.value);
        CaptureIndexsv_c(glState, isCallValid, c, &cParam);
        paramBuffer.addParam(std::move(cParam));
    }
    else
    {
        ParamCapture cParam("c", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &cParam.value);
        paramBuffer.addParam(std::move(cParam));
    }

    return CallCapture(angle::EntryPoint::GLIndexsv, std::move(paramBuffer));
}

CallCapture CaptureInitNames(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLInitNames, std::move(paramBuffer));
}

CallCapture CaptureIsList(const State &glState,
                          bool isCallValid,
                          GLuint list,
                          GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("list", ParamType::TGLuint, list);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsList, std::move(paramBuffer));
}

CallCapture CaptureLightModeli(const State &glState, bool isCallValid, GLenum pname, GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", BigGLEnum::LightModelParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLLightModeli, std::move(paramBuffer));
}

CallCapture CaptureLightModeliv(const State &glState,
                                bool isCallValid,
                                GLenum pname,
                                const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", BigGLEnum::LightModelParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureLightModeliv_params(glState, isCallValid, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLLightModeliv, std::move(paramBuffer));
}

CallCapture CaptureLighti(const State &glState,
                          bool isCallValid,
                          GLenum light,
                          GLenum pname,
                          GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", BigGLEnum::LightName, ParamType::TGLenum, light);
    paramBuffer.addEnumParam("pname", BigGLEnum::LightParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLLighti, std::move(paramBuffer));
}

CallCapture CaptureLightiv(const State &glState,
                           bool isCallValid,
                           GLenum light,
                           GLenum pname,
                           const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", BigGLEnum::LightName, ParamType::TGLenum, light);
    paramBuffer.addEnumParam("pname", BigGLEnum::LightParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureLightiv_params(glState, isCallValid, light, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLLightiv, std::move(paramBuffer));
}

CallCapture CaptureLineStipple(const State &glState,
                               bool isCallValid,
                               GLint factor,
                               GLushort pattern)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("factor", ParamType::TGLint, factor);
    paramBuffer.addValueParam("pattern", ParamType::TGLushort, pattern);

    return CallCapture(angle::EntryPoint::GLLineStipple, std::move(paramBuffer));
}

CallCapture CaptureListBase(const State &glState, bool isCallValid, GLuint base)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("base", ParamType::TGLuint, base);

    return CallCapture(angle::EntryPoint::GLListBase, std::move(paramBuffer));
}

CallCapture CaptureLoadMatrixd(const State &glState, bool isCallValid, const GLdouble *m)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mParam("m", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, m, &mParam.value);
        CaptureLoadMatrixd_m(glState, isCallValid, m, &mParam);
        paramBuffer.addParam(std::move(mParam));
    }
    else
    {
        ParamCapture mParam("m", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &mParam.value);
        paramBuffer.addParam(std::move(mParam));
    }

    return CallCapture(angle::EntryPoint::GLLoadMatrixd, std::move(paramBuffer));
}

CallCapture CaptureLoadName(const State &glState, bool isCallValid, GLuint name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("name", ParamType::TGLuint, name);

    return CallCapture(angle::EntryPoint::GLLoadName, std::move(paramBuffer));
}

CallCapture CaptureMap1d(const State &glState,
                         bool isCallValid,
                         GLenum target,
                         GLdouble u1,
                         GLdouble u2,
                         GLint stride,
                         GLint order,
                         const GLdouble *points)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::MapTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("u1", ParamType::TGLdouble, u1);
    paramBuffer.addValueParam("u2", ParamType::TGLdouble, u2);
    paramBuffer.addValueParam("stride", ParamType::TGLint, stride);
    paramBuffer.addValueParam("order", ParamType::TGLint, order);

    if (isCallValid)
    {
        ParamCapture pointsParam("points", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, points, &pointsParam.value);
        CaptureMap1d_points(glState, isCallValid, target, u1, u2, stride, order, points,
                            &pointsParam);
        paramBuffer.addParam(std::move(pointsParam));
    }
    else
    {
        ParamCapture pointsParam("points", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &pointsParam.value);
        paramBuffer.addParam(std::move(pointsParam));
    }

    return CallCapture(angle::EntryPoint::GLMap1d, std::move(paramBuffer));
}

CallCapture CaptureMap1f(const State &glState,
                         bool isCallValid,
                         GLenum target,
                         GLfloat u1,
                         GLfloat u2,
                         GLint stride,
                         GLint order,
                         const GLfloat *points)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::MapTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("u1", ParamType::TGLfloat, u1);
    paramBuffer.addValueParam("u2", ParamType::TGLfloat, u2);
    paramBuffer.addValueParam("stride", ParamType::TGLint, stride);
    paramBuffer.addValueParam("order", ParamType::TGLint, order);

    if (isCallValid)
    {
        ParamCapture pointsParam("points", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, points, &pointsParam.value);
        CaptureMap1f_points(glState, isCallValid, target, u1, u2, stride, order, points,
                            &pointsParam);
        paramBuffer.addParam(std::move(pointsParam));
    }
    else
    {
        ParamCapture pointsParam("points", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &pointsParam.value);
        paramBuffer.addParam(std::move(pointsParam));
    }

    return CallCapture(angle::EntryPoint::GLMap1f, std::move(paramBuffer));
}

CallCapture CaptureMap2d(const State &glState,
                         bool isCallValid,
                         GLenum target,
                         GLdouble u1,
                         GLdouble u2,
                         GLint ustride,
                         GLint uorder,
                         GLdouble v1,
                         GLdouble v2,
                         GLint vstride,
                         GLint vorder,
                         const GLdouble *points)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::MapTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("u1", ParamType::TGLdouble, u1);
    paramBuffer.addValueParam("u2", ParamType::TGLdouble, u2);
    paramBuffer.addValueParam("ustride", ParamType::TGLint, ustride);
    paramBuffer.addValueParam("uorder", ParamType::TGLint, uorder);
    paramBuffer.addValueParam("v1", ParamType::TGLdouble, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLdouble, v2);
    paramBuffer.addValueParam("vstride", ParamType::TGLint, vstride);
    paramBuffer.addValueParam("vorder", ParamType::TGLint, vorder);

    if (isCallValid)
    {
        ParamCapture pointsParam("points", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, points, &pointsParam.value);
        CaptureMap2d_points(glState, isCallValid, target, u1, u2, ustride, uorder, v1, v2, vstride,
                            vorder, points, &pointsParam);
        paramBuffer.addParam(std::move(pointsParam));
    }
    else
    {
        ParamCapture pointsParam("points", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &pointsParam.value);
        paramBuffer.addParam(std::move(pointsParam));
    }

    return CallCapture(angle::EntryPoint::GLMap2d, std::move(paramBuffer));
}

CallCapture CaptureMap2f(const State &glState,
                         bool isCallValid,
                         GLenum target,
                         GLfloat u1,
                         GLfloat u2,
                         GLint ustride,
                         GLint uorder,
                         GLfloat v1,
                         GLfloat v2,
                         GLint vstride,
                         GLint vorder,
                         const GLfloat *points)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::MapTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("u1", ParamType::TGLfloat, u1);
    paramBuffer.addValueParam("u2", ParamType::TGLfloat, u2);
    paramBuffer.addValueParam("ustride", ParamType::TGLint, ustride);
    paramBuffer.addValueParam("uorder", ParamType::TGLint, uorder);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);
    paramBuffer.addValueParam("vstride", ParamType::TGLint, vstride);
    paramBuffer.addValueParam("vorder", ParamType::TGLint, vorder);

    if (isCallValid)
    {
        ParamCapture pointsParam("points", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, points, &pointsParam.value);
        CaptureMap2f_points(glState, isCallValid, target, u1, u2, ustride, uorder, v1, v2, vstride,
                            vorder, points, &pointsParam);
        paramBuffer.addParam(std::move(pointsParam));
    }
    else
    {
        ParamCapture pointsParam("points", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &pointsParam.value);
        paramBuffer.addParam(std::move(pointsParam));
    }

    return CallCapture(angle::EntryPoint::GLMap2f, std::move(paramBuffer));
}

CallCapture CaptureMapGrid1d(const State &glState,
                             bool isCallValid,
                             GLint un,
                             GLdouble u1,
                             GLdouble u2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("un", ParamType::TGLint, un);
    paramBuffer.addValueParam("u1", ParamType::TGLdouble, u1);
    paramBuffer.addValueParam("u2", ParamType::TGLdouble, u2);

    return CallCapture(angle::EntryPoint::GLMapGrid1d, std::move(paramBuffer));
}

CallCapture CaptureMapGrid1f(const State &glState,
                             bool isCallValid,
                             GLint un,
                             GLfloat u1,
                             GLfloat u2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("un", ParamType::TGLint, un);
    paramBuffer.addValueParam("u1", ParamType::TGLfloat, u1);
    paramBuffer.addValueParam("u2", ParamType::TGLfloat, u2);

    return CallCapture(angle::EntryPoint::GLMapGrid1f, std::move(paramBuffer));
}

CallCapture CaptureMapGrid2d(const State &glState,
                             bool isCallValid,
                             GLint un,
                             GLdouble u1,
                             GLdouble u2,
                             GLint vn,
                             GLdouble v1,
                             GLdouble v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("un", ParamType::TGLint, un);
    paramBuffer.addValueParam("u1", ParamType::TGLdouble, u1);
    paramBuffer.addValueParam("u2", ParamType::TGLdouble, u2);
    paramBuffer.addValueParam("vn", ParamType::TGLint, vn);
    paramBuffer.addValueParam("v1", ParamType::TGLdouble, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLdouble, v2);

    return CallCapture(angle::EntryPoint::GLMapGrid2d, std::move(paramBuffer));
}

CallCapture CaptureMapGrid2f(const State &glState,
                             bool isCallValid,
                             GLint un,
                             GLfloat u1,
                             GLfloat u2,
                             GLint vn,
                             GLfloat v1,
                             GLfloat v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("un", ParamType::TGLint, un);
    paramBuffer.addValueParam("u1", ParamType::TGLfloat, u1);
    paramBuffer.addValueParam("u2", ParamType::TGLfloat, u2);
    paramBuffer.addValueParam("vn", ParamType::TGLint, vn);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);

    return CallCapture(angle::EntryPoint::GLMapGrid2f, std::move(paramBuffer));
}

CallCapture CaptureMateriali(const State &glState,
                             bool isCallValid,
                             GLenum face,
                             GLenum pname,
                             GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", BigGLEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addEnumParam("pname", BigGLEnum::MaterialParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLMateriali, std::move(paramBuffer));
}

CallCapture CaptureMaterialiv(const State &glState,
                              bool isCallValid,
                              GLenum face,
                              GLenum pname,
                              const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", BigGLEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addEnumParam("pname", BigGLEnum::MaterialParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureMaterialiv_params(glState, isCallValid, face, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLMaterialiv, std::move(paramBuffer));
}

CallCapture CaptureMultMatrixd(const State &glState, bool isCallValid, const GLdouble *m)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mParam("m", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, m, &mParam.value);
        CaptureMultMatrixd_m(glState, isCallValid, m, &mParam);
        paramBuffer.addParam(std::move(mParam));
    }
    else
    {
        ParamCapture mParam("m", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &mParam.value);
        paramBuffer.addParam(std::move(mParam));
    }

    return CallCapture(angle::EntryPoint::GLMultMatrixd, std::move(paramBuffer));
}

CallCapture CaptureNewList(const State &glState, bool isCallValid, GLuint list, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("list", ParamType::TGLuint, list);
    paramBuffer.addEnumParam("mode", BigGLEnum::ListMode, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLNewList, std::move(paramBuffer));
}

CallCapture CaptureNormal3b(const State &glState, bool isCallValid, GLbyte nx, GLbyte ny, GLbyte nz)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("nx", ParamType::TGLbyte, nx);
    paramBuffer.addValueParam("ny", ParamType::TGLbyte, ny);
    paramBuffer.addValueParam("nz", ParamType::TGLbyte, nz);

    return CallCapture(angle::EntryPoint::GLNormal3b, std::move(paramBuffer));
}

CallCapture CaptureNormal3bv(const State &glState, bool isCallValid, const GLbyte *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLbyteConstPointer);
        InitParamValue(ParamType::TGLbyteConstPointer, v, &vParam.value);
        CaptureNormal3bv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLbyteConstPointer);
        InitParamValue(ParamType::TGLbyteConstPointer, static_cast<const GLbyte *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLNormal3bv, std::move(paramBuffer));
}

CallCapture CaptureNormal3d(const State &glState,
                            bool isCallValid,
                            GLdouble nx,
                            GLdouble ny,
                            GLdouble nz)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("nx", ParamType::TGLdouble, nx);
    paramBuffer.addValueParam("ny", ParamType::TGLdouble, ny);
    paramBuffer.addValueParam("nz", ParamType::TGLdouble, nz);

    return CallCapture(angle::EntryPoint::GLNormal3d, std::move(paramBuffer));
}

CallCapture CaptureNormal3dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureNormal3dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLNormal3dv, std::move(paramBuffer));
}

CallCapture CaptureNormal3fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureNormal3fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLNormal3fv, std::move(paramBuffer));
}

CallCapture CaptureNormal3i(const State &glState, bool isCallValid, GLint nx, GLint ny, GLint nz)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("nx", ParamType::TGLint, nx);
    paramBuffer.addValueParam("ny", ParamType::TGLint, ny);
    paramBuffer.addValueParam("nz", ParamType::TGLint, nz);

    return CallCapture(angle::EntryPoint::GLNormal3i, std::move(paramBuffer));
}

CallCapture CaptureNormal3iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureNormal3iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLNormal3iv, std::move(paramBuffer));
}

CallCapture CaptureNormal3s(const State &glState,
                            bool isCallValid,
                            GLshort nx,
                            GLshort ny,
                            GLshort nz)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("nx", ParamType::TGLshort, nx);
    paramBuffer.addValueParam("ny", ParamType::TGLshort, ny);
    paramBuffer.addValueParam("nz", ParamType::TGLshort, nz);

    return CallCapture(angle::EntryPoint::GLNormal3s, std::move(paramBuffer));
}

CallCapture CaptureNormal3sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureNormal3sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLNormal3sv, std::move(paramBuffer));
}

CallCapture CaptureOrtho(const State &glState,
                         bool isCallValid,
                         GLdouble left,
                         GLdouble right,
                         GLdouble bottom,
                         GLdouble top,
                         GLdouble zNear,
                         GLdouble zFar)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("left", ParamType::TGLdouble, left);
    paramBuffer.addValueParam("right", ParamType::TGLdouble, right);
    paramBuffer.addValueParam("bottom", ParamType::TGLdouble, bottom);
    paramBuffer.addValueParam("top", ParamType::TGLdouble, top);
    paramBuffer.addValueParam("zNear", ParamType::TGLdouble, zNear);
    paramBuffer.addValueParam("zFar", ParamType::TGLdouble, zFar);

    return CallCapture(angle::EntryPoint::GLOrtho, std::move(paramBuffer));
}

CallCapture CapturePassThrough(const State &glState, bool isCallValid, GLfloat token)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("token", ParamType::TGLfloat, token);

    return CallCapture(angle::EntryPoint::GLPassThrough, std::move(paramBuffer));
}

CallCapture CapturePixelMapfv(const State &glState,
                              bool isCallValid,
                              GLenum map,
                              GLsizei mapsize,
                              const GLfloat *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("map", BigGLEnum::PixelMap, ParamType::TGLenum, map);
    paramBuffer.addValueParam("mapsize", ParamType::TGLsizei, mapsize);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, values, &valuesParam.value);
        CapturePixelMapfv_values(glState, isCallValid, map, mapsize, values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLPixelMapfv, std::move(paramBuffer));
}

CallCapture CapturePixelMapuiv(const State &glState,
                               bool isCallValid,
                               GLenum map,
                               GLsizei mapsize,
                               const GLuint *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("map", BigGLEnum::PixelMap, ParamType::TGLenum, map);
    paramBuffer.addValueParam("mapsize", ParamType::TGLsizei, mapsize);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, values, &valuesParam.value);
        CapturePixelMapuiv_values(glState, isCallValid, map, mapsize, values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLPixelMapuiv, std::move(paramBuffer));
}

CallCapture CapturePixelMapusv(const State &glState,
                               bool isCallValid,
                               GLenum map,
                               GLsizei mapsize,
                               const GLushort *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("map", BigGLEnum::PixelMap, ParamType::TGLenum, map);
    paramBuffer.addValueParam("mapsize", ParamType::TGLsizei, mapsize);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLushortConstPointer);
        InitParamValue(ParamType::TGLushortConstPointer, values, &valuesParam.value);
        CapturePixelMapusv_values(glState, isCallValid, map, mapsize, values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLushortConstPointer);
        InitParamValue(ParamType::TGLushortConstPointer, static_cast<const GLushort *>(nullptr),
                       &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLPixelMapusv, std::move(paramBuffer));
}

CallCapture CapturePixelStoref(const State &glState, bool isCallValid, GLenum pname, GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", BigGLEnum::PixelStoreParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLPixelStoref, std::move(paramBuffer));
}

CallCapture CapturePixelTransferf(const State &glState,
                                  bool isCallValid,
                                  GLenum pname,
                                  GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", BigGLEnum::PixelTransferParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLPixelTransferf, std::move(paramBuffer));
}

CallCapture CapturePixelTransferi(const State &glState, bool isCallValid, GLenum pname, GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", BigGLEnum::PixelTransferParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLPixelTransferi, std::move(paramBuffer));
}

CallCapture CapturePixelZoom(const State &glState,
                             bool isCallValid,
                             GLfloat xfactor,
                             GLfloat yfactor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("xfactor", ParamType::TGLfloat, xfactor);
    paramBuffer.addValueParam("yfactor", ParamType::TGLfloat, yfactor);

    return CallCapture(angle::EntryPoint::GLPixelZoom, std::move(paramBuffer));
}

CallCapture CapturePolygonMode(const State &glState, bool isCallValid, GLenum face, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", BigGLEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addEnumParam("mode", BigGLEnum::PolygonMode, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLPolygonMode, std::move(paramBuffer));
}

CallCapture CapturePolygonStipple(const State &glState, bool isCallValid, const GLubyte *mask)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture maskParam("mask", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, mask, &maskParam.value);
        CapturePolygonStipple_mask(glState, isCallValid, mask, &maskParam);
        paramBuffer.addParam(std::move(maskParam));
    }
    else
    {
        ParamCapture maskParam("mask", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, static_cast<const GLubyte *>(nullptr),
                       &maskParam.value);
        paramBuffer.addParam(std::move(maskParam));
    }

    return CallCapture(angle::EntryPoint::GLPolygonStipple, std::move(paramBuffer));
}

CallCapture CapturePopAttrib(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLPopAttrib, std::move(paramBuffer));
}

CallCapture CapturePopName(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLPopName, std::move(paramBuffer));
}

CallCapture CapturePushAttrib(const State &glState, bool isCallValid, GLbitfield mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mask", BigGLEnum::AttribMask, ParamType::TGLbitfield, mask);

    return CallCapture(angle::EntryPoint::GLPushAttrib, std::move(paramBuffer));
}

CallCapture CapturePushName(const State &glState, bool isCallValid, GLuint name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("name", ParamType::TGLuint, name);

    return CallCapture(angle::EntryPoint::GLPushName, std::move(paramBuffer));
}

CallCapture CaptureRasterPos2d(const State &glState, bool isCallValid, GLdouble x, GLdouble y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);

    return CallCapture(angle::EntryPoint::GLRasterPos2d, std::move(paramBuffer));
}

CallCapture CaptureRasterPos2dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureRasterPos2dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos2dv, std::move(paramBuffer));
}

CallCapture CaptureRasterPos2f(const State &glState, bool isCallValid, GLfloat x, GLfloat y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);

    return CallCapture(angle::EntryPoint::GLRasterPos2f, std::move(paramBuffer));
}

CallCapture CaptureRasterPos2fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureRasterPos2fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos2fv, std::move(paramBuffer));
}

CallCapture CaptureRasterPos2i(const State &glState, bool isCallValid, GLint x, GLint y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);

    return CallCapture(angle::EntryPoint::GLRasterPos2i, std::move(paramBuffer));
}

CallCapture CaptureRasterPos2iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureRasterPos2iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos2iv, std::move(paramBuffer));
}

CallCapture CaptureRasterPos2s(const State &glState, bool isCallValid, GLshort x, GLshort y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);

    return CallCapture(angle::EntryPoint::GLRasterPos2s, std::move(paramBuffer));
}

CallCapture CaptureRasterPos2sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureRasterPos2sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos2sv, std::move(paramBuffer));
}

CallCapture CaptureRasterPos3d(const State &glState,
                               bool isCallValid,
                               GLdouble x,
                               GLdouble y,
                               GLdouble z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);

    return CallCapture(angle::EntryPoint::GLRasterPos3d, std::move(paramBuffer));
}

CallCapture CaptureRasterPos3dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureRasterPos3dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos3dv, std::move(paramBuffer));
}

CallCapture CaptureRasterPos3f(const State &glState,
                               bool isCallValid,
                               GLfloat x,
                               GLfloat y,
                               GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture(angle::EntryPoint::GLRasterPos3f, std::move(paramBuffer));
}

CallCapture CaptureRasterPos3fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureRasterPos3fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos3fv, std::move(paramBuffer));
}

CallCapture CaptureRasterPos3i(const State &glState, bool isCallValid, GLint x, GLint y, GLint z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);

    return CallCapture(angle::EntryPoint::GLRasterPos3i, std::move(paramBuffer));
}

CallCapture CaptureRasterPos3iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureRasterPos3iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos3iv, std::move(paramBuffer));
}

CallCapture CaptureRasterPos3s(const State &glState,
                               bool isCallValid,
                               GLshort x,
                               GLshort y,
                               GLshort z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);
    paramBuffer.addValueParam("z", ParamType::TGLshort, z);

    return CallCapture(angle::EntryPoint::GLRasterPos3s, std::move(paramBuffer));
}

CallCapture CaptureRasterPos3sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureRasterPos3sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos3sv, std::move(paramBuffer));
}

CallCapture CaptureRasterPos4d(const State &glState,
                               bool isCallValid,
                               GLdouble x,
                               GLdouble y,
                               GLdouble z,
                               GLdouble w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);
    paramBuffer.addValueParam("w", ParamType::TGLdouble, w);

    return CallCapture(angle::EntryPoint::GLRasterPos4d, std::move(paramBuffer));
}

CallCapture CaptureRasterPos4dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureRasterPos4dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos4dv, std::move(paramBuffer));
}

CallCapture CaptureRasterPos4f(const State &glState,
                               bool isCallValid,
                               GLfloat x,
                               GLfloat y,
                               GLfloat z,
                               GLfloat w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);
    paramBuffer.addValueParam("w", ParamType::TGLfloat, w);

    return CallCapture(angle::EntryPoint::GLRasterPos4f, std::move(paramBuffer));
}

CallCapture CaptureRasterPos4fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureRasterPos4fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos4fv, std::move(paramBuffer));
}

CallCapture CaptureRasterPos4i(const State &glState,
                               bool isCallValid,
                               GLint x,
                               GLint y,
                               GLint z,
                               GLint w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("w", ParamType::TGLint, w);

    return CallCapture(angle::EntryPoint::GLRasterPos4i, std::move(paramBuffer));
}

CallCapture CaptureRasterPos4iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureRasterPos4iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos4iv, std::move(paramBuffer));
}

CallCapture CaptureRasterPos4s(const State &glState,
                               bool isCallValid,
                               GLshort x,
                               GLshort y,
                               GLshort z,
                               GLshort w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);
    paramBuffer.addValueParam("z", ParamType::TGLshort, z);
    paramBuffer.addValueParam("w", ParamType::TGLshort, w);

    return CallCapture(angle::EntryPoint::GLRasterPos4s, std::move(paramBuffer));
}

CallCapture CaptureRasterPos4sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureRasterPos4sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLRasterPos4sv, std::move(paramBuffer));
}

CallCapture CaptureRectd(const State &glState,
                         bool isCallValid,
                         GLdouble x1,
                         GLdouble y1,
                         GLdouble x2,
                         GLdouble y2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x1", ParamType::TGLdouble, x1);
    paramBuffer.addValueParam("y1", ParamType::TGLdouble, y1);
    paramBuffer.addValueParam("x2", ParamType::TGLdouble, x2);
    paramBuffer.addValueParam("y2", ParamType::TGLdouble, y2);

    return CallCapture(angle::EntryPoint::GLRectd, std::move(paramBuffer));
}

CallCapture CaptureRectdv(const State &glState,
                          bool isCallValid,
                          const GLdouble *v1,
                          const GLdouble *v2)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture v1Param("v1", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v1, &v1Param.value);
        CaptureRectdv_v1(glState, isCallValid, v1, v2, &v1Param);
        paramBuffer.addParam(std::move(v1Param));
    }
    else
    {
        ParamCapture v1Param("v1", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &v1Param.value);
        paramBuffer.addParam(std::move(v1Param));
    }

    if (isCallValid)
    {
        ParamCapture v2Param("v2", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v2, &v2Param.value);
        CaptureRectdv_v2(glState, isCallValid, v1, v2, &v2Param);
        paramBuffer.addParam(std::move(v2Param));
    }
    else
    {
        ParamCapture v2Param("v2", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &v2Param.value);
        paramBuffer.addParam(std::move(v2Param));
    }

    return CallCapture(angle::EntryPoint::GLRectdv, std::move(paramBuffer));
}

CallCapture CaptureRectf(const State &glState,
                         bool isCallValid,
                         GLfloat x1,
                         GLfloat y1,
                         GLfloat x2,
                         GLfloat y2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x1", ParamType::TGLfloat, x1);
    paramBuffer.addValueParam("y1", ParamType::TGLfloat, y1);
    paramBuffer.addValueParam("x2", ParamType::TGLfloat, x2);
    paramBuffer.addValueParam("y2", ParamType::TGLfloat, y2);

    return CallCapture(angle::EntryPoint::GLRectf, std::move(paramBuffer));
}

CallCapture CaptureRectfv(const State &glState,
                          bool isCallValid,
                          const GLfloat *v1,
                          const GLfloat *v2)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture v1Param("v1", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v1, &v1Param.value);
        CaptureRectfv_v1(glState, isCallValid, v1, v2, &v1Param);
        paramBuffer.addParam(std::move(v1Param));
    }
    else
    {
        ParamCapture v1Param("v1", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &v1Param.value);
        paramBuffer.addParam(std::move(v1Param));
    }

    if (isCallValid)
    {
        ParamCapture v2Param("v2", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v2, &v2Param.value);
        CaptureRectfv_v2(glState, isCallValid, v1, v2, &v2Param);
        paramBuffer.addParam(std::move(v2Param));
    }
    else
    {
        ParamCapture v2Param("v2", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &v2Param.value);
        paramBuffer.addParam(std::move(v2Param));
    }

    return CallCapture(angle::EntryPoint::GLRectfv, std::move(paramBuffer));
}

CallCapture CaptureRecti(const State &glState,
                         bool isCallValid,
                         GLint x1,
                         GLint y1,
                         GLint x2,
                         GLint y2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x1", ParamType::TGLint, x1);
    paramBuffer.addValueParam("y1", ParamType::TGLint, y1);
    paramBuffer.addValueParam("x2", ParamType::TGLint, x2);
    paramBuffer.addValueParam("y2", ParamType::TGLint, y2);

    return CallCapture(angle::EntryPoint::GLRecti, std::move(paramBuffer));
}

CallCapture CaptureRectiv(const State &glState, bool isCallValid, const GLint *v1, const GLint *v2)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture v1Param("v1", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v1, &v1Param.value);
        CaptureRectiv_v1(glState, isCallValid, v1, v2, &v1Param);
        paramBuffer.addParam(std::move(v1Param));
    }
    else
    {
        ParamCapture v1Param("v1", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &v1Param.value);
        paramBuffer.addParam(std::move(v1Param));
    }

    if (isCallValid)
    {
        ParamCapture v2Param("v2", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v2, &v2Param.value);
        CaptureRectiv_v2(glState, isCallValid, v1, v2, &v2Param);
        paramBuffer.addParam(std::move(v2Param));
    }
    else
    {
        ParamCapture v2Param("v2", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &v2Param.value);
        paramBuffer.addParam(std::move(v2Param));
    }

    return CallCapture(angle::EntryPoint::GLRectiv, std::move(paramBuffer));
}

CallCapture CaptureRects(const State &glState,
                         bool isCallValid,
                         GLshort x1,
                         GLshort y1,
                         GLshort x2,
                         GLshort y2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x1", ParamType::TGLshort, x1);
    paramBuffer.addValueParam("y1", ParamType::TGLshort, y1);
    paramBuffer.addValueParam("x2", ParamType::TGLshort, x2);
    paramBuffer.addValueParam("y2", ParamType::TGLshort, y2);

    return CallCapture(angle::EntryPoint::GLRects, std::move(paramBuffer));
}

CallCapture CaptureRectsv(const State &glState,
                          bool isCallValid,
                          const GLshort *v1,
                          const GLshort *v2)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture v1Param("v1", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v1, &v1Param.value);
        CaptureRectsv_v1(glState, isCallValid, v1, v2, &v1Param);
        paramBuffer.addParam(std::move(v1Param));
    }
    else
    {
        ParamCapture v1Param("v1", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &v1Param.value);
        paramBuffer.addParam(std::move(v1Param));
    }

    if (isCallValid)
    {
        ParamCapture v2Param("v2", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v2, &v2Param.value);
        CaptureRectsv_v2(glState, isCallValid, v1, v2, &v2Param);
        paramBuffer.addParam(std::move(v2Param));
    }
    else
    {
        ParamCapture v2Param("v2", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &v2Param.value);
        paramBuffer.addParam(std::move(v2Param));
    }

    return CallCapture(angle::EntryPoint::GLRectsv, std::move(paramBuffer));
}

CallCapture CaptureRenderMode(const State &glState,
                              bool isCallValid,
                              GLenum mode,
                              GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", BigGLEnum::RenderingMode, ParamType::TGLenum, mode);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLRenderMode, std::move(paramBuffer));
}

CallCapture CaptureRotated(const State &glState,
                           bool isCallValid,
                           GLdouble angle,
                           GLdouble x,
                           GLdouble y,
                           GLdouble z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("angle", ParamType::TGLdouble, angle);
    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);

    return CallCapture(angle::EntryPoint::GLRotated, std::move(paramBuffer));
}

CallCapture CaptureScaled(const State &glState,
                          bool isCallValid,
                          GLdouble x,
                          GLdouble y,
                          GLdouble z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);

    return CallCapture(angle::EntryPoint::GLScaled, std::move(paramBuffer));
}

CallCapture CaptureSelectBuffer(const State &glState,
                                bool isCallValid,
                                GLsizei size,
                                GLuint *buffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLsizei, size);

    if (isCallValid)
    {
        ParamCapture bufferParam("buffer", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, buffer, &bufferParam.value);
        CaptureSelectBuffer_buffer(glState, isCallValid, size, buffer, &bufferParam);
        paramBuffer.addParam(std::move(bufferParam));
    }
    else
    {
        ParamCapture bufferParam("buffer", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &bufferParam.value);
        paramBuffer.addParam(std::move(bufferParam));
    }

    return CallCapture(angle::EntryPoint::GLSelectBuffer, std::move(paramBuffer));
}

CallCapture CaptureTexCoord1d(const State &glState, bool isCallValid, GLdouble s)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLdouble, s);

    return CallCapture(angle::EntryPoint::GLTexCoord1d, std::move(paramBuffer));
}

CallCapture CaptureTexCoord1dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureTexCoord1dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord1dv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord1f(const State &glState, bool isCallValid, GLfloat s)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLfloat, s);

    return CallCapture(angle::EntryPoint::GLTexCoord1f, std::move(paramBuffer));
}

CallCapture CaptureTexCoord1fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureTexCoord1fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord1fv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord1i(const State &glState, bool isCallValid, GLint s)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLint, s);

    return CallCapture(angle::EntryPoint::GLTexCoord1i, std::move(paramBuffer));
}

CallCapture CaptureTexCoord1iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureTexCoord1iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord1iv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord1s(const State &glState, bool isCallValid, GLshort s)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLshort, s);

    return CallCapture(angle::EntryPoint::GLTexCoord1s, std::move(paramBuffer));
}

CallCapture CaptureTexCoord1sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureTexCoord1sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord1sv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord2d(const State &glState, bool isCallValid, GLdouble s, GLdouble t)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLdouble, s);
    paramBuffer.addValueParam("t", ParamType::TGLdouble, t);

    return CallCapture(angle::EntryPoint::GLTexCoord2d, std::move(paramBuffer));
}

CallCapture CaptureTexCoord2dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureTexCoord2dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord2dv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord2f(const State &glState, bool isCallValid, GLfloat s, GLfloat t)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLfloat, s);
    paramBuffer.addValueParam("t", ParamType::TGLfloat, t);

    return CallCapture(angle::EntryPoint::GLTexCoord2f, std::move(paramBuffer));
}

CallCapture CaptureTexCoord2fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureTexCoord2fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord2fv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord2i(const State &glState, bool isCallValid, GLint s, GLint t)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLint, s);
    paramBuffer.addValueParam("t", ParamType::TGLint, t);

    return CallCapture(angle::EntryPoint::GLTexCoord2i, std::move(paramBuffer));
}

CallCapture CaptureTexCoord2iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureTexCoord2iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord2iv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord2s(const State &glState, bool isCallValid, GLshort s, GLshort t)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLshort, s);
    paramBuffer.addValueParam("t", ParamType::TGLshort, t);

    return CallCapture(angle::EntryPoint::GLTexCoord2s, std::move(paramBuffer));
}

CallCapture CaptureTexCoord2sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureTexCoord2sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord2sv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord3d(const State &glState,
                              bool isCallValid,
                              GLdouble s,
                              GLdouble t,
                              GLdouble r)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLdouble, s);
    paramBuffer.addValueParam("t", ParamType::TGLdouble, t);
    paramBuffer.addValueParam("r", ParamType::TGLdouble, r);

    return CallCapture(angle::EntryPoint::GLTexCoord3d, std::move(paramBuffer));
}

CallCapture CaptureTexCoord3dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureTexCoord3dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord3dv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord3f(const State &glState,
                              bool isCallValid,
                              GLfloat s,
                              GLfloat t,
                              GLfloat r)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLfloat, s);
    paramBuffer.addValueParam("t", ParamType::TGLfloat, t);
    paramBuffer.addValueParam("r", ParamType::TGLfloat, r);

    return CallCapture(angle::EntryPoint::GLTexCoord3f, std::move(paramBuffer));
}

CallCapture CaptureTexCoord3fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureTexCoord3fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord3fv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord3i(const State &glState, bool isCallValid, GLint s, GLint t, GLint r)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLint, s);
    paramBuffer.addValueParam("t", ParamType::TGLint, t);
    paramBuffer.addValueParam("r", ParamType::TGLint, r);

    return CallCapture(angle::EntryPoint::GLTexCoord3i, std::move(paramBuffer));
}

CallCapture CaptureTexCoord3iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureTexCoord3iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord3iv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord3s(const State &glState,
                              bool isCallValid,
                              GLshort s,
                              GLshort t,
                              GLshort r)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLshort, s);
    paramBuffer.addValueParam("t", ParamType::TGLshort, t);
    paramBuffer.addValueParam("r", ParamType::TGLshort, r);

    return CallCapture(angle::EntryPoint::GLTexCoord3s, std::move(paramBuffer));
}

CallCapture CaptureTexCoord3sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureTexCoord3sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord3sv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord4d(const State &glState,
                              bool isCallValid,
                              GLdouble s,
                              GLdouble t,
                              GLdouble r,
                              GLdouble q)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLdouble, s);
    paramBuffer.addValueParam("t", ParamType::TGLdouble, t);
    paramBuffer.addValueParam("r", ParamType::TGLdouble, r);
    paramBuffer.addValueParam("q", ParamType::TGLdouble, q);

    return CallCapture(angle::EntryPoint::GLTexCoord4d, std::move(paramBuffer));
}

CallCapture CaptureTexCoord4dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureTexCoord4dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord4dv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord4f(const State &glState,
                              bool isCallValid,
                              GLfloat s,
                              GLfloat t,
                              GLfloat r,
                              GLfloat q)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLfloat, s);
    paramBuffer.addValueParam("t", ParamType::TGLfloat, t);
    paramBuffer.addValueParam("r", ParamType::TGLfloat, r);
    paramBuffer.addValueParam("q", ParamType::TGLfloat, q);

    return CallCapture(angle::EntryPoint::GLTexCoord4f, std::move(paramBuffer));
}

CallCapture CaptureTexCoord4fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureTexCoord4fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord4fv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord4i(const State &glState,
                              bool isCallValid,
                              GLint s,
                              GLint t,
                              GLint r,
                              GLint q)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLint, s);
    paramBuffer.addValueParam("t", ParamType::TGLint, t);
    paramBuffer.addValueParam("r", ParamType::TGLint, r);
    paramBuffer.addValueParam("q", ParamType::TGLint, q);

    return CallCapture(angle::EntryPoint::GLTexCoord4i, std::move(paramBuffer));
}

CallCapture CaptureTexCoord4iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureTexCoord4iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord4iv, std::move(paramBuffer));
}

CallCapture CaptureTexCoord4s(const State &glState,
                              bool isCallValid,
                              GLshort s,
                              GLshort t,
                              GLshort r,
                              GLshort q)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLshort, s);
    paramBuffer.addValueParam("t", ParamType::TGLshort, t);
    paramBuffer.addValueParam("r", ParamType::TGLshort, r);
    paramBuffer.addValueParam("q", ParamType::TGLshort, q);

    return CallCapture(angle::EntryPoint::GLTexCoord4s, std::move(paramBuffer));
}

CallCapture CaptureTexCoord4sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureTexCoord4sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoord4sv, std::move(paramBuffer));
}

CallCapture CaptureTexGend(const State &glState,
                           bool isCallValid,
                           GLenum coord,
                           GLenum pname,
                           GLdouble param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", BigGLEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLdouble, param);

    return CallCapture(angle::EntryPoint::GLTexGend, std::move(paramBuffer));
}

CallCapture CaptureTexGendv(const State &glState,
                            bool isCallValid,
                            GLenum coord,
                            GLenum pname,
                            const GLdouble *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", BigGLEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, params, &paramsParam.value);
        CaptureTexGendv_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexGendv, std::move(paramBuffer));
}

CallCapture CaptureTexGenf(const State &glState,
                           bool isCallValid,
                           GLenum coord,
                           GLenum pname,
                           GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", BigGLEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLTexGenf, std::move(paramBuffer));
}

CallCapture CaptureTexGenfv(const State &glState,
                            bool isCallValid,
                            GLenum coord,
                            GLenum pname,
                            const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", BigGLEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CaptureTexGenfv_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexGenfv, std::move(paramBuffer));
}

CallCapture CaptureTexGeni(const State &glState,
                           bool isCallValid,
                           GLenum coord,
                           GLenum pname,
                           GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", BigGLEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLTexGeni, std::move(paramBuffer));
}

CallCapture CaptureTexGeniv(const State &glState,
                            bool isCallValid,
                            GLenum coord,
                            GLenum pname,
                            const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", BigGLEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexGeniv_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexGeniv, std::move(paramBuffer));
}

CallCapture CaptureTexImage1D(const State &glState,
                              bool isCallValid,
                              GLenum target,
                              GLint level,
                              GLint internalformat,
                              GLsizei width,
                              GLint border,
                              GLenum format,
                              GLenum type,
                              const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexImage1D_pixels(glState, isCallValid, target, level, internalformat, width, border,
                                 format, type, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexImage1D, std::move(paramBuffer));
}

CallCapture CaptureTranslated(const State &glState,
                              bool isCallValid,
                              GLdouble x,
                              GLdouble y,
                              GLdouble z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);

    return CallCapture(angle::EntryPoint::GLTranslated, std::move(paramBuffer));
}

CallCapture CaptureVertex2d(const State &glState, bool isCallValid, GLdouble x, GLdouble y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);

    return CallCapture(angle::EntryPoint::GLVertex2d, std::move(paramBuffer));
}

CallCapture CaptureVertex2dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureVertex2dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex2dv, std::move(paramBuffer));
}

CallCapture CaptureVertex2f(const State &glState, bool isCallValid, GLfloat x, GLfloat y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);

    return CallCapture(angle::EntryPoint::GLVertex2f, std::move(paramBuffer));
}

CallCapture CaptureVertex2fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureVertex2fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex2fv, std::move(paramBuffer));
}

CallCapture CaptureVertex2i(const State &glState, bool isCallValid, GLint x, GLint y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);

    return CallCapture(angle::EntryPoint::GLVertex2i, std::move(paramBuffer));
}

CallCapture CaptureVertex2iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureVertex2iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex2iv, std::move(paramBuffer));
}

CallCapture CaptureVertex2s(const State &glState, bool isCallValid, GLshort x, GLshort y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);

    return CallCapture(angle::EntryPoint::GLVertex2s, std::move(paramBuffer));
}

CallCapture CaptureVertex2sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureVertex2sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex2sv, std::move(paramBuffer));
}

CallCapture CaptureVertex3d(const State &glState,
                            bool isCallValid,
                            GLdouble x,
                            GLdouble y,
                            GLdouble z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);

    return CallCapture(angle::EntryPoint::GLVertex3d, std::move(paramBuffer));
}

CallCapture CaptureVertex3dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureVertex3dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex3dv, std::move(paramBuffer));
}

CallCapture CaptureVertex3f(const State &glState, bool isCallValid, GLfloat x, GLfloat y, GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture(angle::EntryPoint::GLVertex3f, std::move(paramBuffer));
}

CallCapture CaptureVertex3fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureVertex3fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex3fv, std::move(paramBuffer));
}

CallCapture CaptureVertex3i(const State &glState, bool isCallValid, GLint x, GLint y, GLint z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);

    return CallCapture(angle::EntryPoint::GLVertex3i, std::move(paramBuffer));
}

CallCapture CaptureVertex3iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureVertex3iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex3iv, std::move(paramBuffer));
}

CallCapture CaptureVertex3s(const State &glState, bool isCallValid, GLshort x, GLshort y, GLshort z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);
    paramBuffer.addValueParam("z", ParamType::TGLshort, z);

    return CallCapture(angle::EntryPoint::GLVertex3s, std::move(paramBuffer));
}

CallCapture CaptureVertex3sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureVertex3sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex3sv, std::move(paramBuffer));
}

CallCapture CaptureVertex4d(const State &glState,
                            bool isCallValid,
                            GLdouble x,
                            GLdouble y,
                            GLdouble z,
                            GLdouble w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);
    paramBuffer.addValueParam("w", ParamType::TGLdouble, w);

    return CallCapture(angle::EntryPoint::GLVertex4d, std::move(paramBuffer));
}

CallCapture CaptureVertex4dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureVertex4dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex4dv, std::move(paramBuffer));
}

CallCapture CaptureVertex4f(const State &glState,
                            bool isCallValid,
                            GLfloat x,
                            GLfloat y,
                            GLfloat z,
                            GLfloat w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);
    paramBuffer.addValueParam("w", ParamType::TGLfloat, w);

    return CallCapture(angle::EntryPoint::GLVertex4f, std::move(paramBuffer));
}

CallCapture CaptureVertex4fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureVertex4fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex4fv, std::move(paramBuffer));
}

CallCapture CaptureVertex4i(const State &glState,
                            bool isCallValid,
                            GLint x,
                            GLint y,
                            GLint z,
                            GLint w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("w", ParamType::TGLint, w);

    return CallCapture(angle::EntryPoint::GLVertex4i, std::move(paramBuffer));
}

CallCapture CaptureVertex4iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureVertex4iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex4iv, std::move(paramBuffer));
}

CallCapture CaptureVertex4s(const State &glState,
                            bool isCallValid,
                            GLshort x,
                            GLshort y,
                            GLshort z,
                            GLshort w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);
    paramBuffer.addValueParam("z", ParamType::TGLshort, z);
    paramBuffer.addValueParam("w", ParamType::TGLshort, w);

    return CallCapture(angle::EntryPoint::GLVertex4s, std::move(paramBuffer));
}

CallCapture CaptureVertex4sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureVertex4sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertex4sv, std::move(paramBuffer));
}

// GL 1.1
CallCapture CaptureAreTexturesResident(const State &glState,
                                       bool isCallValid,
                                       GLsizei n,
                                       const GLuint *textures,
                                       GLboolean *residences,
                                       GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture texturesParam("textures", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, textures, &texturesParam.value);
        CaptureAreTexturesResident_textures(glState, isCallValid, n, textures, residences,
                                            &texturesParam);
        paramBuffer.addParam(std::move(texturesParam));
    }
    else
    {
        ParamCapture texturesParam("textures", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &texturesParam.value);
        paramBuffer.addParam(std::move(texturesParam));
    }

    if (isCallValid)
    {
        ParamCapture residencesParam("residences", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, residences, &residencesParam.value);
        CaptureAreTexturesResident_residences(glState, isCallValid, n, textures, residences,
                                              &residencesParam);
        paramBuffer.addParam(std::move(residencesParam));
    }
    else
    {
        ParamCapture residencesParam("residences", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, static_cast<GLboolean *>(nullptr),
                       &residencesParam.value);
        paramBuffer.addParam(std::move(residencesParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLAreTexturesResident, std::move(paramBuffer));
}

CallCapture CaptureArrayElement(const State &glState, bool isCallValid, GLint i)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("i", ParamType::TGLint, i);

    return CallCapture(angle::EntryPoint::GLArrayElement, std::move(paramBuffer));
}

CallCapture CaptureCopyTexImage1D(const State &glState,
                                  bool isCallValid,
                                  GLenum target,
                                  GLint level,
                                  GLenum internalformat,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLint border)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);

    return CallCapture(angle::EntryPoint::GLCopyTexImage1D, std::move(paramBuffer));
}

CallCapture CaptureCopyTexSubImage1D(const State &glState,
                                     bool isCallValid,
                                     GLenum target,
                                     GLint level,
                                     GLint xoffset,
                                     GLint x,
                                     GLint y,
                                     GLsizei width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);

    return CallCapture(angle::EntryPoint::GLCopyTexSubImage1D, std::move(paramBuffer));
}

CallCapture CaptureEdgeFlagPointer(const State &glState,
                                   bool isCallValid,
                                   GLsizei stride,
                                   const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureEdgeFlagPointer_pointer(glState, isCallValid, stride, pointer, &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLEdgeFlagPointer, std::move(paramBuffer));
}

CallCapture CaptureIndexPointer(const State &glState,
                                bool isCallValid,
                                GLenum type,
                                GLsizei stride,
                                const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::IndexPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureIndexPointer_pointer(glState, isCallValid, type, stride, pointer, &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLIndexPointer, std::move(paramBuffer));
}

CallCapture CaptureIndexub(const State &glState, bool isCallValid, GLubyte c)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("c", ParamType::TGLubyte, c);

    return CallCapture(angle::EntryPoint::GLIndexub, std::move(paramBuffer));
}

CallCapture CaptureIndexubv(const State &glState, bool isCallValid, const GLubyte *c)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture cParam("c", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, c, &cParam.value);
        CaptureIndexubv_c(glState, isCallValid, c, &cParam);
        paramBuffer.addParam(std::move(cParam));
    }
    else
    {
        ParamCapture cParam("c", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, static_cast<const GLubyte *>(nullptr),
                       &cParam.value);
        paramBuffer.addParam(std::move(cParam));
    }

    return CallCapture(angle::EntryPoint::GLIndexubv, std::move(paramBuffer));
}

CallCapture CaptureInterleavedArrays(const State &glState,
                                     bool isCallValid,
                                     GLenum format,
                                     GLsizei stride,
                                     const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("format", BigGLEnum::InterleavedArrayFormat, ParamType::TGLenum,
                             format);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureInterleavedArrays_pointer(glState, isCallValid, format, stride, pointer,
                                         &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLInterleavedArrays, std::move(paramBuffer));
}

CallCapture CapturePopClientAttrib(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLPopClientAttrib, std::move(paramBuffer));
}

CallCapture CapturePrioritizeTextures(const State &glState,
                                      bool isCallValid,
                                      GLsizei n,
                                      const GLuint *textures,
                                      const GLfloat *priorities)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture texturesParam("textures", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, textures, &texturesParam.value);
        CapturePrioritizeTextures_textures(glState, isCallValid, n, textures, priorities,
                                           &texturesParam);
        paramBuffer.addParam(std::move(texturesParam));
    }
    else
    {
        ParamCapture texturesParam("textures", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &texturesParam.value);
        paramBuffer.addParam(std::move(texturesParam));
    }

    if (isCallValid)
    {
        ParamCapture prioritiesParam("priorities", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, priorities, &prioritiesParam.value);
        CapturePrioritizeTextures_priorities(glState, isCallValid, n, textures, priorities,
                                             &prioritiesParam);
        paramBuffer.addParam(std::move(prioritiesParam));
    }
    else
    {
        ParamCapture prioritiesParam("priorities", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &prioritiesParam.value);
        paramBuffer.addParam(std::move(prioritiesParam));
    }

    return CallCapture(angle::EntryPoint::GLPrioritizeTextures, std::move(paramBuffer));
}

CallCapture CapturePushClientAttrib(const State &glState, bool isCallValid, GLbitfield mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mask", BigGLEnum::ClientAttribMask, ParamType::TGLbitfield, mask);

    return CallCapture(angle::EntryPoint::GLPushClientAttrib, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage1D(const State &glState,
                                 bool isCallValid,
                                 GLenum target,
                                 GLint level,
                                 GLint xoffset,
                                 GLsizei width,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexSubImage1D_pixels(glState, isCallValid, target, level, xoffset, width, format,
                                    type, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexSubImage1D, std::move(paramBuffer));
}

// GL 1.2

// GL 1.3
CallCapture CaptureCompressedTexImage1D(const State &glState,
                                        bool isCallValid,
                                        GLenum target,
                                        GLint level,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLint border,
                                        GLsizei imageSize,
                                        const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexImage1D_data(glState, isCallValid, target, level, internalformat, width,
                                         border, imageSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLCompressedTexImage1D, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage1D(const State &glState,
                                           bool isCallValid,
                                           GLenum target,
                                           GLint level,
                                           GLint xoffset,
                                           GLsizei width,
                                           GLenum format,
                                           GLsizei imageSize,
                                           const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addEnumParam("format", BigGLEnum::InternalFormat, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexSubImage1D_data(glState, isCallValid, target, level, xoffset, width,
                                            format, imageSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLCompressedTexSubImage1D, std::move(paramBuffer));
}

CallCapture CaptureGetCompressedTexImage(const State &glState,
                                         bool isCallValid,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         void *img)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    if (isCallValid)
    {
        ParamCapture imgParam("img", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, img, &imgParam.value);
        CaptureGetCompressedTexImage_img(glState, isCallValid, targetPacked, level, img, &imgParam);
        paramBuffer.addParam(std::move(imgParam));
    }
    else
    {
        ParamCapture imgParam("img", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &imgParam.value);
        paramBuffer.addParam(std::move(imgParam));
    }

    return CallCapture(angle::EntryPoint::GLGetCompressedTexImage, std::move(paramBuffer));
}

CallCapture CaptureLoadTransposeMatrixd(const State &glState, bool isCallValid, const GLdouble *m)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mParam("m", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, m, &mParam.value);
        CaptureLoadTransposeMatrixd_m(glState, isCallValid, m, &mParam);
        paramBuffer.addParam(std::move(mParam));
    }
    else
    {
        ParamCapture mParam("m", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &mParam.value);
        paramBuffer.addParam(std::move(mParam));
    }

    return CallCapture(angle::EntryPoint::GLLoadTransposeMatrixd, std::move(paramBuffer));
}

CallCapture CaptureLoadTransposeMatrixf(const State &glState, bool isCallValid, const GLfloat *m)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mParam("m", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, m, &mParam.value);
        CaptureLoadTransposeMatrixf_m(glState, isCallValid, m, &mParam);
        paramBuffer.addParam(std::move(mParam));
    }
    else
    {
        ParamCapture mParam("m", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &mParam.value);
        paramBuffer.addParam(std::move(mParam));
    }

    return CallCapture(angle::EntryPoint::GLLoadTransposeMatrixf, std::move(paramBuffer));
}

CallCapture CaptureMultTransposeMatrixd(const State &glState, bool isCallValid, const GLdouble *m)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mParam("m", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, m, &mParam.value);
        CaptureMultTransposeMatrixd_m(glState, isCallValid, m, &mParam);
        paramBuffer.addParam(std::move(mParam));
    }
    else
    {
        ParamCapture mParam("m", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &mParam.value);
        paramBuffer.addParam(std::move(mParam));
    }

    return CallCapture(angle::EntryPoint::GLMultTransposeMatrixd, std::move(paramBuffer));
}

CallCapture CaptureMultTransposeMatrixf(const State &glState, bool isCallValid, const GLfloat *m)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mParam("m", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, m, &mParam.value);
        CaptureMultTransposeMatrixf_m(glState, isCallValid, m, &mParam);
        paramBuffer.addParam(std::move(mParam));
    }
    else
    {
        ParamCapture mParam("m", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &mParam.value);
        paramBuffer.addParam(std::move(mParam));
    }

    return CallCapture(angle::EntryPoint::GLMultTransposeMatrixf, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord1d(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLdouble s)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLdouble, s);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord1d, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord1dv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLdouble *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureMultiTexCoord1dv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord1dv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord1f(const State &glState, bool isCallValid, GLenum target, GLfloat s)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLfloat, s);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord1f, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord1fv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureMultiTexCoord1fv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord1fv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord1i(const State &glState, bool isCallValid, GLenum target, GLint s)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLint, s);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord1i, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord1iv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureMultiTexCoord1iv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord1iv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord1s(const State &glState, bool isCallValid, GLenum target, GLshort s)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLshort, s);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord1s, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord1sv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLshort *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureMultiTexCoord1sv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord1sv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord2d(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLdouble s,
                                   GLdouble t)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLdouble, s);
    paramBuffer.addValueParam("t", ParamType::TGLdouble, t);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord2d, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord2dv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLdouble *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureMultiTexCoord2dv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord2dv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord2f(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLfloat s,
                                   GLfloat t)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLfloat, s);
    paramBuffer.addValueParam("t", ParamType::TGLfloat, t);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord2f, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord2fv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureMultiTexCoord2fv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord2fv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord2i(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLint s,
                                   GLint t)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLint, s);
    paramBuffer.addValueParam("t", ParamType::TGLint, t);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord2i, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord2iv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureMultiTexCoord2iv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord2iv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord2s(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLshort s,
                                   GLshort t)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLshort, s);
    paramBuffer.addValueParam("t", ParamType::TGLshort, t);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord2s, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord2sv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLshort *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureMultiTexCoord2sv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord2sv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord3d(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLdouble s,
                                   GLdouble t,
                                   GLdouble r)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLdouble, s);
    paramBuffer.addValueParam("t", ParamType::TGLdouble, t);
    paramBuffer.addValueParam("r", ParamType::TGLdouble, r);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord3d, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord3dv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLdouble *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureMultiTexCoord3dv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord3dv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord3f(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLfloat s,
                                   GLfloat t,
                                   GLfloat r)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLfloat, s);
    paramBuffer.addValueParam("t", ParamType::TGLfloat, t);
    paramBuffer.addValueParam("r", ParamType::TGLfloat, r);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord3f, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord3fv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureMultiTexCoord3fv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord3fv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord3i(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLint s,
                                   GLint t,
                                   GLint r)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLint, s);
    paramBuffer.addValueParam("t", ParamType::TGLint, t);
    paramBuffer.addValueParam("r", ParamType::TGLint, r);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord3i, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord3iv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureMultiTexCoord3iv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord3iv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord3s(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLshort s,
                                   GLshort t,
                                   GLshort r)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLshort, s);
    paramBuffer.addValueParam("t", ParamType::TGLshort, t);
    paramBuffer.addValueParam("r", ParamType::TGLshort, r);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord3s, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord3sv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLshort *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureMultiTexCoord3sv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord3sv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord4d(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLdouble s,
                                   GLdouble t,
                                   GLdouble r,
                                   GLdouble q)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLdouble, s);
    paramBuffer.addValueParam("t", ParamType::TGLdouble, t);
    paramBuffer.addValueParam("r", ParamType::TGLdouble, r);
    paramBuffer.addValueParam("q", ParamType::TGLdouble, q);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord4d, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord4dv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLdouble *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureMultiTexCoord4dv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord4dv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord4fv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureMultiTexCoord4fv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord4fv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord4i(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLint s,
                                   GLint t,
                                   GLint r,
                                   GLint q)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLint, s);
    paramBuffer.addValueParam("t", ParamType::TGLint, t);
    paramBuffer.addValueParam("r", ParamType::TGLint, r);
    paramBuffer.addValueParam("q", ParamType::TGLint, q);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord4i, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord4iv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureMultiTexCoord4iv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord4iv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord4s(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLshort s,
                                   GLshort t,
                                   GLshort r,
                                   GLshort q)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLshort, s);
    paramBuffer.addValueParam("t", ParamType::TGLshort, t);
    paramBuffer.addValueParam("r", ParamType::TGLshort, r);
    paramBuffer.addValueParam("q", ParamType::TGLshort, q);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord4s, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord4sv(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    const GLshort *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureUnit, ParamType::TGLenum, target);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureMultiTexCoord4sv_v(glState, isCallValid, target, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoord4sv, std::move(paramBuffer));
}

// GL 1.4
CallCapture CaptureFogCoordPointer(const State &glState,
                                   bool isCallValid,
                                   GLenum type,
                                   GLsizei stride,
                                   const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::FogPointerTypeEXT, ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureFogCoordPointer_pointer(glState, isCallValid, type, stride, pointer, &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLFogCoordPointer, std::move(paramBuffer));
}

CallCapture CaptureFogCoordd(const State &glState, bool isCallValid, GLdouble coord)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("coord", ParamType::TGLdouble, coord);

    return CallCapture(angle::EntryPoint::GLFogCoordd, std::move(paramBuffer));
}

CallCapture CaptureFogCoorddv(const State &glState, bool isCallValid, const GLdouble *coord)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture coordParam("coord", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, coord, &coordParam.value);
        CaptureFogCoorddv_coord(glState, isCallValid, coord, &coordParam);
        paramBuffer.addParam(std::move(coordParam));
    }
    else
    {
        ParamCapture coordParam("coord", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &coordParam.value);
        paramBuffer.addParam(std::move(coordParam));
    }

    return CallCapture(angle::EntryPoint::GLFogCoorddv, std::move(paramBuffer));
}

CallCapture CaptureFogCoordf(const State &glState, bool isCallValid, GLfloat coord)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("coord", ParamType::TGLfloat, coord);

    return CallCapture(angle::EntryPoint::GLFogCoordf, std::move(paramBuffer));
}

CallCapture CaptureFogCoordfv(const State &glState, bool isCallValid, const GLfloat *coord)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture coordParam("coord", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, coord, &coordParam.value);
        CaptureFogCoordfv_coord(glState, isCallValid, coord, &coordParam);
        paramBuffer.addParam(std::move(coordParam));
    }
    else
    {
        ParamCapture coordParam("coord", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &coordParam.value);
        paramBuffer.addParam(std::move(coordParam));
    }

    return CallCapture(angle::EntryPoint::GLFogCoordfv, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArrays(const State &glState,
                                   bool isCallValid,
                                   PrimitiveMode modePacked,
                                   const GLint *first,
                                   const GLsizei *count,
                                   GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture firstParam("first", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, first, &firstParam.value);
        CaptureMultiDrawArrays_first(glState, isCallValid, modePacked, first, count, drawcount,
                                     &firstParam);
        paramBuffer.addParam(std::move(firstParam));
    }
    else
    {
        ParamCapture firstParam("first", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &firstParam.value);
        paramBuffer.addParam(std::move(firstParam));
    }

    if (isCallValid)
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, count, &countParam.value);
        CaptureMultiDrawArrays_count(glState, isCallValid, modePacked, first, count, drawcount,
                                     &countParam);
        paramBuffer.addParam(std::move(countParam));
    }
    else
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countParam.value);
        paramBuffer.addParam(std::move(countParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(angle::EntryPoint::GLMultiDrawArrays, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElements(const State &glState,
                                     bool isCallValid,
                                     PrimitiveMode modePacked,
                                     const GLsizei *count,
                                     DrawElementsType typePacked,
                                     const void *const *indices,
                                     GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, count, &countParam.value);
        CaptureMultiDrawElements_count(glState, isCallValid, modePacked, count, typePacked, indices,
                                       drawcount, &countParam);
        paramBuffer.addParam(std::move(countParam));
    }
    else
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countParam.value);
        paramBuffer.addParam(std::move(countParam));
    }

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, indices, &indicesParam.value);
        CaptureMultiDrawElements_indices(glState, isCallValid, modePacked, count, typePacked,
                                         indices, drawcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer,
                       static_cast<const void *const *>(nullptr), &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(angle::EntryPoint::GLMultiDrawElements, std::move(paramBuffer));
}

CallCapture CapturePointParameteri(const State &glState,
                                   bool isCallValid,
                                   GLenum pname,
                                   GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", BigGLEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLPointParameteri, std::move(paramBuffer));
}

CallCapture CapturePointParameteriv(const State &glState,
                                    bool isCallValid,
                                    GLenum pname,
                                    const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", BigGLEnum::AllEnums, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CapturePointParameteriv_params(glState, isCallValid, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLPointParameteriv, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3b(const State &glState,
                                    bool isCallValid,
                                    GLbyte red,
                                    GLbyte green,
                                    GLbyte blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLbyte, red);
    paramBuffer.addValueParam("green", ParamType::TGLbyte, green);
    paramBuffer.addValueParam("blue", ParamType::TGLbyte, blue);

    return CallCapture(angle::EntryPoint::GLSecondaryColor3b, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3bv(const State &glState, bool isCallValid, const GLbyte *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLbyteConstPointer);
        InitParamValue(ParamType::TGLbyteConstPointer, v, &vParam.value);
        CaptureSecondaryColor3bv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLbyteConstPointer);
        InitParamValue(ParamType::TGLbyteConstPointer, static_cast<const GLbyte *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLSecondaryColor3bv, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3d(const State &glState,
                                    bool isCallValid,
                                    GLdouble red,
                                    GLdouble green,
                                    GLdouble blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLdouble, red);
    paramBuffer.addValueParam("green", ParamType::TGLdouble, green);
    paramBuffer.addValueParam("blue", ParamType::TGLdouble, blue);

    return CallCapture(angle::EntryPoint::GLSecondaryColor3d, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureSecondaryColor3dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLSecondaryColor3dv, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3f(const State &glState,
                                    bool isCallValid,
                                    GLfloat red,
                                    GLfloat green,
                                    GLfloat blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfloat, red);
    paramBuffer.addValueParam("green", ParamType::TGLfloat, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfloat, blue);

    return CallCapture(angle::EntryPoint::GLSecondaryColor3f, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureSecondaryColor3fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLSecondaryColor3fv, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3i(const State &glState,
                                    bool isCallValid,
                                    GLint red,
                                    GLint green,
                                    GLint blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLint, red);
    paramBuffer.addValueParam("green", ParamType::TGLint, green);
    paramBuffer.addValueParam("blue", ParamType::TGLint, blue);

    return CallCapture(angle::EntryPoint::GLSecondaryColor3i, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureSecondaryColor3iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLSecondaryColor3iv, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3s(const State &glState,
                                    bool isCallValid,
                                    GLshort red,
                                    GLshort green,
                                    GLshort blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLshort, red);
    paramBuffer.addValueParam("green", ParamType::TGLshort, green);
    paramBuffer.addValueParam("blue", ParamType::TGLshort, blue);

    return CallCapture(angle::EntryPoint::GLSecondaryColor3s, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureSecondaryColor3sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLSecondaryColor3sv, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3ub(const State &glState,
                                     bool isCallValid,
                                     GLubyte red,
                                     GLubyte green,
                                     GLubyte blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLubyte, red);
    paramBuffer.addValueParam("green", ParamType::TGLubyte, green);
    paramBuffer.addValueParam("blue", ParamType::TGLubyte, blue);

    return CallCapture(angle::EntryPoint::GLSecondaryColor3ub, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3ubv(const State &glState, bool isCallValid, const GLubyte *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, v, &vParam.value);
        CaptureSecondaryColor3ubv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, static_cast<const GLubyte *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLSecondaryColor3ubv, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3ui(const State &glState,
                                     bool isCallValid,
                                     GLuint red,
                                     GLuint green,
                                     GLuint blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLuint, red);
    paramBuffer.addValueParam("green", ParamType::TGLuint, green);
    paramBuffer.addValueParam("blue", ParamType::TGLuint, blue);

    return CallCapture(angle::EntryPoint::GLSecondaryColor3ui, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3uiv(const State &glState, bool isCallValid, const GLuint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, v, &vParam.value);
        CaptureSecondaryColor3uiv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLSecondaryColor3uiv, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3us(const State &glState,
                                     bool isCallValid,
                                     GLushort red,
                                     GLushort green,
                                     GLushort blue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLushort, red);
    paramBuffer.addValueParam("green", ParamType::TGLushort, green);
    paramBuffer.addValueParam("blue", ParamType::TGLushort, blue);

    return CallCapture(angle::EntryPoint::GLSecondaryColor3us, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColor3usv(const State &glState, bool isCallValid, const GLushort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLushortConstPointer);
        InitParamValue(ParamType::TGLushortConstPointer, v, &vParam.value);
        CaptureSecondaryColor3usv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLushortConstPointer);
        InitParamValue(ParamType::TGLushortConstPointer, static_cast<const GLushort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLSecondaryColor3usv, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColorPointer(const State &glState,
                                         bool isCallValid,
                                         GLint size,
                                         GLenum type,
                                         GLsizei stride,
                                         const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", BigGLEnum::ColorPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureSecondaryColorPointer_pointer(glState, isCallValid, size, type, stride, pointer,
                                             &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLSecondaryColorPointer, std::move(paramBuffer));
}

CallCapture CaptureWindowPos2d(const State &glState, bool isCallValid, GLdouble x, GLdouble y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);

    return CallCapture(angle::EntryPoint::GLWindowPos2d, std::move(paramBuffer));
}

CallCapture CaptureWindowPos2dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureWindowPos2dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLWindowPos2dv, std::move(paramBuffer));
}

CallCapture CaptureWindowPos2f(const State &glState, bool isCallValid, GLfloat x, GLfloat y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);

    return CallCapture(angle::EntryPoint::GLWindowPos2f, std::move(paramBuffer));
}

CallCapture CaptureWindowPos2fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureWindowPos2fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLWindowPos2fv, std::move(paramBuffer));
}

CallCapture CaptureWindowPos2i(const State &glState, bool isCallValid, GLint x, GLint y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);

    return CallCapture(angle::EntryPoint::GLWindowPos2i, std::move(paramBuffer));
}

CallCapture CaptureWindowPos2iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureWindowPos2iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLWindowPos2iv, std::move(paramBuffer));
}

CallCapture CaptureWindowPos2s(const State &glState, bool isCallValid, GLshort x, GLshort y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);

    return CallCapture(angle::EntryPoint::GLWindowPos2s, std::move(paramBuffer));
}

CallCapture CaptureWindowPos2sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureWindowPos2sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLWindowPos2sv, std::move(paramBuffer));
}

CallCapture CaptureWindowPos3d(const State &glState,
                               bool isCallValid,
                               GLdouble x,
                               GLdouble y,
                               GLdouble z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);

    return CallCapture(angle::EntryPoint::GLWindowPos3d, std::move(paramBuffer));
}

CallCapture CaptureWindowPos3dv(const State &glState, bool isCallValid, const GLdouble *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureWindowPos3dv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLWindowPos3dv, std::move(paramBuffer));
}

CallCapture CaptureWindowPos3f(const State &glState,
                               bool isCallValid,
                               GLfloat x,
                               GLfloat y,
                               GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture(angle::EntryPoint::GLWindowPos3f, std::move(paramBuffer));
}

CallCapture CaptureWindowPos3fv(const State &glState, bool isCallValid, const GLfloat *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureWindowPos3fv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLWindowPos3fv, std::move(paramBuffer));
}

CallCapture CaptureWindowPos3i(const State &glState, bool isCallValid, GLint x, GLint y, GLint z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);

    return CallCapture(angle::EntryPoint::GLWindowPos3i, std::move(paramBuffer));
}

CallCapture CaptureWindowPos3iv(const State &glState, bool isCallValid, const GLint *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureWindowPos3iv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLWindowPos3iv, std::move(paramBuffer));
}

CallCapture CaptureWindowPos3s(const State &glState,
                               bool isCallValid,
                               GLshort x,
                               GLshort y,
                               GLshort z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);
    paramBuffer.addValueParam("z", ParamType::TGLshort, z);

    return CallCapture(angle::EntryPoint::GLWindowPos3s, std::move(paramBuffer));
}

CallCapture CaptureWindowPos3sv(const State &glState, bool isCallValid, const GLshort *v)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureWindowPos3sv_v(glState, isCallValid, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLWindowPos3sv, std::move(paramBuffer));
}

// GL 1.5
CallCapture CaptureGetBufferSubData(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    GLintptr offset,
                                    GLsizeiptr size,
                                    void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::BufferTargetARB, ParamType::TGLenum, target);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
        CaptureGetBufferSubData_data(glState, isCallValid, target, offset, size, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetBufferSubData, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectiv(const State &glState,
                                    bool isCallValid,
                                    QueryID idPacked,
                                    GLenum pname,
                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetQueryObjectiv_params(glState, isCallValid, idPacked, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryObjectiv, std::move(paramBuffer));
}

CallCapture CaptureMapBuffer(const State &glState,
                             bool isCallValid,
                             BufferBinding targetPacked,
                             GLenum access,
                             void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("access", BigGLEnum::BufferAccessARB, ParamType::TGLenum, access);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLMapBuffer, std::move(paramBuffer));
}

}  // namespace gl
