/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the RepositorySyncURL type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RepositorySyncURL{}

// RepositorySyncURL A mixin for validating unknown serializers' fields.
type RepositorySyncURL struct {
	// A remote to sync from. This will override a remote set on repository.
	Remote *string `json:"remote,omitempty"`
	// If ``True``, synchronization will remove all content that is not present in the remote repository. If ``False``, sync will be additive only.
	Mirror *bool `json:"mirror,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _RepositorySyncURL RepositorySyncURL

// NewRepositorySyncURL instantiates a new RepositorySyncURL object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRepositorySyncURL() *RepositorySyncURL {
	this := RepositorySyncURL{}
	var mirror bool = false
	this.Mirror = &mirror
	return &this
}

// NewRepositorySyncURLWithDefaults instantiates a new RepositorySyncURL object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRepositorySyncURLWithDefaults() *RepositorySyncURL {
	this := RepositorySyncURL{}
	var mirror bool = false
	this.Mirror = &mirror
	return &this
}

// GetRemote returns the Remote field value if set, zero value otherwise.
func (o *RepositorySyncURL) GetRemote() string {
	if o == nil || IsNil(o.Remote) {
		var ret string
		return ret
	}
	return *o.Remote
}

// GetRemoteOk returns a tuple with the Remote field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RepositorySyncURL) GetRemoteOk() (*string, bool) {
	if o == nil || IsNil(o.Remote) {
		return nil, false
	}
	return o.Remote, true
}

// HasRemote returns a boolean if a field has been set.
func (o *RepositorySyncURL) HasRemote() bool {
	if o != nil && !IsNil(o.Remote) {
		return true
	}

	return false
}

// SetRemote gets a reference to the given string and assigns it to the Remote field.
func (o *RepositorySyncURL) SetRemote(v string) {
	o.Remote = &v
}

// GetMirror returns the Mirror field value if set, zero value otherwise.
func (o *RepositorySyncURL) GetMirror() bool {
	if o == nil || IsNil(o.Mirror) {
		var ret bool
		return ret
	}
	return *o.Mirror
}

// GetMirrorOk returns a tuple with the Mirror field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RepositorySyncURL) GetMirrorOk() (*bool, bool) {
	if o == nil || IsNil(o.Mirror) {
		return nil, false
	}
	return o.Mirror, true
}

// HasMirror returns a boolean if a field has been set.
func (o *RepositorySyncURL) HasMirror() bool {
	if o != nil && !IsNil(o.Mirror) {
		return true
	}

	return false
}

// SetMirror gets a reference to the given bool and assigns it to the Mirror field.
func (o *RepositorySyncURL) SetMirror(v bool) {
	o.Mirror = &v
}

func (o RepositorySyncURL) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RepositorySyncURL) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Remote) {
		toSerialize["remote"] = o.Remote
	}
	if !IsNil(o.Mirror) {
		toSerialize["mirror"] = o.Mirror
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RepositorySyncURL) UnmarshalJSON(bytes []byte) (err error) {
	varRepositorySyncURL := _RepositorySyncURL{}

	if err = json.Unmarshal(bytes, &varRepositorySyncURL); err == nil {
		*o = RepositorySyncURL(varRepositorySyncURL)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "remote")
		delete(additionalProperties, "mirror")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRepositorySyncURL struct {
	value *RepositorySyncURL
	isSet bool
}

func (v NullableRepositorySyncURL) Get() *RepositorySyncURL {
	return v.value
}

func (v *NullableRepositorySyncURL) Set(val *RepositorySyncURL) {
	v.value = val
	v.isSet = true
}

func (v NullableRepositorySyncURL) IsSet() bool {
	return v.isSet
}

func (v *NullableRepositorySyncURL) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRepositorySyncURL(val *RepositorySyncURL) *NullableRepositorySyncURL {
	return &NullableRepositorySyncURL{value: val, isSet: true}
}

func (v NullableRepositorySyncURL) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRepositorySyncURL) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


