/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the PulpImportCheck type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PulpImportCheck{}

// PulpImportCheck Check validity of provided import-options.  Provides the ability to check that an import is 'sane' without having to actually create an importer.
type PulpImportCheck struct {
	// Path to export-tar-gz that will be imported.
	Path *string `json:"path,omitempty"`
	// Path to a table-of-contents file describing chunks to be validated, reassembled, and imported.
	Toc *string `json:"toc,omitempty"`
	// Mapping of repo names in an export file to the repo names in Pulp. For example, if the export has a repo named 'foo' and the repo to import content into was 'bar', the mapping would be \"{'foo': 'bar'}\".
	RepoMapping *string `json:"repo_mapping,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PulpImportCheck PulpImportCheck

// NewPulpImportCheck instantiates a new PulpImportCheck object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPulpImportCheck() *PulpImportCheck {
	this := PulpImportCheck{}
	return &this
}

// NewPulpImportCheckWithDefaults instantiates a new PulpImportCheck object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPulpImportCheckWithDefaults() *PulpImportCheck {
	this := PulpImportCheck{}
	return &this
}

// GetPath returns the Path field value if set, zero value otherwise.
func (o *PulpImportCheck) GetPath() string {
	if o == nil || IsNil(o.Path) {
		var ret string
		return ret
	}
	return *o.Path
}

// GetPathOk returns a tuple with the Path field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpImportCheck) GetPathOk() (*string, bool) {
	if o == nil || IsNil(o.Path) {
		return nil, false
	}
	return o.Path, true
}

// HasPath returns a boolean if a field has been set.
func (o *PulpImportCheck) HasPath() bool {
	if o != nil && !IsNil(o.Path) {
		return true
	}

	return false
}

// SetPath gets a reference to the given string and assigns it to the Path field.
func (o *PulpImportCheck) SetPath(v string) {
	o.Path = &v
}

// GetToc returns the Toc field value if set, zero value otherwise.
func (o *PulpImportCheck) GetToc() string {
	if o == nil || IsNil(o.Toc) {
		var ret string
		return ret
	}
	return *o.Toc
}

// GetTocOk returns a tuple with the Toc field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpImportCheck) GetTocOk() (*string, bool) {
	if o == nil || IsNil(o.Toc) {
		return nil, false
	}
	return o.Toc, true
}

// HasToc returns a boolean if a field has been set.
func (o *PulpImportCheck) HasToc() bool {
	if o != nil && !IsNil(o.Toc) {
		return true
	}

	return false
}

// SetToc gets a reference to the given string and assigns it to the Toc field.
func (o *PulpImportCheck) SetToc(v string) {
	o.Toc = &v
}

// GetRepoMapping returns the RepoMapping field value if set, zero value otherwise.
func (o *PulpImportCheck) GetRepoMapping() string {
	if o == nil || IsNil(o.RepoMapping) {
		var ret string
		return ret
	}
	return *o.RepoMapping
}

// GetRepoMappingOk returns a tuple with the RepoMapping field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpImportCheck) GetRepoMappingOk() (*string, bool) {
	if o == nil || IsNil(o.RepoMapping) {
		return nil, false
	}
	return o.RepoMapping, true
}

// HasRepoMapping returns a boolean if a field has been set.
func (o *PulpImportCheck) HasRepoMapping() bool {
	if o != nil && !IsNil(o.RepoMapping) {
		return true
	}

	return false
}

// SetRepoMapping gets a reference to the given string and assigns it to the RepoMapping field.
func (o *PulpImportCheck) SetRepoMapping(v string) {
	o.RepoMapping = &v
}

func (o PulpImportCheck) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PulpImportCheck) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Path) {
		toSerialize["path"] = o.Path
	}
	if !IsNil(o.Toc) {
		toSerialize["toc"] = o.Toc
	}
	if !IsNil(o.RepoMapping) {
		toSerialize["repo_mapping"] = o.RepoMapping
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PulpImportCheck) UnmarshalJSON(bytes []byte) (err error) {
	varPulpImportCheck := _PulpImportCheck{}

	if err = json.Unmarshal(bytes, &varPulpImportCheck); err == nil {
		*o = PulpImportCheck(varPulpImportCheck)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "path")
		delete(additionalProperties, "toc")
		delete(additionalProperties, "repo_mapping")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePulpImportCheck struct {
	value *PulpImportCheck
	isSet bool
}

func (v NullablePulpImportCheck) Get() *PulpImportCheck {
	return v.value
}

func (v *NullablePulpImportCheck) Set(val *PulpImportCheck) {
	v.value = val
	v.isSet = true
}

func (v NullablePulpImportCheck) IsSet() bool {
	return v.isSet
}

func (v *NullablePulpImportCheck) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePulpImportCheck(val *PulpImportCheck) *NullablePulpImportCheck {
	return &NullablePulpImportCheck{value: val, isSet: true}
}

func (v NullablePulpImportCheck) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePulpImportCheck) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


