/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the ArtifactResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ArtifactResponse{}

// ArtifactResponse Base serializer for use with :class:`pulpcore.app.models.Model`  This ensures that all Serializers provide values for the 'pulp_href` field.  The class provides a default for the ``ref_name`` attribute in the ModelSerializers's ``Meta`` class. This ensures that the OpenAPI definitions of plugins are namespaced properly.
type ArtifactResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// The stored file.
	File string `json:"file"`
	// The size of the file in bytes.
	Size *int64 `json:"size,omitempty"`
	// The MD5 checksum of the file if available.
	Md5 NullableString `json:"md5,omitempty"`
	// The SHA-1 checksum of the file if available.
	Sha1 NullableString `json:"sha1,omitempty"`
	// The SHA-224 checksum of the file if available.
	Sha224 NullableString `json:"sha224,omitempty"`
	// The SHA-256 checksum of the file if available.
	Sha256 NullableString `json:"sha256,omitempty"`
	// The SHA-384 checksum of the file if available.
	Sha384 NullableString `json:"sha384,omitempty"`
	// The SHA-512 checksum of the file if available.
	Sha512 NullableString `json:"sha512,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _ArtifactResponse ArtifactResponse

// NewArtifactResponse instantiates a new ArtifactResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewArtifactResponse(file string) *ArtifactResponse {
	this := ArtifactResponse{}
	this.File = file
	return &this
}

// NewArtifactResponseWithDefaults instantiates a new ArtifactResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewArtifactResponseWithDefaults() *ArtifactResponse {
	this := ArtifactResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *ArtifactResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ArtifactResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *ArtifactResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *ArtifactResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *ArtifactResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ArtifactResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *ArtifactResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *ArtifactResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetFile returns the File field value
func (o *ArtifactResponse) GetFile() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.File
}

// GetFileOk returns a tuple with the File field value
// and a boolean to check if the value has been set.
func (o *ArtifactResponse) GetFileOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.File, true
}

// SetFile sets field value
func (o *ArtifactResponse) SetFile(v string) {
	o.File = v
}

// GetSize returns the Size field value if set, zero value otherwise.
func (o *ArtifactResponse) GetSize() int64 {
	if o == nil || IsNil(o.Size) {
		var ret int64
		return ret
	}
	return *o.Size
}

// GetSizeOk returns a tuple with the Size field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ArtifactResponse) GetSizeOk() (*int64, bool) {
	if o == nil || IsNil(o.Size) {
		return nil, false
	}
	return o.Size, true
}

// HasSize returns a boolean if a field has been set.
func (o *ArtifactResponse) HasSize() bool {
	if o != nil && !IsNil(o.Size) {
		return true
	}

	return false
}

// SetSize gets a reference to the given int64 and assigns it to the Size field.
func (o *ArtifactResponse) SetSize(v int64) {
	o.Size = &v
}

// GetMd5 returns the Md5 field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *ArtifactResponse) GetMd5() string {
	if o == nil || IsNil(o.Md5.Get()) {
		var ret string
		return ret
	}
	return *o.Md5.Get()
}

// GetMd5Ok returns a tuple with the Md5 field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ArtifactResponse) GetMd5Ok() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Md5.Get(), o.Md5.IsSet()
}

// HasMd5 returns a boolean if a field has been set.
func (o *ArtifactResponse) HasMd5() bool {
	if o != nil && o.Md5.IsSet() {
		return true
	}

	return false
}

// SetMd5 gets a reference to the given NullableString and assigns it to the Md5 field.
func (o *ArtifactResponse) SetMd5(v string) {
	o.Md5.Set(&v)
}
// SetMd5Nil sets the value for Md5 to be an explicit nil
func (o *ArtifactResponse) SetMd5Nil() {
	o.Md5.Set(nil)
}

// UnsetMd5 ensures that no value is present for Md5, not even an explicit nil
func (o *ArtifactResponse) UnsetMd5() {
	o.Md5.Unset()
}

// GetSha1 returns the Sha1 field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *ArtifactResponse) GetSha1() string {
	if o == nil || IsNil(o.Sha1.Get()) {
		var ret string
		return ret
	}
	return *o.Sha1.Get()
}

// GetSha1Ok returns a tuple with the Sha1 field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ArtifactResponse) GetSha1Ok() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Sha1.Get(), o.Sha1.IsSet()
}

// HasSha1 returns a boolean if a field has been set.
func (o *ArtifactResponse) HasSha1() bool {
	if o != nil && o.Sha1.IsSet() {
		return true
	}

	return false
}

// SetSha1 gets a reference to the given NullableString and assigns it to the Sha1 field.
func (o *ArtifactResponse) SetSha1(v string) {
	o.Sha1.Set(&v)
}
// SetSha1Nil sets the value for Sha1 to be an explicit nil
func (o *ArtifactResponse) SetSha1Nil() {
	o.Sha1.Set(nil)
}

// UnsetSha1 ensures that no value is present for Sha1, not even an explicit nil
func (o *ArtifactResponse) UnsetSha1() {
	o.Sha1.Unset()
}

// GetSha224 returns the Sha224 field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *ArtifactResponse) GetSha224() string {
	if o == nil || IsNil(o.Sha224.Get()) {
		var ret string
		return ret
	}
	return *o.Sha224.Get()
}

// GetSha224Ok returns a tuple with the Sha224 field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ArtifactResponse) GetSha224Ok() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Sha224.Get(), o.Sha224.IsSet()
}

// HasSha224 returns a boolean if a field has been set.
func (o *ArtifactResponse) HasSha224() bool {
	if o != nil && o.Sha224.IsSet() {
		return true
	}

	return false
}

// SetSha224 gets a reference to the given NullableString and assigns it to the Sha224 field.
func (o *ArtifactResponse) SetSha224(v string) {
	o.Sha224.Set(&v)
}
// SetSha224Nil sets the value for Sha224 to be an explicit nil
func (o *ArtifactResponse) SetSha224Nil() {
	o.Sha224.Set(nil)
}

// UnsetSha224 ensures that no value is present for Sha224, not even an explicit nil
func (o *ArtifactResponse) UnsetSha224() {
	o.Sha224.Unset()
}

// GetSha256 returns the Sha256 field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *ArtifactResponse) GetSha256() string {
	if o == nil || IsNil(o.Sha256.Get()) {
		var ret string
		return ret
	}
	return *o.Sha256.Get()
}

// GetSha256Ok returns a tuple with the Sha256 field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ArtifactResponse) GetSha256Ok() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Sha256.Get(), o.Sha256.IsSet()
}

// HasSha256 returns a boolean if a field has been set.
func (o *ArtifactResponse) HasSha256() bool {
	if o != nil && o.Sha256.IsSet() {
		return true
	}

	return false
}

// SetSha256 gets a reference to the given NullableString and assigns it to the Sha256 field.
func (o *ArtifactResponse) SetSha256(v string) {
	o.Sha256.Set(&v)
}
// SetSha256Nil sets the value for Sha256 to be an explicit nil
func (o *ArtifactResponse) SetSha256Nil() {
	o.Sha256.Set(nil)
}

// UnsetSha256 ensures that no value is present for Sha256, not even an explicit nil
func (o *ArtifactResponse) UnsetSha256() {
	o.Sha256.Unset()
}

// GetSha384 returns the Sha384 field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *ArtifactResponse) GetSha384() string {
	if o == nil || IsNil(o.Sha384.Get()) {
		var ret string
		return ret
	}
	return *o.Sha384.Get()
}

// GetSha384Ok returns a tuple with the Sha384 field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ArtifactResponse) GetSha384Ok() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Sha384.Get(), o.Sha384.IsSet()
}

// HasSha384 returns a boolean if a field has been set.
func (o *ArtifactResponse) HasSha384() bool {
	if o != nil && o.Sha384.IsSet() {
		return true
	}

	return false
}

// SetSha384 gets a reference to the given NullableString and assigns it to the Sha384 field.
func (o *ArtifactResponse) SetSha384(v string) {
	o.Sha384.Set(&v)
}
// SetSha384Nil sets the value for Sha384 to be an explicit nil
func (o *ArtifactResponse) SetSha384Nil() {
	o.Sha384.Set(nil)
}

// UnsetSha384 ensures that no value is present for Sha384, not even an explicit nil
func (o *ArtifactResponse) UnsetSha384() {
	o.Sha384.Unset()
}

// GetSha512 returns the Sha512 field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *ArtifactResponse) GetSha512() string {
	if o == nil || IsNil(o.Sha512.Get()) {
		var ret string
		return ret
	}
	return *o.Sha512.Get()
}

// GetSha512Ok returns a tuple with the Sha512 field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ArtifactResponse) GetSha512Ok() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Sha512.Get(), o.Sha512.IsSet()
}

// HasSha512 returns a boolean if a field has been set.
func (o *ArtifactResponse) HasSha512() bool {
	if o != nil && o.Sha512.IsSet() {
		return true
	}

	return false
}

// SetSha512 gets a reference to the given NullableString and assigns it to the Sha512 field.
func (o *ArtifactResponse) SetSha512(v string) {
	o.Sha512.Set(&v)
}
// SetSha512Nil sets the value for Sha512 to be an explicit nil
func (o *ArtifactResponse) SetSha512Nil() {
	o.Sha512.Set(nil)
}

// UnsetSha512 ensures that no value is present for Sha512, not even an explicit nil
func (o *ArtifactResponse) UnsetSha512() {
	o.Sha512.Unset()
}

func (o ArtifactResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ArtifactResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	toSerialize["file"] = o.File
	if !IsNil(o.Size) {
		toSerialize["size"] = o.Size
	}
	if o.Md5.IsSet() {
		toSerialize["md5"] = o.Md5.Get()
	}
	if o.Sha1.IsSet() {
		toSerialize["sha1"] = o.Sha1.Get()
	}
	if o.Sha224.IsSet() {
		toSerialize["sha224"] = o.Sha224.Get()
	}
	if o.Sha256.IsSet() {
		toSerialize["sha256"] = o.Sha256.Get()
	}
	if o.Sha384.IsSet() {
		toSerialize["sha384"] = o.Sha384.Get()
	}
	if o.Sha512.IsSet() {
		toSerialize["sha512"] = o.Sha512.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ArtifactResponse) UnmarshalJSON(bytes []byte) (err error) {
	varArtifactResponse := _ArtifactResponse{}

	if err = json.Unmarshal(bytes, &varArtifactResponse); err == nil {
		*o = ArtifactResponse(varArtifactResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "file")
		delete(additionalProperties, "size")
		delete(additionalProperties, "md5")
		delete(additionalProperties, "sha1")
		delete(additionalProperties, "sha224")
		delete(additionalProperties, "sha256")
		delete(additionalProperties, "sha384")
		delete(additionalProperties, "sha512")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableArtifactResponse struct {
	value *ArtifactResponse
	isSet bool
}

func (v NullableArtifactResponse) Get() *ArtifactResponse {
	return v.value
}

func (v *NullableArtifactResponse) Set(val *ArtifactResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableArtifactResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableArtifactResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableArtifactResponse(val *ArtifactResponse) *NullableArtifactResponse {
	return &NullableArtifactResponse{value: val, isSet: true}
}

func (v NullableArtifactResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableArtifactResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


