// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package compute

import (
	computepb "cloud.google.com/go/compute/apiv1/computepb"
	"google.golang.org/api/iterator"
)

// AcceleratorTypeIterator manages a stream of *computepb.AcceleratorType.
type AcceleratorTypeIterator struct {
	items    []*computepb.AcceleratorType
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.AcceleratorType, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *AcceleratorTypeIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AcceleratorTypeIterator) Next() (*computepb.AcceleratorType, error) {
	var item *computepb.AcceleratorType
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AcceleratorTypeIterator) bufLen() int {
	return len(it.items)
}

func (it *AcceleratorTypeIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// AcceleratorTypesScopedListPair is a holder type for string/*computepb.AcceleratorTypesScopedList map entries
type AcceleratorTypesScopedListPair struct {
	Key   string
	Value *computepb.AcceleratorTypesScopedList
}

// AcceleratorTypesScopedListPairIterator manages a stream of AcceleratorTypesScopedListPair.
type AcceleratorTypesScopedListPairIterator struct {
	items    []AcceleratorTypesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []AcceleratorTypesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *AcceleratorTypesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AcceleratorTypesScopedListPairIterator) Next() (AcceleratorTypesScopedListPair, error) {
	var item AcceleratorTypesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AcceleratorTypesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *AcceleratorTypesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// AddressIterator manages a stream of *computepb.Address.
type AddressIterator struct {
	items    []*computepb.Address
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Address, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *AddressIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AddressIterator) Next() (*computepb.Address, error) {
	var item *computepb.Address
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AddressIterator) bufLen() int {
	return len(it.items)
}

func (it *AddressIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// AddressesScopedListPair is a holder type for string/*computepb.AddressesScopedList map entries
type AddressesScopedListPair struct {
	Key   string
	Value *computepb.AddressesScopedList
}

// AddressesScopedListPairIterator manages a stream of AddressesScopedListPair.
type AddressesScopedListPairIterator struct {
	items    []AddressesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []AddressesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *AddressesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AddressesScopedListPairIterator) Next() (AddressesScopedListPair, error) {
	var item AddressesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AddressesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *AddressesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// AutoscalerIterator manages a stream of *computepb.Autoscaler.
type AutoscalerIterator struct {
	items    []*computepb.Autoscaler
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Autoscaler, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *AutoscalerIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AutoscalerIterator) Next() (*computepb.Autoscaler, error) {
	var item *computepb.Autoscaler
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AutoscalerIterator) bufLen() int {
	return len(it.items)
}

func (it *AutoscalerIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// AutoscalersScopedListPair is a holder type for string/*computepb.AutoscalersScopedList map entries
type AutoscalersScopedListPair struct {
	Key   string
	Value *computepb.AutoscalersScopedList
}

// AutoscalersScopedListPairIterator manages a stream of AutoscalersScopedListPair.
type AutoscalersScopedListPairIterator struct {
	items    []AutoscalersScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []AutoscalersScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *AutoscalersScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AutoscalersScopedListPairIterator) Next() (AutoscalersScopedListPair, error) {
	var item AutoscalersScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AutoscalersScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *AutoscalersScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// BackendBucketIterator manages a stream of *computepb.BackendBucket.
type BackendBucketIterator struct {
	items    []*computepb.BackendBucket
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.BackendBucket, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *BackendBucketIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *BackendBucketIterator) Next() (*computepb.BackendBucket, error) {
	var item *computepb.BackendBucket
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *BackendBucketIterator) bufLen() int {
	return len(it.items)
}

func (it *BackendBucketIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// BackendServiceIterator manages a stream of *computepb.BackendService.
type BackendServiceIterator struct {
	items    []*computepb.BackendService
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.BackendService, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *BackendServiceIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *BackendServiceIterator) Next() (*computepb.BackendService, error) {
	var item *computepb.BackendService
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *BackendServiceIterator) bufLen() int {
	return len(it.items)
}

func (it *BackendServiceIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// BackendServicesScopedListPair is a holder type for string/*computepb.BackendServicesScopedList map entries
type BackendServicesScopedListPair struct {
	Key   string
	Value *computepb.BackendServicesScopedList
}

// BackendServicesScopedListPairIterator manages a stream of BackendServicesScopedListPair.
type BackendServicesScopedListPairIterator struct {
	items    []BackendServicesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []BackendServicesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *BackendServicesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *BackendServicesScopedListPairIterator) Next() (BackendServicesScopedListPair, error) {
	var item BackendServicesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *BackendServicesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *BackendServicesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// CommitmentIterator manages a stream of *computepb.Commitment.
type CommitmentIterator struct {
	items    []*computepb.Commitment
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Commitment, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *CommitmentIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *CommitmentIterator) Next() (*computepb.Commitment, error) {
	var item *computepb.Commitment
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *CommitmentIterator) bufLen() int {
	return len(it.items)
}

func (it *CommitmentIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// CommitmentsScopedListPair is a holder type for string/*computepb.CommitmentsScopedList map entries
type CommitmentsScopedListPair struct {
	Key   string
	Value *computepb.CommitmentsScopedList
}

// CommitmentsScopedListPairIterator manages a stream of CommitmentsScopedListPair.
type CommitmentsScopedListPairIterator struct {
	items    []CommitmentsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []CommitmentsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *CommitmentsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *CommitmentsScopedListPairIterator) Next() (CommitmentsScopedListPair, error) {
	var item CommitmentsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *CommitmentsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *CommitmentsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// DiskIterator manages a stream of *computepb.Disk.
type DiskIterator struct {
	items    []*computepb.Disk
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Disk, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *DiskIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *DiskIterator) Next() (*computepb.Disk, error) {
	var item *computepb.Disk
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *DiskIterator) bufLen() int {
	return len(it.items)
}

func (it *DiskIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// DiskTypeIterator manages a stream of *computepb.DiskType.
type DiskTypeIterator struct {
	items    []*computepb.DiskType
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.DiskType, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *DiskTypeIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *DiskTypeIterator) Next() (*computepb.DiskType, error) {
	var item *computepb.DiskType
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *DiskTypeIterator) bufLen() int {
	return len(it.items)
}

func (it *DiskTypeIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// DiskTypesScopedListPair is a holder type for string/*computepb.DiskTypesScopedList map entries
type DiskTypesScopedListPair struct {
	Key   string
	Value *computepb.DiskTypesScopedList
}

// DiskTypesScopedListPairIterator manages a stream of DiskTypesScopedListPair.
type DiskTypesScopedListPairIterator struct {
	items    []DiskTypesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []DiskTypesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *DiskTypesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *DiskTypesScopedListPairIterator) Next() (DiskTypesScopedListPair, error) {
	var item DiskTypesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *DiskTypesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *DiskTypesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// DisksScopedListPair is a holder type for string/*computepb.DisksScopedList map entries
type DisksScopedListPair struct {
	Key   string
	Value *computepb.DisksScopedList
}

// DisksScopedListPairIterator manages a stream of DisksScopedListPair.
type DisksScopedListPairIterator struct {
	items    []DisksScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []DisksScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *DisksScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *DisksScopedListPairIterator) Next() (DisksScopedListPair, error) {
	var item DisksScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *DisksScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *DisksScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ExchangedPeeringRouteIterator manages a stream of *computepb.ExchangedPeeringRoute.
type ExchangedPeeringRouteIterator struct {
	items    []*computepb.ExchangedPeeringRoute
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.ExchangedPeeringRoute, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ExchangedPeeringRouteIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ExchangedPeeringRouteIterator) Next() (*computepb.ExchangedPeeringRoute, error) {
	var item *computepb.ExchangedPeeringRoute
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ExchangedPeeringRouteIterator) bufLen() int {
	return len(it.items)
}

func (it *ExchangedPeeringRouteIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ExternalVpnGatewayIterator manages a stream of *computepb.ExternalVpnGateway.
type ExternalVpnGatewayIterator struct {
	items    []*computepb.ExternalVpnGateway
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.ExternalVpnGateway, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ExternalVpnGatewayIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ExternalVpnGatewayIterator) Next() (*computepb.ExternalVpnGateway, error) {
	var item *computepb.ExternalVpnGateway
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ExternalVpnGatewayIterator) bufLen() int {
	return len(it.items)
}

func (it *ExternalVpnGatewayIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// FirewallIterator manages a stream of *computepb.Firewall.
type FirewallIterator struct {
	items    []*computepb.Firewall
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Firewall, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *FirewallIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *FirewallIterator) Next() (*computepb.Firewall, error) {
	var item *computepb.Firewall
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *FirewallIterator) bufLen() int {
	return len(it.items)
}

func (it *FirewallIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// FirewallPolicyIterator manages a stream of *computepb.FirewallPolicy.
type FirewallPolicyIterator struct {
	items    []*computepb.FirewallPolicy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.FirewallPolicy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *FirewallPolicyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *FirewallPolicyIterator) Next() (*computepb.FirewallPolicy, error) {
	var item *computepb.FirewallPolicy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *FirewallPolicyIterator) bufLen() int {
	return len(it.items)
}

func (it *FirewallPolicyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ForwardingRuleIterator manages a stream of *computepb.ForwardingRule.
type ForwardingRuleIterator struct {
	items    []*computepb.ForwardingRule
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.ForwardingRule, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ForwardingRuleIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ForwardingRuleIterator) Next() (*computepb.ForwardingRule, error) {
	var item *computepb.ForwardingRule
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ForwardingRuleIterator) bufLen() int {
	return len(it.items)
}

func (it *ForwardingRuleIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ForwardingRulesScopedListPair is a holder type for string/*computepb.ForwardingRulesScopedList map entries
type ForwardingRulesScopedListPair struct {
	Key   string
	Value *computepb.ForwardingRulesScopedList
}

// ForwardingRulesScopedListPairIterator manages a stream of ForwardingRulesScopedListPair.
type ForwardingRulesScopedListPairIterator struct {
	items    []ForwardingRulesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []ForwardingRulesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ForwardingRulesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ForwardingRulesScopedListPairIterator) Next() (ForwardingRulesScopedListPair, error) {
	var item ForwardingRulesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ForwardingRulesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *ForwardingRulesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// HealthCheckIterator manages a stream of *computepb.HealthCheck.
type HealthCheckIterator struct {
	items    []*computepb.HealthCheck
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.HealthCheck, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *HealthCheckIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *HealthCheckIterator) Next() (*computepb.HealthCheck, error) {
	var item *computepb.HealthCheck
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *HealthCheckIterator) bufLen() int {
	return len(it.items)
}

func (it *HealthCheckIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// HealthCheckServiceIterator manages a stream of *computepb.HealthCheckService.
type HealthCheckServiceIterator struct {
	items    []*computepb.HealthCheckService
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.HealthCheckService, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *HealthCheckServiceIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *HealthCheckServiceIterator) Next() (*computepb.HealthCheckService, error) {
	var item *computepb.HealthCheckService
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *HealthCheckServiceIterator) bufLen() int {
	return len(it.items)
}

func (it *HealthCheckServiceIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// HealthChecksScopedListPair is a holder type for string/*computepb.HealthChecksScopedList map entries
type HealthChecksScopedListPair struct {
	Key   string
	Value *computepb.HealthChecksScopedList
}

// HealthChecksScopedListPairIterator manages a stream of HealthChecksScopedListPair.
type HealthChecksScopedListPairIterator struct {
	items    []HealthChecksScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []HealthChecksScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *HealthChecksScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *HealthChecksScopedListPairIterator) Next() (HealthChecksScopedListPair, error) {
	var item HealthChecksScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *HealthChecksScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *HealthChecksScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ImageIterator manages a stream of *computepb.Image.
type ImageIterator struct {
	items    []*computepb.Image
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Image, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ImageIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ImageIterator) Next() (*computepb.Image, error) {
	var item *computepb.Image
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ImageIterator) bufLen() int {
	return len(it.items)
}

func (it *ImageIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstanceGroupIterator manages a stream of *computepb.InstanceGroup.
type InstanceGroupIterator struct {
	items    []*computepb.InstanceGroup
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.InstanceGroup, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstanceGroupIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstanceGroupIterator) Next() (*computepb.InstanceGroup, error) {
	var item *computepb.InstanceGroup
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstanceGroupIterator) bufLen() int {
	return len(it.items)
}

func (it *InstanceGroupIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstanceGroupManagerIterator manages a stream of *computepb.InstanceGroupManager.
type InstanceGroupManagerIterator struct {
	items    []*computepb.InstanceGroupManager
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.InstanceGroupManager, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstanceGroupManagerIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstanceGroupManagerIterator) Next() (*computepb.InstanceGroupManager, error) {
	var item *computepb.InstanceGroupManager
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstanceGroupManagerIterator) bufLen() int {
	return len(it.items)
}

func (it *InstanceGroupManagerIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstanceGroupManagerResizeRequestIterator manages a stream of *computepb.InstanceGroupManagerResizeRequest.
type InstanceGroupManagerResizeRequestIterator struct {
	items    []*computepb.InstanceGroupManagerResizeRequest
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.InstanceGroupManagerResizeRequest, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstanceGroupManagerResizeRequestIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstanceGroupManagerResizeRequestIterator) Next() (*computepb.InstanceGroupManagerResizeRequest, error) {
	var item *computepb.InstanceGroupManagerResizeRequest
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstanceGroupManagerResizeRequestIterator) bufLen() int {
	return len(it.items)
}

func (it *InstanceGroupManagerResizeRequestIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstanceGroupManagersScopedListPair is a holder type for string/*computepb.InstanceGroupManagersScopedList map entries
type InstanceGroupManagersScopedListPair struct {
	Key   string
	Value *computepb.InstanceGroupManagersScopedList
}

// InstanceGroupManagersScopedListPairIterator manages a stream of InstanceGroupManagersScopedListPair.
type InstanceGroupManagersScopedListPairIterator struct {
	items    []InstanceGroupManagersScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []InstanceGroupManagersScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstanceGroupManagersScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstanceGroupManagersScopedListPairIterator) Next() (InstanceGroupManagersScopedListPair, error) {
	var item InstanceGroupManagersScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstanceGroupManagersScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *InstanceGroupManagersScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstanceGroupsScopedListPair is a holder type for string/*computepb.InstanceGroupsScopedList map entries
type InstanceGroupsScopedListPair struct {
	Key   string
	Value *computepb.InstanceGroupsScopedList
}

// InstanceGroupsScopedListPairIterator manages a stream of InstanceGroupsScopedListPair.
type InstanceGroupsScopedListPairIterator struct {
	items    []InstanceGroupsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []InstanceGroupsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstanceGroupsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstanceGroupsScopedListPairIterator) Next() (InstanceGroupsScopedListPair, error) {
	var item InstanceGroupsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstanceGroupsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *InstanceGroupsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstanceIterator manages a stream of *computepb.Instance.
type InstanceIterator struct {
	items    []*computepb.Instance
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Instance, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstanceIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstanceIterator) Next() (*computepb.Instance, error) {
	var item *computepb.Instance
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstanceIterator) bufLen() int {
	return len(it.items)
}

func (it *InstanceIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstanceManagedByIgmErrorIterator manages a stream of *computepb.InstanceManagedByIgmError.
type InstanceManagedByIgmErrorIterator struct {
	items    []*computepb.InstanceManagedByIgmError
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.InstanceManagedByIgmError, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstanceManagedByIgmErrorIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstanceManagedByIgmErrorIterator) Next() (*computepb.InstanceManagedByIgmError, error) {
	var item *computepb.InstanceManagedByIgmError
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstanceManagedByIgmErrorIterator) bufLen() int {
	return len(it.items)
}

func (it *InstanceManagedByIgmErrorIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstanceTemplateIterator manages a stream of *computepb.InstanceTemplate.
type InstanceTemplateIterator struct {
	items    []*computepb.InstanceTemplate
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.InstanceTemplate, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstanceTemplateIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstanceTemplateIterator) Next() (*computepb.InstanceTemplate, error) {
	var item *computepb.InstanceTemplate
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstanceTemplateIterator) bufLen() int {
	return len(it.items)
}

func (it *InstanceTemplateIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstanceTemplatesScopedListPair is a holder type for string/*computepb.InstanceTemplatesScopedList map entries
type InstanceTemplatesScopedListPair struct {
	Key   string
	Value *computepb.InstanceTemplatesScopedList
}

// InstanceTemplatesScopedListPairIterator manages a stream of InstanceTemplatesScopedListPair.
type InstanceTemplatesScopedListPairIterator struct {
	items    []InstanceTemplatesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []InstanceTemplatesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstanceTemplatesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstanceTemplatesScopedListPairIterator) Next() (InstanceTemplatesScopedListPair, error) {
	var item InstanceTemplatesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstanceTemplatesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *InstanceTemplatesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstanceWithNamedPortsIterator manages a stream of *computepb.InstanceWithNamedPorts.
type InstanceWithNamedPortsIterator struct {
	items    []*computepb.InstanceWithNamedPorts
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.InstanceWithNamedPorts, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstanceWithNamedPortsIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstanceWithNamedPortsIterator) Next() (*computepb.InstanceWithNamedPorts, error) {
	var item *computepb.InstanceWithNamedPorts
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstanceWithNamedPortsIterator) bufLen() int {
	return len(it.items)
}

func (it *InstanceWithNamedPortsIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstancesScopedListPair is a holder type for string/*computepb.InstancesScopedList map entries
type InstancesScopedListPair struct {
	Key   string
	Value *computepb.InstancesScopedList
}

// InstancesScopedListPairIterator manages a stream of InstancesScopedListPair.
type InstancesScopedListPairIterator struct {
	items    []InstancesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []InstancesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstancesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstancesScopedListPairIterator) Next() (InstancesScopedListPair, error) {
	var item InstancesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstancesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *InstancesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstantSnapshotIterator manages a stream of *computepb.InstantSnapshot.
type InstantSnapshotIterator struct {
	items    []*computepb.InstantSnapshot
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.InstantSnapshot, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstantSnapshotIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstantSnapshotIterator) Next() (*computepb.InstantSnapshot, error) {
	var item *computepb.InstantSnapshot
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstantSnapshotIterator) bufLen() int {
	return len(it.items)
}

func (it *InstantSnapshotIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InstantSnapshotsScopedListPair is a holder type for string/*computepb.InstantSnapshotsScopedList map entries
type InstantSnapshotsScopedListPair struct {
	Key   string
	Value *computepb.InstantSnapshotsScopedList
}

// InstantSnapshotsScopedListPairIterator manages a stream of InstantSnapshotsScopedListPair.
type InstantSnapshotsScopedListPairIterator struct {
	items    []InstantSnapshotsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []InstantSnapshotsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InstantSnapshotsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstantSnapshotsScopedListPairIterator) Next() (InstantSnapshotsScopedListPair, error) {
	var item InstantSnapshotsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstantSnapshotsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *InstantSnapshotsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InterconnectAttachmentIterator manages a stream of *computepb.InterconnectAttachment.
type InterconnectAttachmentIterator struct {
	items    []*computepb.InterconnectAttachment
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.InterconnectAttachment, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InterconnectAttachmentIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InterconnectAttachmentIterator) Next() (*computepb.InterconnectAttachment, error) {
	var item *computepb.InterconnectAttachment
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InterconnectAttachmentIterator) bufLen() int {
	return len(it.items)
}

func (it *InterconnectAttachmentIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InterconnectAttachmentsScopedListPair is a holder type for string/*computepb.InterconnectAttachmentsScopedList map entries
type InterconnectAttachmentsScopedListPair struct {
	Key   string
	Value *computepb.InterconnectAttachmentsScopedList
}

// InterconnectAttachmentsScopedListPairIterator manages a stream of InterconnectAttachmentsScopedListPair.
type InterconnectAttachmentsScopedListPairIterator struct {
	items    []InterconnectAttachmentsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []InterconnectAttachmentsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InterconnectAttachmentsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InterconnectAttachmentsScopedListPairIterator) Next() (InterconnectAttachmentsScopedListPair, error) {
	var item InterconnectAttachmentsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InterconnectAttachmentsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *InterconnectAttachmentsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InterconnectIterator manages a stream of *computepb.Interconnect.
type InterconnectIterator struct {
	items    []*computepb.Interconnect
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Interconnect, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InterconnectIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InterconnectIterator) Next() (*computepb.Interconnect, error) {
	var item *computepb.Interconnect
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InterconnectIterator) bufLen() int {
	return len(it.items)
}

func (it *InterconnectIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InterconnectLocationIterator manages a stream of *computepb.InterconnectLocation.
type InterconnectLocationIterator struct {
	items    []*computepb.InterconnectLocation
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.InterconnectLocation, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InterconnectLocationIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InterconnectLocationIterator) Next() (*computepb.InterconnectLocation, error) {
	var item *computepb.InterconnectLocation
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InterconnectLocationIterator) bufLen() int {
	return len(it.items)
}

func (it *InterconnectLocationIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// InterconnectRemoteLocationIterator manages a stream of *computepb.InterconnectRemoteLocation.
type InterconnectRemoteLocationIterator struct {
	items    []*computepb.InterconnectRemoteLocation
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.InterconnectRemoteLocation, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *InterconnectRemoteLocationIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InterconnectRemoteLocationIterator) Next() (*computepb.InterconnectRemoteLocation, error) {
	var item *computepb.InterconnectRemoteLocation
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InterconnectRemoteLocationIterator) bufLen() int {
	return len(it.items)
}

func (it *InterconnectRemoteLocationIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// LicenseIterator manages a stream of *computepb.License.
type LicenseIterator struct {
	items    []*computepb.License
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.License, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *LicenseIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *LicenseIterator) Next() (*computepb.License, error) {
	var item *computepb.License
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *LicenseIterator) bufLen() int {
	return len(it.items)
}

func (it *LicenseIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// MachineImageIterator manages a stream of *computepb.MachineImage.
type MachineImageIterator struct {
	items    []*computepb.MachineImage
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.MachineImage, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *MachineImageIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *MachineImageIterator) Next() (*computepb.MachineImage, error) {
	var item *computepb.MachineImage
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *MachineImageIterator) bufLen() int {
	return len(it.items)
}

func (it *MachineImageIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// MachineTypeIterator manages a stream of *computepb.MachineType.
type MachineTypeIterator struct {
	items    []*computepb.MachineType
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.MachineType, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *MachineTypeIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *MachineTypeIterator) Next() (*computepb.MachineType, error) {
	var item *computepb.MachineType
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *MachineTypeIterator) bufLen() int {
	return len(it.items)
}

func (it *MachineTypeIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// MachineTypesScopedListPair is a holder type for string/*computepb.MachineTypesScopedList map entries
type MachineTypesScopedListPair struct {
	Key   string
	Value *computepb.MachineTypesScopedList
}

// MachineTypesScopedListPairIterator manages a stream of MachineTypesScopedListPair.
type MachineTypesScopedListPairIterator struct {
	items    []MachineTypesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []MachineTypesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *MachineTypesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *MachineTypesScopedListPairIterator) Next() (MachineTypesScopedListPair, error) {
	var item MachineTypesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *MachineTypesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *MachineTypesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ManagedInstanceIterator manages a stream of *computepb.ManagedInstance.
type ManagedInstanceIterator struct {
	items    []*computepb.ManagedInstance
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.ManagedInstance, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ManagedInstanceIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ManagedInstanceIterator) Next() (*computepb.ManagedInstance, error) {
	var item *computepb.ManagedInstance
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ManagedInstanceIterator) bufLen() int {
	return len(it.items)
}

func (it *ManagedInstanceIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NetworkAttachmentIterator manages a stream of *computepb.NetworkAttachment.
type NetworkAttachmentIterator struct {
	items    []*computepb.NetworkAttachment
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.NetworkAttachment, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NetworkAttachmentIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NetworkAttachmentIterator) Next() (*computepb.NetworkAttachment, error) {
	var item *computepb.NetworkAttachment
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NetworkAttachmentIterator) bufLen() int {
	return len(it.items)
}

func (it *NetworkAttachmentIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NetworkAttachmentsScopedListPair is a holder type for string/*computepb.NetworkAttachmentsScopedList map entries
type NetworkAttachmentsScopedListPair struct {
	Key   string
	Value *computepb.NetworkAttachmentsScopedList
}

// NetworkAttachmentsScopedListPairIterator manages a stream of NetworkAttachmentsScopedListPair.
type NetworkAttachmentsScopedListPairIterator struct {
	items    []NetworkAttachmentsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []NetworkAttachmentsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NetworkAttachmentsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NetworkAttachmentsScopedListPairIterator) Next() (NetworkAttachmentsScopedListPair, error) {
	var item NetworkAttachmentsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NetworkAttachmentsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *NetworkAttachmentsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NetworkEdgeSecurityServicesScopedListPair is a holder type for string/*computepb.NetworkEdgeSecurityServicesScopedList map entries
type NetworkEdgeSecurityServicesScopedListPair struct {
	Key   string
	Value *computepb.NetworkEdgeSecurityServicesScopedList
}

// NetworkEdgeSecurityServicesScopedListPairIterator manages a stream of NetworkEdgeSecurityServicesScopedListPair.
type NetworkEdgeSecurityServicesScopedListPairIterator struct {
	items    []NetworkEdgeSecurityServicesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []NetworkEdgeSecurityServicesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NetworkEdgeSecurityServicesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NetworkEdgeSecurityServicesScopedListPairIterator) Next() (NetworkEdgeSecurityServicesScopedListPair, error) {
	var item NetworkEdgeSecurityServicesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NetworkEdgeSecurityServicesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *NetworkEdgeSecurityServicesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NetworkEndpointGroupIterator manages a stream of *computepb.NetworkEndpointGroup.
type NetworkEndpointGroupIterator struct {
	items    []*computepb.NetworkEndpointGroup
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.NetworkEndpointGroup, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NetworkEndpointGroupIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NetworkEndpointGroupIterator) Next() (*computepb.NetworkEndpointGroup, error) {
	var item *computepb.NetworkEndpointGroup
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NetworkEndpointGroupIterator) bufLen() int {
	return len(it.items)
}

func (it *NetworkEndpointGroupIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NetworkEndpointGroupsScopedListPair is a holder type for string/*computepb.NetworkEndpointGroupsScopedList map entries
type NetworkEndpointGroupsScopedListPair struct {
	Key   string
	Value *computepb.NetworkEndpointGroupsScopedList
}

// NetworkEndpointGroupsScopedListPairIterator manages a stream of NetworkEndpointGroupsScopedListPair.
type NetworkEndpointGroupsScopedListPairIterator struct {
	items    []NetworkEndpointGroupsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []NetworkEndpointGroupsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NetworkEndpointGroupsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NetworkEndpointGroupsScopedListPairIterator) Next() (NetworkEndpointGroupsScopedListPair, error) {
	var item NetworkEndpointGroupsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NetworkEndpointGroupsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *NetworkEndpointGroupsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NetworkEndpointWithHealthStatusIterator manages a stream of *computepb.NetworkEndpointWithHealthStatus.
type NetworkEndpointWithHealthStatusIterator struct {
	items    []*computepb.NetworkEndpointWithHealthStatus
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.NetworkEndpointWithHealthStatus, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NetworkEndpointWithHealthStatusIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NetworkEndpointWithHealthStatusIterator) Next() (*computepb.NetworkEndpointWithHealthStatus, error) {
	var item *computepb.NetworkEndpointWithHealthStatus
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NetworkEndpointWithHealthStatusIterator) bufLen() int {
	return len(it.items)
}

func (it *NetworkEndpointWithHealthStatusIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NetworkIterator manages a stream of *computepb.Network.
type NetworkIterator struct {
	items    []*computepb.Network
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Network, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NetworkIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NetworkIterator) Next() (*computepb.Network, error) {
	var item *computepb.Network
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NetworkIterator) bufLen() int {
	return len(it.items)
}

func (it *NetworkIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NetworkProfileIterator manages a stream of *computepb.NetworkProfile.
type NetworkProfileIterator struct {
	items    []*computepb.NetworkProfile
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.NetworkProfile, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NetworkProfileIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NetworkProfileIterator) Next() (*computepb.NetworkProfile, error) {
	var item *computepb.NetworkProfile
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NetworkProfileIterator) bufLen() int {
	return len(it.items)
}

func (it *NetworkProfileIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NodeGroupIterator manages a stream of *computepb.NodeGroup.
type NodeGroupIterator struct {
	items    []*computepb.NodeGroup
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.NodeGroup, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NodeGroupIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NodeGroupIterator) Next() (*computepb.NodeGroup, error) {
	var item *computepb.NodeGroup
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NodeGroupIterator) bufLen() int {
	return len(it.items)
}

func (it *NodeGroupIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NodeGroupNodeIterator manages a stream of *computepb.NodeGroupNode.
type NodeGroupNodeIterator struct {
	items    []*computepb.NodeGroupNode
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.NodeGroupNode, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NodeGroupNodeIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NodeGroupNodeIterator) Next() (*computepb.NodeGroupNode, error) {
	var item *computepb.NodeGroupNode
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NodeGroupNodeIterator) bufLen() int {
	return len(it.items)
}

func (it *NodeGroupNodeIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NodeGroupsScopedListPair is a holder type for string/*computepb.NodeGroupsScopedList map entries
type NodeGroupsScopedListPair struct {
	Key   string
	Value *computepb.NodeGroupsScopedList
}

// NodeGroupsScopedListPairIterator manages a stream of NodeGroupsScopedListPair.
type NodeGroupsScopedListPairIterator struct {
	items    []NodeGroupsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []NodeGroupsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NodeGroupsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NodeGroupsScopedListPairIterator) Next() (NodeGroupsScopedListPair, error) {
	var item NodeGroupsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NodeGroupsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *NodeGroupsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NodeTemplateIterator manages a stream of *computepb.NodeTemplate.
type NodeTemplateIterator struct {
	items    []*computepb.NodeTemplate
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.NodeTemplate, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NodeTemplateIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NodeTemplateIterator) Next() (*computepb.NodeTemplate, error) {
	var item *computepb.NodeTemplate
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NodeTemplateIterator) bufLen() int {
	return len(it.items)
}

func (it *NodeTemplateIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NodeTemplatesScopedListPair is a holder type for string/*computepb.NodeTemplatesScopedList map entries
type NodeTemplatesScopedListPair struct {
	Key   string
	Value *computepb.NodeTemplatesScopedList
}

// NodeTemplatesScopedListPairIterator manages a stream of NodeTemplatesScopedListPair.
type NodeTemplatesScopedListPairIterator struct {
	items    []NodeTemplatesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []NodeTemplatesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NodeTemplatesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NodeTemplatesScopedListPairIterator) Next() (NodeTemplatesScopedListPair, error) {
	var item NodeTemplatesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NodeTemplatesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *NodeTemplatesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NodeTypeIterator manages a stream of *computepb.NodeType.
type NodeTypeIterator struct {
	items    []*computepb.NodeType
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.NodeType, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NodeTypeIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NodeTypeIterator) Next() (*computepb.NodeType, error) {
	var item *computepb.NodeType
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NodeTypeIterator) bufLen() int {
	return len(it.items)
}

func (it *NodeTypeIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NodeTypesScopedListPair is a holder type for string/*computepb.NodeTypesScopedList map entries
type NodeTypesScopedListPair struct {
	Key   string
	Value *computepb.NodeTypesScopedList
}

// NodeTypesScopedListPairIterator manages a stream of NodeTypesScopedListPair.
type NodeTypesScopedListPairIterator struct {
	items    []NodeTypesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []NodeTypesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NodeTypesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NodeTypesScopedListPairIterator) Next() (NodeTypesScopedListPair, error) {
	var item NodeTypesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NodeTypesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *NodeTypesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NotificationEndpointIterator manages a stream of *computepb.NotificationEndpoint.
type NotificationEndpointIterator struct {
	items    []*computepb.NotificationEndpoint
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.NotificationEndpoint, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *NotificationEndpointIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NotificationEndpointIterator) Next() (*computepb.NotificationEndpoint, error) {
	var item *computepb.NotificationEndpoint
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NotificationEndpointIterator) bufLen() int {
	return len(it.items)
}

func (it *NotificationEndpointIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// OperationIterator manages a stream of *computepb.Operation.
type OperationIterator struct {
	items    []*computepb.Operation
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Operation, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *OperationIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *OperationIterator) Next() (*computepb.Operation, error) {
	var item *computepb.Operation
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *OperationIterator) bufLen() int {
	return len(it.items)
}

func (it *OperationIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// OperationsScopedListPair is a holder type for string/*computepb.OperationsScopedList map entries
type OperationsScopedListPair struct {
	Key   string
	Value *computepb.OperationsScopedList
}

// OperationsScopedListPairIterator manages a stream of OperationsScopedListPair.
type OperationsScopedListPairIterator struct {
	items    []OperationsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []OperationsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *OperationsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *OperationsScopedListPairIterator) Next() (OperationsScopedListPair, error) {
	var item OperationsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *OperationsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *OperationsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// PacketMirroringIterator manages a stream of *computepb.PacketMirroring.
type PacketMirroringIterator struct {
	items    []*computepb.PacketMirroring
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.PacketMirroring, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *PacketMirroringIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *PacketMirroringIterator) Next() (*computepb.PacketMirroring, error) {
	var item *computepb.PacketMirroring
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *PacketMirroringIterator) bufLen() int {
	return len(it.items)
}

func (it *PacketMirroringIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// PacketMirroringsScopedListPair is a holder type for string/*computepb.PacketMirroringsScopedList map entries
type PacketMirroringsScopedListPair struct {
	Key   string
	Value *computepb.PacketMirroringsScopedList
}

// PacketMirroringsScopedListPairIterator manages a stream of PacketMirroringsScopedListPair.
type PacketMirroringsScopedListPairIterator struct {
	items    []PacketMirroringsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []PacketMirroringsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *PacketMirroringsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *PacketMirroringsScopedListPairIterator) Next() (PacketMirroringsScopedListPair, error) {
	var item PacketMirroringsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *PacketMirroringsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *PacketMirroringsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// PerInstanceConfigIterator manages a stream of *computepb.PerInstanceConfig.
type PerInstanceConfigIterator struct {
	items    []*computepb.PerInstanceConfig
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.PerInstanceConfig, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *PerInstanceConfigIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *PerInstanceConfigIterator) Next() (*computepb.PerInstanceConfig, error) {
	var item *computepb.PerInstanceConfig
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *PerInstanceConfigIterator) bufLen() int {
	return len(it.items)
}

func (it *PerInstanceConfigIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ProjectIterator manages a stream of *computepb.Project.
type ProjectIterator struct {
	items    []*computepb.Project
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Project, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ProjectIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ProjectIterator) Next() (*computepb.Project, error) {
	var item *computepb.Project
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ProjectIterator) bufLen() int {
	return len(it.items)
}

func (it *ProjectIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// PublicAdvertisedPrefixIterator manages a stream of *computepb.PublicAdvertisedPrefix.
type PublicAdvertisedPrefixIterator struct {
	items    []*computepb.PublicAdvertisedPrefix
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.PublicAdvertisedPrefix, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *PublicAdvertisedPrefixIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *PublicAdvertisedPrefixIterator) Next() (*computepb.PublicAdvertisedPrefix, error) {
	var item *computepb.PublicAdvertisedPrefix
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *PublicAdvertisedPrefixIterator) bufLen() int {
	return len(it.items)
}

func (it *PublicAdvertisedPrefixIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// PublicDelegatedPrefixIterator manages a stream of *computepb.PublicDelegatedPrefix.
type PublicDelegatedPrefixIterator struct {
	items    []*computepb.PublicDelegatedPrefix
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.PublicDelegatedPrefix, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *PublicDelegatedPrefixIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *PublicDelegatedPrefixIterator) Next() (*computepb.PublicDelegatedPrefix, error) {
	var item *computepb.PublicDelegatedPrefix
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *PublicDelegatedPrefixIterator) bufLen() int {
	return len(it.items)
}

func (it *PublicDelegatedPrefixIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// PublicDelegatedPrefixesScopedListPair is a holder type for string/*computepb.PublicDelegatedPrefixesScopedList map entries
type PublicDelegatedPrefixesScopedListPair struct {
	Key   string
	Value *computepb.PublicDelegatedPrefixesScopedList
}

// PublicDelegatedPrefixesScopedListPairIterator manages a stream of PublicDelegatedPrefixesScopedListPair.
type PublicDelegatedPrefixesScopedListPairIterator struct {
	items    []PublicDelegatedPrefixesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []PublicDelegatedPrefixesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *PublicDelegatedPrefixesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *PublicDelegatedPrefixesScopedListPairIterator) Next() (PublicDelegatedPrefixesScopedListPair, error) {
	var item PublicDelegatedPrefixesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *PublicDelegatedPrefixesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *PublicDelegatedPrefixesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ReferenceIterator manages a stream of *computepb.Reference.
type ReferenceIterator struct {
	items    []*computepb.Reference
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Reference, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ReferenceIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ReferenceIterator) Next() (*computepb.Reference, error) {
	var item *computepb.Reference
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ReferenceIterator) bufLen() int {
	return len(it.items)
}

func (it *ReferenceIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// RegionIterator manages a stream of *computepb.Region.
type RegionIterator struct {
	items    []*computepb.Region
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Region, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *RegionIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *RegionIterator) Next() (*computepb.Region, error) {
	var item *computepb.Region
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *RegionIterator) bufLen() int {
	return len(it.items)
}

func (it *RegionIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ReservationIterator manages a stream of *computepb.Reservation.
type ReservationIterator struct {
	items    []*computepb.Reservation
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Reservation, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ReservationIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ReservationIterator) Next() (*computepb.Reservation, error) {
	var item *computepb.Reservation
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ReservationIterator) bufLen() int {
	return len(it.items)
}

func (it *ReservationIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ReservationsScopedListPair is a holder type for string/*computepb.ReservationsScopedList map entries
type ReservationsScopedListPair struct {
	Key   string
	Value *computepb.ReservationsScopedList
}

// ReservationsScopedListPairIterator manages a stream of ReservationsScopedListPair.
type ReservationsScopedListPairIterator struct {
	items    []ReservationsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []ReservationsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ReservationsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ReservationsScopedListPairIterator) Next() (ReservationsScopedListPair, error) {
	var item ReservationsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ReservationsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *ReservationsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ResourcePoliciesScopedListPair is a holder type for string/*computepb.ResourcePoliciesScopedList map entries
type ResourcePoliciesScopedListPair struct {
	Key   string
	Value *computepb.ResourcePoliciesScopedList
}

// ResourcePoliciesScopedListPairIterator manages a stream of ResourcePoliciesScopedListPair.
type ResourcePoliciesScopedListPairIterator struct {
	items    []ResourcePoliciesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []ResourcePoliciesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ResourcePoliciesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ResourcePoliciesScopedListPairIterator) Next() (ResourcePoliciesScopedListPair, error) {
	var item ResourcePoliciesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ResourcePoliciesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *ResourcePoliciesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ResourcePolicyIterator manages a stream of *computepb.ResourcePolicy.
type ResourcePolicyIterator struct {
	items    []*computepb.ResourcePolicy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.ResourcePolicy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ResourcePolicyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ResourcePolicyIterator) Next() (*computepb.ResourcePolicy, error) {
	var item *computepb.ResourcePolicy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ResourcePolicyIterator) bufLen() int {
	return len(it.items)
}

func (it *ResourcePolicyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// RouteIterator manages a stream of *computepb.Route.
type RouteIterator struct {
	items    []*computepb.Route
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Route, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *RouteIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *RouteIterator) Next() (*computepb.Route, error) {
	var item *computepb.Route
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *RouteIterator) bufLen() int {
	return len(it.items)
}

func (it *RouteIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// RouterIterator manages a stream of *computepb.Router.
type RouterIterator struct {
	items    []*computepb.Router
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Router, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *RouterIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *RouterIterator) Next() (*computepb.Router, error) {
	var item *computepb.Router
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *RouterIterator) bufLen() int {
	return len(it.items)
}

func (it *RouterIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// RoutersScopedListPair is a holder type for string/*computepb.RoutersScopedList map entries
type RoutersScopedListPair struct {
	Key   string
	Value *computepb.RoutersScopedList
}

// RoutersScopedListPairIterator manages a stream of RoutersScopedListPair.
type RoutersScopedListPairIterator struct {
	items    []RoutersScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []RoutersScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *RoutersScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *RoutersScopedListPairIterator) Next() (RoutersScopedListPair, error) {
	var item RoutersScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *RoutersScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *RoutersScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SecurityPoliciesScopedListPair is a holder type for string/*computepb.SecurityPoliciesScopedList map entries
type SecurityPoliciesScopedListPair struct {
	Key   string
	Value *computepb.SecurityPoliciesScopedList
}

// SecurityPoliciesScopedListPairIterator manages a stream of SecurityPoliciesScopedListPair.
type SecurityPoliciesScopedListPairIterator struct {
	items    []SecurityPoliciesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []SecurityPoliciesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *SecurityPoliciesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SecurityPoliciesScopedListPairIterator) Next() (SecurityPoliciesScopedListPair, error) {
	var item SecurityPoliciesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SecurityPoliciesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *SecurityPoliciesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SecurityPolicyIterator manages a stream of *computepb.SecurityPolicy.
type SecurityPolicyIterator struct {
	items    []*computepb.SecurityPolicy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.SecurityPolicy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *SecurityPolicyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SecurityPolicyIterator) Next() (*computepb.SecurityPolicy, error) {
	var item *computepb.SecurityPolicy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SecurityPolicyIterator) bufLen() int {
	return len(it.items)
}

func (it *SecurityPolicyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ServiceAttachmentIterator manages a stream of *computepb.ServiceAttachment.
type ServiceAttachmentIterator struct {
	items    []*computepb.ServiceAttachment
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.ServiceAttachment, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ServiceAttachmentIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ServiceAttachmentIterator) Next() (*computepb.ServiceAttachment, error) {
	var item *computepb.ServiceAttachment
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ServiceAttachmentIterator) bufLen() int {
	return len(it.items)
}

func (it *ServiceAttachmentIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ServiceAttachmentsScopedListPair is a holder type for string/*computepb.ServiceAttachmentsScopedList map entries
type ServiceAttachmentsScopedListPair struct {
	Key   string
	Value *computepb.ServiceAttachmentsScopedList
}

// ServiceAttachmentsScopedListPairIterator manages a stream of ServiceAttachmentsScopedListPair.
type ServiceAttachmentsScopedListPairIterator struct {
	items    []ServiceAttachmentsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []ServiceAttachmentsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ServiceAttachmentsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ServiceAttachmentsScopedListPairIterator) Next() (ServiceAttachmentsScopedListPair, error) {
	var item ServiceAttachmentsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ServiceAttachmentsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *ServiceAttachmentsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SnapshotIterator manages a stream of *computepb.Snapshot.
type SnapshotIterator struct {
	items    []*computepb.Snapshot
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Snapshot, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *SnapshotIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SnapshotIterator) Next() (*computepb.Snapshot, error) {
	var item *computepb.Snapshot
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SnapshotIterator) bufLen() int {
	return len(it.items)
}

func (it *SnapshotIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SslCertificateIterator manages a stream of *computepb.SslCertificate.
type SslCertificateIterator struct {
	items    []*computepb.SslCertificate
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.SslCertificate, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *SslCertificateIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SslCertificateIterator) Next() (*computepb.SslCertificate, error) {
	var item *computepb.SslCertificate
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SslCertificateIterator) bufLen() int {
	return len(it.items)
}

func (it *SslCertificateIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SslCertificatesScopedListPair is a holder type for string/*computepb.SslCertificatesScopedList map entries
type SslCertificatesScopedListPair struct {
	Key   string
	Value *computepb.SslCertificatesScopedList
}

// SslCertificatesScopedListPairIterator manages a stream of SslCertificatesScopedListPair.
type SslCertificatesScopedListPairIterator struct {
	items    []SslCertificatesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []SslCertificatesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *SslCertificatesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SslCertificatesScopedListPairIterator) Next() (SslCertificatesScopedListPair, error) {
	var item SslCertificatesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SslCertificatesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *SslCertificatesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SslPoliciesScopedListPair is a holder type for string/*computepb.SslPoliciesScopedList map entries
type SslPoliciesScopedListPair struct {
	Key   string
	Value *computepb.SslPoliciesScopedList
}

// SslPoliciesScopedListPairIterator manages a stream of SslPoliciesScopedListPair.
type SslPoliciesScopedListPairIterator struct {
	items    []SslPoliciesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []SslPoliciesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *SslPoliciesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SslPoliciesScopedListPairIterator) Next() (SslPoliciesScopedListPair, error) {
	var item SslPoliciesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SslPoliciesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *SslPoliciesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SslPolicyIterator manages a stream of *computepb.SslPolicy.
type SslPolicyIterator struct {
	items    []*computepb.SslPolicy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.SslPolicy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *SslPolicyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SslPolicyIterator) Next() (*computepb.SslPolicy, error) {
	var item *computepb.SslPolicy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SslPolicyIterator) bufLen() int {
	return len(it.items)
}

func (it *SslPolicyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// StoragePoolDiskIterator manages a stream of *computepb.StoragePoolDisk.
type StoragePoolDiskIterator struct {
	items    []*computepb.StoragePoolDisk
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.StoragePoolDisk, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *StoragePoolDiskIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *StoragePoolDiskIterator) Next() (*computepb.StoragePoolDisk, error) {
	var item *computepb.StoragePoolDisk
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *StoragePoolDiskIterator) bufLen() int {
	return len(it.items)
}

func (it *StoragePoolDiskIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// StoragePoolIterator manages a stream of *computepb.StoragePool.
type StoragePoolIterator struct {
	items    []*computepb.StoragePool
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.StoragePool, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *StoragePoolIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *StoragePoolIterator) Next() (*computepb.StoragePool, error) {
	var item *computepb.StoragePool
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *StoragePoolIterator) bufLen() int {
	return len(it.items)
}

func (it *StoragePoolIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// StoragePoolTypeIterator manages a stream of *computepb.StoragePoolType.
type StoragePoolTypeIterator struct {
	items    []*computepb.StoragePoolType
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.StoragePoolType, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *StoragePoolTypeIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *StoragePoolTypeIterator) Next() (*computepb.StoragePoolType, error) {
	var item *computepb.StoragePoolType
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *StoragePoolTypeIterator) bufLen() int {
	return len(it.items)
}

func (it *StoragePoolTypeIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// StoragePoolTypesScopedListPair is a holder type for string/*computepb.StoragePoolTypesScopedList map entries
type StoragePoolTypesScopedListPair struct {
	Key   string
	Value *computepb.StoragePoolTypesScopedList
}

// StoragePoolTypesScopedListPairIterator manages a stream of StoragePoolTypesScopedListPair.
type StoragePoolTypesScopedListPairIterator struct {
	items    []StoragePoolTypesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []StoragePoolTypesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *StoragePoolTypesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *StoragePoolTypesScopedListPairIterator) Next() (StoragePoolTypesScopedListPair, error) {
	var item StoragePoolTypesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *StoragePoolTypesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *StoragePoolTypesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// StoragePoolsScopedListPair is a holder type for string/*computepb.StoragePoolsScopedList map entries
type StoragePoolsScopedListPair struct {
	Key   string
	Value *computepb.StoragePoolsScopedList
}

// StoragePoolsScopedListPairIterator manages a stream of StoragePoolsScopedListPair.
type StoragePoolsScopedListPairIterator struct {
	items    []StoragePoolsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []StoragePoolsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *StoragePoolsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *StoragePoolsScopedListPairIterator) Next() (StoragePoolsScopedListPair, error) {
	var item StoragePoolsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *StoragePoolsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *StoragePoolsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SubnetworkIterator manages a stream of *computepb.Subnetwork.
type SubnetworkIterator struct {
	items    []*computepb.Subnetwork
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Subnetwork, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *SubnetworkIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SubnetworkIterator) Next() (*computepb.Subnetwork, error) {
	var item *computepb.Subnetwork
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SubnetworkIterator) bufLen() int {
	return len(it.items)
}

func (it *SubnetworkIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SubnetworksScopedListPair is a holder type for string/*computepb.SubnetworksScopedList map entries
type SubnetworksScopedListPair struct {
	Key   string
	Value *computepb.SubnetworksScopedList
}

// SubnetworksScopedListPairIterator manages a stream of SubnetworksScopedListPair.
type SubnetworksScopedListPairIterator struct {
	items    []SubnetworksScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []SubnetworksScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *SubnetworksScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SubnetworksScopedListPairIterator) Next() (SubnetworksScopedListPair, error) {
	var item SubnetworksScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SubnetworksScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *SubnetworksScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetGrpcProxyIterator manages a stream of *computepb.TargetGrpcProxy.
type TargetGrpcProxyIterator struct {
	items    []*computepb.TargetGrpcProxy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.TargetGrpcProxy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetGrpcProxyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetGrpcProxyIterator) Next() (*computepb.TargetGrpcProxy, error) {
	var item *computepb.TargetGrpcProxy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetGrpcProxyIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetGrpcProxyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetHttpProxiesScopedListPair is a holder type for string/*computepb.TargetHttpProxiesScopedList map entries
type TargetHttpProxiesScopedListPair struct {
	Key   string
	Value *computepb.TargetHttpProxiesScopedList
}

// TargetHttpProxiesScopedListPairIterator manages a stream of TargetHttpProxiesScopedListPair.
type TargetHttpProxiesScopedListPairIterator struct {
	items    []TargetHttpProxiesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []TargetHttpProxiesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetHttpProxiesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetHttpProxiesScopedListPairIterator) Next() (TargetHttpProxiesScopedListPair, error) {
	var item TargetHttpProxiesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetHttpProxiesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetHttpProxiesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetHttpProxyIterator manages a stream of *computepb.TargetHttpProxy.
type TargetHttpProxyIterator struct {
	items    []*computepb.TargetHttpProxy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.TargetHttpProxy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetHttpProxyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetHttpProxyIterator) Next() (*computepb.TargetHttpProxy, error) {
	var item *computepb.TargetHttpProxy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetHttpProxyIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetHttpProxyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetHttpsProxiesScopedListPair is a holder type for string/*computepb.TargetHttpsProxiesScopedList map entries
type TargetHttpsProxiesScopedListPair struct {
	Key   string
	Value *computepb.TargetHttpsProxiesScopedList
}

// TargetHttpsProxiesScopedListPairIterator manages a stream of TargetHttpsProxiesScopedListPair.
type TargetHttpsProxiesScopedListPairIterator struct {
	items    []TargetHttpsProxiesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []TargetHttpsProxiesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetHttpsProxiesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetHttpsProxiesScopedListPairIterator) Next() (TargetHttpsProxiesScopedListPair, error) {
	var item TargetHttpsProxiesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetHttpsProxiesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetHttpsProxiesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetHttpsProxyIterator manages a stream of *computepb.TargetHttpsProxy.
type TargetHttpsProxyIterator struct {
	items    []*computepb.TargetHttpsProxy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.TargetHttpsProxy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetHttpsProxyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetHttpsProxyIterator) Next() (*computepb.TargetHttpsProxy, error) {
	var item *computepb.TargetHttpsProxy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetHttpsProxyIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetHttpsProxyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetInstanceIterator manages a stream of *computepb.TargetInstance.
type TargetInstanceIterator struct {
	items    []*computepb.TargetInstance
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.TargetInstance, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetInstanceIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetInstanceIterator) Next() (*computepb.TargetInstance, error) {
	var item *computepb.TargetInstance
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetInstanceIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetInstanceIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetInstancesScopedListPair is a holder type for string/*computepb.TargetInstancesScopedList map entries
type TargetInstancesScopedListPair struct {
	Key   string
	Value *computepb.TargetInstancesScopedList
}

// TargetInstancesScopedListPairIterator manages a stream of TargetInstancesScopedListPair.
type TargetInstancesScopedListPairIterator struct {
	items    []TargetInstancesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []TargetInstancesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetInstancesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetInstancesScopedListPairIterator) Next() (TargetInstancesScopedListPair, error) {
	var item TargetInstancesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetInstancesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetInstancesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetPoolIterator manages a stream of *computepb.TargetPool.
type TargetPoolIterator struct {
	items    []*computepb.TargetPool
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.TargetPool, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetPoolIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetPoolIterator) Next() (*computepb.TargetPool, error) {
	var item *computepb.TargetPool
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetPoolIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetPoolIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetPoolsScopedListPair is a holder type for string/*computepb.TargetPoolsScopedList map entries
type TargetPoolsScopedListPair struct {
	Key   string
	Value *computepb.TargetPoolsScopedList
}

// TargetPoolsScopedListPairIterator manages a stream of TargetPoolsScopedListPair.
type TargetPoolsScopedListPairIterator struct {
	items    []TargetPoolsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []TargetPoolsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetPoolsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetPoolsScopedListPairIterator) Next() (TargetPoolsScopedListPair, error) {
	var item TargetPoolsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetPoolsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetPoolsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetSslProxyIterator manages a stream of *computepb.TargetSslProxy.
type TargetSslProxyIterator struct {
	items    []*computepb.TargetSslProxy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.TargetSslProxy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetSslProxyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetSslProxyIterator) Next() (*computepb.TargetSslProxy, error) {
	var item *computepb.TargetSslProxy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetSslProxyIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetSslProxyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetTcpProxiesScopedListPair is a holder type for string/*computepb.TargetTcpProxiesScopedList map entries
type TargetTcpProxiesScopedListPair struct {
	Key   string
	Value *computepb.TargetTcpProxiesScopedList
}

// TargetTcpProxiesScopedListPairIterator manages a stream of TargetTcpProxiesScopedListPair.
type TargetTcpProxiesScopedListPairIterator struct {
	items    []TargetTcpProxiesScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []TargetTcpProxiesScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetTcpProxiesScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetTcpProxiesScopedListPairIterator) Next() (TargetTcpProxiesScopedListPair, error) {
	var item TargetTcpProxiesScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetTcpProxiesScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetTcpProxiesScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetTcpProxyIterator manages a stream of *computepb.TargetTcpProxy.
type TargetTcpProxyIterator struct {
	items    []*computepb.TargetTcpProxy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.TargetTcpProxy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetTcpProxyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetTcpProxyIterator) Next() (*computepb.TargetTcpProxy, error) {
	var item *computepb.TargetTcpProxy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetTcpProxyIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetTcpProxyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetVpnGatewayIterator manages a stream of *computepb.TargetVpnGateway.
type TargetVpnGatewayIterator struct {
	items    []*computepb.TargetVpnGateway
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.TargetVpnGateway, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetVpnGatewayIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetVpnGatewayIterator) Next() (*computepb.TargetVpnGateway, error) {
	var item *computepb.TargetVpnGateway
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetVpnGatewayIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetVpnGatewayIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetVpnGatewaysScopedListPair is a holder type for string/*computepb.TargetVpnGatewaysScopedList map entries
type TargetVpnGatewaysScopedListPair struct {
	Key   string
	Value *computepb.TargetVpnGatewaysScopedList
}

// TargetVpnGatewaysScopedListPairIterator manages a stream of TargetVpnGatewaysScopedListPair.
type TargetVpnGatewaysScopedListPairIterator struct {
	items    []TargetVpnGatewaysScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []TargetVpnGatewaysScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *TargetVpnGatewaysScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetVpnGatewaysScopedListPairIterator) Next() (TargetVpnGatewaysScopedListPair, error) {
	var item TargetVpnGatewaysScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetVpnGatewaysScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetVpnGatewaysScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// UrlMapIterator manages a stream of *computepb.UrlMap.
type UrlMapIterator struct {
	items    []*computepb.UrlMap
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.UrlMap, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *UrlMapIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *UrlMapIterator) Next() (*computepb.UrlMap, error) {
	var item *computepb.UrlMap
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *UrlMapIterator) bufLen() int {
	return len(it.items)
}

func (it *UrlMapIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// UrlMapsScopedListPair is a holder type for string/*computepb.UrlMapsScopedList map entries
type UrlMapsScopedListPair struct {
	Key   string
	Value *computepb.UrlMapsScopedList
}

// UrlMapsScopedListPairIterator manages a stream of UrlMapsScopedListPair.
type UrlMapsScopedListPairIterator struct {
	items    []UrlMapsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []UrlMapsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *UrlMapsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *UrlMapsScopedListPairIterator) Next() (UrlMapsScopedListPair, error) {
	var item UrlMapsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *UrlMapsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *UrlMapsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// UsableSubnetworkIterator manages a stream of *computepb.UsableSubnetwork.
type UsableSubnetworkIterator struct {
	items    []*computepb.UsableSubnetwork
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.UsableSubnetwork, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *UsableSubnetworkIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *UsableSubnetworkIterator) Next() (*computepb.UsableSubnetwork, error) {
	var item *computepb.UsableSubnetwork
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *UsableSubnetworkIterator) bufLen() int {
	return len(it.items)
}

func (it *UsableSubnetworkIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// VmEndpointNatMappingsIterator manages a stream of *computepb.VmEndpointNatMappings.
type VmEndpointNatMappingsIterator struct {
	items    []*computepb.VmEndpointNatMappings
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.VmEndpointNatMappings, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *VmEndpointNatMappingsIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *VmEndpointNatMappingsIterator) Next() (*computepb.VmEndpointNatMappings, error) {
	var item *computepb.VmEndpointNatMappings
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *VmEndpointNatMappingsIterator) bufLen() int {
	return len(it.items)
}

func (it *VmEndpointNatMappingsIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// VpnGatewayIterator manages a stream of *computepb.VpnGateway.
type VpnGatewayIterator struct {
	items    []*computepb.VpnGateway
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.VpnGateway, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *VpnGatewayIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *VpnGatewayIterator) Next() (*computepb.VpnGateway, error) {
	var item *computepb.VpnGateway
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *VpnGatewayIterator) bufLen() int {
	return len(it.items)
}

func (it *VpnGatewayIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// VpnGatewaysScopedListPair is a holder type for string/*computepb.VpnGatewaysScopedList map entries
type VpnGatewaysScopedListPair struct {
	Key   string
	Value *computepb.VpnGatewaysScopedList
}

// VpnGatewaysScopedListPairIterator manages a stream of VpnGatewaysScopedListPair.
type VpnGatewaysScopedListPairIterator struct {
	items    []VpnGatewaysScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []VpnGatewaysScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *VpnGatewaysScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *VpnGatewaysScopedListPairIterator) Next() (VpnGatewaysScopedListPair, error) {
	var item VpnGatewaysScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *VpnGatewaysScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *VpnGatewaysScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// VpnTunnelIterator manages a stream of *computepb.VpnTunnel.
type VpnTunnelIterator struct {
	items    []*computepb.VpnTunnel
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.VpnTunnel, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *VpnTunnelIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *VpnTunnelIterator) Next() (*computepb.VpnTunnel, error) {
	var item *computepb.VpnTunnel
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *VpnTunnelIterator) bufLen() int {
	return len(it.items)
}

func (it *VpnTunnelIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// VpnTunnelsScopedListPair is a holder type for string/*computepb.VpnTunnelsScopedList map entries
type VpnTunnelsScopedListPair struct {
	Key   string
	Value *computepb.VpnTunnelsScopedList
}

// VpnTunnelsScopedListPairIterator manages a stream of VpnTunnelsScopedListPair.
type VpnTunnelsScopedListPairIterator struct {
	items    []VpnTunnelsScopedListPair
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []VpnTunnelsScopedListPair, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *VpnTunnelsScopedListPairIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *VpnTunnelsScopedListPairIterator) Next() (VpnTunnelsScopedListPair, error) {
	var item VpnTunnelsScopedListPair
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *VpnTunnelsScopedListPairIterator) bufLen() int {
	return len(it.items)
}

func (it *VpnTunnelsScopedListPairIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// XpnResourceIdIterator manages a stream of *computepb.XpnResourceId.
type XpnResourceIdIterator struct {
	items    []*computepb.XpnResourceId
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.XpnResourceId, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *XpnResourceIdIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *XpnResourceIdIterator) Next() (*computepb.XpnResourceId, error) {
	var item *computepb.XpnResourceId
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *XpnResourceIdIterator) bufLen() int {
	return len(it.items)
}

func (it *XpnResourceIdIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ZoneIterator manages a stream of *computepb.Zone.
type ZoneIterator struct {
	items    []*computepb.Zone
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*computepb.Zone, nextPageToken string, err error)
}

// PageInfo supports pagination. See the [google.golang.org/api/iterator] package for details.
func (it *ZoneIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ZoneIterator) Next() (*computepb.Zone, error) {
	var item *computepb.Zone
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ZoneIterator) bufLen() int {
	return len(it.items)
}

func (it *ZoneIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
