/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentguardsContentRedirectAPIService ContentguardsContentRedirectAPI service
type ContentguardsContentRedirectAPIService service

type ContentguardsContentRedirectAPIContentguardsCoreContentRedirectAddRoleRequest struct {
	ctx context.Context
	ApiService *ContentguardsContentRedirectAPIService
	contentRedirectContentGuardHref string
	nestedRole *NestedRole
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectAddRoleRequest) NestedRole(nestedRole NestedRole) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreContentRedirectAddRoleExecute(r)
}

/*
ContentguardsCoreContentRedirectAddRole Method for ContentguardsCoreContentRedirectAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param contentRedirectContentGuardHref
 @return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectAddRoleRequest
*/
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectAddRole(ctx context.Context, contentRedirectContentGuardHref string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectAddRoleRequest {
	return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		contentRedirectContentGuardHref: contentRedirectContentGuardHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectAddRoleExecute(r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsContentRedirectAPIService.ContentguardsCoreContentRedirectAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{content_redirect_content_guard_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"content_redirect_content_guard_href"+"}", parameterValueToString(r.contentRedirectContentGuardHref, "contentRedirectContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsContentRedirectAPIContentguardsCoreContentRedirectCreateRequest struct {
	ctx context.Context
	ApiService *ContentguardsContentRedirectAPIService
	contentRedirectContentGuard *ContentRedirectContentGuard
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectCreateRequest) ContentRedirectContentGuard(contentRedirectContentGuard ContentRedirectContentGuard) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectCreateRequest {
	r.contentRedirectContentGuard = &contentRedirectContentGuard
	return r
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectCreateRequest) Execute() (*ContentRedirectContentGuardResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreContentRedirectCreateExecute(r)
}

/*
ContentguardsCoreContentRedirectCreate Create a content redirect content guard

Content guard to protect preauthenticated redirects to the content app.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectCreateRequest
*/
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectCreate(ctx context.Context) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectCreateRequest {
	return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return ContentRedirectContentGuardResponse
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectCreateExecute(r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectCreateRequest) (*ContentRedirectContentGuardResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContentRedirectContentGuardResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsContentRedirectAPIService.ContentguardsCoreContentRedirectCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/contentguards/core/content_redirect/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.contentRedirectContentGuard == nil {
		return localVarReturnValue, nil, reportError("contentRedirectContentGuard is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.contentRedirectContentGuard
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsContentRedirectAPIContentguardsCoreContentRedirectDeleteRequest struct {
	ctx context.Context
	ApiService *ContentguardsContentRedirectAPIService
	contentRedirectContentGuardHref string
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.ContentguardsCoreContentRedirectDeleteExecute(r)
}

/*
ContentguardsCoreContentRedirectDelete Delete a content redirect content guard

Content guard to protect preauthenticated redirects to the content app.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param contentRedirectContentGuardHref
 @return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectDeleteRequest
*/
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectDelete(ctx context.Context, contentRedirectContentGuardHref string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectDeleteRequest {
	return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectDeleteRequest{
		ApiService: a,
		ctx: ctx,
		contentRedirectContentGuardHref: contentRedirectContentGuardHref,
	}
}

// Execute executes the request
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectDeleteExecute(r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsContentRedirectAPIService.ContentguardsCoreContentRedirectDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{content_redirect_content_guard_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"content_redirect_content_guard_href"+"}", parameterValueToString(r.contentRedirectContentGuardHref, "contentRedirectContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest struct {
	ctx context.Context
	ApiService *ContentguardsContentRedirectAPIService
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) Limit(limit int32) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) Name(name string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) NameContains(nameContains string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) NameIcontains(nameIcontains string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) NameIn(nameIn []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) NameStartswith(nameStartswith string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) Offset(offset int32) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) Ordering(ordering []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) PulpHrefIn(pulpHrefIn []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) PulpIdIn(pulpIdIn []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// A list of fields to include in the response.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) Fields(fields []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) ExcludeFields(excludeFields []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) Execute() (*PaginatedContentRedirectContentGuardResponseList, *http.Response, error) {
	return r.ApiService.ContentguardsCoreContentRedirectListExecute(r)
}

/*
ContentguardsCoreContentRedirectList List content redirect content guards

Content guard to protect preauthenticated redirects to the content app.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest
*/
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectList(ctx context.Context) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest {
	return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedContentRedirectContentGuardResponseList
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectListExecute(r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRequest) (*PaginatedContentRedirectContentGuardResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedContentRedirectContentGuardResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsContentRedirectAPIService.ContentguardsCoreContentRedirectList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/contentguards/core/content_redirect/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRolesRequest struct {
	ctx context.Context
	ApiService *ContentguardsContentRedirectAPIService
	contentRedirectContentGuardHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRolesRequest) Fields(fields []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRolesRequest) ExcludeFields(excludeFields []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreContentRedirectListRolesExecute(r)
}

/*
ContentguardsCoreContentRedirectListRoles Method for ContentguardsCoreContentRedirectListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param contentRedirectContentGuardHref
 @return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRolesRequest
*/
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectListRoles(ctx context.Context, contentRedirectContentGuardHref string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRolesRequest {
	return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRolesRequest{
		ApiService: a,
		ctx: ctx,
		contentRedirectContentGuardHref: contentRedirectContentGuardHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectListRolesExecute(r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsContentRedirectAPIService.ContentguardsCoreContentRedirectListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{content_redirect_content_guard_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"content_redirect_content_guard_href"+"}", parameterValueToString(r.contentRedirectContentGuardHref, "contentRedirectContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsContentRedirectAPIContentguardsCoreContentRedirectMyPermissionsRequest struct {
	ctx context.Context
	ApiService *ContentguardsContentRedirectAPIService
	contentRedirectContentGuardHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectMyPermissionsRequest) Fields(fields []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectMyPermissionsRequest) ExcludeFields(excludeFields []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreContentRedirectMyPermissionsExecute(r)
}

/*
ContentguardsCoreContentRedirectMyPermissions Method for ContentguardsCoreContentRedirectMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param contentRedirectContentGuardHref
 @return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectMyPermissionsRequest
*/
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectMyPermissions(ctx context.Context, contentRedirectContentGuardHref string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectMyPermissionsRequest {
	return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		contentRedirectContentGuardHref: contentRedirectContentGuardHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectMyPermissionsExecute(r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsContentRedirectAPIService.ContentguardsCoreContentRedirectMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{content_redirect_content_guard_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"content_redirect_content_guard_href"+"}", parameterValueToString(r.contentRedirectContentGuardHref, "contentRedirectContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsContentRedirectAPIContentguardsCoreContentRedirectPartialUpdateRequest struct {
	ctx context.Context
	ApiService *ContentguardsContentRedirectAPIService
	contentRedirectContentGuardHref string
	patchedContentRedirectContentGuard *PatchedContentRedirectContentGuard
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectPartialUpdateRequest) PatchedContentRedirectContentGuard(patchedContentRedirectContentGuard PatchedContentRedirectContentGuard) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectPartialUpdateRequest {
	r.patchedContentRedirectContentGuard = &patchedContentRedirectContentGuard
	return r
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectPartialUpdateRequest) Execute() (*ContentRedirectContentGuardResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreContentRedirectPartialUpdateExecute(r)
}

/*
ContentguardsCoreContentRedirectPartialUpdate Update a content redirect content guard

Content guard to protect preauthenticated redirects to the content app.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param contentRedirectContentGuardHref
 @return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectPartialUpdateRequest
*/
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectPartialUpdate(ctx context.Context, contentRedirectContentGuardHref string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectPartialUpdateRequest {
	return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		contentRedirectContentGuardHref: contentRedirectContentGuardHref,
	}
}

// Execute executes the request
//  @return ContentRedirectContentGuardResponse
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectPartialUpdateExecute(r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectPartialUpdateRequest) (*ContentRedirectContentGuardResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContentRedirectContentGuardResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsContentRedirectAPIService.ContentguardsCoreContentRedirectPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{content_redirect_content_guard_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"content_redirect_content_guard_href"+"}", parameterValueToString(r.contentRedirectContentGuardHref, "contentRedirectContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedContentRedirectContentGuard == nil {
		return localVarReturnValue, nil, reportError("patchedContentRedirectContentGuard is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedContentRedirectContentGuard
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsContentRedirectAPIContentguardsCoreContentRedirectReadRequest struct {
	ctx context.Context
	ApiService *ContentguardsContentRedirectAPIService
	contentRedirectContentGuardHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectReadRequest) Fields(fields []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectReadRequest) ExcludeFields(excludeFields []string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectReadRequest) Execute() (*ContentRedirectContentGuardResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreContentRedirectReadExecute(r)
}

/*
ContentguardsCoreContentRedirectRead Inspect a content redirect content guard

Content guard to protect preauthenticated redirects to the content app.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param contentRedirectContentGuardHref
 @return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectReadRequest
*/
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectRead(ctx context.Context, contentRedirectContentGuardHref string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectReadRequest {
	return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectReadRequest{
		ApiService: a,
		ctx: ctx,
		contentRedirectContentGuardHref: contentRedirectContentGuardHref,
	}
}

// Execute executes the request
//  @return ContentRedirectContentGuardResponse
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectReadExecute(r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectReadRequest) (*ContentRedirectContentGuardResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContentRedirectContentGuardResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsContentRedirectAPIService.ContentguardsCoreContentRedirectRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{content_redirect_content_guard_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"content_redirect_content_guard_href"+"}", parameterValueToString(r.contentRedirectContentGuardHref, "contentRedirectContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsContentRedirectAPIContentguardsCoreContentRedirectRemoveRoleRequest struct {
	ctx context.Context
	ApiService *ContentguardsContentRedirectAPIService
	contentRedirectContentGuardHref string
	nestedRole *NestedRole
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectRemoveRoleRequest) NestedRole(nestedRole NestedRole) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreContentRedirectRemoveRoleExecute(r)
}

/*
ContentguardsCoreContentRedirectRemoveRole Method for ContentguardsCoreContentRedirectRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param contentRedirectContentGuardHref
 @return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectRemoveRoleRequest
*/
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectRemoveRole(ctx context.Context, contentRedirectContentGuardHref string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectRemoveRoleRequest {
	return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		contentRedirectContentGuardHref: contentRedirectContentGuardHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectRemoveRoleExecute(r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsContentRedirectAPIService.ContentguardsCoreContentRedirectRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{content_redirect_content_guard_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"content_redirect_content_guard_href"+"}", parameterValueToString(r.contentRedirectContentGuardHref, "contentRedirectContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsContentRedirectAPIContentguardsCoreContentRedirectUpdateRequest struct {
	ctx context.Context
	ApiService *ContentguardsContentRedirectAPIService
	contentRedirectContentGuardHref string
	contentRedirectContentGuard *ContentRedirectContentGuard
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectUpdateRequest) ContentRedirectContentGuard(contentRedirectContentGuard ContentRedirectContentGuard) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectUpdateRequest {
	r.contentRedirectContentGuard = &contentRedirectContentGuard
	return r
}

func (r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectUpdateRequest) Execute() (*ContentRedirectContentGuardResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreContentRedirectUpdateExecute(r)
}

/*
ContentguardsCoreContentRedirectUpdate Update a content redirect content guard

Content guard to protect preauthenticated redirects to the content app.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param contentRedirectContentGuardHref
 @return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectUpdateRequest
*/
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectUpdate(ctx context.Context, contentRedirectContentGuardHref string) ContentguardsContentRedirectAPIContentguardsCoreContentRedirectUpdateRequest {
	return ContentguardsContentRedirectAPIContentguardsCoreContentRedirectUpdateRequest{
		ApiService: a,
		ctx: ctx,
		contentRedirectContentGuardHref: contentRedirectContentGuardHref,
	}
}

// Execute executes the request
//  @return ContentRedirectContentGuardResponse
func (a *ContentguardsContentRedirectAPIService) ContentguardsCoreContentRedirectUpdateExecute(r ContentguardsContentRedirectAPIContentguardsCoreContentRedirectUpdateRequest) (*ContentRedirectContentGuardResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContentRedirectContentGuardResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsContentRedirectAPIService.ContentguardsCoreContentRedirectUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{content_redirect_content_guard_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"content_redirect_content_guard_href"+"}", parameterValueToString(r.contentRedirectContentGuardHref, "contentRedirectContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.contentRedirectContentGuard == nil {
		return localVarReturnValue, nil, reportError("contentRedirectContentGuard is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.contentRedirectContentGuard
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
