/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// AcsRpmAPIService AcsRpmAPI service
type AcsRpmAPIService service

type AcsRpmAPIAcsRpmRpmAddRoleRequest struct {
	ctx context.Context
	ApiService *AcsRpmAPIService
	rpmRpmAlternateContentSourceHref string
	nestedRole *NestedRole
}

func (r AcsRpmAPIAcsRpmRpmAddRoleRequest) NestedRole(nestedRole NestedRole) AcsRpmAPIAcsRpmRpmAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r AcsRpmAPIAcsRpmRpmAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.AcsRpmRpmAddRoleExecute(r)
}

/*
AcsRpmRpmAddRole Method for AcsRpmRpmAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmAlternateContentSourceHref
 @return AcsRpmAPIAcsRpmRpmAddRoleRequest
*/
func (a *AcsRpmAPIService) AcsRpmRpmAddRole(ctx context.Context, rpmRpmAlternateContentSourceHref string) AcsRpmAPIAcsRpmRpmAddRoleRequest {
	return AcsRpmAPIAcsRpmRpmAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmAlternateContentSourceHref: rpmRpmAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *AcsRpmAPIService) AcsRpmRpmAddRoleExecute(r AcsRpmAPIAcsRpmRpmAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsRpmAPIService.AcsRpmRpmAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_alternate_content_source_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_alternate_content_source_href"+"}", parameterValueToString(r.rpmRpmAlternateContentSourceHref, "rpmRpmAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsRpmAPIAcsRpmRpmCreateRequest struct {
	ctx context.Context
	ApiService *AcsRpmAPIService
	rpmRpmAlternateContentSource *RpmRpmAlternateContentSource
}

func (r AcsRpmAPIAcsRpmRpmCreateRequest) RpmRpmAlternateContentSource(rpmRpmAlternateContentSource RpmRpmAlternateContentSource) AcsRpmAPIAcsRpmRpmCreateRequest {
	r.rpmRpmAlternateContentSource = &rpmRpmAlternateContentSource
	return r
}

func (r AcsRpmAPIAcsRpmRpmCreateRequest) Execute() (*RpmRpmAlternateContentSourceResponse, *http.Response, error) {
	return r.ApiService.AcsRpmRpmCreateExecute(r)
}

/*
AcsRpmRpmCreate Create a rpm alternate content source

ViewSet for ACS.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return AcsRpmAPIAcsRpmRpmCreateRequest
*/
func (a *AcsRpmAPIService) AcsRpmRpmCreate(ctx context.Context) AcsRpmAPIAcsRpmRpmCreateRequest {
	return AcsRpmAPIAcsRpmRpmCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return RpmRpmAlternateContentSourceResponse
func (a *AcsRpmAPIService) AcsRpmRpmCreateExecute(r AcsRpmAPIAcsRpmRpmCreateRequest) (*RpmRpmAlternateContentSourceResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RpmRpmAlternateContentSourceResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsRpmAPIService.AcsRpmRpmCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/acs/rpm/rpm/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rpmRpmAlternateContentSource == nil {
		return localVarReturnValue, nil, reportError("rpmRpmAlternateContentSource is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rpmRpmAlternateContentSource
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsRpmAPIAcsRpmRpmDeleteRequest struct {
	ctx context.Context
	ApiService *AcsRpmAPIService
	rpmRpmAlternateContentSourceHref string
}

func (r AcsRpmAPIAcsRpmRpmDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.AcsRpmRpmDeleteExecute(r)
}

/*
AcsRpmRpmDelete Delete a rpm alternate content source

Trigger an asynchronous delete ACS task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmAlternateContentSourceHref
 @return AcsRpmAPIAcsRpmRpmDeleteRequest
*/
func (a *AcsRpmAPIService) AcsRpmRpmDelete(ctx context.Context, rpmRpmAlternateContentSourceHref string) AcsRpmAPIAcsRpmRpmDeleteRequest {
	return AcsRpmAPIAcsRpmRpmDeleteRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmAlternateContentSourceHref: rpmRpmAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *AcsRpmAPIService) AcsRpmRpmDeleteExecute(r AcsRpmAPIAcsRpmRpmDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsRpmAPIService.AcsRpmRpmDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_alternate_content_source_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_alternate_content_source_href"+"}", parameterValueToString(r.rpmRpmAlternateContentSourceHref, "rpmRpmAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsRpmAPIAcsRpmRpmListRequest struct {
	ctx context.Context
	ApiService *AcsRpmAPIService
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r AcsRpmAPIAcsRpmRpmListRequest) Limit(limit int32) AcsRpmAPIAcsRpmRpmListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r AcsRpmAPIAcsRpmRpmListRequest) Name(name string) AcsRpmAPIAcsRpmRpmListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r AcsRpmAPIAcsRpmRpmListRequest) NameContains(nameContains string) AcsRpmAPIAcsRpmRpmListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r AcsRpmAPIAcsRpmRpmListRequest) NameIcontains(nameIcontains string) AcsRpmAPIAcsRpmRpmListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r AcsRpmAPIAcsRpmRpmListRequest) NameIn(nameIn []string) AcsRpmAPIAcsRpmRpmListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r AcsRpmAPIAcsRpmRpmListRequest) NameStartswith(nameStartswith string) AcsRpmAPIAcsRpmRpmListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r AcsRpmAPIAcsRpmRpmListRequest) Offset(offset int32) AcsRpmAPIAcsRpmRpmListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;last_refreshed&#x60; - Last refreshed * &#x60;-last_refreshed&#x60; - Last refreshed (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r AcsRpmAPIAcsRpmRpmListRequest) Ordering(ordering []string) AcsRpmAPIAcsRpmRpmListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r AcsRpmAPIAcsRpmRpmListRequest) PulpHrefIn(pulpHrefIn []string) AcsRpmAPIAcsRpmRpmListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r AcsRpmAPIAcsRpmRpmListRequest) PulpIdIn(pulpIdIn []string) AcsRpmAPIAcsRpmRpmListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// A list of fields to include in the response.
func (r AcsRpmAPIAcsRpmRpmListRequest) Fields(fields []string) AcsRpmAPIAcsRpmRpmListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r AcsRpmAPIAcsRpmRpmListRequest) ExcludeFields(excludeFields []string) AcsRpmAPIAcsRpmRpmListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r AcsRpmAPIAcsRpmRpmListRequest) Execute() (*PaginatedrpmRpmAlternateContentSourceResponseList, *http.Response, error) {
	return r.ApiService.AcsRpmRpmListExecute(r)
}

/*
AcsRpmRpmList List rpm alternate content sources

ViewSet for ACS.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return AcsRpmAPIAcsRpmRpmListRequest
*/
func (a *AcsRpmAPIService) AcsRpmRpmList(ctx context.Context) AcsRpmAPIAcsRpmRpmListRequest {
	return AcsRpmAPIAcsRpmRpmListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedrpmRpmAlternateContentSourceResponseList
func (a *AcsRpmAPIService) AcsRpmRpmListExecute(r AcsRpmAPIAcsRpmRpmListRequest) (*PaginatedrpmRpmAlternateContentSourceResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedrpmRpmAlternateContentSourceResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsRpmAPIService.AcsRpmRpmList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/acs/rpm/rpm/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsRpmAPIAcsRpmRpmListRolesRequest struct {
	ctx context.Context
	ApiService *AcsRpmAPIService
	rpmRpmAlternateContentSourceHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r AcsRpmAPIAcsRpmRpmListRolesRequest) Fields(fields []string) AcsRpmAPIAcsRpmRpmListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r AcsRpmAPIAcsRpmRpmListRolesRequest) ExcludeFields(excludeFields []string) AcsRpmAPIAcsRpmRpmListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r AcsRpmAPIAcsRpmRpmListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.AcsRpmRpmListRolesExecute(r)
}

/*
AcsRpmRpmListRoles Method for AcsRpmRpmListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmAlternateContentSourceHref
 @return AcsRpmAPIAcsRpmRpmListRolesRequest
*/
func (a *AcsRpmAPIService) AcsRpmRpmListRoles(ctx context.Context, rpmRpmAlternateContentSourceHref string) AcsRpmAPIAcsRpmRpmListRolesRequest {
	return AcsRpmAPIAcsRpmRpmListRolesRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmAlternateContentSourceHref: rpmRpmAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *AcsRpmAPIService) AcsRpmRpmListRolesExecute(r AcsRpmAPIAcsRpmRpmListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsRpmAPIService.AcsRpmRpmListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_alternate_content_source_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_alternate_content_source_href"+"}", parameterValueToString(r.rpmRpmAlternateContentSourceHref, "rpmRpmAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsRpmAPIAcsRpmRpmMyPermissionsRequest struct {
	ctx context.Context
	ApiService *AcsRpmAPIService
	rpmRpmAlternateContentSourceHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r AcsRpmAPIAcsRpmRpmMyPermissionsRequest) Fields(fields []string) AcsRpmAPIAcsRpmRpmMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r AcsRpmAPIAcsRpmRpmMyPermissionsRequest) ExcludeFields(excludeFields []string) AcsRpmAPIAcsRpmRpmMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r AcsRpmAPIAcsRpmRpmMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.AcsRpmRpmMyPermissionsExecute(r)
}

/*
AcsRpmRpmMyPermissions Method for AcsRpmRpmMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmAlternateContentSourceHref
 @return AcsRpmAPIAcsRpmRpmMyPermissionsRequest
*/
func (a *AcsRpmAPIService) AcsRpmRpmMyPermissions(ctx context.Context, rpmRpmAlternateContentSourceHref string) AcsRpmAPIAcsRpmRpmMyPermissionsRequest {
	return AcsRpmAPIAcsRpmRpmMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmAlternateContentSourceHref: rpmRpmAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *AcsRpmAPIService) AcsRpmRpmMyPermissionsExecute(r AcsRpmAPIAcsRpmRpmMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsRpmAPIService.AcsRpmRpmMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_alternate_content_source_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_alternate_content_source_href"+"}", parameterValueToString(r.rpmRpmAlternateContentSourceHref, "rpmRpmAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsRpmAPIAcsRpmRpmPartialUpdateRequest struct {
	ctx context.Context
	ApiService *AcsRpmAPIService
	rpmRpmAlternateContentSourceHref string
	patchedrpmRpmAlternateContentSource *PatchedrpmRpmAlternateContentSource
}

func (r AcsRpmAPIAcsRpmRpmPartialUpdateRequest) PatchedrpmRpmAlternateContentSource(patchedrpmRpmAlternateContentSource PatchedrpmRpmAlternateContentSource) AcsRpmAPIAcsRpmRpmPartialUpdateRequest {
	r.patchedrpmRpmAlternateContentSource = &patchedrpmRpmAlternateContentSource
	return r
}

func (r AcsRpmAPIAcsRpmRpmPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.AcsRpmRpmPartialUpdateExecute(r)
}

/*
AcsRpmRpmPartialUpdate Update a rpm alternate content source

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmAlternateContentSourceHref
 @return AcsRpmAPIAcsRpmRpmPartialUpdateRequest
*/
func (a *AcsRpmAPIService) AcsRpmRpmPartialUpdate(ctx context.Context, rpmRpmAlternateContentSourceHref string) AcsRpmAPIAcsRpmRpmPartialUpdateRequest {
	return AcsRpmAPIAcsRpmRpmPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmAlternateContentSourceHref: rpmRpmAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *AcsRpmAPIService) AcsRpmRpmPartialUpdateExecute(r AcsRpmAPIAcsRpmRpmPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsRpmAPIService.AcsRpmRpmPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_alternate_content_source_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_alternate_content_source_href"+"}", parameterValueToString(r.rpmRpmAlternateContentSourceHref, "rpmRpmAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedrpmRpmAlternateContentSource == nil {
		return localVarReturnValue, nil, reportError("patchedrpmRpmAlternateContentSource is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedrpmRpmAlternateContentSource
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsRpmAPIAcsRpmRpmReadRequest struct {
	ctx context.Context
	ApiService *AcsRpmAPIService
	rpmRpmAlternateContentSourceHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r AcsRpmAPIAcsRpmRpmReadRequest) Fields(fields []string) AcsRpmAPIAcsRpmRpmReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r AcsRpmAPIAcsRpmRpmReadRequest) ExcludeFields(excludeFields []string) AcsRpmAPIAcsRpmRpmReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r AcsRpmAPIAcsRpmRpmReadRequest) Execute() (*RpmRpmAlternateContentSourceResponse, *http.Response, error) {
	return r.ApiService.AcsRpmRpmReadExecute(r)
}

/*
AcsRpmRpmRead Inspect a rpm alternate content source

ViewSet for ACS.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmAlternateContentSourceHref
 @return AcsRpmAPIAcsRpmRpmReadRequest
*/
func (a *AcsRpmAPIService) AcsRpmRpmRead(ctx context.Context, rpmRpmAlternateContentSourceHref string) AcsRpmAPIAcsRpmRpmReadRequest {
	return AcsRpmAPIAcsRpmRpmReadRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmAlternateContentSourceHref: rpmRpmAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return RpmRpmAlternateContentSourceResponse
func (a *AcsRpmAPIService) AcsRpmRpmReadExecute(r AcsRpmAPIAcsRpmRpmReadRequest) (*RpmRpmAlternateContentSourceResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RpmRpmAlternateContentSourceResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsRpmAPIService.AcsRpmRpmRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_alternate_content_source_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_alternate_content_source_href"+"}", parameterValueToString(r.rpmRpmAlternateContentSourceHref, "rpmRpmAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsRpmAPIAcsRpmRpmRefreshRequest struct {
	ctx context.Context
	ApiService *AcsRpmAPIService
	rpmRpmAlternateContentSourceHref string
}

func (r AcsRpmAPIAcsRpmRpmRefreshRequest) Execute() (*TaskGroupOperationResponse, *http.Response, error) {
	return r.ApiService.AcsRpmRpmRefreshExecute(r)
}

/*
AcsRpmRpmRefresh Method for AcsRpmRpmRefresh

Trigger an asynchronous task to create Alternate Content Source content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmAlternateContentSourceHref
 @return AcsRpmAPIAcsRpmRpmRefreshRequest
*/
func (a *AcsRpmAPIService) AcsRpmRpmRefresh(ctx context.Context, rpmRpmAlternateContentSourceHref string) AcsRpmAPIAcsRpmRpmRefreshRequest {
	return AcsRpmAPIAcsRpmRpmRefreshRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmAlternateContentSourceHref: rpmRpmAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return TaskGroupOperationResponse
func (a *AcsRpmAPIService) AcsRpmRpmRefreshExecute(r AcsRpmAPIAcsRpmRpmRefreshRequest) (*TaskGroupOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *TaskGroupOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsRpmAPIService.AcsRpmRpmRefresh")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_alternate_content_source_href}refresh/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_alternate_content_source_href"+"}", parameterValueToString(r.rpmRpmAlternateContentSourceHref, "rpmRpmAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsRpmAPIAcsRpmRpmRemoveRoleRequest struct {
	ctx context.Context
	ApiService *AcsRpmAPIService
	rpmRpmAlternateContentSourceHref string
	nestedRole *NestedRole
}

func (r AcsRpmAPIAcsRpmRpmRemoveRoleRequest) NestedRole(nestedRole NestedRole) AcsRpmAPIAcsRpmRpmRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r AcsRpmAPIAcsRpmRpmRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.AcsRpmRpmRemoveRoleExecute(r)
}

/*
AcsRpmRpmRemoveRole Method for AcsRpmRpmRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmAlternateContentSourceHref
 @return AcsRpmAPIAcsRpmRpmRemoveRoleRequest
*/
func (a *AcsRpmAPIService) AcsRpmRpmRemoveRole(ctx context.Context, rpmRpmAlternateContentSourceHref string) AcsRpmAPIAcsRpmRpmRemoveRoleRequest {
	return AcsRpmAPIAcsRpmRpmRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmAlternateContentSourceHref: rpmRpmAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *AcsRpmAPIService) AcsRpmRpmRemoveRoleExecute(r AcsRpmAPIAcsRpmRpmRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsRpmAPIService.AcsRpmRpmRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_alternate_content_source_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_alternate_content_source_href"+"}", parameterValueToString(r.rpmRpmAlternateContentSourceHref, "rpmRpmAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsRpmAPIAcsRpmRpmUpdateRequest struct {
	ctx context.Context
	ApiService *AcsRpmAPIService
	rpmRpmAlternateContentSourceHref string
	rpmRpmAlternateContentSource *RpmRpmAlternateContentSource
}

func (r AcsRpmAPIAcsRpmRpmUpdateRequest) RpmRpmAlternateContentSource(rpmRpmAlternateContentSource RpmRpmAlternateContentSource) AcsRpmAPIAcsRpmRpmUpdateRequest {
	r.rpmRpmAlternateContentSource = &rpmRpmAlternateContentSource
	return r
}

func (r AcsRpmAPIAcsRpmRpmUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.AcsRpmRpmUpdateExecute(r)
}

/*
AcsRpmRpmUpdate Update a rpm alternate content source

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmAlternateContentSourceHref
 @return AcsRpmAPIAcsRpmRpmUpdateRequest
*/
func (a *AcsRpmAPIService) AcsRpmRpmUpdate(ctx context.Context, rpmRpmAlternateContentSourceHref string) AcsRpmAPIAcsRpmRpmUpdateRequest {
	return AcsRpmAPIAcsRpmRpmUpdateRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmAlternateContentSourceHref: rpmRpmAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *AcsRpmAPIService) AcsRpmRpmUpdateExecute(r AcsRpmAPIAcsRpmRpmUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsRpmAPIService.AcsRpmRpmUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_alternate_content_source_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_alternate_content_source_href"+"}", parameterValueToString(r.rpmRpmAlternateContentSourceHref, "rpmRpmAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rpmRpmAlternateContentSource == nil {
		return localVarReturnValue, nil, reportError("rpmRpmAlternateContentSource is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rpmRpmAlternateContentSource
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
