/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"os"
)


// PypiLegacyAPIService PypiLegacyAPI service
type PypiLegacyAPIService service

type PypiLegacyAPIPypiLegacyCreateRequest struct {
	ctx context.Context
	ApiService *PypiLegacyAPIService
	path string
	content *os.File
	sha256Digest *string
	action *string
}

// A Python package release file to upload to the index.
func (r PypiLegacyAPIPypiLegacyCreateRequest) Content(content *os.File) PypiLegacyAPIPypiLegacyCreateRequest {
	r.content = content
	return r
}

// SHA256 of package to validate upload integrity.
func (r PypiLegacyAPIPypiLegacyCreateRequest) Sha256Digest(sha256Digest string) PypiLegacyAPIPypiLegacyCreateRequest {
	r.sha256Digest = &sha256Digest
	return r
}

// Defaults to &#x60;file_upload&#x60;, don&#39;t change it or request will fail!
func (r PypiLegacyAPIPypiLegacyCreateRequest) Action(action string) PypiLegacyAPIPypiLegacyCreateRequest {
	r.action = &action
	return r
}

func (r PypiLegacyAPIPypiLegacyCreateRequest) Execute() (*PackageUploadTaskResponse, *http.Response, error) {
	return r.ApiService.PypiLegacyCreateExecute(r)
}

/*
PypiLegacyCreate Upload a package

Upload package to the index.

This is the endpoint that tools like Twine and Poetry use for their upload commands.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param path
 @return PypiLegacyAPIPypiLegacyCreateRequest
*/
func (a *PypiLegacyAPIService) PypiLegacyCreate(ctx context.Context, path string) PypiLegacyAPIPypiLegacyCreateRequest {
	return PypiLegacyAPIPypiLegacyCreateRequest{
		ApiService: a,
		ctx: ctx,
		path: path,
	}
}

// Execute executes the request
//  @return PackageUploadTaskResponse
func (a *PypiLegacyAPIService) PypiLegacyCreateExecute(r PypiLegacyAPIPypiLegacyCreateRequest) (*PackageUploadTaskResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PackageUploadTaskResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PypiLegacyAPIService.PypiLegacyCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pypi/{path}/legacy/"
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", parameterValueToString(r.path, "path"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.content == nil {
		return localVarReturnValue, nil, reportError("content is required and must be specified")
	}
	if r.sha256Digest == nil {
		return localVarReturnValue, nil, reportError("sha256Digest is required and must be specified")
	}
	if strlen(*r.sha256Digest) < 64 {
		return localVarReturnValue, nil, reportError("sha256Digest must have at least 64 elements")
	}
	if strlen(*r.sha256Digest) > 64 {
		return localVarReturnValue, nil, reportError("sha256Digest must have less than 64 elements")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	var contentLocalVarFormFileName string
	var contentLocalVarFileName     string
	var contentLocalVarFileBytes    []byte

	contentLocalVarFormFileName = "content"


	contentLocalVarFile := r.content

	if contentLocalVarFile != nil {
		fbs, _ := io.ReadAll(contentLocalVarFile)

		contentLocalVarFileBytes = fbs
		contentLocalVarFileName = contentLocalVarFile.Name()
		contentLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: contentLocalVarFileBytes, fileName: contentLocalVarFileName, formFileName: contentLocalVarFormFileName})
	}
	if r.action != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "action", r.action, "")
	}
	parameterAddToHeaderOrQuery(localVarFormParams, "sha256_digest", r.sha256Digest, "")
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
