/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"os"
	"reflect"
)


// ContentPackagesAPIService ContentPackagesAPI service
type ContentPackagesAPIService service

type ContentPackagesAPIContentDebPackagesCreateRequest struct {
	ctx context.Context
	ApiService *ContentPackagesAPIService
	repository *string
	artifact *string
	relativePath *string
	file *os.File
	upload *string
	distribution *string
	component *string
}

// A URI of a repository the new content unit should be associated with.
func (r ContentPackagesAPIContentDebPackagesCreateRequest) Repository(repository string) ContentPackagesAPIContentDebPackagesCreateRequest {
	r.repository = &repository
	return r
}

// Artifact file representing the physical content
func (r ContentPackagesAPIContentDebPackagesCreateRequest) Artifact(artifact string) ContentPackagesAPIContentDebPackagesCreateRequest {
	r.artifact = &artifact
	return r
}

// Path where the artifact is located relative to distributions base_path
func (r ContentPackagesAPIContentDebPackagesCreateRequest) RelativePath(relativePath string) ContentPackagesAPIContentDebPackagesCreateRequest {
	r.relativePath = &relativePath
	return r
}

// An uploaded file that may be turned into the artifact of the content unit.
func (r ContentPackagesAPIContentDebPackagesCreateRequest) File(file *os.File) ContentPackagesAPIContentDebPackagesCreateRequest {
	r.file = file
	return r
}

// An uncommitted upload that may be turned into the artifact of the content unit.
func (r ContentPackagesAPIContentDebPackagesCreateRequest) Upload(upload string) ContentPackagesAPIContentDebPackagesCreateRequest {
	r.upload = &upload
	return r
}

// Name of the distribution.
func (r ContentPackagesAPIContentDebPackagesCreateRequest) Distribution(distribution string) ContentPackagesAPIContentDebPackagesCreateRequest {
	r.distribution = &distribution
	return r
}

// Name of the component.
func (r ContentPackagesAPIContentDebPackagesCreateRequest) Component(component string) ContentPackagesAPIContentDebPackagesCreateRequest {
	r.component = &component
	return r
}

func (r ContentPackagesAPIContentDebPackagesCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.ContentDebPackagesCreateExecute(r)
}

/*
ContentDebPackagesCreate Create a package

Trigger an asynchronous task to create content,optionally create new repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentPackagesAPIContentDebPackagesCreateRequest
*/
func (a *ContentPackagesAPIService) ContentDebPackagesCreate(ctx context.Context) ContentPackagesAPIContentDebPackagesCreateRequest {
	return ContentPackagesAPIContentDebPackagesCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *ContentPackagesAPIService) ContentDebPackagesCreateExecute(r ContentPackagesAPIContentDebPackagesCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackagesAPIService.ContentDebPackagesCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/packages/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.repository != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "repository", r.repository, "")
	}
	if r.artifact != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "artifact", r.artifact, "")
	}
	if r.relativePath != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "relative_path", r.relativePath, "")
	}
	var fileLocalVarFormFileName string
	var fileLocalVarFileName     string
	var fileLocalVarFileBytes    []byte

	fileLocalVarFormFileName = "file"


	fileLocalVarFile := r.file

	if fileLocalVarFile != nil {
		fbs, _ := io.ReadAll(fileLocalVarFile)

		fileLocalVarFileBytes = fbs
		fileLocalVarFileName = fileLocalVarFile.Name()
		fileLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: fileLocalVarFileBytes, fileName: fileLocalVarFileName, formFileName: fileLocalVarFormFileName})
	}
	if r.upload != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "upload", r.upload, "")
	}
	if r.distribution != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "distribution", r.distribution, "")
	}
	if r.component != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "component", r.component, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentPackagesAPIContentDebPackagesListRequest struct {
	ctx context.Context
	ApiService *ContentPackagesAPIService
	architecture *string
	autoBuiltPackage *string
	buildEssential *bool
	builtUsing *string
	essential *bool
	installedSize *int32
	limit *int32
	maintainer *string
	multiArch *string
	offset *int32
	ordering *[]string
	origin *string
	originalMaintainer *string
	package_ *string
	priority *string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	relativePath *string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	section *string
	sha256 *string
	source *string
	tag *string
	version *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where architecture matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) Architecture(architecture string) ContentPackagesAPIContentDebPackagesListRequest {
	r.architecture = &architecture
	return r
}

// Filter results where auto_built_package matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) AutoBuiltPackage(autoBuiltPackage string) ContentPackagesAPIContentDebPackagesListRequest {
	r.autoBuiltPackage = &autoBuiltPackage
	return r
}

// Filter results where build_essential matches value  * &#x60;True&#x60; - yes * &#x60;False&#x60; - no
func (r ContentPackagesAPIContentDebPackagesListRequest) BuildEssential(buildEssential bool) ContentPackagesAPIContentDebPackagesListRequest {
	r.buildEssential = &buildEssential
	return r
}

// Filter results where built_using matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) BuiltUsing(builtUsing string) ContentPackagesAPIContentDebPackagesListRequest {
	r.builtUsing = &builtUsing
	return r
}

// Filter results where essential matches value  * &#x60;True&#x60; - yes * &#x60;False&#x60; - no
func (r ContentPackagesAPIContentDebPackagesListRequest) Essential(essential bool) ContentPackagesAPIContentDebPackagesListRequest {
	r.essential = &essential
	return r
}

// Filter results where installed_size matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) InstalledSize(installedSize int32) ContentPackagesAPIContentDebPackagesListRequest {
	r.installedSize = &installedSize
	return r
}

// Number of results to return per page.
func (r ContentPackagesAPIContentDebPackagesListRequest) Limit(limit int32) ContentPackagesAPIContentDebPackagesListRequest {
	r.limit = &limit
	return r
}

// Filter results where maintainer matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) Maintainer(maintainer string) ContentPackagesAPIContentDebPackagesListRequest {
	r.maintainer = &maintainer
	return r
}

// Filter results where multi_arch matches value  * &#x60;no&#x60; - no * &#x60;same&#x60; - same * &#x60;foreign&#x60; - foreign * &#x60;allowed&#x60; - allowed
func (r ContentPackagesAPIContentDebPackagesListRequest) MultiArch(multiArch string) ContentPackagesAPIContentDebPackagesListRequest {
	r.multiArch = &multiArch
	return r
}

// The initial index from which to return the results.
func (r ContentPackagesAPIContentDebPackagesListRequest) Offset(offset int32) ContentPackagesAPIContentDebPackagesListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;package&#x60; - Package * &#x60;-package&#x60; - Package (descending) * &#x60;source&#x60; - Source * &#x60;-source&#x60; - Source (descending) * &#x60;version&#x60; - Version * &#x60;-version&#x60; - Version (descending) * &#x60;architecture&#x60; - Architecture * &#x60;-architecture&#x60; - Architecture (descending) * &#x60;section&#x60; - Section * &#x60;-section&#x60; - Section (descending) * &#x60;priority&#x60; - Priority * &#x60;-priority&#x60; - Priority (descending) * &#x60;origin&#x60; - Origin * &#x60;-origin&#x60; - Origin (descending) * &#x60;tag&#x60; - Tag * &#x60;-tag&#x60; - Tag (descending) * &#x60;bugs&#x60; - Bugs * &#x60;-bugs&#x60; - Bugs (descending) * &#x60;essential&#x60; - Essential * &#x60;-essential&#x60; - Essential (descending) * &#x60;build_essential&#x60; - Build essential * &#x60;-build_essential&#x60; - Build essential (descending) * &#x60;installed_size&#x60; - Installed size * &#x60;-installed_size&#x60; - Installed size (descending) * &#x60;maintainer&#x60; - Maintainer * &#x60;-maintainer&#x60; - Maintainer (descending) * &#x60;original_maintainer&#x60; - Original maintainer * &#x60;-original_maintainer&#x60; - Original maintainer (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;description_md5&#x60; - Description md5 * &#x60;-description_md5&#x60; - Description md5 (descending) * &#x60;homepage&#x60; - Homepage * &#x60;-homepage&#x60; - Homepage (descending) * &#x60;built_using&#x60; - Built using * &#x60;-built_using&#x60; - Built using (descending) * &#x60;auto_built_package&#x60; - Auto built package * &#x60;-auto_built_package&#x60; - Auto built package (descending) * &#x60;multi_arch&#x60; - Multi arch * &#x60;-multi_arch&#x60; - Multi arch (descending) * &#x60;breaks&#x60; - Breaks * &#x60;-breaks&#x60; - Breaks (descending) * &#x60;conflicts&#x60; - Conflicts * &#x60;-conflicts&#x60; - Conflicts (descending) * &#x60;depends&#x60; - Depends * &#x60;-depends&#x60; - Depends (descending) * &#x60;recommends&#x60; - Recommends * &#x60;-recommends&#x60; - Recommends (descending) * &#x60;suggests&#x60; - Suggests * &#x60;-suggests&#x60; - Suggests (descending) * &#x60;enhances&#x60; - Enhances * &#x60;-enhances&#x60; - Enhances (descending) * &#x60;pre_depends&#x60; - Pre depends * &#x60;-pre_depends&#x60; - Pre depends (descending) * &#x60;provides&#x60; - Provides * &#x60;-provides&#x60; - Provides (descending) * &#x60;replaces&#x60; - Replaces * &#x60;-replaces&#x60; - Replaces (descending) * &#x60;relative_path&#x60; - Relative path * &#x60;-relative_path&#x60; - Relative path (descending) * &#x60;sha256&#x60; - Sha256 * &#x60;-sha256&#x60; - Sha256 (descending) * &#x60;custom_fields&#x60; - Custom fields * &#x60;-custom_fields&#x60; - Custom fields (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentPackagesAPIContentDebPackagesListRequest) Ordering(ordering []string) ContentPackagesAPIContentDebPackagesListRequest {
	r.ordering = &ordering
	return r
}

// Filter results where origin matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) Origin(origin string) ContentPackagesAPIContentDebPackagesListRequest {
	r.origin = &origin
	return r
}

// Filter results where original_maintainer matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) OriginalMaintainer(originalMaintainer string) ContentPackagesAPIContentDebPackagesListRequest {
	r.originalMaintainer = &originalMaintainer
	return r
}

// Filter results where package matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) Package_(package_ string) ContentPackagesAPIContentDebPackagesListRequest {
	r.package_ = &package_
	return r
}

// Filter results where priority matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) Priority(priority string) ContentPackagesAPIContentDebPackagesListRequest {
	r.priority = &priority
	return r
}

// Multiple values may be separated by commas.
func (r ContentPackagesAPIContentDebPackagesListRequest) PulpHrefIn(pulpHrefIn []string) ContentPackagesAPIContentDebPackagesListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentPackagesAPIContentDebPackagesListRequest) PulpIdIn(pulpIdIn []string) ContentPackagesAPIContentDebPackagesListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter results where relative_path matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) RelativePath(relativePath string) ContentPackagesAPIContentDebPackagesListRequest {
	r.relativePath = &relativePath
	return r
}

// Repository Version referenced by HREF
func (r ContentPackagesAPIContentDebPackagesListRequest) RepositoryVersion(repositoryVersion string) ContentPackagesAPIContentDebPackagesListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentPackagesAPIContentDebPackagesListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentPackagesAPIContentDebPackagesListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentPackagesAPIContentDebPackagesListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentPackagesAPIContentDebPackagesListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// Filter results where section matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) Section(section string) ContentPackagesAPIContentDebPackagesListRequest {
	r.section = &section
	return r
}

// Filter results where sha256 matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) Sha256(sha256 string) ContentPackagesAPIContentDebPackagesListRequest {
	r.sha256 = &sha256
	return r
}

// Filter results where source matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) Source(source string) ContentPackagesAPIContentDebPackagesListRequest {
	r.source = &source
	return r
}

// Filter results where tag matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) Tag(tag string) ContentPackagesAPIContentDebPackagesListRequest {
	r.tag = &tag
	return r
}

// Filter results where version matches value
func (r ContentPackagesAPIContentDebPackagesListRequest) Version(version string) ContentPackagesAPIContentDebPackagesListRequest {
	r.version = &version
	return r
}

// A list of fields to include in the response.
func (r ContentPackagesAPIContentDebPackagesListRequest) Fields(fields []string) ContentPackagesAPIContentDebPackagesListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentPackagesAPIContentDebPackagesListRequest) ExcludeFields(excludeFields []string) ContentPackagesAPIContentDebPackagesListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentPackagesAPIContentDebPackagesListRequest) Execute() (*PaginateddebPackageResponseList, *http.Response, error) {
	return r.ApiService.ContentDebPackagesListExecute(r)
}

/*
ContentDebPackagesList List packages

A Package represents a '.deb' binary package.

Associated artifacts: Exactly one '.deb' package file.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentPackagesAPIContentDebPackagesListRequest
*/
func (a *ContentPackagesAPIService) ContentDebPackagesList(ctx context.Context) ContentPackagesAPIContentDebPackagesListRequest {
	return ContentPackagesAPIContentDebPackagesListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginateddebPackageResponseList
func (a *ContentPackagesAPIService) ContentDebPackagesListExecute(r ContentPackagesAPIContentDebPackagesListRequest) (*PaginateddebPackageResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginateddebPackageResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackagesAPIService.ContentDebPackagesList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/packages/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.architecture != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "architecture", r.architecture, "")
	}
	if r.autoBuiltPackage != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "auto_built_package", r.autoBuiltPackage, "")
	}
	if r.buildEssential != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "build_essential", r.buildEssential, "")
	}
	if r.builtUsing != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "built_using", r.builtUsing, "")
	}
	if r.essential != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "essential", r.essential, "")
	}
	if r.installedSize != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "installed_size", r.installedSize, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.maintainer != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "maintainer", r.maintainer, "")
	}
	if r.multiArch != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "multi_arch", r.multiArch, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.origin != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "origin", r.origin, "")
	}
	if r.originalMaintainer != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "original_maintainer", r.originalMaintainer, "")
	}
	if r.package_ != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "package", r.package_, "")
	}
	if r.priority != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "priority", r.priority, "")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.relativePath != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "relative_path", r.relativePath, "")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.section != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "section", r.section, "")
	}
	if r.sha256 != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "sha256", r.sha256, "")
	}
	if r.source != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "source", r.source, "")
	}
	if r.tag != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "tag", r.tag, "")
	}
	if r.version != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version", r.version, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentPackagesAPIContentDebPackagesReadRequest struct {
	ctx context.Context
	ApiService *ContentPackagesAPIService
	debPackageHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentPackagesAPIContentDebPackagesReadRequest) Fields(fields []string) ContentPackagesAPIContentDebPackagesReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentPackagesAPIContentDebPackagesReadRequest) ExcludeFields(excludeFields []string) ContentPackagesAPIContentDebPackagesReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentPackagesAPIContentDebPackagesReadRequest) Execute() (*DebPackageResponse, *http.Response, error) {
	return r.ApiService.ContentDebPackagesReadExecute(r)
}

/*
ContentDebPackagesRead Inspect a package

A Package represents a '.deb' binary package.

Associated artifacts: Exactly one '.deb' package file.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debPackageHref
 @return ContentPackagesAPIContentDebPackagesReadRequest
*/
func (a *ContentPackagesAPIService) ContentDebPackagesRead(ctx context.Context, debPackageHref string) ContentPackagesAPIContentDebPackagesReadRequest {
	return ContentPackagesAPIContentDebPackagesReadRequest{
		ApiService: a,
		ctx: ctx,
		debPackageHref: debPackageHref,
	}
}

// Execute executes the request
//  @return DebPackageResponse
func (a *ContentPackagesAPIService) ContentDebPackagesReadExecute(r ContentPackagesAPIContentDebPackagesReadRequest) (*DebPackageResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebPackageResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackagesAPIService.ContentDebPackagesRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_package_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_package_href"+"}", parameterValueToString(r.debPackageHref, "debPackageHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentPackagesAPIContentPythonPackagesCreateRequest struct {
	ctx context.Context
	ApiService *ContentPackagesAPIService
	relativePath *string
	repository *string
	artifact *string
	file *os.File
	upload *string
	sha256 *string
	summary *string
	description *string
	descriptionContentType *string
	keywords *string
	homePage *string
	downloadUrl *string
	author *string
	authorEmail *string
	maintainer *string
	maintainerEmail *string
	license *string
	requiresPython *string
	projectUrl *string
	projectUrls *map[string]interface{}
	platform *string
	supportedPlatform *string
	requiresDist *map[string]interface{}
	providesDist *map[string]interface{}
	obsoletesDist *map[string]interface{}
	requiresExternal *map[string]interface{}
	classifiers *map[string]interface{}
}

// Path where the artifact is located relative to distributions base_path
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) RelativePath(relativePath string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.relativePath = &relativePath
	return r
}

// A URI of a repository the new content unit should be associated with.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Repository(repository string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.repository = &repository
	return r
}

// Artifact file representing the physical content
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Artifact(artifact string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.artifact = &artifact
	return r
}

// An uploaded file that may be turned into the artifact of the content unit.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) File(file *os.File) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.file = file
	return r
}

// An uncommitted upload that may be turned into the artifact of the content unit.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Upload(upload string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.upload = &upload
	return r
}

// The SHA256 digest of this package.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Sha256(sha256 string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.sha256 = &sha256
	return r
}

// A one-line summary of what the package does.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Summary(summary string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.summary = &summary
	return r
}

// A longer description of the package that can run to several paragraphs.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Description(description string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.description = &description
	return r
}

// A string stating the markup syntax (if any) used in the distribution’s description, so that tools can intelligently render the description.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) DescriptionContentType(descriptionContentType string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.descriptionContentType = &descriptionContentType
	return r
}

// Additional keywords to be used to assist searching for the package in a larger catalog.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Keywords(keywords string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.keywords = &keywords
	return r
}

// The URL for the package&#39;s home page.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) HomePage(homePage string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.homePage = &homePage
	return r
}

// Legacy field denoting the URL from which this package can be downloaded.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) DownloadUrl(downloadUrl string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.downloadUrl = &downloadUrl
	return r
}

// Text containing the author&#39;s name. Contact information can also be added, separated with newlines.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Author(author string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.author = &author
	return r
}

// The author&#39;s e-mail address. 
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) AuthorEmail(authorEmail string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.authorEmail = &authorEmail
	return r
}

// The maintainer&#39;s name at a minimum; additional contact information may be provided.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Maintainer(maintainer string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.maintainer = &maintainer
	return r
}

// The maintainer&#39;s e-mail address.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) MaintainerEmail(maintainerEmail string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.maintainerEmail = &maintainerEmail
	return r
}

// Text indicating the license covering the distribution
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) License(license string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.license = &license
	return r
}

// The Python version(s) that the distribution is guaranteed to be compatible with.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) RequiresPython(requiresPython string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.requiresPython = &requiresPython
	return r
}

// A browsable URL for the project and a label for it, separated by a comma.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) ProjectUrl(projectUrl string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.projectUrl = &projectUrl
	return r
}

// A dictionary of labels and URLs for the project.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) ProjectUrls(projectUrls map[string]interface{}) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.projectUrls = &projectUrls
	return r
}

// A comma-separated list of platform specifications, summarizing the operating systems supported by the package.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Platform(platform string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.platform = &platform
	return r
}

// Field to specify the OS and CPU for which the binary package was compiled. 
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) SupportedPlatform(supportedPlatform string) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.supportedPlatform = &supportedPlatform
	return r
}

// A JSON list containing names of some other distutils project required by this distribution.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) RequiresDist(requiresDist map[string]interface{}) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.requiresDist = &requiresDist
	return r
}

// A JSON list containing names of a Distutils project which is contained within this distribution.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) ProvidesDist(providesDist map[string]interface{}) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.providesDist = &providesDist
	return r
}

// A JSON list containing names of a distutils project&#39;s distribution which this distribution renders obsolete, meaning that the two projects should not be installed at the same time.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) ObsoletesDist(obsoletesDist map[string]interface{}) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.obsoletesDist = &obsoletesDist
	return r
}

// A JSON list containing some dependency in the system that the distribution is to be used.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) RequiresExternal(requiresExternal map[string]interface{}) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.requiresExternal = &requiresExternal
	return r
}

// A JSON list containing classification values for a Python package.
func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Classifiers(classifiers map[string]interface{}) ContentPackagesAPIContentPythonPackagesCreateRequest {
	r.classifiers = &classifiers
	return r
}

func (r ContentPackagesAPIContentPythonPackagesCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.ContentPythonPackagesCreateExecute(r)
}

/*
ContentPythonPackagesCreate Create a python package content

Trigger an asynchronous task to create content,optionally create new repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentPackagesAPIContentPythonPackagesCreateRequest
*/
func (a *ContentPackagesAPIService) ContentPythonPackagesCreate(ctx context.Context) ContentPackagesAPIContentPythonPackagesCreateRequest {
	return ContentPackagesAPIContentPythonPackagesCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *ContentPackagesAPIService) ContentPythonPackagesCreateExecute(r ContentPackagesAPIContentPythonPackagesCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackagesAPIService.ContentPythonPackagesCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/python/packages/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.relativePath == nil {
		return localVarReturnValue, nil, reportError("relativePath is required and must be specified")
	}
	if strlen(*r.relativePath) < 1 {
		return localVarReturnValue, nil, reportError("relativePath must have at least 1 elements")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.repository != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "repository", r.repository, "")
	}
	if r.artifact != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "artifact", r.artifact, "")
	}
	parameterAddToHeaderOrQuery(localVarFormParams, "relative_path", r.relativePath, "")
	var fileLocalVarFormFileName string
	var fileLocalVarFileName     string
	var fileLocalVarFileBytes    []byte

	fileLocalVarFormFileName = "file"


	fileLocalVarFile := r.file

	if fileLocalVarFile != nil {
		fbs, _ := io.ReadAll(fileLocalVarFile)

		fileLocalVarFileBytes = fbs
		fileLocalVarFileName = fileLocalVarFile.Name()
		fileLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: fileLocalVarFileBytes, fileName: fileLocalVarFileName, formFileName: fileLocalVarFormFileName})
	}
	if r.upload != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "upload", r.upload, "")
	}
	if r.sha256 != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "sha256", r.sha256, "")
	}
	if r.summary != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "summary", r.summary, "")
	}
	if r.description != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "description", r.description, "")
	}
	if r.descriptionContentType != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "description_content_type", r.descriptionContentType, "")
	}
	if r.keywords != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "keywords", r.keywords, "")
	}
	if r.homePage != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "home_page", r.homePage, "")
	}
	if r.downloadUrl != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "download_url", r.downloadUrl, "")
	}
	if r.author != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "author", r.author, "")
	}
	if r.authorEmail != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "author_email", r.authorEmail, "")
	}
	if r.maintainer != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "maintainer", r.maintainer, "")
	}
	if r.maintainerEmail != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "maintainer_email", r.maintainerEmail, "")
	}
	if r.license != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "license", r.license, "")
	}
	if r.requiresPython != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "requires_python", r.requiresPython, "")
	}
	if r.projectUrl != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "project_url", r.projectUrl, "")
	}
	if r.projectUrls != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "project_urls", r.projectUrls, "")
	}
	if r.platform != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "platform", r.platform, "")
	}
	if r.supportedPlatform != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "supported_platform", r.supportedPlatform, "")
	}
	if r.requiresDist != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "requires_dist", r.requiresDist, "")
	}
	if r.providesDist != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "provides_dist", r.providesDist, "")
	}
	if r.obsoletesDist != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "obsoletes_dist", r.obsoletesDist, "")
	}
	if r.requiresExternal != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "requires_external", r.requiresExternal, "")
	}
	if r.classifiers != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "classifiers", r.classifiers, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentPackagesAPIContentPythonPackagesListRequest struct {
	ctx context.Context
	ApiService *ContentPackagesAPIService
	author *string
	authorIn *[]string
	filename *string
	filenameContains *string
	filenameIn *[]string
	keywordsContains *string
	keywordsIn *[]string
	limit *int32
	name *string
	nameIn *[]string
	offset *int32
	ordering *[]string
	packagetype *string
	packagetypeIn *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	requiresPython *string
	requiresPythonContains *string
	requiresPythonIn *[]string
	sha256 *string
	sha256In *[]string
	version *string
	versionGt *string
	versionGte *string
	versionLt *string
	versionLte *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where author matches value
func (r ContentPackagesAPIContentPythonPackagesListRequest) Author(author string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.author = &author
	return r
}

// Filter results where author is in a comma-separated list of values
func (r ContentPackagesAPIContentPythonPackagesListRequest) AuthorIn(authorIn []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.authorIn = &authorIn
	return r
}

// Filter results where filename matches value
func (r ContentPackagesAPIContentPythonPackagesListRequest) Filename(filename string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.filename = &filename
	return r
}

// Filter results where filename contains value
func (r ContentPackagesAPIContentPythonPackagesListRequest) FilenameContains(filenameContains string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.filenameContains = &filenameContains
	return r
}

// Filter results where filename is in a comma-separated list of values
func (r ContentPackagesAPIContentPythonPackagesListRequest) FilenameIn(filenameIn []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.filenameIn = &filenameIn
	return r
}

// Filter results where keywords contains value
func (r ContentPackagesAPIContentPythonPackagesListRequest) KeywordsContains(keywordsContains string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.keywordsContains = &keywordsContains
	return r
}

// Filter results where keywords is in a comma-separated list of values
func (r ContentPackagesAPIContentPythonPackagesListRequest) KeywordsIn(keywordsIn []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.keywordsIn = &keywordsIn
	return r
}

// Number of results to return per page.
func (r ContentPackagesAPIContentPythonPackagesListRequest) Limit(limit int32) ContentPackagesAPIContentPythonPackagesListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r ContentPackagesAPIContentPythonPackagesListRequest) Name(name string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.name = &name
	return r
}

// Filter results where name is in a comma-separated list of values
func (r ContentPackagesAPIContentPythonPackagesListRequest) NameIn(nameIn []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.nameIn = &nameIn
	return r
}

// The initial index from which to return the results.
func (r ContentPackagesAPIContentPythonPackagesListRequest) Offset(offset int32) ContentPackagesAPIContentPythonPackagesListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;filename&#x60; - Filename * &#x60;-filename&#x60; - Filename (descending) * &#x60;packagetype&#x60; - Packagetype * &#x60;-packagetype&#x60; - Packagetype (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;version&#x60; - Version * &#x60;-version&#x60; - Version (descending) * &#x60;sha256&#x60; - Sha256 * &#x60;-sha256&#x60; - Sha256 (descending) * &#x60;python_version&#x60; - Python version * &#x60;-python_version&#x60; - Python version (descending) * &#x60;metadata_version&#x60; - Metadata version * &#x60;-metadata_version&#x60; - Metadata version (descending) * &#x60;summary&#x60; - Summary * &#x60;-summary&#x60; - Summary (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;keywords&#x60; - Keywords * &#x60;-keywords&#x60; - Keywords (descending) * &#x60;home_page&#x60; - Home page * &#x60;-home_page&#x60; - Home page (descending) * &#x60;download_url&#x60; - Download url * &#x60;-download_url&#x60; - Download url (descending) * &#x60;author&#x60; - Author * &#x60;-author&#x60; - Author (descending) * &#x60;author_email&#x60; - Author email * &#x60;-author_email&#x60; - Author email (descending) * &#x60;maintainer&#x60; - Maintainer * &#x60;-maintainer&#x60; - Maintainer (descending) * &#x60;maintainer_email&#x60; - Maintainer email * &#x60;-maintainer_email&#x60; - Maintainer email (descending) * &#x60;license&#x60; - License * &#x60;-license&#x60; - License (descending) * &#x60;requires_python&#x60; - Requires python * &#x60;-requires_python&#x60; - Requires python (descending) * &#x60;project_url&#x60; - Project url * &#x60;-project_url&#x60; - Project url (descending) * &#x60;platform&#x60; - Platform * &#x60;-platform&#x60; - Platform (descending) * &#x60;supported_platform&#x60; - Supported platform * &#x60;-supported_platform&#x60; - Supported platform (descending) * &#x60;requires_dist&#x60; - Requires dist * &#x60;-requires_dist&#x60; - Requires dist (descending) * &#x60;provides_dist&#x60; - Provides dist * &#x60;-provides_dist&#x60; - Provides dist (descending) * &#x60;obsoletes_dist&#x60; - Obsoletes dist * &#x60;-obsoletes_dist&#x60; - Obsoletes dist (descending) * &#x60;requires_external&#x60; - Requires external * &#x60;-requires_external&#x60; - Requires external (descending) * &#x60;classifiers&#x60; - Classifiers * &#x60;-classifiers&#x60; - Classifiers (descending) * &#x60;project_urls&#x60; - Project urls * &#x60;-project_urls&#x60; - Project urls (descending) * &#x60;description_content_type&#x60; - Description content type * &#x60;-description_content_type&#x60; - Description content type (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentPackagesAPIContentPythonPackagesListRequest) Ordering(ordering []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.ordering = &ordering
	return r
}

// Filter results where packagetype matches value  * &#x60;bdist_dmg&#x60; - bdist_dmg * &#x60;bdist_dumb&#x60; - bdist_dumb * &#x60;bdist_egg&#x60; - bdist_egg * &#x60;bdist_msi&#x60; - bdist_msi * &#x60;bdist_rpm&#x60; - bdist_rpm * &#x60;bdist_wheel&#x60; - bdist_wheel * &#x60;bdist_wininst&#x60; - bdist_wininst * &#x60;sdist&#x60; - sdist
func (r ContentPackagesAPIContentPythonPackagesListRequest) Packagetype(packagetype string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.packagetype = &packagetype
	return r
}

// Filter results where packagetype is in a comma-separated list of values
func (r ContentPackagesAPIContentPythonPackagesListRequest) PackagetypeIn(packagetypeIn []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.packagetypeIn = &packagetypeIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentPackagesAPIContentPythonPackagesListRequest) PulpHrefIn(pulpHrefIn []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentPackagesAPIContentPythonPackagesListRequest) PulpIdIn(pulpIdIn []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository Version referenced by HREF
func (r ContentPackagesAPIContentPythonPackagesListRequest) RepositoryVersion(repositoryVersion string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentPackagesAPIContentPythonPackagesListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentPackagesAPIContentPythonPackagesListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// Filter results where requires_python matches value
func (r ContentPackagesAPIContentPythonPackagesListRequest) RequiresPython(requiresPython string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.requiresPython = &requiresPython
	return r
}

// Filter results where requires_python contains value
func (r ContentPackagesAPIContentPythonPackagesListRequest) RequiresPythonContains(requiresPythonContains string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.requiresPythonContains = &requiresPythonContains
	return r
}

// Filter results where requires_python is in a comma-separated list of values
func (r ContentPackagesAPIContentPythonPackagesListRequest) RequiresPythonIn(requiresPythonIn []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.requiresPythonIn = &requiresPythonIn
	return r
}

// Filter results where sha256 matches value
func (r ContentPackagesAPIContentPythonPackagesListRequest) Sha256(sha256 string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.sha256 = &sha256
	return r
}

// Filter results where sha256 is in a comma-separated list of values
func (r ContentPackagesAPIContentPythonPackagesListRequest) Sha256In(sha256In []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.sha256In = &sha256In
	return r
}

// Filter results where version matches value
func (r ContentPackagesAPIContentPythonPackagesListRequest) Version(version string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.version = &version
	return r
}

// Filter results where version is greater than value
func (r ContentPackagesAPIContentPythonPackagesListRequest) VersionGt(versionGt string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.versionGt = &versionGt
	return r
}

// Filter results where version is greater than or equal to value
func (r ContentPackagesAPIContentPythonPackagesListRequest) VersionGte(versionGte string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.versionGte = &versionGte
	return r
}

// Filter results where version is less than value
func (r ContentPackagesAPIContentPythonPackagesListRequest) VersionLt(versionLt string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.versionLt = &versionLt
	return r
}

// Filter results where version is less than or equal to value
func (r ContentPackagesAPIContentPythonPackagesListRequest) VersionLte(versionLte string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.versionLte = &versionLte
	return r
}

// A list of fields to include in the response.
func (r ContentPackagesAPIContentPythonPackagesListRequest) Fields(fields []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentPackagesAPIContentPythonPackagesListRequest) ExcludeFields(excludeFields []string) ContentPackagesAPIContentPythonPackagesListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentPackagesAPIContentPythonPackagesListRequest) Execute() (*PaginatedpythonPythonPackageContentResponseList, *http.Response, error) {
	return r.ApiService.ContentPythonPackagesListExecute(r)
}

/*
ContentPythonPackagesList List python package contents


PythonPackageContent represents each individually installable Python package. In the Python
ecosystem, this is called a Python Distribution, sometimes (ambiguously) refered to as a
package. In Pulp Python, we refer to it as PythonPackageContent. Each
PythonPackageContent corresponds to a single filename, for example
`pulpcore-3.0.0rc1-py3-none-any.whl` or `pulpcore-3.0.0rc1.tar.gz`.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentPackagesAPIContentPythonPackagesListRequest
*/
func (a *ContentPackagesAPIService) ContentPythonPackagesList(ctx context.Context) ContentPackagesAPIContentPythonPackagesListRequest {
	return ContentPackagesAPIContentPythonPackagesListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedpythonPythonPackageContentResponseList
func (a *ContentPackagesAPIService) ContentPythonPackagesListExecute(r ContentPackagesAPIContentPythonPackagesListRequest) (*PaginatedpythonPythonPackageContentResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedpythonPythonPackageContentResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackagesAPIService.ContentPythonPackagesList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/python/packages/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.author != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "author", r.author, "")
	}
	if r.authorIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "author__in", r.authorIn, "csv")
	}
	if r.filename != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "filename", r.filename, "")
	}
	if r.filenameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "filename__contains", r.filenameContains, "")
	}
	if r.filenameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "filename__in", r.filenameIn, "csv")
	}
	if r.keywordsContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "keywords__contains", r.keywordsContains, "")
	}
	if r.keywordsIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "keywords__in", r.keywordsIn, "csv")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.packagetype != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "packagetype", r.packagetype, "")
	}
	if r.packagetypeIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "packagetype__in", r.packagetypeIn, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.requiresPython != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "requires_python", r.requiresPython, "")
	}
	if r.requiresPythonContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "requires_python__contains", r.requiresPythonContains, "")
	}
	if r.requiresPythonIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "requires_python__in", r.requiresPythonIn, "csv")
	}
	if r.sha256 != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "sha256", r.sha256, "")
	}
	if r.sha256In != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "sha256__in", r.sha256In, "csv")
	}
	if r.version != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version", r.version, "")
	}
	if r.versionGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version__gt", r.versionGt, "")
	}
	if r.versionGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version__gte", r.versionGte, "")
	}
	if r.versionLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version__lt", r.versionLt, "")
	}
	if r.versionLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version__lte", r.versionLte, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentPackagesAPIContentPythonPackagesReadRequest struct {
	ctx context.Context
	ApiService *ContentPackagesAPIService
	pythonPythonPackageContentHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentPackagesAPIContentPythonPackagesReadRequest) Fields(fields []string) ContentPackagesAPIContentPythonPackagesReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentPackagesAPIContentPythonPackagesReadRequest) ExcludeFields(excludeFields []string) ContentPackagesAPIContentPythonPackagesReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentPackagesAPIContentPythonPackagesReadRequest) Execute() (*PythonPythonPackageContentResponse, *http.Response, error) {
	return r.ApiService.ContentPythonPackagesReadExecute(r)
}

/*
ContentPythonPackagesRead Inspect a python package content


PythonPackageContent represents each individually installable Python package. In the Python
ecosystem, this is called a Python Distribution, sometimes (ambiguously) refered to as a
package. In Pulp Python, we refer to it as PythonPackageContent. Each
PythonPackageContent corresponds to a single filename, for example
`pulpcore-3.0.0rc1-py3-none-any.whl` or `pulpcore-3.0.0rc1.tar.gz`.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonPackageContentHref
 @return ContentPackagesAPIContentPythonPackagesReadRequest
*/
func (a *ContentPackagesAPIService) ContentPythonPackagesRead(ctx context.Context, pythonPythonPackageContentHref string) ContentPackagesAPIContentPythonPackagesReadRequest {
	return ContentPackagesAPIContentPythonPackagesReadRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonPackageContentHref: pythonPythonPackageContentHref,
	}
}

// Execute executes the request
//  @return PythonPythonPackageContentResponse
func (a *ContentPackagesAPIService) ContentPythonPackagesReadExecute(r ContentPackagesAPIContentPythonPackagesReadRequest) (*PythonPythonPackageContentResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PythonPythonPackageContentResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackagesAPIService.ContentPythonPackagesRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_package_content_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_package_content_href"+"}", parameterValueToString(r.pythonPythonPackageContentHref, "pythonPythonPackageContentHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentPackagesAPIContentRpmPackagesCreateRequest struct {
	ctx context.Context
	ApiService *ContentPackagesAPIService
	repository *string
	artifact *string
	relativePath *string
	file *os.File
	upload *string
}

// A URI of a repository the new content unit should be associated with.
func (r ContentPackagesAPIContentRpmPackagesCreateRequest) Repository(repository string) ContentPackagesAPIContentRpmPackagesCreateRequest {
	r.repository = &repository
	return r
}

// Artifact file representing the physical content
func (r ContentPackagesAPIContentRpmPackagesCreateRequest) Artifact(artifact string) ContentPackagesAPIContentRpmPackagesCreateRequest {
	r.artifact = &artifact
	return r
}

// Path where the artifact is located relative to distributions base_path
func (r ContentPackagesAPIContentRpmPackagesCreateRequest) RelativePath(relativePath string) ContentPackagesAPIContentRpmPackagesCreateRequest {
	r.relativePath = &relativePath
	return r
}

// An uploaded file that may be turned into the artifact of the content unit.
func (r ContentPackagesAPIContentRpmPackagesCreateRequest) File(file *os.File) ContentPackagesAPIContentRpmPackagesCreateRequest {
	r.file = file
	return r
}

// An uncommitted upload that may be turned into the artifact of the content unit.
func (r ContentPackagesAPIContentRpmPackagesCreateRequest) Upload(upload string) ContentPackagesAPIContentRpmPackagesCreateRequest {
	r.upload = &upload
	return r
}

func (r ContentPackagesAPIContentRpmPackagesCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.ContentRpmPackagesCreateExecute(r)
}

/*
ContentRpmPackagesCreate Create a package

Trigger an asynchronous task to create content,optionally create new repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentPackagesAPIContentRpmPackagesCreateRequest
*/
func (a *ContentPackagesAPIService) ContentRpmPackagesCreate(ctx context.Context) ContentPackagesAPIContentRpmPackagesCreateRequest {
	return ContentPackagesAPIContentRpmPackagesCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *ContentPackagesAPIService) ContentRpmPackagesCreateExecute(r ContentPackagesAPIContentRpmPackagesCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackagesAPIService.ContentRpmPackagesCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/rpm/packages/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.repository != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "repository", r.repository, "")
	}
	if r.artifact != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "artifact", r.artifact, "")
	}
	if r.relativePath != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "relative_path", r.relativePath, "")
	}
	var fileLocalVarFormFileName string
	var fileLocalVarFileName     string
	var fileLocalVarFileBytes    []byte

	fileLocalVarFormFileName = "file"


	fileLocalVarFile := r.file

	if fileLocalVarFile != nil {
		fbs, _ := io.ReadAll(fileLocalVarFile)

		fileLocalVarFileBytes = fbs
		fileLocalVarFileName = fileLocalVarFile.Name()
		fileLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: fileLocalVarFileBytes, fileName: fileLocalVarFileName, formFileName: fileLocalVarFormFileName})
	}
	if r.upload != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "upload", r.upload, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentPackagesAPIContentRpmPackagesListRequest struct {
	ctx context.Context
	ApiService *ContentPackagesAPIService
	arch *string
	archContains *string
	archIn *[]string
	archNe *string
	archStartswith *string
	checksumType *string
	checksumTypeIn *[]string
	checksumTypeNe *string
	epoch *string
	epochIn *[]string
	epochNe *string
	limit *int32
	name *string
	nameContains *string
	nameIn *[]string
	nameNe *string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pkgId *string
	pkgIdIn *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	release *string
	releaseContains *string
	releaseIn *[]string
	releaseNe *string
	releaseStartswith *string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	sha256 *string
	version *string
	versionIn *[]string
	versionNe *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where arch matches value
func (r ContentPackagesAPIContentRpmPackagesListRequest) Arch(arch string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.arch = &arch
	return r
}

// Filter results where arch contains value
func (r ContentPackagesAPIContentRpmPackagesListRequest) ArchContains(archContains string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.archContains = &archContains
	return r
}

// Filter results where arch is in a comma-separated list of values
func (r ContentPackagesAPIContentRpmPackagesListRequest) ArchIn(archIn []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.archIn = &archIn
	return r
}

// Filter results where arch not equal to value
func (r ContentPackagesAPIContentRpmPackagesListRequest) ArchNe(archNe string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.archNe = &archNe
	return r
}

// Filter results where arch starts with value
func (r ContentPackagesAPIContentRpmPackagesListRequest) ArchStartswith(archStartswith string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.archStartswith = &archStartswith
	return r
}

// Filter results where checksum_type matches value  * &#x60;unknown&#x60; - unknown * &#x60;md5&#x60; - md5 * &#x60;sha1&#x60; - sha1 * &#x60;sha1&#x60; - sha1 * &#x60;sha224&#x60; - sha224 * &#x60;sha256&#x60; - sha256 * &#x60;sha384&#x60; - sha384 * &#x60;sha512&#x60; - sha512
func (r ContentPackagesAPIContentRpmPackagesListRequest) ChecksumType(checksumType string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.checksumType = &checksumType
	return r
}

// Filter results where checksum_type is in a comma-separated list of values
func (r ContentPackagesAPIContentRpmPackagesListRequest) ChecksumTypeIn(checksumTypeIn []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.checksumTypeIn = &checksumTypeIn
	return r
}

// Filter results where checksum_type not equal to value
func (r ContentPackagesAPIContentRpmPackagesListRequest) ChecksumTypeNe(checksumTypeNe string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.checksumTypeNe = &checksumTypeNe
	return r
}

// Filter results where epoch matches value
func (r ContentPackagesAPIContentRpmPackagesListRequest) Epoch(epoch string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.epoch = &epoch
	return r
}

// Filter results where epoch is in a comma-separated list of values
func (r ContentPackagesAPIContentRpmPackagesListRequest) EpochIn(epochIn []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.epochIn = &epochIn
	return r
}

// Filter results where epoch not equal to value
func (r ContentPackagesAPIContentRpmPackagesListRequest) EpochNe(epochNe string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.epochNe = &epochNe
	return r
}

// Number of results to return per page.
func (r ContentPackagesAPIContentRpmPackagesListRequest) Limit(limit int32) ContentPackagesAPIContentRpmPackagesListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r ContentPackagesAPIContentRpmPackagesListRequest) Name(name string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r ContentPackagesAPIContentRpmPackagesListRequest) NameContains(nameContains string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r ContentPackagesAPIContentRpmPackagesListRequest) NameIn(nameIn []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name not equal to value
func (r ContentPackagesAPIContentRpmPackagesListRequest) NameNe(nameNe string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.nameNe = &nameNe
	return r
}

// Filter results where name starts with value
func (r ContentPackagesAPIContentRpmPackagesListRequest) NameStartswith(nameStartswith string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r ContentPackagesAPIContentRpmPackagesListRequest) Offset(offset int32) ContentPackagesAPIContentRpmPackagesListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;epoch&#x60; - Epoch * &#x60;-epoch&#x60; - Epoch (descending) * &#x60;version&#x60; - Version * &#x60;-version&#x60; - Version (descending) * &#x60;release&#x60; - Release * &#x60;-release&#x60; - Release (descending) * &#x60;arch&#x60; - Arch * &#x60;-arch&#x60; - Arch (descending) * &#x60;evr&#x60; - Evr * &#x60;-evr&#x60; - Evr (descending) * &#x60;pkgId&#x60; - Pkgid * &#x60;-pkgId&#x60; - Pkgid (descending) * &#x60;checksum_type&#x60; - Checksum type * &#x60;-checksum_type&#x60; - Checksum type (descending) * &#x60;summary&#x60; - Summary * &#x60;-summary&#x60; - Summary (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;url&#x60; - Url * &#x60;-url&#x60; - Url (descending) * &#x60;changelogs&#x60; - Changelogs * &#x60;-changelogs&#x60; - Changelogs (descending) * &#x60;files&#x60; - Files * &#x60;-files&#x60; - Files (descending) * &#x60;requires&#x60; - Requires * &#x60;-requires&#x60; - Requires (descending) * &#x60;provides&#x60; - Provides * &#x60;-provides&#x60; - Provides (descending) * &#x60;conflicts&#x60; - Conflicts * &#x60;-conflicts&#x60; - Conflicts (descending) * &#x60;obsoletes&#x60; - Obsoletes * &#x60;-obsoletes&#x60; - Obsoletes (descending) * &#x60;suggests&#x60; - Suggests * &#x60;-suggests&#x60; - Suggests (descending) * &#x60;enhances&#x60; - Enhances * &#x60;-enhances&#x60; - Enhances (descending) * &#x60;recommends&#x60; - Recommends * &#x60;-recommends&#x60; - Recommends (descending) * &#x60;supplements&#x60; - Supplements * &#x60;-supplements&#x60; - Supplements (descending) * &#x60;location_base&#x60; - Location base * &#x60;-location_base&#x60; - Location base (descending) * &#x60;location_href&#x60; - Location href * &#x60;-location_href&#x60; - Location href (descending) * &#x60;rpm_buildhost&#x60; - Rpm buildhost * &#x60;-rpm_buildhost&#x60; - Rpm buildhost (descending) * &#x60;rpm_group&#x60; - Rpm group * &#x60;-rpm_group&#x60; - Rpm group (descending) * &#x60;rpm_license&#x60; - Rpm license * &#x60;-rpm_license&#x60; - Rpm license (descending) * &#x60;rpm_packager&#x60; - Rpm packager * &#x60;-rpm_packager&#x60; - Rpm packager (descending) * &#x60;rpm_sourcerpm&#x60; - Rpm sourcerpm * &#x60;-rpm_sourcerpm&#x60; - Rpm sourcerpm (descending) * &#x60;rpm_vendor&#x60; - Rpm vendor * &#x60;-rpm_vendor&#x60; - Rpm vendor (descending) * &#x60;rpm_header_start&#x60; - Rpm header start * &#x60;-rpm_header_start&#x60; - Rpm header start (descending) * &#x60;rpm_header_end&#x60; - Rpm header end * &#x60;-rpm_header_end&#x60; - Rpm header end (descending) * &#x60;size_archive&#x60; - Size archive * &#x60;-size_archive&#x60; - Size archive (descending) * &#x60;size_installed&#x60; - Size installed * &#x60;-size_installed&#x60; - Size installed (descending) * &#x60;size_package&#x60; - Size package * &#x60;-size_package&#x60; - Size package (descending) * &#x60;time_build&#x60; - Time build * &#x60;-time_build&#x60; - Time build (descending) * &#x60;time_file&#x60; - Time file * &#x60;-time_file&#x60; - Time file (descending) * &#x60;is_modular&#x60; - Is modular * &#x60;-is_modular&#x60; - Is modular (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentPackagesAPIContentRpmPackagesListRequest) Ordering(ordering []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.ordering = &ordering
	return r
}

// Filter results where pkgId matches value
func (r ContentPackagesAPIContentRpmPackagesListRequest) PkgId(pkgId string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.pkgId = &pkgId
	return r
}

// Filter results where pkgId is in a comma-separated list of values
func (r ContentPackagesAPIContentRpmPackagesListRequest) PkgIdIn(pkgIdIn []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.pkgIdIn = &pkgIdIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentPackagesAPIContentRpmPackagesListRequest) PulpHrefIn(pulpHrefIn []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentPackagesAPIContentRpmPackagesListRequest) PulpIdIn(pulpIdIn []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter results where release matches value
func (r ContentPackagesAPIContentRpmPackagesListRequest) Release(release string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.release = &release
	return r
}

// Filter results where release contains value
func (r ContentPackagesAPIContentRpmPackagesListRequest) ReleaseContains(releaseContains string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.releaseContains = &releaseContains
	return r
}

// Filter results where release is in a comma-separated list of values
func (r ContentPackagesAPIContentRpmPackagesListRequest) ReleaseIn(releaseIn []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.releaseIn = &releaseIn
	return r
}

// Filter results where release not equal to value
func (r ContentPackagesAPIContentRpmPackagesListRequest) ReleaseNe(releaseNe string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.releaseNe = &releaseNe
	return r
}

// Filter results where release starts with value
func (r ContentPackagesAPIContentRpmPackagesListRequest) ReleaseStartswith(releaseStartswith string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.releaseStartswith = &releaseStartswith
	return r
}

// Repository Version referenced by HREF
func (r ContentPackagesAPIContentRpmPackagesListRequest) RepositoryVersion(repositoryVersion string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentPackagesAPIContentRpmPackagesListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentPackagesAPIContentRpmPackagesListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

func (r ContentPackagesAPIContentRpmPackagesListRequest) Sha256(sha256 string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.sha256 = &sha256
	return r
}

// Filter results where version matches value
func (r ContentPackagesAPIContentRpmPackagesListRequest) Version(version string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.version = &version
	return r
}

// Filter results where version is in a comma-separated list of values
func (r ContentPackagesAPIContentRpmPackagesListRequest) VersionIn(versionIn []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.versionIn = &versionIn
	return r
}

// Filter results where version not equal to value
func (r ContentPackagesAPIContentRpmPackagesListRequest) VersionNe(versionNe string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.versionNe = &versionNe
	return r
}

// A list of fields to include in the response.
func (r ContentPackagesAPIContentRpmPackagesListRequest) Fields(fields []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentPackagesAPIContentRpmPackagesListRequest) ExcludeFields(excludeFields []string) ContentPackagesAPIContentRpmPackagesListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentPackagesAPIContentRpmPackagesListRequest) Execute() (*PaginatedrpmPackageResponseList, *http.Response, error) {
	return r.ApiService.ContentRpmPackagesListExecute(r)
}

/*
ContentRpmPackagesList List packages

A ViewSet for Package.

Define endpoint name which will appear in the API endpoint for this content type.
For example::
    http://pulp.example.com/pulp/api/v3/content/rpm/packages/

Also specify queryset and serializer for Package.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentPackagesAPIContentRpmPackagesListRequest
*/
func (a *ContentPackagesAPIService) ContentRpmPackagesList(ctx context.Context) ContentPackagesAPIContentRpmPackagesListRequest {
	return ContentPackagesAPIContentRpmPackagesListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedrpmPackageResponseList
func (a *ContentPackagesAPIService) ContentRpmPackagesListExecute(r ContentPackagesAPIContentRpmPackagesListRequest) (*PaginatedrpmPackageResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedrpmPackageResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackagesAPIService.ContentRpmPackagesList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/rpm/packages/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.arch != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "arch", r.arch, "")
	}
	if r.archContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "arch__contains", r.archContains, "")
	}
	if r.archIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "arch__in", r.archIn, "csv")
	}
	if r.archNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "arch__ne", r.archNe, "")
	}
	if r.archStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "arch__startswith", r.archStartswith, "")
	}
	if r.checksumType != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "checksum_type", r.checksumType, "")
	}
	if r.checksumTypeIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "checksum_type__in", r.checksumTypeIn, "csv")
	}
	if r.checksumTypeNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "checksum_type__ne", r.checksumTypeNe, "")
	}
	if r.epoch != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "epoch", r.epoch, "")
	}
	if r.epochIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "epoch__in", r.epochIn, "csv")
	}
	if r.epochNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "epoch__ne", r.epochNe, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__ne", r.nameNe, "")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pkgId != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pkgId", r.pkgId, "")
	}
	if r.pkgIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pkgId__in", r.pkgIdIn, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.release != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "release", r.release, "")
	}
	if r.releaseContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "release__contains", r.releaseContains, "")
	}
	if r.releaseIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "release__in", r.releaseIn, "csv")
	}
	if r.releaseNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "release__ne", r.releaseNe, "")
	}
	if r.releaseStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "release__startswith", r.releaseStartswith, "")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.sha256 != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "sha256", r.sha256, "")
	}
	if r.version != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version", r.version, "")
	}
	if r.versionIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version__in", r.versionIn, "csv")
	}
	if r.versionNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version__ne", r.versionNe, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentPackagesAPIContentRpmPackagesReadRequest struct {
	ctx context.Context
	ApiService *ContentPackagesAPIService
	rpmPackageHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentPackagesAPIContentRpmPackagesReadRequest) Fields(fields []string) ContentPackagesAPIContentRpmPackagesReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentPackagesAPIContentRpmPackagesReadRequest) ExcludeFields(excludeFields []string) ContentPackagesAPIContentRpmPackagesReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentPackagesAPIContentRpmPackagesReadRequest) Execute() (*RpmPackageResponse, *http.Response, error) {
	return r.ApiService.ContentRpmPackagesReadExecute(r)
}

/*
ContentRpmPackagesRead Inspect a package

A ViewSet for Package.

Define endpoint name which will appear in the API endpoint for this content type.
For example::
    http://pulp.example.com/pulp/api/v3/content/rpm/packages/

Also specify queryset and serializer for Package.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmPackageHref
 @return ContentPackagesAPIContentRpmPackagesReadRequest
*/
func (a *ContentPackagesAPIService) ContentRpmPackagesRead(ctx context.Context, rpmPackageHref string) ContentPackagesAPIContentRpmPackagesReadRequest {
	return ContentPackagesAPIContentRpmPackagesReadRequest{
		ApiService: a,
		ctx: ctx,
		rpmPackageHref: rpmPackageHref,
	}
}

// Execute executes the request
//  @return RpmPackageResponse
func (a *ContentPackagesAPIService) ContentRpmPackagesReadExecute(r ContentPackagesAPIContentRpmPackagesReadRequest) (*RpmPackageResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RpmPackageResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentPackagesAPIService.ContentRpmPackagesRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_package_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_package_href"+"}", parameterValueToString(r.rpmPackageHref, "rpmPackageHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
