import { TransportItemType } from '../../transports';
export function initializeMeasurementsAPI(transports, metas, tracesApi) {
    const pushMeasurement = (payload) => {
        try {
            const item = {
                type: TransportItemType.MEASUREMENT,
                payload: Object.assign(Object.assign({}, payload), { trace: tracesApi.getTraceContext() }),
                meta: metas.value,
            };
            transports.execute(item);
        }
        catch (err) {
            // TODO: Add proper logging when debug is enabled
        }
    };
    return {
        pushMeasurement,
    };
}
//# sourceMappingURL=initialize.js.map