import { isFunction } from '../utils';
import { VERSION } from '../version';
export function initializeMetas(config) {
    var _a;
    let items = [];
    const add = (item) => {
        items.push(item);
    };
    const remove = (item) => {
        items = items.filter((i) => i !== item);
    };
    const initial = {
        sdk: {
            name: '@grafana/agent-core',
            version: VERSION,
            integrations: config.instrumentations.map(({ name, version }) => ({ name, version })),
        },
    };
    if (config.app) {
        initial.app = config.app;
    }
    if (config.user) {
        initial.user = config.user;
    }
    if (config.session) {
        initial.session = config.session;
    }
    (_a = config.metas) === null || _a === void 0 ? void 0 : _a.forEach(add);
    add(initial);
    return {
        add,
        remove,
        get value() {
            const meta = {};
            items.forEach((item) => Object.assign(meta, isFunction(item) ? item() : item));
            return meta;
        },
    };
}
//# sourceMappingURL=initialize.js.map