// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See format_utils_generator.py for modifications


/***************************************************************************
 *
 * Copyright (c) 2015-2022 The Khronos Group Inc.
 * Copyright (c) 2015-2022 Valve Corporation
 * Copyright (c) 2015-2022 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Mark Lobodzinski <mark@lunarg.com>
 * Author: Dave Houlton <daveh@lunarg.com>
 * Author: Spencer Fricke <s.fricke@samsung.com>
 *
 ****************************************************************************/

#include "vk_format_utils.h"
#include "vk_layer_utils.h"
#include <map>
#include <vector>


enum class COMPONENT_TYPE {
    NONE,
    R,
    G,
    B,
    A,
    D,
    S
};

// Compressed formats don't have a defined component size
const uint32_t COMPRESSED_COMPONENT = 0xFFFFFFFF;

struct COMPONENT_INFO {
    COMPONENT_TYPE type;
    uint32_t size; // bits

    COMPONENT_INFO() : type(COMPONENT_TYPE::NONE), size(0) {};
    COMPONENT_INFO(COMPONENT_TYPE type, uint32_t size) : type(type), size(size) {};
};

// Generic information for all formats
struct FORMAT_INFO {
    FORMAT_COMPATIBILITY_CLASS compatibility;
    uint32_t block_size; // bytes
    uint32_t texel_per_block;
    VkExtent3D block_extent;
    uint32_t component_count;
    COMPONENT_INFO components[FORMAT_MAX_COMPONENTS];
};

namespace std {
template <>
struct hash<VkFormat> {
    size_t operator()(VkFormat fmt) const noexcept {
        return hash<uint32_t>()(static_cast<uint32_t>(fmt));
    }
};
}

// clang-format off
static const layer_data::unordered_map<VkFormat, FORMAT_INFO> kVkFormatTable = {
    {VK_FORMAT_A1R5G5B5_UNORM_PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 1}, {COMPONENT_TYPE::R, 5}, {COMPONENT_TYPE::G, 5}, {COMPONENT_TYPE::B, 5}} }},
    {VK_FORMAT_A2B10G10R10_SINT_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_A2B10G10R10_SNORM_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_A2B10G10R10_SSCALED_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_A2B10G10R10_UINT_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_A2B10G10R10_UNORM_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_A2B10G10R10_USCALED_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_A2R10G10B10_SINT_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::R, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}} }},
    {VK_FORMAT_A2R10G10B10_SNORM_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::R, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}} }},
    {VK_FORMAT_A2R10G10B10_SSCALED_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::R, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}} }},
    {VK_FORMAT_A2R10G10B10_UINT_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::R, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}} }},
    {VK_FORMAT_A2R10G10B10_UNORM_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::R, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}} }},
    {VK_FORMAT_A2R10G10B10_USCALED_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 2}, {COMPONENT_TYPE::R, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}} }},
    {VK_FORMAT_A4B4G4R4_UNORM_PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 4}, {COMPONENT_TYPE::B, 4}, {COMPONENT_TYPE::G, 4}, {COMPONENT_TYPE::R, 4}} }},
    {VK_FORMAT_A4R4G4B4_UNORM_PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 4}, {COMPONENT_TYPE::R, 4}, {COMPONENT_TYPE::G, 4}, {COMPONENT_TYPE::B, 4}} }},
    {VK_FORMAT_A8B8G8R8_SINT_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_A8B8G8R8_SNORM_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_A8B8G8R8_SRGB_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_A8B8G8R8_SSCALED_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_A8B8G8R8_UINT_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_A8B8G8R8_UNORM_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_A8B8G8R8_USCALED_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::A, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X10, 16, 100, {10, 10, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_10x10_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X10, 16, 100, {10, 10, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_10x10_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X10, 16, 100, {10, 10, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X5, 16, 50, {10, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_10x5_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X5, 16, 50, {10, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_10x5_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X5, 16, 50, {10, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X6, 16, 60, {10, 6, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_10x6_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X6, 16, 60, {10, 6, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_10x6_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X6, 16, 60, {10, 6, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X8, 16, 80, {10, 8, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_10x8_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X8, 16, 80, {10, 8, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_10x8_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_10X8, 16, 80, {10, 8, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_12X10, 16, 120, {12, 10, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_12x10_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_12X10, 16, 120, {12, 10, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_12x10_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_12X10, 16, 120, {12, 10, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_12X12, 16, 144, {12, 12, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_12x12_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_12X12, 16, 144, {12, 12, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_12x12_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_12X12, 16, 144, {12, 12, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_4X4, 16, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_4x4_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_4X4, 16, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_4x4_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_4X4, 16, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_5X4, 16, 20, {5, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_5x4_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_5X4, 16, 20, {5, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_5x4_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_5X4, 16, 20, {5, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_5X5, 16, 25, {5, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_5x5_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_5X5, 16, 25, {5, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_5x5_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_5X5, 16, 25, {5, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_6X5, 16, 30, {6, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_6x5_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_6X5, 16, 30, {6, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_6x5_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_6X5, 16, 30, {6, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_6X6, 16, 36, {6, 6, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_6x6_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_6X6, 16, 36, {6, 6, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_6x6_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_6X6, 16, 36, {6, 6, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_8X5, 16, 40, {8, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_8x5_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_8X5, 16, 40, {8, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_8x5_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_8X5, 16, 40, {8, 5, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_8X6, 16, 48, {8, 6, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_8x6_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_8X6, 16, 48, {8, 6, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_8x6_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_8X6, 16, 48, {8, 6, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_8X8, 16, 64, {8, 8, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_8x8_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_8X8, 16, 64, {8, 8, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ASTC_8x8_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ASTC_8X8, 16, 64, {8, 8, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_B10G11R11_UFLOAT_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::G, 11}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT_B10G10R10G10, 8, 1, {2, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::R, 10}, {COMPONENT_TYPE::G, 10}} }},
    {VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT_B12G12R12G12, 8, 1, {2, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 12}, {COMPONENT_TYPE::G, 12}, {COMPONENT_TYPE::R, 12}, {COMPONENT_TYPE::G, 12}} }},
    {VK_FORMAT_B16G16R16G16_422_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT_B16G16R16G16, 8, 1, {2, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}} }},
    {VK_FORMAT_B4G4R4A4_UNORM_PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 4}, {COMPONENT_TYPE::G, 4}, {COMPONENT_TYPE::R, 4}, {COMPONENT_TYPE::A, 4}} }},
    {VK_FORMAT_B5G5R5A1_UNORM_PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 5}, {COMPONENT_TYPE::R, 5}, {COMPONENT_TYPE::G, 5}, {COMPONENT_TYPE::A, 1}} }},
    {VK_FORMAT_B5G6R5_UNORM_PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::B, 5}, {COMPONENT_TYPE::G, 6}, {COMPONENT_TYPE::R, 5}} }},
    {VK_FORMAT_B8G8R8A8_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_B8G8R8A8_SNORM,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_B8G8R8A8_SRGB,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_B8G8R8A8_SSCALED,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_B8G8R8A8_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_B8G8R8A8_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_B8G8R8A8_USCALED,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_B8G8R8G8_422_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT_B8G8R8G8, 4, 1, {2, 1, 1}, 4,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}} }},
    {VK_FORMAT_B8G8R8_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_B8G8R8_SNORM,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_B8G8R8_SRGB,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_B8G8R8_SSCALED,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_B8G8R8_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_B8G8R8_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_B8G8R8_USCALED,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_BC1_RGBA_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC1_RGBA, 8, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC1_RGBA_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC1_RGBA, 8, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC1_RGB_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC1_RGB, 8, 16, {4, 4, 1}, 3,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC1_RGB_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC1_RGB, 8, 16, {4, 4, 1}, 3,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC2_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC2, 16, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC2_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC2, 16, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC3_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC3, 16, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC3_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC3, 16, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC4_SNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC4, 8, 16, {4, 4, 1}, 1,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC4_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC4, 8, 16, {4, 4, 1}, 1,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC5_SNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC5, 16, 16, {4, 4, 1}, 2,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC5_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC5, 16, 16, {4, 4, 1}, 2,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC6H_SFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC6H, 16, 16, {4, 4, 1}, 3,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC6H_UFLOAT_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC6H, 16, 16, {4, 4, 1}, 3,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC7_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC7, 16, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_BC7_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::BC7, 16, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_D16_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::D16, 2, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::D, 16}} }},
    {VK_FORMAT_D16_UNORM_S8_UINT,
        {FORMAT_COMPATIBILITY_CLASS::D16S8, 3, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::D, 16}, {COMPONENT_TYPE::S, 8}} }},
    {VK_FORMAT_D24_UNORM_S8_UINT,
        {FORMAT_COMPATIBILITY_CLASS::D24S8, 4, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::D, 24}, {COMPONENT_TYPE::S, 8}} }},
    {VK_FORMAT_D32_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::D32, 4, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::D, 32}} }},
    {VK_FORMAT_D32_SFLOAT_S8_UINT,
        {FORMAT_COMPATIBILITY_CLASS::D32S8, 5, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::D, 32}, {COMPONENT_TYPE::S, 8}} }},
    {VK_FORMAT_E5B9G9R9_UFLOAT_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::B, 9}, {COMPONENT_TYPE::G, 9}, {COMPONENT_TYPE::R, 9}} }},
    {VK_FORMAT_EAC_R11G11_SNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::EAC_RG, 16, 16, {4, 4, 1}, 2,
        {{COMPONENT_TYPE::R, 11}, {COMPONENT_TYPE::G, 11}} }},
    {VK_FORMAT_EAC_R11G11_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::EAC_RG, 16, 16, {4, 4, 1}, 2,
        {{COMPONENT_TYPE::R, 11}, {COMPONENT_TYPE::G, 11}} }},
    {VK_FORMAT_EAC_R11_SNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::EAC_R, 8, 16, {4, 4, 1}, 1,
        {{COMPONENT_TYPE::R, 11}} }},
    {VK_FORMAT_EAC_R11_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::EAC_R, 8, 16, {4, 4, 1}, 1,
        {{COMPONENT_TYPE::R, 11}} }},
    {VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ETC2_RGBA, 8, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ETC2_RGBA, 8, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ETC2_EAC_RGBA, 16, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ETC2_EAC_RGBA, 16, 16, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ETC2_RGB, 8, 16, {4, 4, 1}, 3,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK,
        {FORMAT_COMPATIBILITY_CLASS::ETC2_RGB, 8, 16, {4, 4, 1}, 3,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT_G10B10G10R10, 8, 1, {2, 1, 1}, 4,
        {{COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_10BIT_2PLANE_420, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_10BIT_2PLANE_422, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_10BIT_2PLANE_444, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_10BIT_3PLANE_420, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_10BIT_3PLANE_422, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_10BIT_3PLANE_444, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT_G12B12G12R12, 8, 1, {2, 1, 1}, 4,
        {{COMPONENT_TYPE::G, 12}, {COMPONENT_TYPE::B, 12}, {COMPONENT_TYPE::G, 12}, {COMPONENT_TYPE::R, 12}} }},
    {VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_12BIT_2PLANE_420, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 12}, {COMPONENT_TYPE::B, 12}, {COMPONENT_TYPE::R, 12}} }},
    {VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_12BIT_2PLANE_422, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 12}, {COMPONENT_TYPE::B, 12}, {COMPONENT_TYPE::R, 12}} }},
    {VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_12BIT_2PLANE_444, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 12}, {COMPONENT_TYPE::B, 12}, {COMPONENT_TYPE::R, 12}} }},
    {VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_12BIT_3PLANE_420, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 12}, {COMPONENT_TYPE::B, 12}, {COMPONENT_TYPE::R, 12}} }},
    {VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_12BIT_3PLANE_422, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 12}, {COMPONENT_TYPE::B, 12}, {COMPONENT_TYPE::R, 12}} }},
    {VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_12BIT_3PLANE_444, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 12}, {COMPONENT_TYPE::B, 12}, {COMPONENT_TYPE::R, 12}} }},
    {VK_FORMAT_G16B16G16R16_422_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT_G16B16G16R16, 8, 1, {2, 1, 1}, 4,
        {{COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_G16_B16R16_2PLANE_420_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT_2PLANE_420, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_G16_B16R16_2PLANE_422_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT_2PLANE_422, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_G16_B16R16_2PLANE_444_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT_2PLANE_444, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT_3PLANE_420, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT_3PLANE_422, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT_3PLANE_444, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_G8B8G8R8_422_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT_G8B8G8R8, 4, 1, {2, 1, 1}, 4,
        {{COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_G8_B8R8_2PLANE_420_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT_2PLANE_420, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_G8_B8R8_2PLANE_422_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT_2PLANE_422, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_G8_B8R8_2PLANE_444_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT_2PLANE_444, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT_3PLANE_420, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT_3PLANE_422, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT_3PLANE_444, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG,
        {FORMAT_COMPATIBILITY_CLASS::PVRTC1_2BPP, 8, 1, {8, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG,
        {FORMAT_COMPATIBILITY_CLASS::PVRTC1_2BPP, 8, 1, {8, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG,
        {FORMAT_COMPATIBILITY_CLASS::PVRTC1_4BPP, 8, 1, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG,
        {FORMAT_COMPATIBILITY_CLASS::PVRTC1_4BPP, 8, 1, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG,
        {FORMAT_COMPATIBILITY_CLASS::PVRTC2_2BPP, 8, 1, {8, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG,
        {FORMAT_COMPATIBILITY_CLASS::PVRTC2_2BPP, 8, 1, {8, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG,
        {FORMAT_COMPATIBILITY_CLASS::PVRTC2_4BPP, 8, 1, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG,
        {FORMAT_COMPATIBILITY_CLASS::PVRTC2_4BPP, 8, 1, {4, 4, 1}, 4,
        {{COMPONENT_TYPE::R, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::G, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::B, COMPRESSED_COMPONENT}, {COMPONENT_TYPE::A, COMPRESSED_COMPONENT}} }},
    {VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT_R10G10B10A10, 8, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 10}, {COMPONENT_TYPE::G, 10}, {COMPONENT_TYPE::B, 10}, {COMPONENT_TYPE::A, 10}} }},
    {VK_FORMAT_R10X6G10X6_UNORM_2PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 10}, {COMPONENT_TYPE::G, 10}} }},
    {VK_FORMAT_R10X6_UNORM_PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 10}} }},
    {VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT_R12G12B12A12, 8, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 12}, {COMPONENT_TYPE::G, 12}, {COMPONENT_TYPE::B, 12}, {COMPONENT_TYPE::A, 12}} }},
    {VK_FORMAT_R12X4G12X4_UNORM_2PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 12}, {COMPONENT_TYPE::G, 12}} }},
    {VK_FORMAT_R12X4_UNORM_PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 12}} }},
    {VK_FORMAT_R16G16B16A16_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::A, 16}} }},
    {VK_FORMAT_R16G16B16A16_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::A, 16}} }},
    {VK_FORMAT_R16G16B16A16_SNORM,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::A, 16}} }},
    {VK_FORMAT_R16G16B16A16_SSCALED,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::A, 16}} }},
    {VK_FORMAT_R16G16B16A16_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::A, 16}} }},
    {VK_FORMAT_R16G16B16A16_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::A, 16}} }},
    {VK_FORMAT_R16G16B16A16_USCALED,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}, {COMPONENT_TYPE::A, 16}} }},
    {VK_FORMAT_R16G16B16_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_48BIT, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}} }},
    {VK_FORMAT_R16G16B16_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_48BIT, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}} }},
    {VK_FORMAT_R16G16B16_SNORM,
        {FORMAT_COMPATIBILITY_CLASS::_48BIT, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}} }},
    {VK_FORMAT_R16G16B16_SSCALED,
        {FORMAT_COMPATIBILITY_CLASS::_48BIT, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}} }},
    {VK_FORMAT_R16G16B16_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_48BIT, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}} }},
    {VK_FORMAT_R16G16B16_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_48BIT, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}} }},
    {VK_FORMAT_R16G16B16_USCALED,
        {FORMAT_COMPATIBILITY_CLASS::_48BIT, 6, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}, {COMPONENT_TYPE::B, 16}} }},
    {VK_FORMAT_R16G16_S10_5_NV,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}} }},
    {VK_FORMAT_R16G16_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}} }},
    {VK_FORMAT_R16G16_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}} }},
    {VK_FORMAT_R16G16_SNORM,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}} }},
    {VK_FORMAT_R16G16_SSCALED,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}} }},
    {VK_FORMAT_R16G16_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}} }},
    {VK_FORMAT_R16G16_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}} }},
    {VK_FORMAT_R16G16_USCALED,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 16}, {COMPONENT_TYPE::G, 16}} }},
    {VK_FORMAT_R16_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_R16_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_R16_SNORM,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_R16_SSCALED,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_R16_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_R16_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_R16_USCALED,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 16}} }},
    {VK_FORMAT_R32G32B32A32_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_128BIT, 16, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 32}, {COMPONENT_TYPE::G, 32}, {COMPONENT_TYPE::B, 32}, {COMPONENT_TYPE::A, 32}} }},
    {VK_FORMAT_R32G32B32A32_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_128BIT, 16, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 32}, {COMPONENT_TYPE::G, 32}, {COMPONENT_TYPE::B, 32}, {COMPONENT_TYPE::A, 32}} }},
    {VK_FORMAT_R32G32B32A32_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_128BIT, 16, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 32}, {COMPONENT_TYPE::G, 32}, {COMPONENT_TYPE::B, 32}, {COMPONENT_TYPE::A, 32}} }},
    {VK_FORMAT_R32G32B32_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_96BIT, 12, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 32}, {COMPONENT_TYPE::G, 32}, {COMPONENT_TYPE::B, 32}} }},
    {VK_FORMAT_R32G32B32_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_96BIT, 12, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 32}, {COMPONENT_TYPE::G, 32}, {COMPONENT_TYPE::B, 32}} }},
    {VK_FORMAT_R32G32B32_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_96BIT, 12, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 32}, {COMPONENT_TYPE::G, 32}, {COMPONENT_TYPE::B, 32}} }},
    {VK_FORMAT_R32G32_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 32}, {COMPONENT_TYPE::G, 32}} }},
    {VK_FORMAT_R32G32_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 32}, {COMPONENT_TYPE::G, 32}} }},
    {VK_FORMAT_R32G32_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 32}, {COMPONENT_TYPE::G, 32}} }},
    {VK_FORMAT_R32_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 32}} }},
    {VK_FORMAT_R32_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 32}} }},
    {VK_FORMAT_R32_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 32}} }},
    {VK_FORMAT_R4G4B4A4_UNORM_PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 4}, {COMPONENT_TYPE::G, 4}, {COMPONENT_TYPE::B, 4}, {COMPONENT_TYPE::A, 4}} }},
    {VK_FORMAT_R4G4_UNORM_PACK8,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT, 1, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 4}, {COMPONENT_TYPE::G, 4}} }},
    {VK_FORMAT_R5G5B5A1_UNORM_PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 5}, {COMPONENT_TYPE::G, 5}, {COMPONENT_TYPE::B, 5}, {COMPONENT_TYPE::A, 1}} }},
    {VK_FORMAT_R5G6B5_UNORM_PACK16,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 5}, {COMPONENT_TYPE::G, 6}, {COMPONENT_TYPE::B, 5}} }},
    {VK_FORMAT_R64G64B64A64_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_256BIT, 32, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 64}, {COMPONENT_TYPE::G, 64}, {COMPONENT_TYPE::B, 64}, {COMPONENT_TYPE::A, 64}} }},
    {VK_FORMAT_R64G64B64A64_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_256BIT, 32, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 64}, {COMPONENT_TYPE::G, 64}, {COMPONENT_TYPE::B, 64}, {COMPONENT_TYPE::A, 64}} }},
    {VK_FORMAT_R64G64B64A64_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_256BIT, 32, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 64}, {COMPONENT_TYPE::G, 64}, {COMPONENT_TYPE::B, 64}, {COMPONENT_TYPE::A, 64}} }},
    {VK_FORMAT_R64G64B64_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_192BIT, 24, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 64}, {COMPONENT_TYPE::G, 64}, {COMPONENT_TYPE::B, 64}} }},
    {VK_FORMAT_R64G64B64_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_192BIT, 24, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 64}, {COMPONENT_TYPE::G, 64}, {COMPONENT_TYPE::B, 64}} }},
    {VK_FORMAT_R64G64B64_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_192BIT, 24, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 64}, {COMPONENT_TYPE::G, 64}, {COMPONENT_TYPE::B, 64}} }},
    {VK_FORMAT_R64G64_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_128BIT, 16, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 64}, {COMPONENT_TYPE::B, 64}} }},
    {VK_FORMAT_R64G64_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_128BIT, 16, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 64}, {COMPONENT_TYPE::B, 64}} }},
    {VK_FORMAT_R64G64_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_128BIT, 16, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 64}, {COMPONENT_TYPE::B, 64}} }},
    {VK_FORMAT_R64_SFLOAT,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 64}} }},
    {VK_FORMAT_R64_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 64}} }},
    {VK_FORMAT_R64_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_64BIT, 8, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 64}} }},
    {VK_FORMAT_R8G8B8A8_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_R8G8B8A8_SNORM,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_R8G8B8A8_SRGB,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_R8G8B8A8_SSCALED,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_R8G8B8A8_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_R8G8B8A8_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_R8G8B8A8_USCALED,
        {FORMAT_COMPATIBILITY_CLASS::_32BIT, 4, 1, {1, 1, 1}, 4,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}, {COMPONENT_TYPE::A, 8}} }},
    {VK_FORMAT_R8G8B8_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}} }},
    {VK_FORMAT_R8G8B8_SNORM,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}} }},
    {VK_FORMAT_R8G8B8_SRGB,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}} }},
    {VK_FORMAT_R8G8B8_SSCALED,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}} }},
    {VK_FORMAT_R8G8B8_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}} }},
    {VK_FORMAT_R8G8B8_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}} }},
    {VK_FORMAT_R8G8B8_USCALED,
        {FORMAT_COMPATIBILITY_CLASS::_24BIT, 3, 1, {1, 1, 1}, 3,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}, {COMPONENT_TYPE::B, 8}} }},
    {VK_FORMAT_R8G8_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}} }},
    {VK_FORMAT_R8G8_SNORM,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}} }},
    {VK_FORMAT_R8G8_SRGB,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}} }},
    {VK_FORMAT_R8G8_SSCALED,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}} }},
    {VK_FORMAT_R8G8_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}} }},
    {VK_FORMAT_R8G8_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}} }},
    {VK_FORMAT_R8G8_USCALED,
        {FORMAT_COMPATIBILITY_CLASS::_16BIT, 2, 1, {1, 1, 1}, 2,
        {{COMPONENT_TYPE::R, 8}, {COMPONENT_TYPE::G, 8}} }},
    {VK_FORMAT_R8_SINT,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT, 1, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_R8_SNORM,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT, 1, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_R8_SRGB,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT, 1, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_R8_SSCALED,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT, 1, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_R8_UINT,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT, 1, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_R8_UNORM,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT, 1, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_R8_USCALED,
        {FORMAT_COMPATIBILITY_CLASS::_8BIT, 1, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::R, 8}} }},
    {VK_FORMAT_S8_UINT,
        {FORMAT_COMPATIBILITY_CLASS::S8, 1, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::S, 8}} }},
    {VK_FORMAT_X8_D24_UNORM_PACK32,
        {FORMAT_COMPATIBILITY_CLASS::D24, 4, 1, {1, 1, 1}, 1,
        {{COMPONENT_TYPE::D, 24}} }},
    {VK_FORMAT_UNDEFINED, {FORMAT_COMPATIBILITY_CLASS::NONE, 0, 0, {0, 0, 0}, 0, {}}}};
// clang-format on

struct PER_PLANE_COMPATIBILITY {
    uint32_t width_divisor;
    uint32_t height_divisor;
    VkFormat compatible_format;

    // Need default otherwise if app tries to grab a plane that doesn't exist it will crash
    // if returned the value of 0 in IMAGE_STATE::GetSubresourceExtent()
    // This is ok, because there are VUs later that will catch the bad app behaviour
    PER_PLANE_COMPATIBILITY() : width_divisor(1), height_divisor(1), compatible_format(VK_FORMAT_UNDEFINED) {}
    PER_PLANE_COMPATIBILITY(uint32_t width_divisor, uint32_t height_divisor, VkFormat compatible_format) :
        width_divisor(width_divisor), height_divisor(height_divisor), compatible_format(compatible_format) {}
};

// Information for multiplanar formats
struct MULTIPLANE_COMPATIBILITY {
    PER_PLANE_COMPATIBILITY per_plane[FORMAT_MAX_PLANES];
};

// Source: Vulkan spec Table 47. Plane Format Compatibility Table
// clang-format off
static const layer_data::unordered_map<VkFormat, MULTIPLANE_COMPATIBILITY> kVkMultiplaneCompatibilityMap {
    { VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R10X6_UNORM_PACK16 },
        { 2, 2, VK_FORMAT_R10X6G10X6_UNORM_2PACK16 }
    }}},
    { VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R10X6_UNORM_PACK16 },
        { 2, 1, VK_FORMAT_R10X6G10X6_UNORM_2PACK16 }
    }}},
    { VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R10X6_UNORM_PACK16 },
        { 1, 1, VK_FORMAT_R10X6G10X6_UNORM_2PACK16 }
    }}},
    { VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R10X6_UNORM_PACK16 },
        { 2, 2, VK_FORMAT_R10X6_UNORM_PACK16 },
        { 2, 2, VK_FORMAT_R10X6_UNORM_PACK16 }
    }}},
    { VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R10X6_UNORM_PACK16 },
        { 2, 1, VK_FORMAT_R10X6_UNORM_PACK16 },
        { 2, 1, VK_FORMAT_R10X6_UNORM_PACK16 }
    }}},
    { VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R10X6_UNORM_PACK16 },
        { 1, 1, VK_FORMAT_R10X6_UNORM_PACK16 },
        { 1, 1, VK_FORMAT_R10X6_UNORM_PACK16 }
    }}},
    { VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R12X4_UNORM_PACK16 },
        { 2, 2, VK_FORMAT_R12X4G12X4_UNORM_2PACK16 }
    }}},
    { VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R12X4_UNORM_PACK16 },
        { 2, 1, VK_FORMAT_R12X4G12X4_UNORM_2PACK16 }
    }}},
    { VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R12X4_UNORM_PACK16 },
        { 1, 1, VK_FORMAT_R12X4G12X4_UNORM_2PACK16 }
    }}},
    { VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R12X4_UNORM_PACK16 },
        { 2, 2, VK_FORMAT_R12X4_UNORM_PACK16 },
        { 2, 2, VK_FORMAT_R12X4_UNORM_PACK16 }
    }}},
    { VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R12X4_UNORM_PACK16 },
        { 2, 1, VK_FORMAT_R12X4_UNORM_PACK16 },
        { 2, 1, VK_FORMAT_R12X4_UNORM_PACK16 }
    }}},
    { VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16, {{
        { 1, 1, VK_FORMAT_R12X4_UNORM_PACK16 },
        { 1, 1, VK_FORMAT_R12X4_UNORM_PACK16 },
        { 1, 1, VK_FORMAT_R12X4_UNORM_PACK16 }
    }}},
    { VK_FORMAT_G16_B16R16_2PLANE_420_UNORM, {{
        { 1, 1, VK_FORMAT_R16_UNORM },
        { 2, 2, VK_FORMAT_R16G16_UNORM }
    }}},
    { VK_FORMAT_G16_B16R16_2PLANE_422_UNORM, {{
        { 1, 1, VK_FORMAT_R16_UNORM },
        { 2, 1, VK_FORMAT_R16G16_UNORM }
    }}},
    { VK_FORMAT_G16_B16R16_2PLANE_444_UNORM, {{
        { 1, 1, VK_FORMAT_R16_UNORM },
        { 1, 1, VK_FORMAT_R16G16_UNORM }
    }}},
    { VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM, {{
        { 1, 1, VK_FORMAT_R16_UNORM },
        { 2, 2, VK_FORMAT_R16_UNORM },
        { 2, 2, VK_FORMAT_R16_UNORM }
    }}},
    { VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM, {{
        { 1, 1, VK_FORMAT_R16_UNORM },
        { 2, 1, VK_FORMAT_R16_UNORM },
        { 2, 1, VK_FORMAT_R16_UNORM }
    }}},
    { VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM, {{
        { 1, 1, VK_FORMAT_R16_UNORM },
        { 1, 1, VK_FORMAT_R16_UNORM },
        { 1, 1, VK_FORMAT_R16_UNORM }
    }}},
    { VK_FORMAT_G8_B8R8_2PLANE_420_UNORM, {{
        { 1, 1, VK_FORMAT_R8_UNORM },
        { 2, 2, VK_FORMAT_R8G8_UNORM }
    }}},
    { VK_FORMAT_G8_B8R8_2PLANE_422_UNORM, {{
        { 1, 1, VK_FORMAT_R8_UNORM },
        { 2, 1, VK_FORMAT_R8G8_UNORM }
    }}},
    { VK_FORMAT_G8_B8R8_2PLANE_444_UNORM, {{
        { 1, 1, VK_FORMAT_R8_UNORM },
        { 1, 1, VK_FORMAT_R8G8_UNORM }
    }}},
    { VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM, {{
        { 1, 1, VK_FORMAT_R8_UNORM },
        { 2, 2, VK_FORMAT_R8_UNORM },
        { 2, 2, VK_FORMAT_R8_UNORM }
    }}},
    { VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM, {{
        { 1, 1, VK_FORMAT_R8_UNORM },
        { 2, 1, VK_FORMAT_R8_UNORM },
        { 2, 1, VK_FORMAT_R8_UNORM }
    }}},
    { VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM, {{
        { 1, 1, VK_FORMAT_R8_UNORM },
        { 1, 1, VK_FORMAT_R8_UNORM },
        { 1, 1, VK_FORMAT_R8_UNORM }
    }}},
};
// clang-format on


// Return true if all components in the format are an UNORM
bool FormatIsUNORM(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_R4G4_UNORM_PACK8:
        case VK_FORMAT_R4G4B4A4_UNORM_PACK16:
        case VK_FORMAT_B4G4R4A4_UNORM_PACK16:
        case VK_FORMAT_R5G6B5_UNORM_PACK16:
        case VK_FORMAT_B5G6R5_UNORM_PACK16:
        case VK_FORMAT_R5G5B5A1_UNORM_PACK16:
        case VK_FORMAT_B5G5R5A1_UNORM_PACK16:
        case VK_FORMAT_A1R5G5B5_UNORM_PACK16:
        case VK_FORMAT_R8_UNORM:
        case VK_FORMAT_R8G8_UNORM:
        case VK_FORMAT_R8G8B8_UNORM:
        case VK_FORMAT_B8G8R8_UNORM:
        case VK_FORMAT_R8G8B8A8_UNORM:
        case VK_FORMAT_B8G8R8A8_UNORM:
        case VK_FORMAT_A8B8G8R8_UNORM_PACK32:
        case VK_FORMAT_A2R10G10B10_UNORM_PACK32:
        case VK_FORMAT_A2B10G10R10_UNORM_PACK32:
        case VK_FORMAT_R16_UNORM:
        case VK_FORMAT_R16G16_UNORM:
        case VK_FORMAT_R16G16B16_UNORM:
        case VK_FORMAT_R16G16B16A16_UNORM:
        case VK_FORMAT_D16_UNORM:
        case VK_FORMAT_X8_D24_UNORM_PACK32:
        case VK_FORMAT_BC1_RGB_UNORM_BLOCK:
        case VK_FORMAT_BC1_RGBA_UNORM_BLOCK:
        case VK_FORMAT_BC2_UNORM_BLOCK:
        case VK_FORMAT_BC3_UNORM_BLOCK:
        case VK_FORMAT_BC4_UNORM_BLOCK:
        case VK_FORMAT_BC5_UNORM_BLOCK:
        case VK_FORMAT_BC7_UNORM_BLOCK:
        case VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK:
        case VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK:
        case VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK:
        case VK_FORMAT_EAC_R11_UNORM_BLOCK:
        case VK_FORMAT_EAC_R11G11_UNORM_BLOCK:
        case VK_FORMAT_ASTC_4x4_UNORM_BLOCK:
        case VK_FORMAT_ASTC_5x4_UNORM_BLOCK:
        case VK_FORMAT_ASTC_5x5_UNORM_BLOCK:
        case VK_FORMAT_ASTC_6x5_UNORM_BLOCK:
        case VK_FORMAT_ASTC_6x6_UNORM_BLOCK:
        case VK_FORMAT_ASTC_8x5_UNORM_BLOCK:
        case VK_FORMAT_ASTC_8x6_UNORM_BLOCK:
        case VK_FORMAT_ASTC_8x8_UNORM_BLOCK:
        case VK_FORMAT_ASTC_10x5_UNORM_BLOCK:
        case VK_FORMAT_ASTC_10x6_UNORM_BLOCK:
        case VK_FORMAT_ASTC_10x8_UNORM_BLOCK:
        case VK_FORMAT_ASTC_10x10_UNORM_BLOCK:
        case VK_FORMAT_ASTC_12x10_UNORM_BLOCK:
        case VK_FORMAT_ASTC_12x12_UNORM_BLOCK:
        case VK_FORMAT_G8B8G8R8_422_UNORM:
        case VK_FORMAT_B8G8R8G8_422_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM:
        case VK_FORMAT_G8_B8R8_2PLANE_420_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM:
        case VK_FORMAT_G8_B8R8_2PLANE_422_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM:
        case VK_FORMAT_R10X6_UNORM_PACK16:
        case VK_FORMAT_R10X6G10X6_UNORM_2PACK16:
        case VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16:
        case VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:
        case VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_R12X4_UNORM_PACK16:
        case VK_FORMAT_R12X4G12X4_UNORM_2PACK16:
        case VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16:
        case VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:
        case VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G16B16G16R16_422_UNORM:
        case VK_FORMAT_B16G16R16G16_422_UNORM:
        case VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM:
        case VK_FORMAT_G16_B16R16_2PLANE_420_UNORM:
        case VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM:
        case VK_FORMAT_G16_B16R16_2PLANE_422_UNORM:
        case VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM:
        case VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG:
        case VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG:
        case VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG:
        case VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG:
        case VK_FORMAT_G8_B8R8_2PLANE_444_UNORM:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G16_B16R16_2PLANE_444_UNORM:
        case VK_FORMAT_A4R4G4B4_UNORM_PACK16:
        case VK_FORMAT_A4B4G4R4_UNORM_PACK16:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if all components in the format are an SNORM
bool FormatIsSNORM(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_R8_SNORM:
        case VK_FORMAT_R8G8_SNORM:
        case VK_FORMAT_R8G8B8_SNORM:
        case VK_FORMAT_B8G8R8_SNORM:
        case VK_FORMAT_R8G8B8A8_SNORM:
        case VK_FORMAT_B8G8R8A8_SNORM:
        case VK_FORMAT_A8B8G8R8_SNORM_PACK32:
        case VK_FORMAT_A2R10G10B10_SNORM_PACK32:
        case VK_FORMAT_A2B10G10R10_SNORM_PACK32:
        case VK_FORMAT_R16_SNORM:
        case VK_FORMAT_R16G16_SNORM:
        case VK_FORMAT_R16G16B16_SNORM:
        case VK_FORMAT_R16G16B16A16_SNORM:
        case VK_FORMAT_EAC_R11_SNORM_BLOCK:
        case VK_FORMAT_EAC_R11G11_SNORM_BLOCK:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if all components in the format are an USCALED
bool FormatIsUSCALED(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_R8_USCALED:
        case VK_FORMAT_R8G8_USCALED:
        case VK_FORMAT_R8G8B8_USCALED:
        case VK_FORMAT_B8G8R8_USCALED:
        case VK_FORMAT_R8G8B8A8_USCALED:
        case VK_FORMAT_B8G8R8A8_USCALED:
        case VK_FORMAT_A8B8G8R8_USCALED_PACK32:
        case VK_FORMAT_A2R10G10B10_USCALED_PACK32:
        case VK_FORMAT_A2B10G10R10_USCALED_PACK32:
        case VK_FORMAT_R16_USCALED:
        case VK_FORMAT_R16G16_USCALED:
        case VK_FORMAT_R16G16B16_USCALED:
        case VK_FORMAT_R16G16B16A16_USCALED:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if all components in the format are an SSCALED
bool FormatIsSSCALED(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_R8_SSCALED:
        case VK_FORMAT_R8G8_SSCALED:
        case VK_FORMAT_R8G8B8_SSCALED:
        case VK_FORMAT_B8G8R8_SSCALED:
        case VK_FORMAT_R8G8B8A8_SSCALED:
        case VK_FORMAT_B8G8R8A8_SSCALED:
        case VK_FORMAT_A8B8G8R8_SSCALED_PACK32:
        case VK_FORMAT_A2R10G10B10_SSCALED_PACK32:
        case VK_FORMAT_A2B10G10R10_SSCALED_PACK32:
        case VK_FORMAT_R16_SSCALED:
        case VK_FORMAT_R16G16_SSCALED:
        case VK_FORMAT_R16G16B16_SSCALED:
        case VK_FORMAT_R16G16B16A16_SSCALED:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if all components in the format are an UINT
bool FormatIsUINT(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_R8_UINT:
        case VK_FORMAT_R8G8_UINT:
        case VK_FORMAT_R8G8B8_UINT:
        case VK_FORMAT_B8G8R8_UINT:
        case VK_FORMAT_R8G8B8A8_UINT:
        case VK_FORMAT_B8G8R8A8_UINT:
        case VK_FORMAT_A8B8G8R8_UINT_PACK32:
        case VK_FORMAT_A2R10G10B10_UINT_PACK32:
        case VK_FORMAT_A2B10G10R10_UINT_PACK32:
        case VK_FORMAT_R16_UINT:
        case VK_FORMAT_R16G16_UINT:
        case VK_FORMAT_R16G16B16_UINT:
        case VK_FORMAT_R16G16B16A16_UINT:
        case VK_FORMAT_R32_UINT:
        case VK_FORMAT_R32G32_UINT:
        case VK_FORMAT_R32G32B32_UINT:
        case VK_FORMAT_R32G32B32A32_UINT:
        case VK_FORMAT_R64_UINT:
        case VK_FORMAT_R64G64_UINT:
        case VK_FORMAT_R64G64B64_UINT:
        case VK_FORMAT_R64G64B64A64_UINT:
        case VK_FORMAT_S8_UINT:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if all components in the format are an SINT
bool FormatIsSINT(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_R8_SINT:
        case VK_FORMAT_R8G8_SINT:
        case VK_FORMAT_R8G8B8_SINT:
        case VK_FORMAT_B8G8R8_SINT:
        case VK_FORMAT_R8G8B8A8_SINT:
        case VK_FORMAT_B8G8R8A8_SINT:
        case VK_FORMAT_A8B8G8R8_SINT_PACK32:
        case VK_FORMAT_A2R10G10B10_SINT_PACK32:
        case VK_FORMAT_A2B10G10R10_SINT_PACK32:
        case VK_FORMAT_R16_SINT:
        case VK_FORMAT_R16G16_SINT:
        case VK_FORMAT_R16G16B16_SINT:
        case VK_FORMAT_R16G16B16A16_SINT:
        case VK_FORMAT_R32_SINT:
        case VK_FORMAT_R32G32_SINT:
        case VK_FORMAT_R32G32B32_SINT:
        case VK_FORMAT_R32G32B32A32_SINT:
        case VK_FORMAT_R64_SINT:
        case VK_FORMAT_R64G64_SINT:
        case VK_FORMAT_R64G64B64_SINT:
        case VK_FORMAT_R64G64B64A64_SINT:
        case VK_FORMAT_R16G16_S10_5_NV:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if all components in the format are an SRGB
bool FormatIsSRGB(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_R8_SRGB:
        case VK_FORMAT_R8G8_SRGB:
        case VK_FORMAT_R8G8B8_SRGB:
        case VK_FORMAT_B8G8R8_SRGB:
        case VK_FORMAT_R8G8B8A8_SRGB:
        case VK_FORMAT_B8G8R8A8_SRGB:
        case VK_FORMAT_A8B8G8R8_SRGB_PACK32:
        case VK_FORMAT_BC1_RGB_SRGB_BLOCK:
        case VK_FORMAT_BC1_RGBA_SRGB_BLOCK:
        case VK_FORMAT_BC2_SRGB_BLOCK:
        case VK_FORMAT_BC3_SRGB_BLOCK:
        case VK_FORMAT_BC4_SNORM_BLOCK:
        case VK_FORMAT_BC5_SNORM_BLOCK:
        case VK_FORMAT_BC7_SRGB_BLOCK:
        case VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK:
        case VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK:
        case VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK:
        case VK_FORMAT_ASTC_4x4_SRGB_BLOCK:
        case VK_FORMAT_ASTC_5x4_SRGB_BLOCK:
        case VK_FORMAT_ASTC_5x5_SRGB_BLOCK:
        case VK_FORMAT_ASTC_6x5_SRGB_BLOCK:
        case VK_FORMAT_ASTC_6x6_SRGB_BLOCK:
        case VK_FORMAT_ASTC_8x5_SRGB_BLOCK:
        case VK_FORMAT_ASTC_8x6_SRGB_BLOCK:
        case VK_FORMAT_ASTC_8x8_SRGB_BLOCK:
        case VK_FORMAT_ASTC_10x5_SRGB_BLOCK:
        case VK_FORMAT_ASTC_10x6_SRGB_BLOCK:
        case VK_FORMAT_ASTC_10x8_SRGB_BLOCK:
        case VK_FORMAT_ASTC_10x10_SRGB_BLOCK:
        case VK_FORMAT_ASTC_12x10_SRGB_BLOCK:
        case VK_FORMAT_ASTC_12x12_SRGB_BLOCK:
        case VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG:
        case VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG:
        case VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG:
        case VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if all components in the format are an SFLOAT
bool FormatIsSFLOAT(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_R16_SFLOAT:
        case VK_FORMAT_R16G16_SFLOAT:
        case VK_FORMAT_R16G16B16_SFLOAT:
        case VK_FORMAT_R16G16B16A16_SFLOAT:
        case VK_FORMAT_R32_SFLOAT:
        case VK_FORMAT_R32G32_SFLOAT:
        case VK_FORMAT_R32G32B32_SFLOAT:
        case VK_FORMAT_R32G32B32A32_SFLOAT:
        case VK_FORMAT_R64_SFLOAT:
        case VK_FORMAT_R64G64_SFLOAT:
        case VK_FORMAT_R64G64B64_SFLOAT:
        case VK_FORMAT_R64G64B64A64_SFLOAT:
        case VK_FORMAT_D32_SFLOAT:
        case VK_FORMAT_BC6H_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if all components in the format are an UFLOAT
bool FormatIsUFLOAT(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_B10G11R11_UFLOAT_PACK32:
        case VK_FORMAT_E5B9G9R9_UFLOAT_PACK32:
        case VK_FORMAT_BC6H_UFLOAT_BLOCK:
        found = true;
            break;
        default:
            break;
    }
    return found;
}


// Return true if the format is a ASTC_HDR compressed image format
bool FormatIsCompressed_ASTC_HDR(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK:
        case VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if the format is a ASTC_LDR compressed image format
bool FormatIsCompressed_ASTC_LDR(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_ASTC_10x10_SRGB_BLOCK:
        case VK_FORMAT_ASTC_10x10_UNORM_BLOCK:
        case VK_FORMAT_ASTC_10x5_SRGB_BLOCK:
        case VK_FORMAT_ASTC_10x5_UNORM_BLOCK:
        case VK_FORMAT_ASTC_10x6_SRGB_BLOCK:
        case VK_FORMAT_ASTC_10x6_UNORM_BLOCK:
        case VK_FORMAT_ASTC_10x8_SRGB_BLOCK:
        case VK_FORMAT_ASTC_10x8_UNORM_BLOCK:
        case VK_FORMAT_ASTC_12x10_SRGB_BLOCK:
        case VK_FORMAT_ASTC_12x10_UNORM_BLOCK:
        case VK_FORMAT_ASTC_12x12_SRGB_BLOCK:
        case VK_FORMAT_ASTC_12x12_UNORM_BLOCK:
        case VK_FORMAT_ASTC_4x4_SRGB_BLOCK:
        case VK_FORMAT_ASTC_4x4_UNORM_BLOCK:
        case VK_FORMAT_ASTC_5x4_SRGB_BLOCK:
        case VK_FORMAT_ASTC_5x4_UNORM_BLOCK:
        case VK_FORMAT_ASTC_5x5_SRGB_BLOCK:
        case VK_FORMAT_ASTC_5x5_UNORM_BLOCK:
        case VK_FORMAT_ASTC_6x5_SRGB_BLOCK:
        case VK_FORMAT_ASTC_6x5_UNORM_BLOCK:
        case VK_FORMAT_ASTC_6x6_SRGB_BLOCK:
        case VK_FORMAT_ASTC_6x6_UNORM_BLOCK:
        case VK_FORMAT_ASTC_8x5_SRGB_BLOCK:
        case VK_FORMAT_ASTC_8x5_UNORM_BLOCK:
        case VK_FORMAT_ASTC_8x6_SRGB_BLOCK:
        case VK_FORMAT_ASTC_8x6_UNORM_BLOCK:
        case VK_FORMAT_ASTC_8x8_SRGB_BLOCK:
        case VK_FORMAT_ASTC_8x8_UNORM_BLOCK:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if the format is a BC compressed image format
bool FormatIsCompressed_BC(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_BC1_RGBA_SRGB_BLOCK:
        case VK_FORMAT_BC1_RGBA_UNORM_BLOCK:
        case VK_FORMAT_BC1_RGB_SRGB_BLOCK:
        case VK_FORMAT_BC1_RGB_UNORM_BLOCK:
        case VK_FORMAT_BC2_SRGB_BLOCK:
        case VK_FORMAT_BC2_UNORM_BLOCK:
        case VK_FORMAT_BC3_SRGB_BLOCK:
        case VK_FORMAT_BC3_UNORM_BLOCK:
        case VK_FORMAT_BC4_SNORM_BLOCK:
        case VK_FORMAT_BC4_UNORM_BLOCK:
        case VK_FORMAT_BC5_SNORM_BLOCK:
        case VK_FORMAT_BC5_UNORM_BLOCK:
        case VK_FORMAT_BC6H_SFLOAT_BLOCK:
        case VK_FORMAT_BC6H_UFLOAT_BLOCK:
        case VK_FORMAT_BC7_SRGB_BLOCK:
        case VK_FORMAT_BC7_UNORM_BLOCK:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if the format is a EAC compressed image format
bool FormatIsCompressed_EAC(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_EAC_R11G11_SNORM_BLOCK:
        case VK_FORMAT_EAC_R11G11_UNORM_BLOCK:
        case VK_FORMAT_EAC_R11_SNORM_BLOCK:
        case VK_FORMAT_EAC_R11_UNORM_BLOCK:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if the format is a ETC2 compressed image format
bool FormatIsCompressed_ETC2(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK:
        case VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK:
        case VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK:
        case VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK:
        case VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK:
        case VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if the format is a PVRTC compressed image format
bool FormatIsCompressed_PVRTC(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG:
        case VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG:
        case VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG:
        case VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG:
        case VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG:
        case VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG:
        case VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG:
        case VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if the format is any compressed image format
bool FormatIsCompressed(VkFormat format) {
    return (
      FormatIsCompressed_ASTC_HDR(format) ||
      FormatIsCompressed_ASTC_LDR(format) ||
      FormatIsCompressed_BC(format) ||
      FormatIsCompressed_EAC(format) ||
      FormatIsCompressed_ETC2(format) ||
      FormatIsCompressed_PVRTC(format));
}


// Return true if format is a depth OR stencil format
bool FormatIsDepthOrStencil(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_D16_UNORM:
        case VK_FORMAT_D16_UNORM_S8_UINT:
        case VK_FORMAT_D24_UNORM_S8_UINT:
        case VK_FORMAT_D32_SFLOAT:
        case VK_FORMAT_D32_SFLOAT_S8_UINT:
        case VK_FORMAT_S8_UINT:
        case VK_FORMAT_X8_D24_UNORM_PACK32:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if format is a depth AND stencil format
bool FormatIsDepthAndStencil(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_D16_UNORM_S8_UINT:
        case VK_FORMAT_D24_UNORM_S8_UINT:
        case VK_FORMAT_D32_SFLOAT_S8_UINT:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if format is a depth ONLY format
bool FormatIsDepthOnly(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_D16_UNORM:
        case VK_FORMAT_D32_SFLOAT:
        case VK_FORMAT_X8_D24_UNORM_PACK32:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Return true if format is a stencil ONLY format
bool FormatIsStencilOnly(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_S8_UINT:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Returns size of depth component in bits
// Returns zero if no depth component
uint32_t FormatDepthSize(VkFormat format) {
    switch (format) {
           case VK_FORMAT_D16_UNORM:
           case VK_FORMAT_D16_UNORM_S8_UINT:
            return 16;
           case VK_FORMAT_D24_UNORM_S8_UINT:
           case VK_FORMAT_X8_D24_UNORM_PACK32:
            return 24;
           case VK_FORMAT_D32_SFLOAT:
           case VK_FORMAT_D32_SFLOAT_S8_UINT:
            return 32;
        default:
            return 0;
     }
}

// Returns size of stencil component in bits
// Returns zero if no stencil component
uint32_t FormatStencilSize(VkFormat format) {
    switch (format) {
           case VK_FORMAT_D16_UNORM_S8_UINT:
           case VK_FORMAT_D24_UNORM_S8_UINT:
           case VK_FORMAT_D32_SFLOAT_S8_UINT:
           case VK_FORMAT_S8_UINT:
            return 8;
        default:
            return 0;
     }
}

// Returns NONE if no depth component
FORMAT_NUMERICAL_TYPE FormatDepthNumericalType(VkFormat format) {
    switch (format) {
           case VK_FORMAT_D16_UNORM:
           case VK_FORMAT_D16_UNORM_S8_UINT:
           case VK_FORMAT_D24_UNORM_S8_UINT:
           case VK_FORMAT_X8_D24_UNORM_PACK32:
            return FORMAT_NUMERICAL_TYPE::UNORM;
           case VK_FORMAT_D32_SFLOAT:
           case VK_FORMAT_D32_SFLOAT_S8_UINT:
            return FORMAT_NUMERICAL_TYPE::SFLOAT;
        default:
            return FORMAT_NUMERICAL_TYPE::NONE;
     }
}

// Returns NONE if no stencil component
FORMAT_NUMERICAL_TYPE FormatStencilNumericalType(VkFormat format) {
    switch (format) {
           case VK_FORMAT_D16_UNORM_S8_UINT:
           case VK_FORMAT_D24_UNORM_S8_UINT:
           case VK_FORMAT_D32_SFLOAT_S8_UINT:
           case VK_FORMAT_S8_UINT:
            return FORMAT_NUMERICAL_TYPE::UINT;
        default:
            return FORMAT_NUMERICAL_TYPE::NONE;
     }
}


// Return true if format is a packed format
bool FormatIsPacked(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_R4G4_UNORM_PACK8:
        case VK_FORMAT_R4G4B4A4_UNORM_PACK16:
        case VK_FORMAT_B4G4R4A4_UNORM_PACK16:
        case VK_FORMAT_R5G6B5_UNORM_PACK16:
        case VK_FORMAT_B5G6R5_UNORM_PACK16:
        case VK_FORMAT_R5G5B5A1_UNORM_PACK16:
        case VK_FORMAT_B5G5R5A1_UNORM_PACK16:
        case VK_FORMAT_A1R5G5B5_UNORM_PACK16:
        case VK_FORMAT_A8B8G8R8_UNORM_PACK32:
        case VK_FORMAT_A8B8G8R8_SNORM_PACK32:
        case VK_FORMAT_A8B8G8R8_USCALED_PACK32:
        case VK_FORMAT_A8B8G8R8_SSCALED_PACK32:
        case VK_FORMAT_A8B8G8R8_UINT_PACK32:
        case VK_FORMAT_A8B8G8R8_SINT_PACK32:
        case VK_FORMAT_A8B8G8R8_SRGB_PACK32:
        case VK_FORMAT_A2R10G10B10_UNORM_PACK32:
        case VK_FORMAT_A2R10G10B10_SNORM_PACK32:
        case VK_FORMAT_A2R10G10B10_USCALED_PACK32:
        case VK_FORMAT_A2R10G10B10_SSCALED_PACK32:
        case VK_FORMAT_A2R10G10B10_UINT_PACK32:
        case VK_FORMAT_A2R10G10B10_SINT_PACK32:
        case VK_FORMAT_A2B10G10R10_UNORM_PACK32:
        case VK_FORMAT_A2B10G10R10_SNORM_PACK32:
        case VK_FORMAT_A2B10G10R10_USCALED_PACK32:
        case VK_FORMAT_A2B10G10R10_SSCALED_PACK32:
        case VK_FORMAT_A2B10G10R10_UINT_PACK32:
        case VK_FORMAT_A2B10G10R10_SINT_PACK32:
        case VK_FORMAT_B10G11R11_UFLOAT_PACK32:
        case VK_FORMAT_E5B9G9R9_UFLOAT_PACK32:
        case VK_FORMAT_X8_D24_UNORM_PACK32:
        case VK_FORMAT_R10X6_UNORM_PACK16:
        case VK_FORMAT_R10X6G10X6_UNORM_2PACK16:
        case VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16:
        case VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:
        case VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_R12X4_UNORM_PACK16:
        case VK_FORMAT_R12X4G12X4_UNORM_2PACK16:
        case VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16:
        case VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:
        case VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_A4R4G4B4_UNORM_PACK16:
        case VK_FORMAT_A4B4G4R4_UNORM_PACK16:
        found = true;
            break;
        default:
            break;
    }
    return found;
}


// Return true if format requires sampler YCBCR conversion
// for VK_IMAGE_ASPECT_COLOR_BIT image views
// Table found in spec
bool FormatRequiresYcbcrConversion(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:
        case VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:
        case VK_FORMAT_B16G16R16G16_422_UNORM:
        case VK_FORMAT_B8G8R8G8_422_UNORM:
        case VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G16B16G16R16_422_UNORM:
        case VK_FORMAT_G16_B16R16_2PLANE_420_UNORM:
        case VK_FORMAT_G16_B16R16_2PLANE_422_UNORM:
        case VK_FORMAT_G16_B16R16_2PLANE_444_UNORM:
        case VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM:
        case VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM:
        case VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM:
        case VK_FORMAT_G8B8G8R8_422_UNORM:
        case VK_FORMAT_G8_B8R8_2PLANE_420_UNORM:
        case VK_FORMAT_G8_B8R8_2PLANE_422_UNORM:
        case VK_FORMAT_G8_B8R8_2PLANE_444_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM:
        case VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16:
        case VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

bool FormatIsXChromaSubsampled(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:
        case VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:
        case VK_FORMAT_B16G16R16G16_422_UNORM:
        case VK_FORMAT_B8G8R8G8_422_UNORM:
        case VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G16B16G16R16_422_UNORM:
        case VK_FORMAT_G16_B16R16_2PLANE_420_UNORM:
        case VK_FORMAT_G16_B16R16_2PLANE_422_UNORM:
        case VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM:
        case VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM:
        case VK_FORMAT_G8B8G8R8_422_UNORM:
        case VK_FORMAT_G8_B8R8_2PLANE_420_UNORM:
        case VK_FORMAT_G8_B8R8_2PLANE_422_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

bool FormatIsYChromaSubsampled(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G16_B16R16_2PLANE_420_UNORM:
        case VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM:
        case VK_FORMAT_G8_B8R8_2PLANE_420_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM:
        found = true;
            break;
        default:
            break;
    }
    return found;
}


// Single-plane "_422" formats are treated as 2x1 compressed (for copies)

bool FormatIsSinglePlane_422(VkFormat format) {
    bool found = false;
    switch (format) {
        case VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:
        case VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:
        case VK_FORMAT_B16G16R16G16_422_UNORM:
        case VK_FORMAT_B8G8R8G8_422_UNORM:
        case VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:
        case VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:
        case VK_FORMAT_G16B16G16R16_422_UNORM:
        case VK_FORMAT_G8B8G8R8_422_UNORM:
        found = true;
            break;
        default:
            break;
    }
    return found;
}

// Returns number of planes in format (which is 1 by default)
uint32_t FormatPlaneCount(VkFormat format) {
    switch (format) {
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G16_B16R16_2PLANE_420_UNORM:
        case VK_FORMAT_G16_B16R16_2PLANE_422_UNORM:
        case VK_FORMAT_G16_B16R16_2PLANE_444_UNORM:
        case VK_FORMAT_G8_B8R8_2PLANE_420_UNORM:
        case VK_FORMAT_G8_B8R8_2PLANE_422_UNORM:
        case VK_FORMAT_G8_B8R8_2PLANE_444_UNORM:
            return 2;
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:
        case VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM:
        case VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM:
        case VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM:
        case VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM:
            return 3;
        default:
            return 1;
     }
}

// Will return VK_FORMAT_UNDEFINED if given a plane aspect that doesn't exist for the format
VkFormat FindMultiplaneCompatibleFormat(VkFormat mp_fmt, VkImageAspectFlags plane_aspect) {
    const uint32_t plane_idx = GetPlaneIndex(plane_aspect);
    auto it = kVkMultiplaneCompatibilityMap.find(mp_fmt);
    if ((it == kVkMultiplaneCompatibilityMap.end()) || (plane_idx >= FORMAT_MAX_PLANES)) {
        return VK_FORMAT_UNDEFINED;
    }

    return it->second.per_plane[plane_idx].compatible_format;
}

// Will return {1, 1} if given a plane aspect that doesn't exist for the format
VkExtent2D FindMultiplaneExtentDivisors(VkFormat mp_fmt, VkImageAspectFlags plane_aspect) {
    VkExtent2D divisors = {1, 1};
    const uint32_t plane_idx = GetPlaneIndex(plane_aspect);
    auto it = kVkMultiplaneCompatibilityMap.find(mp_fmt);
    if ((it == kVkMultiplaneCompatibilityMap.end()) || (plane_idx >= FORMAT_MAX_PLANES)) {
        return divisors;
    }

    divisors.width = it->second.per_plane[plane_idx].width_divisor;
    divisors.height = it->second.per_plane[plane_idx].height_divisor;
    return divisors;
}


uint32_t FormatComponentCount(VkFormat format) {
    auto format_info = kVkFormatTable.find(format);
    if (format_info != kVkFormatTable.end()) {
        return format_info->second.component_count;
    }
    return 0;
}

VkExtent3D FormatTexelBlockExtent(VkFormat format) {
    auto format_info = kVkFormatTable.find(format);
    if (format_info != kVkFormatTable.end()) {
        return format_info->second.block_extent;
    }
    return {1, 1, 1};
}

FORMAT_COMPATIBILITY_CLASS FormatCompatibilityClass(VkFormat format) {
    auto format_info = kVkFormatTable.find(format);
    if (format_info != kVkFormatTable.end()) {
        return format_info->second.compatibility;
    }
    return FORMAT_COMPATIBILITY_CLASS::NONE;
}

// Return true if format is 'normal', with one texel per format element
bool FormatElementIsTexel(VkFormat format) {
    if (FormatIsPacked(format) || FormatIsCompressed(format) || FormatIsSinglePlane_422(format) || FormatIsMultiplane(format)) {
        return false;
    } else {
        return true;
    }
}

// Return size, in bytes, of one element of the specified format
// For uncompressed this is one texel, for compressed it is one block
uint32_t FormatElementSize(VkFormat format, VkImageAspectFlags aspectMask) {
    // Depth/Stencil aspect have separate helper functions
    if (aspectMask & VK_IMAGE_ASPECT_STENCIL_BIT) {
        return FormatStencilSize(format) / 8;
    } else if (aspectMask & VK_IMAGE_ASPECT_DEPTH_BIT) {
        return FormatDepthSize(format) / 8;
    } else if (FormatIsMultiplane(format)) {
        // Element of entire multiplane format is not useful,
        // Want to get just a single plane as the lookup format
        format = FindMultiplaneCompatibleFormat(format, aspectMask);
    }

    auto item = kVkFormatTable.find(format);
    if (item != kVkFormatTable.end()) {
        return item->second.block_size;
    }
    return 0;
}

// Return the size in bytes of one texel of given foramt
// For compressed or multi-plane, this may be a fractional number
double FormatTexelSize(VkFormat format, VkImageAspectFlags aspectMask) {
    double texel_size = static_cast<double>(FormatElementSize(format, aspectMask));
    VkExtent3D block_extent = FormatTexelBlockExtent(format);
    uint32_t texels_per_block = block_extent.width * block_extent.height * block_extent.depth;
    if (1 < texels_per_block) {
        texel_size /= static_cast<double>(texels_per_block);
    }
    return texel_size;
}

static bool FormatHasComponent(VkFormat format, COMPONENT_TYPE component) {
    auto item = kVkFormatTable.find(format);
    if (item == kVkFormatTable.end()) {
        return false;
    }
    const COMPONENT_INFO* begin = item->second.components;
    const COMPONENT_INFO* end = item->second.components + FORMAT_MAX_COMPONENTS;
    return std::find_if(begin, end, [component](const COMPONENT_INFO& info) { return info.type == component; }) != end;
}

bool FormatHasRed(VkFormat format) {
    return FormatHasComponent(format, COMPONENT_TYPE::R);
}

bool FormatHasGreen(VkFormat format) {
    return FormatHasComponent(format, COMPONENT_TYPE::G);
}

bool FormatHasBlue(VkFormat format) {
    return FormatHasComponent(format, COMPONENT_TYPE::B);
}

bool FormatHasAlpha(VkFormat format) {
    return FormatHasComponent(format, COMPONENT_TYPE::A);
}

